/*
  URGCtrl2D.h 
  Satofumi KAMIMURA
  $Id$
*/

#include <runCtrl.h>
#include <urgCtrl2D.h>


static void fileOutput(int i, VXV_Position& pos, URGCtrl2D& urg) {
  char fileName[14];
  sprintf(fileName, "data2d_%02d.dat", i);
  FILE *fd = fopen(fileName, "w");
  if (fd == NULL) {
    perror(fileName);
    exit(1);
  }

  for (std::vector<VXV_Grid2D>::iterator it = urg.grid2D_vector.begin();
       it != urg.grid2D_vector.end(); ++it) {
    fprintf(fd, "%d\t%d\n", it->x, it->y);
  }
  fclose(fd);
}


static void plotFileOutput(int times) {
  FILE *fd = fopen("plot2d.gnu", "w");
  if (fd == NULL) {
    perror("");
    exit(1);
  }
  fprintf(fd,
	  "set grid\n"
	  "set ticslevel 0\n"
	  "set xlabel \"X-axis\"\n"
	  "set ylabel \"Y-axis\"\n"
	  "set mouse\n"
	  "unset key\n"
	  "\n"
	  "plot \"data2d_00.dat\"");
  
  for (int i = 1; i < times; ++i) {
    fprintf(fd, ", \"data2d_%02d.dat\"", i);
  }
  
  fprintf(fd,
	  "\n"
	  "pause -1\n");
  fclose(fd);
}


int main(int argc, char *argv[]) {
  enum { MESURE_TIMES = 99 };

  try {
    RunCtrl run;
    if (run.connect(argc, argv) < 0) {
      printf("RunCtrl::connect: %s\n", run.getError());
      exit(1);
    }
    URGCtrl2D urg;
    if (urg.connect(argc, argv) < 0) {
      printf("URGCtrl2D::connect: %s\n", urg.getError());
      exit(1);
    }
    
    // ľʤĤġϤΥ󥷥󥰷̤Ͽ
    run.followLine(0, 0, deg(0));

    // ¬
    int preTimes = -1;
    for (int i = 0; i < MESURE_TIMES; ++i) {
      VXV_Position pos = run.getPosition();
      int times = urg.capture().get_captureTimes();
      if (preTimes == times) {
	continue;
      }
      preTimes = times;
      
      // ¬ǡե˵Ͽ
      urg.convert2D(pos);
      fileOutput(i, pos, urg);

      VXV::Delay(100);
    }

    // ¬λ
    run.stop();
    plotFileOutput(MESURE_TIMES);
    
  } catch (std::exception& e) {
    printf("exception: %s\n", e.what());
  }

  return 0;
}
