/*
  ɸϤθ֤ι
  Satofumi KAMIMURA
  $Id$
*/

#include <runCtrl.h>

static void printPosition(VXV_Coordinate& crd) {
  VXV_Position position = crd.getPosition();
  printf("(%d, %d, %d) ", position.x, position.y, position.deg());
}

int main(int argc, char *argv[]) {
  try {
    RunCtrl run;
    if (run.connect(argc, argv) < 0) {
      printf("RunCtrl::connect: %s\n", run.getError());
      exit(1);
    }

    // ɸϤ
    VXV_Coordinate& local1 = run.createCoordinate(100, 0, deg(0));
    VXV_Coordinate& local2 = local1.createCoordinate(100, 0, deg(0));

    // ɸϤΰ֤lcal1 ꤹ
    VXV_Coordinate& local3 =
      local2.createCoordinate().updateParentOffset(local1, -100, 0, deg(0));
    
    run.stopToLine(1000, 0, deg(0));
    while (!run.isStable()) {
      printPosition(run);
      printPosition(local3);
      printPosition(local1);
      printPosition(local2);
      printf("\n");

      VXV::Delay(100);
    }

  } catch (std::exception& e) {
    printf("exception: %s\n", e.what());
  }
  return 0;
}
  
