/*
  ƵŪ˺ɸϤѤ
  Satofumi KAMIMURA
  $Id$
*/

#include <runCtrl.h>

enum
  { MIN_LENGTH = 200
};


static void waitStable(VXV_Coordinate& crd) {
  while (!crd.isStable()) {
    VXV::Delay(100);
  }
}


static void frontAndBack(VXV_Coordinate& crd, int mm_length) {

  // ʤ
  if (mm_length > MIN_LENGTH) {
    crd.stopToLine(mm_length, 0, deg(0));
    waitStable(crd);

    crd.turnToAngle(deg(90));
    waitStable(crd);
    
    VXV_Coordinate& local = crd.createCoordinate(mm_length, 0, deg(90));
    frontAndBack(local, (int)(mm_length * 4 / 5));
  }

  // 
  crd.turnToAngle(deg(0));
  waitStable(crd);

  crd.stopToLine(0, 0, deg(0));
  waitStable(crd);
  
  return;
}

int main(int argc, char *argv[]) {
  try {
    RunCtrl run;
    if (run.connect(argc, argv) < 0) {
      printf("RunCtrl::connect: %s\n", run.getError());
      exit(1);
    }

    // ƵؿθƤӽФ
    frontAndBack(run, 1000);
    
  } catch (std::exception& e) {
    printf("exception: %s\n", e.what());
  }
  return 0;
}
