#include <unistd.h>
#include "notify_timer.h"

NotifyTimer::NotifyTimer(const int msec){
	mInterval = msec;
	pthread_cond_init(&mWaiter, 0);	// default initialize
	pthread_mutex_init(&mMutex, 0);	// default initialize
}

NotifyTimer::~NotifyTimer(){
	pthread_cond_destroy(&mWaiter);
}

void* NotifyTimer::run(){
	while(true){
		usleep(mInterval*1000);
		pthread_cond_broadcast(&mWaiter);
	}
	return 0;
}

void NotifyTimer::wait(){
	pthread_cond_wait(&mWaiter, &mMutex);
}

void NotifyTimer::setTimeout(const int n){
	mInterval = n;
}
