#include <iostream>
#include <stdexcept>
#include "thread.h"

Thread::Thread()
:mThreadId((pthread_t)-1){
}

Thread::~Thread(){
	stop();
}

void Thread::start(){
	if(pthread_create(&mThreadId, 0, Thread::entryPoint, this) != 0){
		throw new std::runtime_error("pthread create failed.");
	}
}

void Thread::stop(){
	if(mThreadId == (pthread_t)-1){
		return;
	}
	if(pthread_cancel(mThreadId) != 0){
		throw new std::runtime_error("pthread_cancel failed.");
	}
}

pthread_t Thread::getThreadId(){
	return mThreadId;
}

int Thread::join(Thread* t){
	return pthread_join(t->getThreadId(), 0);
}

void* Thread::entryPoint(void* p){
	Thread* self = (Thread*)p;
	return self->run();
}
