/*
 * SquareGenerator.cpp
 *
 *  Created on: 2008/07/31
 *      Author: syn
 */

#include <cstring>
#include <math.h>
#include "SquareGenerator.h"

SquareGenerator::SquareGenerator() {
	mPhase = 0;
	mFreq = 440;
	mTargetFreq = 440;
	mPortamentPhase = 0;
	mPortament = 2048;
	mDutyRatio = 0.5;
}

SquareGenerator::~SquareGenerator() {
}

void SquareGenerator::doMix(float* p, const int len){
	int phase = mPhase;
	int freq = mFreq;
	for(int i = 0; i < len/2; i++){
		// Do portament
		if(mPortamentPhase >= mPortament){
			freq = mTargetFreq;
		}else{
			int df;
			df = mTargetFreq -mBaseFreq;
			freq = mBaseFreq +(df*mPortamentPhase/mPortament);
			mPortamentPhase++;
		}

		phase += freq;
		if(phase > mDutyRatio*44100){
			p[i*2 +0] = 1;
			p[i*2 +1] = 1;
		}else{
			p[i*2 +0] = -1;
			p[i*2 +1] = -1;
		}
		phase %= 44100;
	}
	mPhase = phase;
	mFreq = freq;
}

void SquareGenerator::setFreq(int n){
	mBaseFreq = mFreq;
	mTargetFreq = n;
	mPortamentPhase = 0;
}

void SquareGenerator::setPortament(const int n){
	mPortament = n;
	if(mPortamentPhase > mPortament){
		mPortamentPhase = mPortament;
	}
}

void SquareGenerator::setDuty(const int duty){
	mDutyRatio = (float)duty/100.0;
}

void SquareGenerator::eventHandler(const char* path, const int n){
	if(strcmp(path, "/ocillator/frequency") == 0){
		this->setFreq(n);
	}else if(strcmp(path, "/NOTE_ON") == 0){
		this->setFreq(MIDINoteToFreq(n));
	}else if(strcmp(path, "/SQUARE_GENERATOR/duty") == 0){
		this->setDuty(n);
    }
}

