/*
 * SawGenerator.cpp
 *
 *  Created on: 2008/07/29
 *      Author: syn
 */

#include <iostream>
#include <cstring>
#include <math.h>
#include "SawGenerator.h"

SawGenerator::SawGenerator() {
	// TODO Auto-generated constructor stub
	mPhase = 0;
	mFreq = 440;
	mTable = new float[44100];

	float k;
	for(int i = 0; i < 44100; i++){
		k = (float)i/44100;
		mTable[i] = (1-k)*1.0 + k*(-1.0);
	}
}

SawGenerator::~SawGenerator() {
	// TODO Auto-generated destructor stub
	delete[] mTable;
}

void SawGenerator::doMix(float*p, const int len){
	int phase = mPhase;
	for(int i = 0; i < len/2; i++){
		p[i*2 +0] = mTable[phase];
		p[i*2 +1] = mTable[phase];
		phase += mFreq;
		phase %= 44100;
	}
	mPhase = phase;
}

void SawGenerator::setFreq(int n){
	mFreq = n;
}

void SawGenerator::eventHandler(const char* path, const int n){
	if(strcmp(path, "/ocillator/frequency") == 0){
		this->setFreq(n);
	}else if(strcmp(path, "/NOTE_ON") == 0){
		this->setFreq(MIDINoteToFreq(n));
	}
}

