/*
 * Recorder.cpp
 *
 *  Created on: 2008/07/26
 *      Author: syn
 */

#include <stdio.h>
#include <netinet/in.h>
#include "Recorder.h"

Recorder::Recorder(const std::string& path) {
	mOut = fopen(path.c_str(), "w");
	if(mOut == 0){
		printf("fopen(%s) failed.\n", path.c_str());
	}
	writeHeader();
}

Recorder::~Recorder() {
	if(mOut){
		fflush(mOut);
		fclose(mOut);
	}
}

void Recorder::doMix(float* p, const int len){
	signed short s;
	for(int i = 0; i < len; i++){
		if(p[i] > 1.0) s = 32767;
		else if(p[i] < -1.0) s = -32767;
		else s = (signed short)(p[i]*32767);
		s = htons(s);
		fwrite(&s, 1, 2, mOut);
	}
	fflush(mOut);
}

void Recorder::writeHeader(){
	unsigned int word;

	// MagicNumber
	word = htonl(0x2e736e64);
	fwrite(&word, 1, 4, mOut);

	// Offset
	word = htonl(24);
	fwrite(&word, 1, 4, mOut);

	// size
	word = 0xffffffff;
	fwrite(&word, 1, 4, mOut);

	// encording
	word = htonl(3);
	fwrite(&word, 1, 4, mOut);

	// sampling rate
	word = htonl(44100);
	fwrite(&word, 1, 4, mOut);

	// channels
	word = htonl(2);
	fwrite(&word, 1, 4, mOut);

	fflush(mOut);
}
