/*
 * EnvelopeGenerator.cpp
 *
 *  Created on: 2008/07/26
 *      Author: syn
 */

#include <cstring>
#include "EnvelopeGenerator.h"

EnvelopeGenerator::EnvelopeGenerator() {
	// TODO Auto-generated constructor stub
	mPhase = -1;
	mAttackPhase = 800;
	mDecayPhase = 1600;
	mSustainPhase = 30000;
	mReleasePhase = 120000;
}

EnvelopeGenerator::~EnvelopeGenerator() {
	// TODO Auto-generated destructor stub
}

void EnvelopeGenerator::doMix(float* p, const int len){
	float k;
	int n;

	for(int i = 0; i < len/2; i++){
		if(mPhase == -1){
			k = 0.0;
		}else if(mPhase < mAttackPhase){
			// atack
			k = (float)mPhase/mAttackPhase;
		}else if(mPhase < mDecayPhase){
			// Decay
			n = mPhase-mAttackPhase;
			k = 0.2*(float)((mDecayPhase-mAttackPhase)-n)/(mDecayPhase -mAttackPhase);
			k += 0.8;
		}else if(mPhase < mSustainPhase){
			k = 0.8;
		}else if(mPhase < mReleasePhase){
			n = mPhase-mSustainPhase;
			k = 0.8*((float)((mReleasePhase-mSustainPhase)-n))/(mReleasePhase -mSustainPhase);
		}else{
			k = 0.0;
		}
		p[i*2 +0] = k*p[i*2 +0];
		p[i*2 +1] = k*p[i*2 +1];
		if(mPhase >= 0){
			mPhase++;
		}
	}
}

void EnvelopeGenerator::eventHandler(const char* path, const int n){
	if(strcmp(path, "/NOTE_ON") == 0){
		mPhase = 0;
	}
}
