/*
 * Echo.cpp
 *
 *  Created on: 2008/07/31
 *      Author: syn
 */

#include "Echo.h"

Echo::Echo() {
	mBuffer = new float[44100*2];
	for(int i = 0; i < 44100*2; i++){
		mBuffer[i] = 0;
	}
	mDelay = 2205;	// 0.1sec
	mReadIndex = 0;
}

Echo::~Echo() {
	delete[] mBuffer;
}

void Echo::doMix(float* p, const int len){
	// Write to buffer
	int pp = mReadIndex +mDelay;
	for(int i = 0; i < len/2; i++){
		if(pp >= 44100){
			pp -= 44100;
		}
		mBuffer[pp*2 +0] = p[i*2 +0]*0.25;
		mBuffer[pp*2 +1] = p[i*2 +1]*0.25;
		pp++;
	}

	// Read from buffer and mix
	pp = mReadIndex;
	for(int i = 0; i < len/2; i++){
		if(pp >= 44100){
			pp = 0;
		}
		p[i*2 +0] += mBuffer[pp*2 +0];
		p[i*2 +1] += mBuffer[pp*2 +1];
		pp++;
	}
	mReadIndex = pp;
}
