/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "w32brush.h"


static void w32ldr_brush_class_init (W32LdrBrushClass *klass);
static void w32ldr_brush_init       (W32LdrBrush      *w32brush);


static GObjectClass *parent_class = NULL;


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
w32ldr_brush_get_type (void)
{
  static GType type = 0;

  if (!type)
    {
      const static GTypeInfo info =
      {
        sizeof (W32LdrBrushClass),
        NULL,               /* base_init */
        NULL,               /* base_finalize */
        (GClassInitFunc)w32ldr_brush_class_init,
        NULL,               /* class_finalize */
        NULL,               /* class_data */
        sizeof (W32LdrBrush),
        0,                  /* n_preallocs */
        (GInstanceInitFunc)w32ldr_brush_init,
      };

      type = g_type_register_static (G_TYPE_OBJECT, "W32LdrBrush", &info, 0);
    }

  return type;
}


static void
w32ldr_brush_class_init (W32LdrBrushClass *klass)
{
  parent_class = g_type_class_peek_parent (klass);
}


/*  ja:新規作成
    RET,オブジェクト                                                        */
static void
w32ldr_brush_init (W32LdrBrush *w32brush)
{
  w32brush->color.pixel = 0;
  w32brush->color.red = 0;
  w32brush->color.green = 0;
  w32brush->color.blue = 0;
}


/******************************************************************************
*                                                                             *
* ja:ブラシ関数群                                                             *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,オブジェクト                                                        */
W32LdrBrush *
w32ldr_brush_new (void)
{
  return W32LDR_BRUSH (g_object_new (W32LDR_TYPE_BRUSH, NULL));
}


/*  ja:新規作成
    color,色
      RET,オブジェクト                                                      */
W32LdrBrush *
w32ldr_brush_new_with_color (GdkColor *color)
{
  W32LdrBrush *w32brush;

  w32brush = w32ldr_brush_new ();
  w32ldr_brush_set_color (w32brush, color);
  return w32brush;
}


/*  ja:ブラシをコピーする
    w32brush,オブジェクト
         RET,オブジェクト                                                   */
W32LdrBrush *
w32ldr_brush_copy (W32LdrBrush *w32brush)
{
  return W32LDR_IS_BRUSH (w32brush)
                    ? w32ldr_brush_new_with_color (&w32brush->color) : NULL;
}


/*  ja:ブラシの色を取得する
    w32brush,オブジェクト
       color,色                                                             */
void
w32ldr_brush_get_color (W32LdrBrush *w32brush,
                        GdkColor    *color)
{
  if (W32LDR_IS_BRUSH (w32brush) && color)
    *color = w32brush->color;
}


/*  ja:ブラシの色を設定する
    w32brush,オブジェクト
       color,色                                                             */
void
w32ldr_brush_set_color (W32LdrBrush *w32brush,
                        GdkColor    *color)
{
  if (W32LDR_IS_BRUSH (w32brush) && color)
    w32brush->color = *color;
}
