/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __USER32_H__
#define __USER32_H__


#include "w32ldr.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include "gdi32.h"
#include "w32btn.h"
#include "w32edit.h"
#include "w32stc.h"
#include "w32list.h"
#include "w32sbar.h"
#include "w32combo.h"

/* ja:システム */
#define COLOR_SCROLLBAR               0
#define COLOR_BACKGROUND              1
#define COLOR_DESKTOP                 COLOR_BACKGROUND
#define COLOR_ACTIVECAPTION           2
#define COLOR_INACTIVECAPTION         3
#define COLOR_MENU                    4
#define COLOR_WINDOW                  5
#define COLOR_WINDOWFRAME             6
#define COLOR_MENUTEXT                7
#define COLOR_WINDOWTEXT              8
#define COLOR_CAPTIONTEXT             9
#define COLOR_ACTIVEBORDER            10
#define COLOR_INACTIVEBORDER          11
#define COLOR_APPWORKSPACE            12
#define COLOR_HIGHLIGHT               13
#define COLOR_HIGHLIGHTTEXT           14
#define COLOR_BTNFACE                 15
#define COLOR_3DFACE                  COLOR_BTNFACE
#define COLOR_BTNSHADOW               16
#define COLOR_3DSHADOW                COLOR_BTNSHADOW
#define COLOR_GRAYTEXT                17
#define COLOR_BTNTEXT                 18
#define COLOR_INACTIVECAPTIONTEXT     19
#define COLOR_BTNHIGHLIGHT            20
#define COLOR_3DHIGHLIGHT             COLOR_BTNHIGHLIGHT
#define COLOR_3DHILIGHT               COLOR_BTNHIGHLIGHT
#define COLOR_BTNHILIGHT              COLOR_BTNHIGHLIGHT
#define COLOR_3DDKSHADOW              21
#define COLOR_3DLIGHT                 22
#define COLOR_INFOTEXT                23
#define COLOR_INFOBK                  24
#define COLOR_ALTERNATEBTNFACE        25
#define COLOR_HOTLIGHT                26
#define COLOR_GRADIENTACTIVECAPTION   27
#define COLOR_GRADIENTINACTIVECAPTION 28
#define COLOR_MENUHILIGHT             29
#define COLOR_MENUBAR                 30
#define SM_CXSCREEN          0
#define SM_CYSCREEN          1
#define SM_CXVSCROLL         2
#define SM_CYHSCROLL         3
#define SM_CYCAPTION         4
#define SM_CXBORDER          5
#define SM_CYBORDER          6
#define SM_CXDLGFRAME        7
#define SM_CYDLGFRAME        8
#define SM_CYVTHUMB          9
#define SM_CXHTHUMB          10
#define SM_CXICON            11
#define SM_CYICON            12
#define SM_CXCURSOR          13
#define SM_CYCURSOR          14
#define SM_CYMENU            15
#define SM_CXFULLSCREEN      16
#define SM_CYFULLSCREEN      17
#define SM_CYKANJIWINDOW     18
#define SM_MOUSEPRESENT      19
#define SM_CYVSCROLL         20
#define SM_CXHSCROLL         21
#define SM_DEBUG             22
#define SM_SWAPBUTTON        23
#define SM_RESERVED1         24
#define SM_RESERVED2         25
#define SM_RESERVED3         26
#define SM_RESERVED4         27
#define SM_CXMIN             28
#define SM_CYMIN             29
#define SM_CXSIZE            30
#define SM_CYSIZE            31
#define SM_CXFRAME           32
#define SM_CYFRAME           33
#define SM_CXMINTRACK        34
#define SM_CYMINTRACK        35
#define SM_CXDOUBLECLK       36
#define SM_CYDOUBLECLK       37
#define SM_CXICONSPACING     38
#define SM_CYICONSPACING     39
#define SM_MENUDROPALIGNMENT 40
#define SM_PENWINDOWS        41
#define SM_DBCSENABLED       42
#define SM_CMOUSEBUTTONS     43
#define SM_CXFIXEDFRAME      SM_CXDLGFRAME
#define SM_CYFIXEDFRAME      SM_CYDLGFRAME
#define SM_CXSIZEFRAME       SM_CXFRAME
#define SM_CYSIZEFRAME       SM_CYFRAME
#define SM_SECURE            44
#define SM_CXEDGE            45
#define SM_CYEDGE            46
#define SM_CXMINSPACING      47
#define SM_CYMINSPACING      48
#define SM_CXSMICON          49
#define SM_CYSMICON          50
#define SM_CYSMCAPTION       51
#define SM_CXSMSIZE          52
#define SM_CYSMSIZE          53
#define SM_CXMENUSIZE        54
#define SM_CYMENUSIZE        55
#define SM_ARRANGE           56
#define SM_CXMINIMIZED       57
#define SM_CYMINIMIZED       58
#define SM_CXMAXTRACK        59
#define SM_CYMAXTRACK        60
#define SM_CXMAXIMIZED       61
#define SM_CYMAXIMIZED       62
#define SM_NETWORK           63
#define SM_CLEANBOOT         67
#define SM_CXDRAG            68
#define SM_CYDRAG            69
#define SM_SHOWSOUNDS        70
#define SM_CXMENUCHECK       71
#define SM_CYMENUCHECK       72
#define SM_SLOWMACHINE       73
#define SM_MIDEASTENABLED    74
#define SM_MOUSEWHEELPRESENT 75
#define SM_XVIRTUALSCREEN    76
#define SM_YVIRTUALSCREEN    77
#define SM_CXVIRTUALSCREEN   78
#define SM_CYVIRTUALSCREEN   79
#define SM_CMONITORS         80
#define SM_SAMEDISPLAYFORMAT 81
#define SM_IMMENABLED        82
#define SM_CXFOCUSBORDER     83
#define SM_CYFOCUSBORDER     84
#define SM_TABLETPC          86
#define SM_MEDIACENTER       87
#define SM_STARTER           88
#define SM_SERVERR2          89
#define SM_CMETRICS          90
#define SPI_GETBEEP               1
#define SPI_SETBEEP               2
#define SPI_GETMOUSE              3
#define SPI_SETMOUSE              4
#define SPI_GETBORDER             5
#define SPI_SETBORDER             6
#define SPI_GETKEYBOARDSPEED      10
#define SPI_SETKEYBOARDSPEED      11
#define SPI_LANGDRIVER            12
#define SPI_ICONHORIZONTALSPACING 13
#define SPI_GETSCREENSAVETIMEOUT  14
#define SPI_SETSCREENSAVETIMEOUT  15
#define SPI_GETSCREENSAVEACTIVE   16
#define SPI_SETSCREENSAVEACTIVE   17
#define SPI_GETGRIDGRANULARITY    18
#define SPI_SETGRIDGRANULARITY    19
#define SPI_SETDESKWALLPAPER      20
#define SPI_SETDESKPATTERN        21
#define SPI_GETKEYBOARDDELAY      22
#define SPI_SETKEYBOARDDELAY      23
#define SPI_ICONVERTICALSPACING   24
#define SPI_GETICONTITLEWRAP      25
#define SPI_SETICONTITLEWRAP      26
#define SPI_GETMENUDROPALIGNMENT  27
#define SPI_SETMENUDROPALIGNMENT  28
#define SPI_SETDOUBLECLKWIDTH     29
#define SPI_SETDOUBLECLKHEIGHT    30
#define SPI_GETICONTITLELOGFONT   31
#define SPI_SETDOUBLECLICKTIME    32
#define SPI_SETMOUSEBUTTONSWAP    33
#define SPI_SETICONTITLELOGFONT   34
#define SPI_GETFASTTASKSWITCH     35
#define SPI_SETFASTTASKSWITCH     36
#define SPI_SETDRAGFULLWINDOWS    37
#define SPI_GETDRAGFULLWINDOWS    38
#define SPI_GETNONCLIENTMETRICS   41
#define SPI_SETNONCLIENTMETRICS   42
#define SPI_GETMINIMIZEDMETRICS   43
#define SPI_SETMINIMIZEDMETRICS   44
#define SPI_GETICONMETRICS        45
#define SPI_SETICONMETRICS        46
#define SPI_SETWORKAREA           47
#define SPI_GETWORKAREA           48
#define SPI_SETPENWINDOWS         49
#define SPI_GETFILTERKEYS         50
#define SPI_SETFILTERKEYS         51
#define SPI_GETTOGGLEKEYS         52
#define SPI_SETTOGGLEKEYS         53
#define SPI_GETMOUSEKEYS          54
#define SPI_SETMOUSEKEYS          55
#define SPI_GETSHOWSOUNDS         56
#define SPI_SETSHOWSOUNDS         57
#define SPI_GETSTICKYKEYS         58
#define SPI_SETSTICKYKEYS         59
#define SPI_GETACCESSTIMEOUT      60
#define SPI_SETACCESSTIMEOUT      61
#define SPI_GETSERIALKEYS         62
#define SPI_SETSERIALKEYS         63
#define SPI_GETSOUNDSENTRY        64
#define SPI_SETSOUNDSENTRY        65
#define SPI_GETHIGHCONTRAST       66
#define SPI_SETHIGHCONTRAST       67
#define SPI_GETKEYBOARDPREF       68
#define SPI_SETKEYBOARDPREF       69
#define SPI_GETSCREENREADER       70
#define SPI_SETSCREENREADER       71
#define SPI_GETANIMATION          72
#define SPI_SETANIMATION          73
#define SPI_GETFONTSMOOTHING      74
#define SPI_SETFONTSMOOTHING      75
#define SPI_SETDRAGWIDTH          76
#define SPI_SETDRAGHEIGHT         77
#define SPI_SETHANDHELD           78
#define SPI_GETLOWPOWERTIMEOUT    79
#define SPI_GETPOWEROFFTIMEOUT    80
#define SPI_SETLOWPOWERTIMEOUT    81
#define SPI_SETPOWEROFFTIMEOUT    82
#define SPI_GETLOWPOWERACTIVE     83
#define SPI_GETPOWEROFFACTIVE     84
#define SPI_SETLOWPOWERACTIVE     85
#define SPI_SETPOWEROFFACTIVE     86
#define SPI_SETCURSORS            87
#define SPI_SETICONS              88
#define SPI_GETDEFAULTINPUTLANG   89
#define SPI_SETDEFAULTINPUTLANG   90
#define SPI_SETLANGTOGGLE         91
#define SPI_GETWINDOWSEXTENSION   92
#define SPI_SETMOUSETRAILS        93
#define SPI_GETMOUSETRAILS        94
#define SPI_GETSNAPTODEFBUTTON    95
#define SPI_SETSNAPTODEFBUTTON    96
#define SPI_SETSCREENSAVERRUNNING 97
#define SPI_SCREENSAVERRUNNING    SPI_SETSCREENSAVERRUNNING
#define SPI_GETMOUSEHOVERWIDTH    98
#define SPI_SETMOUSEHOVERWIDTH    99
#define SPI_GETMOUSEHOVERHEIGHT   100
#define SPI_SETMOUSEHOVERHEIGHT   101
#define SPI_GETMOUSEHOVERTIME     102
#define SPI_SETMOUSEHOVERTIME     103
#define SPI_GETWHEELSCROLLLINES   104
#define SPI_SETWHEELSCROLLLINES   105
#define SPI_GETMENUSHOWDELAY      106
#define SPI_SETMENUSHOWDELAY      107
#define SPI_GETSHOWIMEUI          110
#define SPI_SETSHOWIMEUI          111
#define SPI_GETMOUSESPEED         112
#define SPI_SETMOUSESPEED         113
#define SPI_GETSCREENSAVERRUNNING 114
#define SPI_GETDESKWALLPAPER      115

/* ja:タイマ */
typedef VOID CALLBACK (*TIMERPROC)(HWND, UINT, UINT, DWORD);

/* ja:描画 */
#define RDW_INVALIDATE      0x0001
#define RDW_INTERNALPAINT   0x0002
#define RDW_ERASE           0x0004
#define RDW_VALIDATE        0x0008
#define RDW_NOINTERNALPAINT 0x0010
#define RDW_NOERASE         0x0020
#define RDW_NOCHILDREN      0x0040
#define RDW_ALLCHILDREN     0x0080
#define RDW_UPDATENOW       0x0100
#define RDW_ERASENOW        0x0200
#define RDW_FRAME           0x0400
#define RDW_NOFRAME         0x0800
#include "pshpack1.h"
typedef struct _POINT
{
  LONG x;
  LONG y;
} POINT, *PPOINT, *LPPOINT;
typedef struct _RECT
{
  LONG left;
  LONG top;
  LONG right;
  LONG bottom;
} RECT, *PRECT, *LPRECT;
typedef const RECT *LPCRECT;
typedef GdkRegion *HRGN;
typedef struct _PAINTSTRUCT
{
  HDC hdc;
  BOOL fErase;
  RECT rcPaint;
  BOOL fRestore;
  BOOL fIncUpdate;
  BYTE rgbReserved[32];
} PAINTSTRUCT, *PPAINTSTRUCT, *LPPAINTSTRUCT;
#include "poppack.h"

/* ja:イメージ */
#define IMAGE_BITMAP      0
#define IMAGE_ICON        1
#define IMAGE_CURSOR      2
#define IMAGE_ENHMETAFILE 3
#define LR_DEFAULTCOLOR     0x0000
#define LR_MONOCHROME       0x0001
#define LR_COLOR            0x0002
#define LR_COPYRETURNORG    0x0004
#define LR_COPYDELETEORG    0x0008
#define LR_LOADFROMFILE     0x0010
#define LR_LOADTRANSPARENT  0x0020
#define LR_DEFAULTSIZE      0x0040
#define LR_VGA_COLOR        0x0080
#define LR_LOADMAP3DCOLORS  0x1000
#define LR_CREATEDIBSECTION 0x2000
#define LR_COPYFROMRESOURCE 0x4000
#define LR_SHARED           0x8000

/* ja:アイコン */
#define OIC_SAMPLE      32512
#define OIC_HAND        32513
#define OIC_ERROR       OIC_HAND
#define OIC_QUES        32514
#define OIC_BANG        32515
#define OIC_WARNING     OIC_BANG
#define OIC_NOTE        32516
#define OIC_INFORMATION OIC_NOTE
#define OIC_WINLOGO     32517
#define IDI_APPLICATION MAKEINTRESOURCE(OIC_SAMPLE)
#define IDI_HAND        MAKEINTRESOURCE(OIC_HAND)
#define IDI_ERROR       IDI_HAND
#define IDI_QUESTION    MAKEINTRESOURCE(OIC_QUES)
#define IDI_EXCLAMATION MAKEINTRESOURCE(OIC_BANG)
#define IDI_WARNING     IDI_EXCLAMATION
#define IDI_ASTERISK    MAKEINTRESOURCE(OIC_NOTE)
#define IDI_INFORMATION IDI_ASTERISK
#define IDI_WINLOGO     MAKEINTRESOURCE(OIC_WINLOGO)
typedef GdkPixbuf *HICON;

/* ja:カーソル */
#define OCR_NORMAL      32512
#define OCR_IBEAM       32513
#define OCR_WAIT        32514
#define OCR_CROSS       32515
#define OCR_UP          32516
#define OCR_SIZE        32640
#define OCR_ICON        32641
#define OCR_SIZENWSE    32642
#define OCR_SIZENESW    32643
#define OCR_SIZEWE      32644
#define OCR_SIZENS      32645
#define OCR_SIZEALL     32646
#define OCR_NO          32648
#define OCR_HAND        32649
#define OCR_APPSTARTING 32650
#define OCR_HELP        32651
#define IDC_ARROW       MAKEINTRESOURCE(OCR_NORMAL)
#define IDC_IBEAM       MAKEINTRESOURCE(OCR_IBEAM)
#define IDC_WAIT        MAKEINTRESOURCE(OCR_WAIT)
#define IDC_CROSS       MAKEINTRESOURCE(OCR_CROSS)
#define IDC_UPARROW     MAKEINTRESOURCE(OCR_UP)
#define IDC_SIZE        MAKEINTRESOURCE(OCR_SIZE)
#define IDC_ICON        MAKEINTRESOURCE(OCR_ICON)
#define IDC_SIZENWSE    MAKEINTRESOURCE(OCR_SIZENWSE)
#define IDC_SIZENESW    MAKEINTRESOURCE(OCR_SIZENESW)
#define IDC_SIZEWE      MAKEINTRESOURCE(OCR_SIZEWE)
#define IDC_SIZENS      MAKEINTRESOURCE(OCR_SIZENS)
#define IDC_SIZEALL     MAKEINTRESOURCE(OCR_SIZEALL)
#define IDC_NO          MAKEINTRESOURCE(OCR_NO)
#define IDC_HAND        MAKEINTRESOURCE(OCR_HAND)
#define IDC_APPSTARTING MAKEINTRESOURCE(OCR_APPSTARTING)
#define IDC_HELP        MAKEINTRESOURCE(OCR_HELP)
typedef GdkCursor *HCURSOR;

/* ja:ビットマップ */
#define OBM_TRTYPE      32732
#define OBM_LFARROWI    32734
#define OBM_RGARROWI    32735
#define OBM_DNARROWI    32736
#define OBM_UPARROWI    32737
#define OBM_COMBO       32738
#define OBM_MNARROW     32739
#define OBM_LFARROWD    32740
#define OBM_RGARROWD    32741
#define OBM_DNARROWD    32742
#define OBM_UPARROWD    32743
#define OBM_RESTORED    32744
#define OBM_ZOOMD       32745
#define OBM_REDUCED     32746
#define OBM_RESTORE     32747
#define OBM_ZOOM        32748
#define OBM_REDUCE      32749
#define OBM_LFARROW     32750
#define OBM_RGARROW     32751
#define OBM_DNARROW     32752
#define OBM_UPARROW     32753
#define OBM_CLOSE       32754
#define OBM_OLD_RESTORE 32755
#define OBM_OLD_ZOOM    32756
#define OBM_OLD_REDUCE  32757
#define OBM_BTNCORNERS  32758
#define OBM_CHECKBOXES  32759
#define OBM_CHECK       32760
#define OBM_BTSIZE      32761
#define OBM_OLD_LFARROW 32762
#define OBM_OLD_RGARROW 32763
#define OBM_OLD_DNARROW 32764
#define OBM_OLD_UPARROW 32765
#define OBM_SIZE        32766
#define OBM_OLD_CLOSE   32767
typedef GdkPixbuf *HBITMAP;
#include "pshpack1.h"
typedef struct _BITMAPINFOHEADER
{
  DWORD biSize;
  LONG biWidth;
  LONG biHeight;
  WORD biPlanes;
  WORD biBitCount;
  DWORD biCompression;
  DWORD biSizeImage;
  LONG biXPelsPerMeter;
  LONG biYPelsPerMeter;
  DWORD biClrUsed;
  DWORD biClrImportant;
} BITMAPINFOHEADER, *PBITMAPINFOHEADER, *LPBITMAPINFOHEADER;
#include "poppack.h"

/* ja:メニュー */
#include "w32menu.h"

/* ja:アクセラレータ */
typedef LPVOID HACCEL;

/* ja:仮想キー */
#define VK_LBUTTON             0x01
#define VK_RBUTTON             0x02
#define VK_CANCEL              0x03
#define VK_MBUTTON             0x04
#define VK_XBUTTON1            0x05
#define VK_XBUTTON2            0x06
#define VK_BACK                0x08
#define VK_TAB                 0x09
#define VK_CLEAR               0x0c
#define VK_RETURN              0x0d
#define VK_SHIFT               0x10
#define VK_CONTROL             0x11
#define VK_MENU                0x12
#define VK_PAUSE               0x13
#define VK_CAPITAL             0x14
#define VK_KANA                0x15
#define VK_HANGEUL             0x15
#define VK_HANGUL              0x15
#define VK_JUNJA               0x17
#define VK_FINAL               0x18
#define VK_HANJA               0x19
#define VK_KANJI               0x19
#define VK_ESCAPE              0x1b
#define VK_CONVERT             0x1c
#define VK_NONCONVERT          0x1d
#define VK_ACCEPT              0x1e
#define VK_MODECHANGE          0x1f
#define VK_SPACE               0x20
#define VK_PRIOR               0x21
#define VK_NEXT                0x22
#define VK_END                 0x23
#define VK_HOME                0x24
#define VK_LEFT                0x25
#define VK_UP                  0x26
#define VK_RIGHT               0x27
#define VK_DOWN                0x28
#define VK_SELECT              0x29
#define VK_PRINT               0x2a
#define VK_EXECUTE             0x2b
#define VK_SNAPSHOT            0x2c
#define VK_INSERT              0x2d
#define VK_DELETE              0x2e
#define VK_HELP                0x2f
#define VK_0                   0x30
#define VK_1                   0x31
#define VK_2                   0x32
#define VK_3                   0x33
#define VK_4                   0x34
#define VK_5                   0x35
#define VK_6                   0x36
#define VK_7                   0x37
#define VK_8                   0x38
#define VK_9                   0x39
#define VK_A                   0x41
#define VK_B                   0x42
#define VK_C                   0x43
#define VK_D                   0x44
#define VK_E                   0x45
#define VK_F                   0x46
#define VK_G                   0x47
#define VK_H                   0x48
#define VK_I                   0x49
#define VK_J                   0x4a
#define VK_K                   0x4b
#define VK_L                   0x4c
#define VK_M                   0x4d
#define VK_N                   0x4e
#define VK_O                   0x4f
#define VK_P                   0x50
#define VK_Q                   0x51
#define VK_R                   0x52
#define VK_S                   0x53
#define VK_T                   0x54
#define VK_U                   0x55
#define VK_V                   0x56
#define VK_W                   0x57
#define VK_X                   0x58
#define VK_Y                   0x59
#define VK_Z                   0x5a
#define VK_LWIN                0x5b
#define VK_RWIN                0x5c
#define VK_APPS                0x5d
#define VK_SLEEP               0x5f
#define VK_NUMPAD0             0x60
#define VK_NUMPAD1             0x61
#define VK_NUMPAD2             0x62
#define VK_NUMPAD3             0x63
#define VK_NUMPAD4             0x64
#define VK_NUMPAD5             0x65
#define VK_NUMPAD6             0x66
#define VK_NUMPAD7             0x67
#define VK_NUMPAD8             0x68
#define VK_NUMPAD9             0x69
#define VK_MULTIPLY            0x6a
#define VK_ADD                 0x6b
#define VK_SEPARATOR           0x6c
#define VK_SUBTRACT            0x6d
#define VK_DECIMAL             0x6e
#define VK_DIVIDE              0x6f
#define VK_F1                  0x70
#define VK_F2                  0x71
#define VK_F3                  0x72
#define VK_F4                  0x73
#define VK_F5                  0x74
#define VK_F6                  0x75
#define VK_F7                  0x76
#define VK_F8                  0x77
#define VK_F9                  0x78
#define VK_F10                 0x79
#define VK_F11                 0x7a
#define VK_F12                 0x7b
#define VK_F13                 0x7c
#define VK_F14                 0x7d
#define VK_F15                 0x7e
#define VK_F16                 0x7f
#define VK_F17                 0x80
#define VK_F18                 0x81
#define VK_F19                 0x82
#define VK_F20                 0x83
#define VK_F21                 0x84
#define VK_F22                 0x85
#define VK_F23                 0x86
#define VK_F24                 0x87
#define VK_NUMLOCK             0x90
#define VK_SCROLL              0x91
#define VK_OEM_NEC_EQUAL       0x92
#define VK_OEM_FJ_JISHO        0x92
#define VK_OEM_FJ_MASSHOU      0x93
#define VK_OEM_FJ_TOUROKU      0x94
#define VK_OEM_FJ_LOYA         0x95
#define VK_OEM_FJ_ROYA         0x96
#define VK_LSHIFT              0xa0
#define VK_RSHIFT              0xa1
#define VK_LCONTROL            0xa2
#define VK_RCONTROL            0xa3
#define VK_LMENU               0xa4
#define VK_RMENU               0xa5
#define VK_BROWSER_BACK        0xa6
#define VK_BROWSER_FORWARD     0xa7
#define VK_BROWSER_REFRESH     0xa8
#define VK_BROWSER_STOP        0xa9
#define VK_BROWSER_SEARCH      0xaa
#define VK_BROWSER_FAVORITES   0xab
#define VK_BROWSER_HOME        0xac
#define VK_VOLUME_MUTE         0xad
#define VK_VOLUME_DOWN         0xae
#define VK_VOLUME_UP           0xaf
#define VK_MEDIA_NEXT_TRACK    0xb0
#define VK_MEDIA_PREV_TRACK    0xb1
#define VK_MEDIA_STOP          0xb2
#define VK_MEDIA_PLAY_PAUSE    0xb3
#define VK_LAUNCH_MAIL         0xb4
#define VK_LAUNCH_MEDIA_SELECT 0xb5
#define VK_LAUNCH_APP1         0xb6
#define VK_LAUNCH_APP2         0xb7
#define VK_OEM_1               0xba
#define VK_OEM_PLUS            0xbb
#define VK_OEM_COMMA           0xbc
#define VK_OEM_MINUS           0xbd
#define VK_OEM_PERIOD          0xbe
#define VK_OEM_2               0xbf
#define VK_OEM_3               0xc0
#define VK_OEM_4               0xcb
#define VK_OEM_5               0xcc
#define VK_OEM_6               0xcd
#define VK_OEM_7               0xce
#define VK_OEM_8               0xcf
#define VK_OEM_AX              0xe1
#define VK_OEM_102             0xe2
#define VK_ICO_HELP            0xe3
#define VK_ICO_00              0xe4
#define VK_PROCESSKEY          0xe5
#define VK_ATTN                0xf6
#define VK_CRSEL               0xf7
#define VK_EXSEL               0xf8
#define VK_EREOF               0xf9
#define VK_PLAY                0xfa
#define VK_ZOOM                0xfb
#define VK_NONAME              0xfc
#define VK_PA1                 0xfd
#define VK_OEM_CLEAR           0xfe

/* ja:クリップボード */
#define CF_TEXT        1
#define CF_BITMAP      2
#define CF_OEMTEXT     7
#define CF_DIB         8
#define CF_UNICODETEXT 13

/* ja:メッセージ */
#define PM_NOREMOVE 0x0000
#define PM_REMOVE   0x0001
#include "pshpack1.h"
typedef struct _MSG
{
  HWND hwnd;
  UINT message;
  WPARAM wParam;
  LPARAM lParam;
  DWORD time;
  POINT pt;
} MSG, *PMSG, *LPMSG;
#include "poppack.h"

/* ja:ウインドウ */
#include "w32wnd.h"
#define CreateWindowA(a,b,c,d,e,f,g,h,i,j,k) CreateWindowExA(0,a,b,c,d,e,f,g,h,i,j,k)
#define CreateWindowW(a,b,c,d,e,f,g,h,i,j,k) CreateWindowExW(0,a,b,c,d,e,f,g,h,i,j,k)
#ifdef UNICODE
# define CreateWindow(a,b,c,d,e,f,g,h,i,j,k) CreateWindowExW(0,a,b,c,d,e,f,g,h,i,j,k)
#else /* not UNICODE */
# define CreateWindow(a,b,c,d,e,f,g,h,i,j,k) CreateWindowExA(0,a,b,c,d,e,f,g,h,i,j,k)
#endif /* not UNICODE */
#define HWND_DESKTOP NULL
#define CW_USEDEFAULT ((INT)0x80000000)
#define GWL_USERDATA   (-21)
#define GWL_EXSTYLE    (-20)
#define GWL_STYLE      (-16)
#define GWL_ID         (-12)
#define GWL_HWNDPARENT (-8)
#define GWL_HINSTANCE  (-6)
#define GWL_WNDPROC    (-4)
#define DWL_MSGRESULT 0
#define DWL_DLGPROC   4
#define DWL_USER      8
#define GW_HWNDFIRST 0
#define GW_HWNDLAST  1
#define GW_HWNDNEXT  2
#define GW_HWNDPREV  3
#define GW_OWNER     4
#define GW_CHILD     5
#define SW_HIDE            0
#define SW_SHOWNORMAL      1
#define SW_NORMAL          1
#define SW_SHOWMINIMIZED   2
#define SW_SHOWMAXIMIZED   3
#define SW_MAXIMIZE        3
#define SW_SHOWNOACTIVATE  4
#define SW_SHOW            5
#define SW_MINIMIZE        6
#define SW_SHOWMINNOACTIVE 7
#define SW_SHOWNA          8
#define SW_RESTORE         9
#define SW_SHOWDEFAULT     10
#define SW_FORCEMINIMIZE   11
#define SW_MAX             11
#define SW_NORMALNA        0xcc
#define HWND_TOP       ((HWND)0)
#define HWND_BOTTOM    ((HWND)1)
#define HWND_TOPMOST   ((HWND)-1)
#define HWND_NOTOPMOST ((HWND)-2)
#define HWND_MESSAGE   ((HWND)-3)
#define SWP_NOSIZE         0x0001
#define SWP_NOMOVE         0x0002
#define SWP_NOZORDER       0x0004
#define SWP_NOREDRAW       0x0008
#define SWP_NOACTIVATE     0x0010
#define SWP_FRAMECHANGED   0x0020
#define SWP_SHOWWINDOW     0x0040
#define SWP_HIDEWINDOW     0x0080
#define SWP_NOCOPYBITS     0x0100
#define SWP_NOOWNERZORDER  0x0200
#define SWP_DRAWFRAME      SWP_FRAMECHANGED
#define SWP_NOREPOSITION   SWP_NOOWNERZORDER
#define SWP_NOSENDCHANGING 0x0400
#define SWP_DEFERERASE     0x2000
#define SWP_ASYNCWINDOWPOS 0x4000
typedef LRESULT (CALLBACK *WNDPROC)(HWND, UINT, WPARAM, LPARAM);
typedef INT_PTR (CALLBACK *DLGPROC)(HWND, UINT, WPARAM, LPARAM);
typedef BOOL CALLBACK (*WNDENUMPROC)(HWND, LPARAM);
#include "pshpack1.h"
typedef struct _WNDCLASSA
{
  UINT style;
  WNDPROC lpfnWndProc;
  INT cbClsExtra;
  INT cbWndExtra;
  HINSTANCE hInstance;
  HICON hIcon;
  HCURSOR hCursor;
  HBRUSH hbrBackground;
  LPCSTR lpszMenuName;
  LPCSTR lpszClassName;
} WNDCLASSA, *PWNDCLASSA, *LPWNDCLASSA;
typedef struct _WNDCLASSW
{
  UINT style;
  WNDPROC lpfnWndProc;
  INT cbClsExtra;
  INT cbWndExtra;
  HINSTANCE hInstance;
  HICON hIcon;
  HCURSOR hCursor;
  HBRUSH hbrBackground;
  LPCWSTR lpszMenuName;
  LPCWSTR lpszClassName;
} WNDCLASSW, *PWNDCLASSW, *LPWNDCLASSW;
#include "poppack.h"
#ifdef UNICODE
# define WNDCLASS WNDCLASSW
# define PWNDCLASS PWNDCLASSW
# define LPWNDCLASS LPWNDCLASSW
#else /* not UNICODE */
# define WNDCLASS WNDCLASSA
# define PWNDCLASS PWNDCLASSA
# define LPWNDCLASS LPWNDCLASSA
#endif /* not UNICODE */
#include "pshpack1.h"
typedef struct _WNDCLASSEXA
{
  UINT cbSize;
  UINT style;
  WNDPROC lpfnWndProc;
  INT cbClsExtra;
  INT cbWndExtra;
  HINSTANCE hInstance;
  HICON hIcon;
  HCURSOR hCursor;
  HBRUSH hbrBackground;
  LPCSTR lpszMenuName;
  LPCSTR lpszClassName;
  HICON hIconSm;
} WNDCLASSEXA, *PWNDCLASSEXA, *LPWNDCLASSEXA;
typedef struct _WNDCLASSEXW
{
  UINT cbSize;
  UINT style;
  WNDPROC lpfnWndProc;
  INT cbClsExtra;
  INT cbWndExtra;
  HINSTANCE hInstance;
  HICON hIcon;
  HCURSOR hCursor;
  HBRUSH hbrBackground;
  LPCWSTR lpszMenuName;
  LPCWSTR lpszClassName;
  HICON hIconSm;
} WNDCLASSEXW, *PWNDCLASSEXW, *LPWNDCLASSEXW;
#include "poppack.h"
#ifdef UNICODE
# define WNDCLASSEX WNDCLASSEXW
# define PWNDCLASSEX PWNDCLASSEXW
# define LPWNDCLASSEX LPWNDCLASSEXW
#else /* not UNICODE */
# define WNDCLASSEX WNDCLASSEXA
# define PWNDCLASSEX PWNDCLASSEXA
# define LPWNDCLASSEX LPWNDCLASSEXA
#endif /* not UNICODE */
#include "pshpack1.h"
typedef struct _CREATESTRUCTA
{
  LPVOID lpCreateParams;
  HINSTANCE hInstance;
  HMENU hMenu;
  HWND hwndParent;
  INT cy;
  INT cx;
  INT y;
  INT x;
  LONG style;
  LPCSTR lpszName;
  LPCSTR lpszClass;
  DWORD dwExStyle;
} CREATESTRUCTA, *PCREATESTRUCTA, *LPCREATESTRUCTA;
typedef struct _CREATESTRUCTW
{
  LPVOID lpCreateParams;
  HINSTANCE hInstance;
  HMENU hMenu;
  HWND hwndParent;
  INT cy;
  INT cx;
  INT y;
  INT x;
  LONG style;
  LPCWSTR lpszName;
  LPCWSTR lpszClass;
  DWORD dwExStyle;
} CREATESTRUCTW, *PCREATESTRUCTW, *LPCREATESTRUCTW;
#include "poppack.h"
#ifdef UNICODE
# define CREATESTRUCT CREATESTRUCTW
# define PCREATESTRUCT PCREATESTRUCTW
# define LPCREATESTRUCT LPCREATESTRUCTW
#else /* not UNICODE */
# define CREATESTRUCT CREATESTRUCTA
# define PCREATESTRUCT PCREATESTRUCTA
# define LPCREATESTRUCT LPCREATESTRUCTA
#endif /* not UNICODE */

/* ja:ダイアログ */
#include "w32dlg.h"
#define CreateDialogA(a,b,c,d) CreateDialogParamA(a,b,c,d,0)
#define CreateDialogW(a,b,c,d) CreateDialogParamW(a,b,c,d,0)
#define DialogBoxA(a,b,c,d) DialogBoxParamA(a,b,c,d,0)
#define DialogBoxW(a,b,c,d) DialogBoxParamW(a,b,c,d,0)
#ifdef UNICODE
# define CreateDialog(a,b,c,d) CreateDialogParamW(a,b,c,d,0)
# define DialogBox(a,b,c,d) DialogBoxParamW(a,b,c,d,0)
#else /* not UNICODE */
# define CreateDialog(a,b,c,d) CreateDialogParamA(a,b,c,d,0)
# define DialogBox(a,b,c,d) DialogBoxParamA(a,b,c,d,0)
#endif /* not UNICODE */
#include "pshpack2.h"
typedef struct _DLGTEMPLATE
{
  DWORD style;
  DWORD exstyle;
  WORD cdit;
  SHORT x;
  SHORT y;
  SHORT cx;
  SHORT cy;
} DLGTEMPLATE, *PDLGTEMPLATE, *LPDLGTEMPLATE;
typedef CONST DLGTEMPLATE *PCDLGTEMPLATE, *LPCDLGTEMPLATE;
typedef struct _DLGITEMTEMPLATE
{
  DWORD style;
  DWORD exstyle;
  SHORT x;
  SHORT y;
  SHORT cx;
  SHORT cy;
  WORD ID;
} DLGITEMTEMPLATE, *PDLGITEMTEMPLATE, *LPDLGITEMTEMPLATE;
typedef CONST DLGITEMTEMPLATE *PCDLGITEMTEMPLATE, *LCPDLGITEMTEMPLATE;
typedef struct _DLGTEMPLATEEX
{
  WORD dlgVer;
  WORD signature;
  DWORD helpID;
  DWORD exstyle;
  DWORD style;
  WORD cdit;
  SHORT x;
  SHORT y;
  SHORT cx;
  SHORT cy;
} DLGTEMPLATEEX, *PDLGTEMPLATEEX, *LPDLGTEMPLATEEX;
typedef CONST DLGTEMPLATEEX *PCDLGTEMPLATEEX, *LPCDLGTEMPLATEEX;
typedef struct _DLGITEMTEMPLATEEX
{
  DWORD helpID;
  DWORD exstyle;
  DWORD style;
  SHORT x;
  SHORT y;
  SHORT cx;
  SHORT cy;
  WORD ID;
} DLGITEMTEMPLATEEX, *PDLGITEMTEMPLATEEX, *LPDLGITEMTEMPLATEEX;
typedef CONST DLGITEMTEMPLATEEX *PCDLGITEMTEMPLATEEX, *LPCDLGITEMTEMPLATEEX;
#include "poppack.h"

/* ja:メッセージボックス */
#define MB_OK                   0x00000000
#define MB_OKCANCEL             0x00000001
#define MB_ABORTRETRYIGNORE     0x00000002
#define MB_YESNOCANCEL          0x00000003
#define MB_YESNO                0x00000004
#define MB_RETRYCANCEL          0x00000005
#define MB_TYPEMASK             0x0000000F
#define MB_ICONHAND             0x00000010
#define MB_ICONQUESTION         0x00000020
#define MB_ICONEXCLAMATION      0x00000030
#define MB_ICONASTERISK         0x00000040
#define MB_USERICON             0x00000080
#define MB_ICONMASK             0x000000F0
#define MB_ICONINFORMATION      MB_ICONASTERISK
#define MB_ICONSTOP             MB_ICONHAND
#define MB_ICONWARNING          MB_ICONEXCLAMATION
#define MB_ICONERROR            MB_ICONHAND
#define MB_DEFBUTTON1           0x00000000
#define MB_DEFBUTTON2           0x00000100
#define MB_DEFBUTTON3           0x00000200
#define MB_DEFBUTTON4           0x00000300
#define MB_DEFMASK              0x00000f00
#define MB_APPLMODAL            0x00000000
#define MB_SYSTEMMODAL          0x00001000
#define MB_TASKMODAL            0x00002000
#define MB_MODEMASK             0x00003000
#define MB_HELP                 0x00004000
#define MB_NOFOCUS              0x00008000
#define MB_MISCMASK             0x0000C000
#define MB_SETFOREGROUND        0x00010000
#define MB_DEFAULT_DESKTOP_ONLY 0x00020000
#define MB_SERVICE_NOTIFICATION 0x00040000
#define MB_TOPMOST              0x00040000
#define MB_RIGHT                0x00080000
#define MB_RTLREADING           0x00100000
/* en:ID */
#define IDOK       1
#define IDCANCEL   2
#define IDABORT    3
#define IDRETRY    4
#define IDIGNORE   5
#define IDYES      6
#define IDNO       7
#define IDCLOSE    8
#define IDHELP     9
#define IDTRYAGAIN 10
#define IDCONTINUE 11


extern W32LdrExport user32_exports[];


BOOL WINAPI AppendMenuA (HMENU hMenu, UINT uFlags, UINT_PTR uItem, LPCSTR lpszItem);
BOOL WINAPI AppendMenuW (HMENU hMenu, UINT uFlags, UINT_PTR uItem, LPCWSTR lpszItem);
HDC WINAPI BeginPaint (HWND hWnd, LPPAINTSTRUCT lpPaint);
LRESULT WINAPI CallWindowProcA (WNDPROC lpPrevWndFunc, HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI CallWindowProcW (WNDPROC lpPrevWndFunc, HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LPSTR WINAPI CharLowerA (LPSTR lpsz);
LPWSTR WINAPI CharLowerW (LPWSTR lpsz);
LPSTR WINAPI CharUpperA (LPSTR lpsz);
LPWSTR WINAPI CharUpperW (LPWSTR lpsz);
BOOL WINAPI CheckDlgButton (HWND hDlg, INT nIDButton, UINT uCheck);
DWORD WINAPI CheckMenuItem (HMENU hMenu, UINT uItem, UINT uFlags);
BOOL WINAPI CheckMenuRadioItem (HMENU hMenu, UINT uFirst, UINT uLast, UINT uCheck, UINT uFlags);
BOOL WINAPI CheckRadioButton (HWND hDlg, INT nIDFirstButton, INT nIDLastButton, INT nIDCheckButton);
BOOL WINAPI ClientToScreen (HWND hWnd, LPPOINT lpPoint);
BOOL WINAPI ClipCursor (CONST LPRECT lpRect);
BOOL WINAPI CloseClipboard (VOID);
BOOL WINAPI CloseWindow (HWND hWnd);
HICON WINAPI CopyIcon (HICON hIcon);
HANDLE WINAPI CopyImage (HANDLE hImage, UINT uType, INT cxDesired, INT cyDesired, UINT fuFlags);
BOOL WINAPI CopyRect (LPRECT lprcDst, CONST LPRECT lprcSrc);
HWND WINAPI CreateDialogIndirectParamA (HINSTANCE hInstance, LPCDLGTEMPLATE lpDialogTemplate, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
HWND WINAPI CreateDialogIndirectParamW (HINSTANCE hInstance, LPCDLGTEMPLATE lpDialogTemplate, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
HWND WINAPI CreateDialogParamA (HINSTANCE hInstance, LPCSTR lpTemplateName, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
HWND WINAPI CreateDialogParamW (HINSTANCE hInstance, LPCWSTR lpTemplateName, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
HMENU WINAPI CreateMenu (VOID);
HMENU WINAPI CreatePopupMenu (VOID);
HWND WINAPI CreateWindowExA (DWORD dwExStyle, LPCSTR lpClassName, LPCSTR lpWindowName, DWORD dwStyle, INT x, INT y, INT nWidth, INT nHeight, HWND hWndParent, HMENU hMenu, HINSTANCE hInstance, LPVOID lpParam);
HWND WINAPI CreateWindowExW (DWORD dwExStyle, LPCWSTR lpClassName, LPCWSTR lpWindowName, DWORD dwStyle, INT x, INT y, INT nWidth, INT nHeight, HWND hWndParent, HMENU hMenu, HINSTANCE hInstance, LPVOID lpParam);
LRESULT WINAPI DefWindowProcA (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI DefWindowProcW (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
BOOL WINAPI DeleteMenu (HMENU hMenu, UINT uItem, UINT uFlags);
BOOL WINAPI DestroyCursor (HCURSOR hCursor);
BOOL WINAPI DestroyIcon (HICON hIcon);
BOOL WINAPI DestroyMenu (HMENU hMenu);
BOOL WINAPI DestroyWindow (HWND hWnd);
INT WINAPI DialogBoxIndirectParamA (HINSTANCE hInstance, LPCDLGTEMPLATE lpDialogTemplate, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
INT WINAPI DialogBoxIndirectParamW (HINSTANCE hInstance, LPCDLGTEMPLATE lpDialogTemplate, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
INT WINAPI DialogBoxParamA (HINSTANCE hInstance, LPCSTR lpTemplateName, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
INT WINAPI DialogBoxParamW (HINSTANCE hInstance, LPCWSTR lpTemplateName, HWND hWndParent, DLGPROC lpDialogFunc, LPARAM dwInitParam);
LONG WINAPI DispatchMessageA (LPMSG lpMsg);
LONG WINAPI DispatchMessageW (LPMSG lpMsg);
BOOL WINAPI DrawMenuBar (HWND hWnd);
BOOL WINAPI EmptyClipboard (VOID);
BOOL EnableMenuItem (HMENU hMenu, UINT uItem, UINT uFlags);
BOOL WINAPI EnableWindow (HWND hWnd, BOOL bEnable);
BOOL WINAPI EndDialog (HWND hDlg, INT nResult);
BOOL WINAPI EndMenu (VOID);
BOOL WINAPI EndPaint (HWND hWnd, LPPAINTSTRUCT lpPaint);
BOOL WINAPI EnumThreadWindows (DWORD dwThreadId, WNDENUMPROC lpEnumFunc, LPARAM lParam);
BOOL WINAPI EnumWindows (WNDENUMPROC lpEnumFunc, LPARAM lParam);
BOOL WINAPI EqualRect (CONST LPRECT lprc1, CONST LPRECT lprc2);
INT WINAPI GetClassNameA (HWND hWnd, LPSTR lpClassName, INT nMaxCount);
INT WINAPI GetClassNameW (HWND hWnd, LPWSTR lpClassName, INT nMaxCount);
BOOL WINAPI GetClientRect (HWND hWnd, LPRECT lpRect);
HCURSOR WINAPI GetCursor (VOID);
BOOL WINAPI GetCursorPos (LPPOINT lpPoint);
HDC WINAPI GetDC (HWND hWnd);
HWND WINAPI GetDesktopWindow (VOID);
INT WINAPI GetDlgCtrlID (HWND hWndCtl);
HWND WINAPI GetDlgItem (HWND hDlg, INT nIDDlgItem);
UINT WINAPI GetDlgItemInt (HWND hDlg, INT nIDDlgItem, BOOL *lpTranslated, BOOL bSigned);
UINT WINAPI GetDlgItemTextA (HWND hDlg, INT nIDDlgItem, LPSTR lpString, INT nMaxCount);
UINT WINAPI GetDlgItemTextW (HWND hDlg, INT nIDDlgItem, LPWSTR lpString, INT nMaxCount);
HWND WINAPI GetFocus (VOID);
INT WINAPI GetKeyboardType (INT nTypeFlag);
HMENU WINAPI GetMenu (HWND hWnd);
LONG WINAPI GetMenuCheckMarkDimensions (VOID);
UINT WINAPI GetMenuDefaultItem (HMENU hMenu, UINT uByPos, UINT gmdiFlags);
INT WINAPI GetMenuItemCount (HMENU hMenu);
UINT WINAPI GetMenuItemID (HMENU hMenu, INT nPos);
BOOL WINAPI GetMenuItemInfoA (HMENU hMenu, UINT uItem, BOOL fByPosition, LPMENUITEMINFOA lpmii);
BOOL WINAPI GetMenuItemInfoW (HMENU hMenu, UINT uItem, BOOL fByPosition, LPMENUITEMINFOW lpmii);
BOOL WINAPI GetMenuItemRect (HWND hWnd, HMENU hMenu, UINT uItem, LPRECT lprcItem);
UINT WINAPI GetMenuState (HMENU hMenu, UINT uItem, UINT uFlags);
INT WINAPI GetMenuStringA (HMENU hMenu, UINT uItem, LPSTR lpszString, INT cchMax, UINT uFlags);
INT WINAPI GetMenuStringW (HMENU hMenu, UINT uItem, LPWSTR lpszString, INT cchMax, UINT uFlags);
BOOL WINAPI WINAPI GetMessageA (LPMSG lpMsg, HWND hWnd, UINT wMsgFilterMin, UINT wMsgFilterMax);
BOOL WINAPI GetMessageW (LPMSG lpMsg, HWND hWnd, UINT wMsgFilterMin, UINT wMsgFilterMax);
HWND WINAPI GetParent (HWND hWnd);
INT WINAPI GetScrollPos (HWND hWnd, INT nBar);
BOOL WINAPI GetScrollRange (HWND hWnd, INT nBar, LPINT lpMinPos, LPINT lpMaxPos);
HMENU WINAPI GetSubMenu (HMENU hMenu, INT nPos);
DWORD WINAPI GetSysColor (int nIndex);
HMENU WINAPI GetSystemMenu (HWND hWnd, BOOL bRevert);
INT WINAPI GetSystemMetrics (INT nIndex);
HWND WINAPI GetWindow (HWND hWnd, UINT uCmd);
LONG WINAPI GetWindowLongA (HWND hWnd, INT nIndex);
LONG WINAPI GetWindowLongW (HWND hWnd, INT nIndex);
BOOL WINAPI GetWindowRect (HWND hWnd, LPRECT lpRect);
INT WINAPI GetWindowTextA (HWND hWnd, LPSTR lpString, INT nMaxCount);
INT WINAPI GetWindowTextLengthA (HWND hWnd);
INT WINAPI GetWindowTextLengthW (HWND hWnd);
INT WINAPI GetWindowTextW (HWND hWnd, LPWSTR lpString, INT nMaxCount);
BOOL WINAPI HiliteMenuItem (HWND hWnd, HMENU hMenu, UINT uItem, UINT uFlags);
BOOL WINAPI InflateRect (LPRECT lprc, INT dx, INT dy);
BOOL WINAPI InsertMenuA (HMENU hMenu, UINT uItem, UINT uFlags, UINT_PTR uNewItem, LPCSTR lpszNewItem);
BOOL WINAPI InsertMenuItemA (HMENU hMenu, UINT uItem, BOOL fByPosition, LPMENUITEMINFOA lpmii);
BOOL WINAPI InsertMenuItemW (HMENU hMenu, UINT uItem, BOOL fByPosition, LPMENUITEMINFOW lpmii);
BOOL WINAPI InsertMenuW (HMENU hMenu, UINT uItem, UINT uFlags, UINT_PTR uNewItem, LPCWSTR lpszNewItem);
BOOL WINAPI IntersectRect (LPRECT lprcDst, CONST LPRECT lprcSrc1, CONST LPRECT lprcSrc2);
BOOL WINAPI InvalidateRect (HWND hWnd, CONST RECT *lpRect, BOOL bErase);
BOOL WINAPI IsChild (HWND hWndParent, HWND hWndChild);
UINT WINAPI IsDlgButtonChecked (HWND hDlg, INT nIDButton);
BOOL WINAPI IsMenu (HMENU hMenu);
BOOL WINAPI IsRectEmpty (CONST LPRECT lprc);
BOOL WINAPI IsWindowEnabled (HWND hWnd);
BOOL WINAPI IsWindowUnicode (HWND hWnd);
BOOL WINAPI KillTimer (HWND hWnd, UINT uIDEvent);
HACCEL WINAPI LoadAcceleratorsA (HINSTANCE hInstance, LPCSTR lpTableName);
HACCEL WINAPI LoadAcceleratorsW (HINSTANCE hInstance, LPCWSTR lpTableName);
HBITMAP WINAPI LoadBitmapA (HINSTANCE hInstance, LPCSTR lpBitmapName);
HBITMAP WINAPI LoadBitmapW (HINSTANCE hInstance, LPCWSTR lpBitmapName);
HCURSOR WINAPI LoadCursorA (HINSTANCE hInstance, LPCSTR lpCursorName);
HCURSOR WINAPI LoadCursorW (HINSTANCE hInstance, LPCWSTR lpCursorName);
HICON WINAPI LoadIconA (HINSTANCE hInstance, LPCSTR lpIconName);
HICON WINAPI LoadIconW (HINSTANCE hInstance, LPCWSTR lpIconName);
HANDLE WINAPI LoadImageA (HINSTANCE hInstance, LPCSTR lpszName, UINT uType, INT cxDesired, INT cyDesired, UINT fuLoad);
HANDLE WINAPI LoadImageW (HINSTANCE hInstance, LPCWSTR lpszName, UINT uType, INT cxDesired, INT cyDesired, UINT fuLoad);
HMENU WINAPI LoadMenuA (HINSTANCE hInstance, LPCSTR lpMenuName);
HMENU WINAPI LoadMenuIndirectA (LPCMENUTEMPLATE lpMenuTemplate);
HMENU WINAPI LoadMenuIndirectW (LPCMENUTEMPLATE lpMenuTemplate);
HMENU WINAPI LoadMenuW (HINSTANCE hInstance, LPCWSTR lpMenuName);
INT WINAPI LoadStringA (HINSTANCE hInstance, UINT uID, LPSTR lpBuffer, INT nBufferMax);
INT WINAPI LoadStringW (HINSTANCE hInstance, UINT uID, LPWSTR lpBuffer, INT nBufferMax);
INT WINAPI MapWindowPoints (HWND hWndFrom, HWND hWndTo, LPPOINT lpPoints, UINT cPoints);
UINT WINAPI MenuItemFromPoint (HWND hWnd, HMENU hMenu, POINT ptScreen);
BOOL WINAPI MessageBeep (UINT uType);
INT WINAPI MessageBoxA (HWND hWnd, LPCSTR lpText, LPCSTR lpCaption, UINT uType);
INT WINAPI MessageBoxExA (HWND hWnd, LPCSTR lpText, LPCSTR lpCaption, UINT uType, WORD wLanguageId);
INT WINAPI MessageBoxExW (HWND hWnd, LPCWSTR lpText, LPCWSTR lpCaption, UINT uType, WORD wLanguageId);
INT WINAPI MessageBoxW (HWND hWnd, LPCWSTR lpText, LPCWSTR lpCaption, UINT uType);
BOOL WINAPI ModifyMenuA (HMENU hMenu, UINT uItem, UINT uFlags, UINT_PTR uNewItem, LPCSTR lpszNewItem);
BOOL WINAPI ModifyMenuW (HMENU hMenu, UINT uItem, UINT uFlags, UINT_PTR uNewItem, LPCWSTR lpszNewItem);
BOOL WINAPI MoveWindow (HWND hWnd, INT x, INT y, INT nWidth, INT nHeight, BOOL bRepaint);
BOOL WINAPI OffsetRect (LPRECT lprc, INT dx, INT dy);
BOOL WINAPI OpenClipboard (HWND hWndNewOwner);
BOOL WINAPI PeekMessageA (LPMSG lpMsg, HWND hWnd, UINT wMsgFilterMin, UINT wMsgFilterMax, UINT wRemoveMsg);
BOOL WINAPI PeekMessageW (LPMSG lpMsg, HWND hWnd, UINT wMsgFilterMin, UINT wMsgFilterMax, UINT wRemoveMsg);
BOOL WINAPI PostMessageA (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
BOOL WINAPI PostMessageW (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
VOID WINAPI PostQuitMessage (INT nExitCode);
BOOL WINAPI PtInRect (CONST LPRECT lprc, POINT pt);
BOOL WINAPI RedrawWindow (HWND hWnd, LPCRECT lprcUpdate, HRGN hrgnUpdate, UINT flags);
ATOM WINAPI RegisterClassA (CONST LPWNDCLASSA lpWndClass);
ATOM WINAPI RegisterClassExA (CONST LPWNDCLASSEXA lpWndClassEx);
ATOM WINAPI RegisterClassExW (CONST LPWNDCLASSEXW lpWndClassEx);
ATOM WINAPI RegisterClassW (CONST LPWNDCLASSW lpWndClass);
BOOL WINAPI ReleaseCapture (VOID);
INT WINAPI ReleaseDC (HWND hWnd, HDC hDC);
BOOL WINAPI RemoveMenu (HMENU hMenu, UINT uItem, UINT uFlags);
BOOL WINAPI ScreenToClient (HWND hWnd, LPPOINT lpPoint);
LONG WINAPI SendDlgItemMessageA (HWND hDlg, INT nIDDlgItem, UINT Msg, WPARAM wParam, LPARAM lParam);
LONG WINAPI SendDlgItemMessageW (HWND hDlg, INT nIDDlgItem, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI SendMessageA (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
LRESULT WINAPI SendMessageW (HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam);
HWND WINAPI SetCapture (HWND hWnd);
HANDLE WINAPI SetClipboardData (UINT uFormat, HANDLE hMem);
HCURSOR WINAPI SetCursor (HCURSOR hCursor);
BOOL WINAPI SetCursorPos (INT x, INT y);
BOOL WINAPI SetDlgItemInt (HWND hDlg, INT nIDDlgItem, UINT uValue, BOOL bSigned);
BOOL WINAPI SetDlgItemTextA (HWND hDlg, INT nIDDlgItem, LPCSTR lpString);
BOOL WINAPI SetDlgItemTextW (HWND hDlg, INT nIDDlgItem, LPCWSTR lpString);
HWND WINAPI SetFocus (HWND hWnd);
BOOL WINAPI SetForegroundWindow (HWND hWnd);
BOOL WINAPI SetMenu (HWND hWnd, HMENU hMenu);
BOOL WINAPI SetMenuDefaultItem (HMENU hMenu, UINT uItem, UINT uByPos);
BOOL WINAPI SetMenuItemBitmaps (HMENU hMenu, UINT uItem, UINT uFlags, HBITMAP hbmUnchecked, HBITMAP hbmChecked);
BOOL WINAPI SetMenuItemInfoA (HMENU hMenu, UINT uItem, BOOL fByPosition, LPMENUITEMINFOA lpmii);
BOOL WINAPI SetMenuItemInfoW (HMENU hMenu, UINT uItem, BOOL fByPosition, LPMENUITEMINFOW lpmii);
BOOL WINAPI SetRect (LPRECT lprc, INT xLeft, INT yTop, INT xRight, INT yBottom);
BOOL WINAPI SetRectEmpty (LPRECT lprc);
INT WINAPI SetScrollPos (HWND hWnd, INT nBar, INT nPos, BOOL bRedraw);
BOOL WINAPI SetScrollRange (HWND hWnd, INT nBar, INT nMinPos, INT nMaxPos, BOOL bRedraw);
UINT WINAPI SetTimer (HWND hWnd, UINT uIDEvent, UINT uElapse, TIMERPROC lpTimerFunc);
LONG WINAPI SetWindowLongA (HWND hWnd, INT nIndex, LONG dwNewLong);
LONG WINAPI SetWindowLongW (HWND hWnd, INT nIndex, LONG dwNewLong);
BOOL WINAPI SetWindowPos (HWND hWnd, HWND hWndInsertAfter, INT x, INT y, INT cx, INT cy, UINT uFlags);
BOOL WINAPI SetWindowTextA (HWND hWnd, LPCSTR lpString);
BOOL WINAPI SetWindowTextW (HWND hWnd, LPCWSTR lpString);
BOOL WINAPI ShowWindow (HWND hWnd, INT nCmdShow);
BOOL WINAPI SubtractRect (LPRECT lprcDst, CONST LPRECT lprcSrc1, CONST LPRECT lprcSrc2);
BOOL WINAPI SystemParametersInfoA (UINT uiAction, UINT uiParam, PVOID pvParam, UINT fWinIni);
BOOL WINAPI SystemParametersInfoW (UINT uiAction, UINT uiParam, PVOID pvParam, UINT fWinIni);
BOOL WINAPI TrackPopupMenu (HMENU hMenu, UINT uFlags, INT x, INT y, INT nReserved, HWND hWnd, LPCRECT lprcRect);
BOOL WINAPI TrackPopupMenuEx (HMENU hMenu, UINT uFlags, INT x, INT y, HWND hWnd, LPTPMPARAMS lptpm);
INT WINAPI TranslateAcceleratorA (HWND hWnd, HACCEL hAccel, LPMSG lpMsg);
INT WINAPI TranslateAcceleratorW (HWND hWnd, HACCEL hAccel, LPMSG lpMsg);
BOOL WINAPI TranslateMessage (CONST MSG *lpMsg);
BOOL WINAPI UnionRect (LPRECT lprcDst, CONST LPRECT lprcSrc1, CONST LPRECT lprcSrc2);
BOOL WINAPI UnregisterClassA (LPCSTR lpClassName, HINSTANCE hInstance);
BOOL WINAPI UnregisterClassW (LPCWSTR lpClassName, HINSTANCE hInstance);
BOOL WINAPI UpdateWindow (HWND hWnd);
BOOL WINAPI WinHelpA (HWND hWndMain, LPCSTR lpszHelp, UINT uCommand, DWORD dwData);
BOOL WINAPI WinHelpW (HWND hWndMain, LPCWSTR lpszHelp, UINT uCommand, DWORD dwData);
HWND WINAPI WindowFromPoint (POINT Point);
INT WINAPIV wsprintfA (LPSTR lpOutput, LPCSTR lpFormat, ...);
INT WINAPIV wsprintfW (LPWSTR lpOutput, LPCWSTR lpFormat, ...);
INT WINAPI wvsprintfA (LPSTR lpOutput, LPCSTR lpFormat, va_list arglist);
INT WINAPI wvsprintfW (LPSTR lpOutput, LPCSTR lpFormat, va_list arglist);


#ifdef UNICODE
# define AppendMenu AppendMenuW
# define CallWindowProc CallWindowProcW
# define CharLower CharLowerW
# define CharUpper CharUpperW
# define CreateDialogIndirectParam CreateDialogIndirectParamW
# define CreateDialogParam CreateDialogParamW
# define CreateWindowEx CreateWindowExW
# define DefWindowProc DefWindowProcW
# define DialogBoxIndirectParam DialogBoxIndirectParamW
# define DialogBoxParam DialogBoxParamW
# define DispatchMessage DispatchMessageW
# define GetClassName GetClassNameW
# define GetDlgItemText GetDlgItemTextW
# define GetMenuItemInfo GetMenuItemInfoW
# define GetMenuString GetMenuStringW
# define GetMessage GetMessageW
# define GetWindowLong GetWindowLongW
# define GetWindowText GetWindowTextW
# define GetWindowTextLength GetWindowTextLengthW
# define InsertMenu InsertMenuW
# define InsertMenuItem InsertMenuItemW
# define LoadAccelerators LoadAcceleratorsW
# define LoadBitmap LoadBitmapW
# define LoadCursor LoadCursorW
# define LoadIcon LoadIconW
# define LoadImage LoadImageW
# define LoadMenu LoadMenuW
# define LoadMenuIndirect LoadMenuIndirectW
# define LoadString LoadStringW
# define MessageBox MessageBoxW
# define MessageBoxEx MessageBoxExW
# define ModifyMenu ModifyMenuW
# define PeekMessage PeekMessageW
# define PostMessage PostMessageW
# define RegisterClass RegisterClassW
# define RegisterClassEx RegisterClassExW
# define SendDlgItemMessage SendDlgItemMessageW
# define SendMessage SendMessageW
# define SetDlgItemText SetDlgItemTextW
# define SetMenuItemInfo SetMenuItemInfoW
# define SetWindowLong SetWindowLongW
# define SetWindowText SetWindowTextW
# define SystemParametersInfo SystemParametersInfoW
# define TranslateAccelerator TranslateAcceleratorW
# define UnregisterClass UnregisterClassW
# define WinHelp WinHelpW
# define wsprintf wsprintfW
# define wvsprintf wvsprintfW
#else /* not UNICODE*/
# define AppendMenu AppendMenuA
# define CallWindowProc CallWindowProcA
# define CharLower CharLowerA
# define CharUpper CharUpperA
# define CreateDialogIndirectParam CreateDialogIndirectParamA
# define CreateDialogParam CreateDialogParamA
# define CreateWindowEx CreateWindowExA
# define DefWindowProc DefWindowProcA
# define DialogBoxIndirectParam DialogBoxIndirectParamA
# define DialogBoxParam DialogBoxParamA
# define DispatchMessage DispatchMessageA
# define GetClassName GetClassNameA
# define GetDlgItemText GetDlgItemTextA
# define GetMenuItemInfo GetMenuItemInfoA
# define GetMenuString GetMenuStringA
# define GetMessage GetMessageA
# define GetWindowLong GetWindowLongA
# define GetWindowText GetWindowTextA
# define GetWindowTextLength GetWindowTextLengthA
# define InsertMenu InsertMenuA
# define InsertMenuItem InsertMenuItemA
# define LoadAccelerators LoadAcceleratorsA
# define LoadBitmap LoadBitmapA
# define LoadCursor LoadCursorA
# define LoadIcon LoadIconA
# define LoadImage LoadImageA
# define LoadMenu LoadMenuA
# define LoadMenuIndirect LoadMenuIndirectA
# define LoadString LoadStringA
# define MessageBox MessageBoxA
# define MessageBoxEx MessageBoxExA
# define ModifyMenu ModifyMenuA
# define PeekMessage PeekMessageA
# define PostMessage PostMessageA
# define RegisterClass RegisterClassA
# define RegisterClassEx RegisterClassExA
# define SendDlgItemMessage SendDlgItemMessageA
# define SendMessage SendMessageA
# define SetDlgItemText SetDlgItemTextA
# define SetMenuItemInfo SetMenuItemInfoA
# define SetWindowLong SetWindowLongA
# define SetWindowText SetWindowTextA
# define SystemParametersInfo SystemParametersInfoA
# define TranslateAccelerator TranslateAcceleratorA
# define UnregisterClass UnregisterClassA
# define WinHelp WinHelpA
# define wsprintf wsprintfA
# define wvsprintf wvsprintfA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __USER32_H__ */
