/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "gdi32.h"
#include "kernel32.h"
#include "misc/pixbuf.h"


#ifdef W32LDR_HEADER
#define RGB(r,g,b) ((COLORREF)((BYTE)(r)|((BYTE)(g)<<8)|((BYTE)(b)<<16)))
#define GetRValue(rgb) ((BYTE)(rgb))
#define GetGValue(rgb) ((BYTE)((rgb)>>8))
#define GetBValue(rgb) ((BYTE)((rgb)>>16))
#define TRANSPARENT 1
#define OPAQUE      2
typedef LPVOID HGDIOBJ;
typedef DWORD COLORREF, *PCOLORREF, *LPCOLORREF;
#include <pshpack1.h>
typedef struct _SIZE
{
  LONG cx;
  LONG cy;
} SIZE, *PSIZE, *LPSIZE;
#include "poppack.h"
/* ja:ラスタオペレーションコード */
#define SRCCOPY     0xcc0020
#define SRCPAINT    0xee0086
#define SRCAND      0x8800c6
#define SRCINVERT   0x660046
#define SRCERASE    0x440328
#define NOTSRCCOPY  0x330008
#define NOTSRCERASE 0x1100a6
#define MERGECOPY   0xc000ca
#define MERGEPAINT  0xbb0226
#define PATCOPY     0xf00021
#define PATPAINT    0xfb0a09
#define PATINVERT   0x5a0049
#define DSTINVERT   0x550009
#define BLACKNESS   0x000042
#define WHITENESS   0xff0062
/* ja:ビットマップ */
#include <pshpack1.h>
typedef struct _BITMAP
{
  LONG bmType;
  LONG bmWidth;
  LONG bmHeight;
  LONG bmWidthBytes;
  WORD bmPlanes;
  WORD bmBitsPixel;
  LPVOID bmBits;
} BITMAP, *PBITMAP, *LPBITMAP;
typedef struct _PALETTEENTRY
{
  BYTE peRed;
  BYTE peGreen;
  BYTE peBlue;
  BYTE peFlags;
} PALETTEENTRY, *PPALETTEENTRY, *LPPALETTEENTRY;
#include "poppack.h"
/* ja:ブラシ */
typedef W32LdrBrush *HBRUSH;
/* ja:ペン */
typedef W32LdrPen *HPEN;
/* ja:フォント */
typedef W32LdrFont *HFONT;
#define FW_DONTCARE   0
#define FW_THIN       100
#define FW_EXTRALIGHT 200
#define FW_LIGHT      300
#define FW_NORMAL     400
#define FW_MEDIUM     500
#define FW_SEMIBOLD   600
#define FW_BOLD       700
#define FW_EXTRABOLD  800
#define FW_HEAVY      900
#define ANSI_CHARSET        0
#define DEFAULT_CHARSET     1
#define SYMBOL_CHARSET      2
#define SHIFTJIS_CHARSET    128
#define HANGEUL_CHARSET     129
#define GB2312_CHARSET      134
#define CHINESEBIG5_CHARSET 136
#define GREEK_CHARSET       161
#define TURKISH_CHARSET     162
#define HEBREW_CHARSET      177
#define ARABIC_CHARSET      178
#define BALTIC_CHARSET      186
#define RUSSIAN_CHARSET     204
#define EASTEUROPE_CHARSET  238
#define THAI_CHARSET        222
#define JOHAB_CHARSET       130
#define MAC_CHARSET         77
#define OEM_CHARSET         255
#define OUT_DEFAULT_PRECIS   0
#define OUT_STRING_PRECIS    1
#define OUT_CHARACTER_PRECIS 2
#define OUT_STROKE_PRECIS    3
#define OUT_TT_PRECIS        4
#define OUT_DEVICE_PRECIS    5
#define OUT_RASTER_PRECIS    6
#define OUT_TT_ONLY_PRECIS   7
#define OUT_OUTLINE_PRECIS   8
#define CLIP_DEFAULT_PRECIS   0x00
#define CLIP_CHARACTER_PRECIS 0x01
#define CLIP_STROKE_PRECIS    0x02
#define CLIP_MASK             0x0f
#define CLIP_LH_ANGLES        0x10
#define CLIP_TT_ALWAYS        0x20
#define CLIP_EMBEDDED         0x80
#define DEFAULT_QUALITY 0
#define DRAFT_QUALITY   1
#define PROOF_QUALITY   2
#define DEFAULT_PITCH  0x00
#define FIXED_PITCH    0x01
#define VARIABLE_PITCH 0x02
#define FF_DONTCARE   0x00
#define FF_ROMAN      0x10
#define FF_SWISS      0x20
#define FF_MODERN     0x30
#define FF_SCRIPT     0x40
#define FF_DECORATIVE 0x50
#define LF_FACESIZE 32
#include <pshpack1.h>
typedef struct _LOGFONTA
{
  LONG lfHeight;
  LONG lfWidth;
  LONG lfEscapement;
  LONG lfOrientation;
  LONG lfWeight;
  BYTE lfItalic;
  BYTE lfUnderline;
  BYTE lfStrikeOut;
  BYTE lfCharSet;
  BYTE lfOutPrecision;
  BYTE lfClipPrecision;
  BYTE lfQuality;
  BYTE lfPitchAndFamily;
  CHAR lfFaceName[LF_FACESIZE];
} LOGFONTA, *PLOGFONTA, *LPLOGFONTA;
typedef struct _LOGFONTW
{
  LONG lfHeight;
  LONG lfWidth;
  LONG lfEscapement;
  LONG lfOrientation;
  LONG lfWeight;
  BYTE lfItalic;
  BYTE lfUnderline;
  BYTE lfStrikeOut;
  BYTE lfCharSet;
  BYTE lfOutPrecision;
  BYTE lfClipPrecision;
  BYTE lfQuality;
  BYTE lfPitchAndFamily;
  WCHAR lfFaceName[LF_FACESIZE];
} LOGFONTW, *PLOGFONTW, *LPLOGFONTW;
#include "poppack.h"
#ifdef UNICODE
# define LOGFONT LOGFONTW
# define PLOGFONT PLOGFONTW
# define LPLOGFONT LPLOGFONTW
#else /* not UNICODE */
# define LOGFONT LOGFONTA
# define PLOGFONT PLOGFONTA
# define LPLOGFONT LPLOGFONTA
#endif /* not UNICODE */
#endif /* W32LDR_HEADER */


#ifndef PANGO_VERSION_CHECK
# define PANGO_VERSION_CHECK(major,minor,micro) 0
#endif /* not PANGO_VERSION_CHECK */


/* AbortDoc ordinal = 1, argument = 4 temporary */
static DWORD WINAPI AbortDoc (DWORD dwArgv0)
{
  return 0;
}


/* AbortPath ordinal = 2, argument = 4 temporary */
static DWORD WINAPI AbortPath (DWORD dwArgv0)
{
  return 0;
}


/* AddFontMemResourceEx ordinal = 3, argument = 16 temporary */
static DWORD WINAPI AddFontMemResourceEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* AddFontResourceA ordinal = 4, argument = 4 temporary */
static DWORD WINAPI AddFontResourceA (DWORD dwArgv0)
{
  return 0;
}


/* AddFontResourceExA ordinal = 5, argument = 12 temporary */
static DWORD WINAPI AddFontResourceExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* AddFontResourceExW ordinal = 6, argument = 12 temporary */
static DWORD WINAPI AddFontResourceExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* AddFontResourceTracking ordinal = 7, argument = 0 temporary */
static DWORD WINAPI AddFontResourceTracking (VOID)
{
  return 0;
}


/* AddFontResourceW ordinal = 8, argument = 4 temporary */
static DWORD WINAPI AddFontResourceW (DWORD dwArgv0)
{
  return 0;
}


/* AngleArc ordinal = 9, argument = 24 temporary */
static DWORD WINAPI AngleArc (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* AnimatePalette ordinal = 10, argument = 16 temporary */
static DWORD WINAPI AnimatePalette (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* AnyLinkedFonts ordinal = 11, argument = 0 temporary */
static DWORD WINAPI AnyLinkedFonts (VOID)
{
  return 0;
}


/* Arc ordinal = 12, argument = 36 temporary */
static DWORD WINAPI Arc (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* ArcTo ordinal = 13, argument = 36 temporary */
static DWORD WINAPI ArcTo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* BRUSHOBJ_hGetColorTransform ordinal = 14, argument = 0 temporary */
static DWORD WINAPI BRUSHOBJ_hGetColorTransform (VOID)
{
  return 0;
}


/* BRUSHOBJ_pvAllocRbrush ordinal = 15, argument = 0 temporary */
static DWORD WINAPI BRUSHOBJ_pvAllocRbrush (VOID)
{
  return 0;
}


/* BRUSHOBJ_pvGetRbrush ordinal = 16, argument = 0 temporary */
static DWORD WINAPI BRUSHOBJ_pvGetRbrush (VOID)
{
  return 0;
}


/* BRUSHOBJ_ulGetBrushColor ordinal = 17, argument = 0 temporary */
static DWORD WINAPI BRUSHOBJ_ulGetBrushColor (VOID)
{
  return 0;
}


/* BeginPath ordinal = 18, argument = 4 temporary */
static DWORD WINAPI BeginPath (DWORD dwArgv0)
{
  return 0;
}


/* BitBlt ordinal = 19, argument = 36 */
BOOL WINAPI BitBlt (HDC hdcDest, INT nXDest, INT nYDest, INT nWidth, INT nHeight, HDC hdcSrc, INT nXSrc, INT nYSrc, DWORD dwRop)
{
  GdkGC *gc;

  if (!hdcDest || !hdcDest->widget
        || !hdcSrc || (!hdcSrc->widget && !hdcSrc->pixbuf) || dwRop != SRCCOPY)
    return FALSE;
  gc = gdk_gc_new (hdcDest->widget->window);
  if (hdcSrc->widget)
    gdk_draw_drawable (hdcDest->widget->window, gc, hdcSrc->widget->window,
                                        hdcSrc->widget->allocation.x + nXSrc,
                                        hdcSrc->widget->allocation.y + nYSrc,
                                            nXDest, nYDest, nWidth, nHeight);
  else
#if GTK_CHECK_VERSION(2,2,0)
    gdk_draw_pixbuf (hdcDest->widget->window, gc, hdcSrc->pixbuf, nXSrc, nYSrc,
                    nXDest, nYDest, nWidth, nHeight, GDK_RGB_DITHER_MAX, 0, 0);
#else /* not GTK_CHECK_VERSION(2,2,0) */
    gdk_pixbuf_render_to_drawable (hdcSrc->pixbuf, hdcDest->widget->window, gc,
                    nXSrc, nYSrc,
                    nXDest, nYDest, nWidth, nHeight, GDK_RGB_DITHER_MAX, 0, 0);
#endif /* not GTK_CHECK_VERSION(2,2,0) */
  g_object_unref (G_OBJECT (gc));
  return TRUE;
}


/* CLIPOBJ_bEnum ordinal = 20, argument = 0 temporary */
static DWORD WINAPI CLIPOBJ_bEnum (VOID)
{
  return 0;
}


/* CLIPOBJ_cEnumStart ordinal = 21, argument = 0 temporary */
static DWORD WINAPI CLIPOBJ_cEnumStart (VOID)
{
  return 0;
}


/* CLIPOBJ_ppoGetPath ordinal = 22, argument = 0 temporary */
static DWORD WINAPI CLIPOBJ_ppoGetPath (VOID)
{
  return 0;
}


/* CancelDC ordinal = 23, argument = 4 temporary */
static DWORD WINAPI CancelDC (DWORD dwArgv0)
{
  return 0;
}


/* CheckColorsInGamut ordinal = 24, argument = 16 temporary */
static DWORD WINAPI CheckColorsInGamut (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* ChoosePixelFormat ordinal = 25, argument = 8 temporary */
static DWORD WINAPI ChoosePixelFormat (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Chord ordinal = 26, argument = 36 temporary */
static DWORD WINAPI Chord (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* CloseEnhMetaFile ordinal = 27, argument = 4 temporary */
static DWORD WINAPI CloseEnhMetaFile (DWORD dwArgv0)
{
  return 0;
}


/* CloseFigure ordinal = 28, argument = 4 temporary */
static DWORD WINAPI CloseFigure (DWORD dwArgv0)
{
  return 0;
}


/* CloseMetaFile ordinal = 29, argument = 4 temporary */
static DWORD WINAPI CloseMetaFile (DWORD dwArgv0)
{
  return 0;
}


/* ColorCorrectPalette ordinal = 30, argument = 16 temporary */
static DWORD WINAPI ColorCorrectPalette (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* ColorMatchToTarget ordinal = 31, argument = 12 temporary */
static DWORD WINAPI ColorMatchToTarget (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CombineRgn ordinal = 32, argument = 16 temporary */
static DWORD WINAPI CombineRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CombineTransform ordinal = 33, argument = 12 temporary */
static DWORD WINAPI CombineTransform (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CopyEnhMetaFileA ordinal = 34, argument = 8 temporary */
static DWORD WINAPI CopyEnhMetaFileA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CopyEnhMetaFileW ordinal = 35, argument = 8 temporary */
static DWORD WINAPI CopyEnhMetaFileW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CopyMetaFileA ordinal = 36, argument = 8 temporary */
static DWORD WINAPI CopyMetaFileA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CopyMetaFileW ordinal = 37, argument = 8 temporary */
static DWORD WINAPI CopyMetaFileW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CreateBitmap ordinal = 38, argument = 20 temporary */
static DWORD WINAPI CreateBitmap (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* CreateBitmapIndirect ordinal = 39, argument = 4 temporary */
static DWORD WINAPI CreateBitmapIndirect (DWORD dwArgv0)
{
  return 0;
}


/* CreateBrushIndirect ordinal = 40, argument = 4 temporary */
static DWORD WINAPI CreateBrushIndirect (DWORD dwArgv0)
{
  return 0;
}


/* CreateColorSpaceA ordinal = 41, argument = 4 temporary */
static DWORD WINAPI CreateColorSpaceA (DWORD dwArgv0)
{
  return 0;
}


/* CreateColorSpaceW ordinal = 42, argument = 4 temporary */
static DWORD WINAPI CreateColorSpaceW (DWORD dwArgv0)
{
  return 0;
}


/* CreateCompatibleBitmap ordinal = 43, argument = 12 temporary */
static DWORD WINAPI CreateCompatibleBitmap (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateCompatibleDC ordinal = 44, argument = 4 */
HDC WINAPI CreateCompatibleDC (HDC hDC)
{
  W32LdrDC *w32dc;

  w32dc = g_malloc0 (sizeof (W32LdrDC));
  if (hDC)
    {
      w32dc->transparent = hDC->transparent;
      w32dc->fgcolor = hDC->fgcolor;
      w32dc->bgcolor = hDC->bgcolor;
      if (hDC->pixbuf)
        w32dc->pixbuf = gdk_pixbuf_copy (hDC->pixbuf);
      if (hDC->brush)
        w32dc->brush = w32ldr_brush_copy (hDC->brush);
      if (hDC->font)
        w32dc->font = w32ldr_font_copy (hDC->font);
      if (hDC->pen)
        w32dc->pen = w32ldr_pen_copy (hDC->pen);
    }
  else
    {
      w32dc->bgcolor.red = G_MAXUINT16;
      w32dc->bgcolor.green = G_MAXUINT16;
      w32dc->bgcolor.blue = G_MAXUINT16;
    }
  if (!w32dc->pixbuf)
    w32dc->pixbuf = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, 1, 1);
  if (!w32dc->brush)
    w32dc->brush = w32ldr_brush_new ();
  if (!w32dc->font)
    w32dc->font = w32ldr_font_new ();
  if (!w32dc->pen)
    w32dc->pen = w32ldr_pen_new ();
  return w32dc;
}


/* CreateDCA ordinal = 45, argument = 16 temporary */
static DWORD WINAPI CreateDCA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateDCW ordinal = 46, argument = 16 temporary */
static DWORD WINAPI CreateDCW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateDIBPatternBrush ordinal = 47, argument = 8 temporary */
static DWORD WINAPI CreateDIBPatternBrush (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CreateDIBPatternBrushPt ordinal = 48, argument = 8 temporary */
static DWORD WINAPI CreateDIBPatternBrushPt (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CreateDIBSection ordinal = 49, argument = 24 temporary */
static DWORD WINAPI CreateDIBSection (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CreateDIBitmap ordinal = 50, argument = 24 temporary */
static DWORD WINAPI CreateDIBitmap (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CreateDiscardableBitmap ordinal = 51, argument = 12 temporary */
static DWORD WINAPI CreateDiscardableBitmap (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateEllipticRgn ordinal = 52, argument = 16 temporary */
static DWORD WINAPI CreateEllipticRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateEllipticRgnIndirect ordinal = 53, argument = 4 temporary */
static DWORD WINAPI CreateEllipticRgnIndirect (DWORD dwArgv0)
{
  return 0;
}


/* CreateEnhMetaFileA ordinal = 54, argument = 16 temporary */
static DWORD WINAPI CreateEnhMetaFileA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateEnhMetaFileW ordinal = 55, argument = 16 temporary */
static DWORD WINAPI CreateEnhMetaFileW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateFontA ordinal = 56, argument = 56 */
HFONT WINAPI CreateFontA (INT nHeight, INT nWidth, INT nEscapement, INT nOrientation, INT nWeight, DWORD dwItalic, DWORD dwUnderline, DWORD dwStrikeOut, DWORD dwCharSet, DWORD dwOutPrecision, DWORD dwClipPrecision, DWORD dwQuality, DWORD dwPitchAndFamily, LPCSTR lpszFaceName)
{
  gchar *utf8str;
  gunichar2 *wc;
  HFONT hFont;

  utf8str = w32ldr_utf8_from_mb (lpszFaceName);
  wc = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  hFont = CreateFontW (nHeight, nWidth, nEscapement, nOrientation, nWeight, dwItalic, dwUnderline, dwStrikeOut, dwCharSet, dwOutPrecision, dwClipPrecision, dwQuality, dwPitchAndFamily, wc);
  g_free (wc);
  return hFont;
}


/* CreateFontIndirectA ordinal = 57, argument = 4 */
HFONT WINAPI CreateFontIndirectA (CONST LOGFONTA *lplf)
{
  return CreateFontA (lplf->lfHeight, lplf->lfWidth, lplf->lfEscapement, lplf->lfOrientation, lplf->lfWeight, lplf->lfItalic, lplf->lfUnderline, lplf->lfStrikeOut, lplf->lfCharSet, lplf->lfOutPrecision, lplf->lfClipPrecision, lplf->lfQuality, lplf->lfPitchAndFamily, lplf->lfFaceName);
}


/* CreateFontIndirectExA ordinal = 58, argument = 4 temporary */
static DWORD WINAPI CreateFontIndirectExA (DWORD dwArgv0)
{
  return 0;
}


/* CreateFontIndirectExW ordinal = 59, argument = 4 temporary */
static DWORD WINAPI CreateFontIndirectExW (DWORD dwArgv0)
{
  return 0;
}


/* CreateFontIndirectW ordinal = 60, argument = 4 */
HFONT WINAPI CreateFontIndirectW (CONST LOGFONTW *lplf)
{
  return CreateFontW (lplf->lfHeight, lplf->lfWidth, lplf->lfEscapement, lplf->lfOrientation, lplf->lfWeight, lplf->lfItalic, lplf->lfUnderline, lplf->lfStrikeOut, lplf->lfCharSet, lplf->lfOutPrecision, lplf->lfClipPrecision, lplf->lfQuality, lplf->lfPitchAndFamily, lplf->lfFaceName);
}


/* CreateFontW ordinal = 61, argument = 56 */
HFONT WINAPI CreateFontW (INT nHeight, INT nWidth, INT nEscapement, INT nOrientation, INT nWeight, DWORD dwItalic, DWORD dwUnderline, DWORD dwStrikeOut, DWORD dwCharSet, DWORD dwOutPrecision, DWORD dwClipPrecision, DWORD dwQuality, DWORD dwPitchAndFamily, LPCWSTR lpszFaceName)
{
  gchar *name;
  PangoFontDescription *desc;

  desc = pango_font_description_new ();
  name = lpszFaceName ? g_utf16_to_utf8 (lpszFaceName, -1, NULL, NULL, NULL)
                      : NULL;
  if (name)
    {
      pango_font_description_set_family (desc, name);
      g_free (name);
    }
  pango_font_description_set_style (desc, dwItalic
                                    ? PANGO_STYLE_NORMAL : PANGO_STYLE_ITALIC);
  pango_font_description_set_variant (desc, PANGO_VARIANT_NORMAL);
  pango_font_description_set_weight (desc, (PangoWeight)nWeight);
  pango_font_description_set_stretch (desc, PANGO_STRETCH_NORMAL);
#if PANGO_VERSION_CHECK(1,8,0)
  if (nHeight >= 0)
    pango_font_description_set_size (desc, nHeight * PANGO_SCALE);
  else
    pango_font_description_set_absolute_size (desc, -nHeight * PANGO_SCALE);
#else /* not PANGO_VERSION_CHECK(1,8,0) */
  pango_font_description_set_size (desc, ABS (nHeight) * PANGO_SCALE);
#endif /* not PANGO_VERSION_CHECK(1,8,0) */
#if PANGO_VERSION_CHECK(1,16,0)
  pango_font_description_set_gravity (desc, PANGO_GRAVITY_AUTO);
#endif /* PANGO_VERSION_CHECK(1,16,0) */
  return w32ldr_font_new_with_description (desc);
}


/* CreateHalftonePalette ordinal = 62, argument = 4 temporary */
static DWORD WINAPI CreateHalftonePalette (DWORD dwArgv0)
{
  return 0;
}


/* CreateHatchBrush ordinal = 63, argument = 8 temporary */
static DWORD WINAPI CreateHatchBrush (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CreateICA ordinal = 64, argument = 16 temporary */
static DWORD WINAPI CreateICA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateICW ordinal = 65, argument = 16 temporary */
static DWORD WINAPI CreateICW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateMetaFileA ordinal = 66, argument = 4 temporary */
static DWORD WINAPI CreateMetaFileA (DWORD dwArgv0)
{
  return 0;
}


/* CreateMetaFileW ordinal = 67, argument = 4 temporary */
static DWORD WINAPI CreateMetaFileW (DWORD dwArgv0)
{
  return 0;
}


/* CreatePalette ordinal = 68, argument = 4 temporary */
static DWORD WINAPI CreatePalette (DWORD dwArgv0)
{
  return 0;
}


/* CreatePatternBrush ordinal = 69, argument = 4 temporary */
static DWORD WINAPI CreatePatternBrush (DWORD dwArgv0)
{
  return 0;
}


/* CreatePen ordinal = 70, argument = 12 temporary */
static DWORD WINAPI CreatePen (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreatePenIndirect ordinal = 71, argument = 4 temporary */
static DWORD WINAPI CreatePenIndirect (DWORD dwArgv0)
{
  return 0;
}


/* CreatePolyPolygonRgn ordinal = 72, argument = 16 temporary */
static DWORD WINAPI CreatePolyPolygonRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreatePolygonRgn ordinal = 73, argument = 12 temporary */
static DWORD WINAPI CreatePolygonRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* CreateRectRgn ordinal = 74, argument = 16 temporary */
static DWORD WINAPI CreateRectRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateRectRgnIndirect ordinal = 75, argument = 4 temporary */
static DWORD WINAPI CreateRectRgnIndirect (DWORD dwArgv0)
{
  return 0;
}


/* CreateRoundRectRgn ordinal = 76, argument = 24 temporary */
static DWORD WINAPI CreateRoundRectRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* CreateScalableFontResourceA ordinal = 77, argument = 16 temporary */
static DWORD WINAPI CreateScalableFontResourceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateScalableFontResourceW ordinal = 78, argument = 16 temporary */
static DWORD WINAPI CreateScalableFontResourceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* CreateSolidBrush ordinal = 79, argument = 4 */
HBRUSH WINAPI CreateSolidBrush (COLORREF crColor)
{
  GdkColor color;

  color.pixel = 0;
  color.red = GetRValue (crColor) * 256;
  color.green = GetGValue (crColor) * 256;
  color.blue = GetBValue (crColor) * 256;
  return w32ldr_brush_new_with_color (&color);
}


/* DPtoLP ordinal = 80, argument = 12 temporary */
static DWORD WINAPI DPtoLP (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* DeleteColorSpace ordinal = 81, argument = 4 temporary */
static DWORD WINAPI DeleteColorSpace (DWORD dwArgv0)
{
  return 0;
}


/* DeleteDC ordinal = 82, argument = 4 */
BOOL WINAPI DeleteDC (HDC hDC)
{
  if (!hDC || hDC->widget)
    return FALSE;
  if (hDC->pixbuf)
    g_object_unref (G_OBJECT (hDC->pixbuf));
  if (hDC->brush)
    g_object_unref (G_OBJECT (hDC->brush));
  if (hDC->font)
    g_object_unref (G_OBJECT (hDC->font));
  if (hDC->pen)
    g_object_unref (G_OBJECT (hDC->pen));
  g_free (hDC);
  return TRUE;
}


/* DeleteEnhMetaFile ordinal = 83, argument = 4 temporary */
static DWORD WINAPI DeleteEnhMetaFile (DWORD dwArgv0)
{
  return 0;
}


/* DeleteMetaFile ordinal = 84, argument = 4 temporary */
static DWORD WINAPI DeleteMetaFile (DWORD dwArgv0)
{
  return 0;
}


/* DeleteObject ordinal = 85, argument = 4 */
BOOL WINAPI DeleteObject (HGDIOBJ hObject)
{
  if (hObject && GDK_IS_PIXBUF (hObject))
    {
      g_object_unref (hObject);
      return TRUE;
    }
  return FALSE;
}


/* DescribePixelFormat ordinal = 86, argument = 16 temporary */
static DWORD WINAPI DescribePixelFormat (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* DeviceCapabilitiesExA ordinal = 87, argument = 24 temporary */
static DWORD WINAPI DeviceCapabilitiesExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* DeviceCapabilitiesExW ordinal = 88, argument = 24 temporary */
static DWORD WINAPI DeviceCapabilitiesExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* DrawEscape ordinal = 89, argument = 16 temporary */
static DWORD WINAPI DrawEscape (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* Ellipse ordinal = 90, argument = 20 temporary */
static DWORD WINAPI Ellipse (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* EnableEUDC ordinal = 91, argument = 4 temporary */
static DWORD WINAPI EnableEUDC (DWORD dwArgv0)
{
  return 0;
}


/* EndDoc ordinal = 92, argument = 4 temporary */
static DWORD WINAPI EndDoc (DWORD dwArgv0)
{
  return 0;
}


/* EndFormPage ordinal = 93, argument = 4 temporary */
static DWORD WINAPI EndFormPage (DWORD dwArgv0)
{
  return 0;
}


/* EndPage ordinal = 94, argument = 4 temporary */
static DWORD WINAPI EndPage (DWORD dwArgv0)
{
  return 0;
}


/* EndPath ordinal = 95, argument = 4 temporary */
static DWORD WINAPI EndPath (DWORD dwArgv0)
{
  return 0;
}


/* EngAcquireSemaphore ordinal = 96, argument = 0 temporary */
static DWORD WINAPI EngAcquireSemaphore (VOID)
{
  return 0;
}


/* EngAlphaBlend ordinal = 97, argument = 0 temporary */
static DWORD WINAPI EngAlphaBlend (VOID)
{
  return 0;
}


/* EngAssociateSurface ordinal = 98, argument = 0 temporary */
static DWORD WINAPI EngAssociateSurface (VOID)
{
  return 0;
}


/* EngBitBlt ordinal = 99, argument = 0 temporary */
static DWORD WINAPI EngBitBlt (VOID)
{
  return 0;
}


/* EngCheckAbort ordinal = 100, argument = 0 temporary */
static DWORD WINAPI EngCheckAbort (VOID)
{
  return 0;
}


/* EngComputeGlyphSet ordinal = 101, argument = 0 temporary */
static DWORD WINAPI EngComputeGlyphSet (VOID)
{
  return 0;
}


/* EngCopyBits ordinal = 102, argument = 0 temporary */
static DWORD WINAPI EngCopyBits (VOID)
{
  return 0;
}


/* EngCreateBitmap ordinal = 103, argument = 0 temporary */
static DWORD WINAPI EngCreateBitmap (VOID)
{
  return 0;
}


/* EngCreateClip ordinal = 104, argument = 0 temporary */
static DWORD WINAPI EngCreateClip (VOID)
{
  return 0;
}


/* EngCreateDeviceBitmap ordinal = 105, argument = 0 temporary */
static DWORD WINAPI EngCreateDeviceBitmap (VOID)
{
  return 0;
}


/* EngCreateDeviceSurface ordinal = 106, argument = 0 temporary */
static DWORD WINAPI EngCreateDeviceSurface (VOID)
{
  return 0;
}


/* EngCreatePalette ordinal = 107, argument = 0 temporary */
static DWORD WINAPI EngCreatePalette (VOID)
{
  return 0;
}


/* EngCreateSemaphore ordinal = 108, argument = 0 temporary */
static DWORD WINAPI EngCreateSemaphore (VOID)
{
  return 0;
}


/* EngDeleteClip ordinal = 109, argument = 0 temporary */
static DWORD WINAPI EngDeleteClip (VOID)
{
  return 0;
}


/* EngDeletePalette ordinal = 110, argument = 0 temporary */
static DWORD WINAPI EngDeletePalette (VOID)
{
  return 0;
}


/* EngDeletePath ordinal = 111, argument = 0 temporary */
static DWORD WINAPI EngDeletePath (VOID)
{
  return 0;
}


/* EngDeleteSemaphore ordinal = 112, argument = 0 temporary */
static DWORD WINAPI EngDeleteSemaphore (VOID)
{
  return 0;
}


/* EngDeleteSurface ordinal = 113, argument = 0 temporary */
static DWORD WINAPI EngDeleteSurface (VOID)
{
  return 0;
}


/* EngEraseSurface ordinal = 114, argument = 0 temporary */
static DWORD WINAPI EngEraseSurface (VOID)
{
  return 0;
}


/* EngFillPath ordinal = 115, argument = 0 temporary */
static DWORD WINAPI EngFillPath (VOID)
{
  return 0;
}


/* EngFindResource ordinal = 116, argument = 0 temporary */
static DWORD WINAPI EngFindResource (VOID)
{
  return 0;
}


/* EngFreeModule ordinal = 117, argument = 0 temporary */
static DWORD WINAPI EngFreeModule (VOID)
{
  return 0;
}


/* EngGetCurrentCodePage ordinal = 118, argument = 0 temporary */
static DWORD WINAPI EngGetCurrentCodePage (VOID)
{
  return 0;
}


/* EngGetDriverName ordinal = 119, argument = 0 temporary */
static DWORD WINAPI EngGetDriverName (VOID)
{
  return 0;
}


/* EngGetPrinterDataFileName ordinal = 120, argument = 0 temporary */
static DWORD WINAPI EngGetPrinterDataFileName (VOID)
{
  return 0;
}


/* EngGradientFill ordinal = 121, argument = 0 temporary */
static DWORD WINAPI EngGradientFill (VOID)
{
  return 0;
}


/* EngLineTo ordinal = 122, argument = 0 temporary */
static DWORD WINAPI EngLineTo (VOID)
{
  return 0;
}


/* EngLoadModule ordinal = 123, argument = 0 temporary */
static DWORD WINAPI EngLoadModule (VOID)
{
  return 0;
}


/* EngLockSurface ordinal = 124, argument = 0 temporary */
static DWORD WINAPI EngLockSurface (VOID)
{
  return 0;
}


/* EngMarkBandingSurface ordinal = 125, argument = 0 temporary */
static DWORD WINAPI EngMarkBandingSurface (VOID)
{
  return 0;
}


/* EngMultiByteToUnicodeN ordinal = 126, argument = 0 temporary */
static DWORD WINAPI EngMultiByteToUnicodeN (VOID)
{
  return 0;
}


/* EngMultiByteToWideChar ordinal = 127, argument = 0 temporary */
static DWORD WINAPI EngMultiByteToWideChar (VOID)
{
  return 0;
}


/* EngPaint ordinal = 128, argument = 0 temporary */
static DWORD WINAPI EngPaint (VOID)
{
  return 0;
}


/* EngPlgBlt ordinal = 129, argument = 0 temporary */
static DWORD WINAPI EngPlgBlt (VOID)
{
  return 0;
}


/* EngQueryEMFInfo ordinal = 130, argument = 0 temporary */
static DWORD WINAPI EngQueryEMFInfo (VOID)
{
  return 0;
}


/* EngQueryLocalTime ordinal = 131, argument = 0 temporary */
static DWORD WINAPI EngQueryLocalTime (VOID)
{
  return 0;
}


/* EngReleaseSemaphore ordinal = 132, argument = 0 temporary */
static DWORD WINAPI EngReleaseSemaphore (VOID)
{
  return 0;
}


/* EngStretchBlt ordinal = 133, argument = 0 temporary */
static DWORD WINAPI EngStretchBlt (VOID)
{
  return 0;
}


/* EngStretchBltROP ordinal = 134, argument = 0 temporary */
static DWORD WINAPI EngStretchBltROP (VOID)
{
  return 0;
}


/* EngStrokeAndFillPath ordinal = 135, argument = 0 temporary */
static DWORD WINAPI EngStrokeAndFillPath (VOID)
{
  return 0;
}


/* EngStrokePath ordinal = 136, argument = 0 temporary */
static DWORD WINAPI EngStrokePath (VOID)
{
  return 0;
}


/* EngTextOut ordinal = 137, argument = 0 temporary */
static DWORD WINAPI EngTextOut (VOID)
{
  return 0;
}


/* EngTransparentBlt ordinal = 138, argument = 0 temporary */
static DWORD WINAPI EngTransparentBlt (VOID)
{
  return 0;
}


/* EngUnicodeToMultiByteN ordinal = 139, argument = 0 temporary */
static DWORD WINAPI EngUnicodeToMultiByteN (VOID)
{
  return 0;
}


/* EngUnlockSurface ordinal = 140, argument = 0 temporary */
static DWORD WINAPI EngUnlockSurface (VOID)
{
  return 0;
}


/* EngWideCharToMultiByte ordinal = 141, argument = 0 temporary */
static DWORD WINAPI EngWideCharToMultiByte (VOID)
{
  return 0;
}


/* EnumEnhMetaFile ordinal = 142, argument = 20 temporary */
static DWORD WINAPI EnumEnhMetaFile (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* EnumFontFamiliesA ordinal = 143, argument = 16 temporary */
static DWORD WINAPI EnumFontFamiliesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumFontFamiliesExA ordinal = 144, argument = 20 temporary */
static DWORD WINAPI EnumFontFamiliesExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* EnumFontFamiliesExW ordinal = 145, argument = 20 temporary */
static DWORD WINAPI EnumFontFamiliesExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* EnumFontFamiliesW ordinal = 146, argument = 16 temporary */
static DWORD WINAPI EnumFontFamiliesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumFontsA ordinal = 147, argument = 16 temporary */
static DWORD WINAPI EnumFontsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumFontsW ordinal = 148, argument = 16 temporary */
static DWORD WINAPI EnumFontsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumICMProfilesA ordinal = 149, argument = 12 temporary */
static DWORD WINAPI EnumICMProfilesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumICMProfilesW ordinal = 150, argument = 12 temporary */
static DWORD WINAPI EnumICMProfilesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* EnumMetaFile ordinal = 151, argument = 16 temporary */
static DWORD WINAPI EnumMetaFile (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EnumObjects ordinal = 152, argument = 16 temporary */
static DWORD WINAPI EnumObjects (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EqualRgn ordinal = 153, argument = 8 temporary */
static DWORD WINAPI EqualRgn (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Escape ordinal = 154, argument = 20 temporary */
static DWORD WINAPI Escape (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* EudcLoadLinkW ordinal = 155, argument = 16 temporary */
static DWORD WINAPI EudcLoadLinkW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* EudcUnloadLinkW ordinal = 156, argument = 8 temporary */
static DWORD WINAPI EudcUnloadLinkW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ExcludeClipRect ordinal = 157, argument = 20 temporary */
static DWORD WINAPI ExcludeClipRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ExtCreatePen ordinal = 158, argument = 20 temporary */
static DWORD WINAPI ExtCreatePen (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ExtCreateRegion ordinal = 159, argument = 12 temporary */
static DWORD WINAPI ExtCreateRegion (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ExtEscape ordinal = 160, argument = 24 temporary */
static DWORD WINAPI ExtEscape (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* ExtFloodFill ordinal = 161, argument = 20 temporary */
static DWORD WINAPI ExtFloodFill (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ExtSelectClipRgn ordinal = 162, argument = 12 temporary */
static DWORD WINAPI ExtSelectClipRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ExtTextOutA ordinal = 163, argument = 32 temporary */
static DWORD WINAPI ExtTextOutA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* ExtTextOutW ordinal = 164, argument = 32 temporary */
static DWORD WINAPI ExtTextOutW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* FONTOBJ_cGetAllGlyphHandles ordinal = 165, argument = 0 temporary */
static DWORD WINAPI FONTOBJ_cGetAllGlyphHandles (VOID)
{
  return 0;
}


/* FONTOBJ_cGetGlyphs ordinal = 166, argument = 0 temporary */
static DWORD WINAPI FONTOBJ_cGetGlyphs (VOID)
{
  return 0;
}


/* FONTOBJ_pQueryGlyphAttrs ordinal = 167, argument = 0 temporary */
static DWORD WINAPI FONTOBJ_pQueryGlyphAttrs (VOID)
{
  return 0;
}


/* FONTOBJ_pfdg ordinal = 168, argument = 0 temporary */
static DWORD WINAPI FONTOBJ_pfdg (VOID)
{
  return 0;
}


/* FONTOBJ_pifi ordinal = 169, argument = 0 temporary */
static DWORD WINAPI FONTOBJ_pifi (VOID)
{
  return 0;
}


/* FONTOBJ_pvTrueTypeFontFile ordinal = 170, argument = 0 temporary */
static DWORD WINAPI FONTOBJ_pvTrueTypeFontFile (VOID)
{
  return 0;
}


/* FONTOBJ_pxoGetXform ordinal = 171, argument = 0 temporary */
static DWORD WINAPI FONTOBJ_pxoGetXform (VOID)
{
  return 0;
}


/* FONTOBJ_vGetInfo ordinal = 172, argument = 0 temporary */
static DWORD WINAPI FONTOBJ_vGetInfo (VOID)
{
  return 0;
}


/* FillPath ordinal = 173, argument = 4 temporary */
static DWORD WINAPI FillPath (DWORD dwArgv0)
{
  return 0;
}


/* FillRgn ordinal = 174, argument = 12 temporary */
static DWORD WINAPI FillRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* FixBrushOrgEx ordinal = 175, argument = 16 temporary */
static DWORD WINAPI FixBrushOrgEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* FlattenPath ordinal = 176, argument = 4 temporary */
static DWORD WINAPI FlattenPath (DWORD dwArgv0)
{
  return 0;
}


/* FloodFill ordinal = 177, argument = 16 temporary */
static DWORD WINAPI FloodFill (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* FontIsLinked ordinal = 178, argument = 0 temporary */
static DWORD WINAPI FontIsLinked (VOID)
{
  return 0;
}


/* FrameRgn ordinal = 179, argument = 20 temporary */
static DWORD WINAPI FrameRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GdiAddFontResourceW ordinal = 180, argument = 0 temporary */
static DWORD WINAPI GdiAddFontResourceW (VOID)
{
  return 0;
}


/* GdiAddGlsBounds ordinal = 181, argument = 0 temporary */
static DWORD WINAPI GdiAddGlsBounds (VOID)
{
  return 0;
}


/* GdiAddGlsRecord ordinal = 182, argument = 0 temporary */
static DWORD WINAPI GdiAddGlsRecord (VOID)
{
  return 0;
}


/* GdiAlphaBlend ordinal = 183, argument = 0 temporary */
static DWORD WINAPI GdiAlphaBlend (VOID)
{
  return 0;
}


/* GdiArtificialDecrementDriver ordinal = 184, argument = 8 temporary */
static DWORD WINAPI GdiArtificialDecrementDriver (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GdiCleanCacheDC ordinal = 185, argument = 0 temporary */
static DWORD WINAPI GdiCleanCacheDC (VOID)
{
  return 0;
}


/* GdiComment ordinal = 186, argument = 12 temporary */
static DWORD WINAPI GdiComment (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GdiConsoleTextOut ordinal = 187, argument = 0 temporary */
static DWORD WINAPI GdiConsoleTextOut (VOID)
{
  return 0;
}


/* GdiConvertAndCheckDC ordinal = 188, argument = 0 temporary */
static DWORD WINAPI GdiConvertAndCheckDC (VOID)
{
  return 0;
}


/* GdiConvertBitmap ordinal = 189, argument = 0 temporary */
static DWORD WINAPI GdiConvertBitmap (VOID)
{
  return 0;
}


/* GdiConvertBitmapV5 ordinal = 190, argument = 0 temporary */
static DWORD WINAPI GdiConvertBitmapV5 (VOID)
{
  return 0;
}


/* GdiConvertBrush ordinal = 191, argument = 0 temporary */
static DWORD WINAPI GdiConvertBrush (VOID)
{
  return 0;
}


/* GdiConvertDC ordinal = 192, argument = 0 temporary */
static DWORD WINAPI GdiConvertDC (VOID)
{
  return 0;
}


/* GdiConvertEnhMetaFile ordinal = 193, argument = 0 temporary */
static DWORD WINAPI GdiConvertEnhMetaFile (VOID)
{
  return 0;
}


/* GdiConvertFont ordinal = 194, argument = 0 temporary */
static DWORD WINAPI GdiConvertFont (VOID)
{
  return 0;
}


/* GdiConvertMetaFilePict ordinal = 195, argument = 0 temporary */
static DWORD WINAPI GdiConvertMetaFilePict (VOID)
{
  return 0;
}


/* GdiConvertPalette ordinal = 196, argument = 0 temporary */
static DWORD WINAPI GdiConvertPalette (VOID)
{
  return 0;
}


/* GdiConvertRegion ordinal = 197, argument = 0 temporary */
static DWORD WINAPI GdiConvertRegion (VOID)
{
  return 0;
}


/* GdiConvertToDevmodeW ordinal = 198, argument = 0 temporary */
static DWORD WINAPI GdiConvertToDevmodeW (VOID)
{
  return 0;
}


/* GdiCreateLocalEnhMetaFile ordinal = 199, argument = 0 temporary */
static DWORD WINAPI GdiCreateLocalEnhMetaFile (VOID)
{
  return 0;
}


/* GdiCreateLocalMetaFilePict ordinal = 200, argument = 0 temporary */
static DWORD WINAPI GdiCreateLocalMetaFilePict (VOID)
{
  return 0;
}


/* GdiDeleteLocalDC ordinal = 201, argument = 0 temporary */
static DWORD WINAPI GdiDeleteLocalDC (VOID)
{
  return 0;
}


/* GdiDeleteSpoolFileHandle ordinal = 202, argument = 4 temporary */
static DWORD WINAPI GdiDeleteSpoolFileHandle (DWORD dwArgv0)
{
  return 0;
}


/* GdiDescribePixelFormat ordinal = 203, argument = 0 temporary */
static DWORD WINAPI GdiDescribePixelFormat (VOID)
{
  return 0;
}


/* GdiDllInitialize ordinal = 204, argument = 0 temporary */
static DWORD WINAPI GdiDllInitialize (VOID)
{
  return 0;
}


/* GdiEndDocEMF ordinal = 205, argument = 4 temporary */
static DWORD WINAPI GdiEndDocEMF (DWORD dwArgv0)
{
  return 0;
}


/* GdiEndPageEMF ordinal = 206, argument = 8 temporary */
static DWORD WINAPI GdiEndPageEMF (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GdiEntry1 ordinal = 214, argument = 0 temporary */
static DWORD WINAPI GdiEntry1 (VOID)
{
  return 0;
}


/* GdiEntry10 ordinal = 207, argument = 0 temporary */
static DWORD WINAPI GdiEntry10 (VOID)
{
  return 0;
}


/* GdiEntry11 ordinal = 208, argument = 0 temporary */
static DWORD WINAPI GdiEntry11 (VOID)
{
  return 0;
}


/* GdiEntry12 ordinal = 209, argument = 0 temporary */
static DWORD WINAPI GdiEntry12 (VOID)
{
  return 0;
}


/* GdiEntry13 ordinal = 210, argument = 0 temporary */
static DWORD WINAPI GdiEntry13 (VOID)
{
  return 0;
}


/* GdiEntry14 ordinal = 211, argument = 0 temporary */
static DWORD WINAPI GdiEntry14 (VOID)
{
  return 0;
}


/* GdiEntry15 ordinal = 212, argument = 0 temporary */
static DWORD WINAPI GdiEntry15 (VOID)
{
  return 0;
}


/* GdiEntry16 ordinal = 213, argument = 0 temporary */
static DWORD WINAPI GdiEntry16 (VOID)
{
  return 0;
}


/* GdiEntry2 ordinal = 215, argument = 0 temporary */
static DWORD WINAPI GdiEntry2 (VOID)
{
  return 0;
}


/* GdiEntry3 ordinal = 216, argument = 0 temporary */
static DWORD WINAPI GdiEntry3 (VOID)
{
  return 0;
}


/* GdiEntry4 ordinal = 217, argument = 0 temporary */
static DWORD WINAPI GdiEntry4 (VOID)
{
  return 0;
}


/* GdiEntry5 ordinal = 218, argument = 0 temporary */
static DWORD WINAPI GdiEntry5 (VOID)
{
  return 0;
}


/* GdiEntry6 ordinal = 219, argument = 0 temporary */
static DWORD WINAPI GdiEntry6 (VOID)
{
  return 0;
}


/* GdiEntry7 ordinal = 220, argument = 0 temporary */
static DWORD WINAPI GdiEntry7 (VOID)
{
  return 0;
}


/* GdiEntry8 ordinal = 221, argument = 0 temporary */
static DWORD WINAPI GdiEntry8 (VOID)
{
  return 0;
}


/* GdiEntry9 ordinal = 222, argument = 0 temporary */
static DWORD WINAPI GdiEntry9 (VOID)
{
  return 0;
}


/* GdiFixUpHandle ordinal = 223, argument = 0 temporary */
static DWORD WINAPI GdiFixUpHandle (VOID)
{
  return 0;
}


/* GdiFlush ordinal = 224, argument = 0 temporary */
static DWORD WINAPI GdiFlush (VOID)
{
  return 0;
}


/* GdiFullscreenControl ordinal = 225, argument = 0 temporary */
static DWORD WINAPI GdiFullscreenControl (VOID)
{
  return 0;
}


/* GdiGetBatchLimit ordinal = 226, argument = 0 temporary */
static DWORD WINAPI GdiGetBatchLimit (VOID)
{
  return 0;
}


/* GdiGetCharDimensions ordinal = 227, argument = 0 temporary */
static DWORD WINAPI GdiGetCharDimensions (VOID)
{
  return 0;
}


/* GdiGetCodePage ordinal = 228, argument = 0 temporary */
static DWORD WINAPI GdiGetCodePage (VOID)
{
  return 0;
}


/* GdiGetDC ordinal = 229, argument = 4 temporary */
static DWORD WINAPI GdiGetDC (DWORD dwArgv0)
{
  return 0;
}


/* GdiGetDevmodeForPage ordinal = 230, argument = 16 temporary */
static DWORD WINAPI GdiGetDevmodeForPage (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GdiGetLocalBrush ordinal = 231, argument = 0 temporary */
static DWORD WINAPI GdiGetLocalBrush (VOID)
{
  return 0;
}


/* GdiGetLocalDC ordinal = 232, argument = 0 temporary */
static DWORD WINAPI GdiGetLocalDC (VOID)
{
  return 0;
}


/* GdiGetLocalFont ordinal = 233, argument = 0 temporary */
static DWORD WINAPI GdiGetLocalFont (VOID)
{
  return 0;
}


/* GdiGetPageCount ordinal = 234, argument = 4 temporary */
static DWORD WINAPI GdiGetPageCount (DWORD dwArgv0)
{
  return 0;
}


/* GdiGetPageHandle ordinal = 235, argument = 12 temporary */
static DWORD WINAPI GdiGetPageHandle (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GdiGetSpoolFileHandle ordinal = 236, argument = 12 temporary */
static DWORD WINAPI GdiGetSpoolFileHandle (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GdiGetSpoolMessage ordinal = 237, argument = 0 temporary */
static DWORD WINAPI GdiGetSpoolMessage (VOID)
{
  return 0;
}


/* GdiGradientFill ordinal = 238, argument = 0 temporary */
static DWORD WINAPI GdiGradientFill (VOID)
{
  return 0;
}


/* GdiInitSpool ordinal = 239, argument = 0 temporary */
static DWORD WINAPI GdiInitSpool (VOID)
{
  return 0;
}


/* GdiInitializeLanguagePack ordinal = 240, argument = 0 temporary */
static DWORD WINAPI GdiInitializeLanguagePack (VOID)
{
  return 0;
}


/* GdiIsMetaFileDC ordinal = 241, argument = 0 temporary */
static DWORD WINAPI GdiIsMetaFileDC (VOID)
{
  return 0;
}


/* GdiIsMetaPrintDC ordinal = 242, argument = 0 temporary */
static DWORD WINAPI GdiIsMetaPrintDC (VOID)
{
  return 0;
}


/* GdiIsPlayMetafileDC ordinal = 243, argument = 0 temporary */
static DWORD WINAPI GdiIsPlayMetafileDC (VOID)
{
  return 0;
}


/* GdiPlayDCScript ordinal = 244, argument = 24 temporary */
static DWORD WINAPI GdiPlayDCScript (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GdiPlayEMF ordinal = 245, argument = 20 temporary */
static DWORD WINAPI GdiPlayEMF (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GdiPlayJournal ordinal = 246, argument = 20 temporary */
static DWORD WINAPI GdiPlayJournal (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GdiPlayPageEMF ordinal = 247, argument = 20 temporary */
static DWORD WINAPI GdiPlayPageEMF (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GdiPlayPrivatePageEMF ordinal = 248, argument = 12 temporary */
static DWORD WINAPI GdiPlayPrivatePageEMF (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GdiPlayScript ordinal = 249, argument = 28 temporary */
static DWORD WINAPI GdiPlayScript (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GdiPrinterThunk ordinal = 250, argument = 0 temporary */
static DWORD WINAPI GdiPrinterThunk (VOID)
{
  return 0;
}


/* GdiProcessSetup ordinal = 251, argument = 0 temporary */
static DWORD WINAPI GdiProcessSetup (VOID)
{
  return 0;
}


/* GdiQueryFonts ordinal = 252, argument = 0 temporary */
static DWORD WINAPI GdiQueryFonts (VOID)
{
  return 0;
}


/* GdiQueryTable ordinal = 253, argument = 0 temporary */
static DWORD WINAPI GdiQueryTable (VOID)
{
  return 0;
}


/* GdiRealizationInfo ordinal = 254, argument = 0 temporary */
static DWORD WINAPI GdiRealizationInfo (VOID)
{
  return 0;
}


/* GdiReleaseDC ordinal = 255, argument = 0 temporary */
static DWORD WINAPI GdiReleaseDC (VOID)
{
  return 0;
}


/* GdiReleaseLocalDC ordinal = 256, argument = 0 temporary */
static DWORD WINAPI GdiReleaseLocalDC (VOID)
{
  return 0;
}


/* GdiResetDCEMF ordinal = 257, argument = 8 temporary */
static DWORD WINAPI GdiResetDCEMF (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GdiSetAttrs ordinal = 258, argument = 0 temporary */
static DWORD WINAPI GdiSetAttrs (VOID)
{
  return 0;
}


/* GdiSetBatchLimit ordinal = 259, argument = 4 temporary */
static DWORD WINAPI GdiSetBatchLimit (DWORD dwArgv0)
{
  return 0;
}


/* GdiSetLastError ordinal = 260, argument = 0 temporary */
static DWORD WINAPI GdiSetLastError (VOID)
{
  return 0;
}


/* GdiSetPixelFormat ordinal = 261, argument = 0 temporary */
static DWORD WINAPI GdiSetPixelFormat (VOID)
{
  return 0;
}


/* GdiSetServerAttr ordinal = 262, argument = 0 temporary */
static DWORD WINAPI GdiSetServerAttr (VOID)
{
  return 0;
}


/* GdiStartDocEMF ordinal = 263, argument = 8 temporary */
static DWORD WINAPI GdiStartDocEMF (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GdiStartPageEMF ordinal = 264, argument = 4 temporary */
static DWORD WINAPI GdiStartPageEMF (DWORD dwArgv0)
{
  return 0;
}


/* GdiSwapBuffers ordinal = 265, argument = 0 temporary */
static DWORD WINAPI GdiSwapBuffers (VOID)
{
  return 0;
}


/* GdiTransparentBlt ordinal = 266, argument = 0 temporary */
static DWORD WINAPI GdiTransparentBlt (VOID)
{
  return 0;
}


/* GdiValidateHandle ordinal = 267, argument = 0 temporary */
static DWORD WINAPI GdiValidateHandle (VOID)
{
  return 0;
}


/* GetArcDirection ordinal = 268, argument = 4 temporary */
static DWORD WINAPI GetArcDirection (DWORD dwArgv0)
{
  return 0;
}


/* GetAspectRatioFilterEx ordinal = 269, argument = 8 temporary */
static DWORD WINAPI GetAspectRatioFilterEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetBitmapBits ordinal = 270, argument = 12 temporary */
static DWORD WINAPI GetBitmapBits (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetBitmapDimensionEx ordinal = 271, argument = 8 temporary */
static DWORD WINAPI GetBitmapDimensionEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetBkColor ordinal = 272, argument = 4 */
COLORREF WINAPI GetBkColor (HDC hDC)
{
  return RGB (hDC->bgcolor.red / 256,
              hDC->bgcolor.green / 256,
              hDC->bgcolor.blue / 256);
}


/* GetBkMode ordinal = 273, argument = 4 */
INT WINAPI GetBkMode (HDC hDC)
{
  return hDC->transparent ? TRANSPARENT : OPAQUE;
}


/* GetBoundsRect ordinal = 274, argument = 12 temporary */
static DWORD WINAPI GetBoundsRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetBrushOrgEx ordinal = 275, argument = 8 temporary */
static DWORD WINAPI GetBrushOrgEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCharABCWidthsA ordinal = 276, argument = 16 temporary */
static DWORD WINAPI GetCharABCWidthsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharABCWidthsFloatA ordinal = 277, argument = 16 temporary */
static DWORD WINAPI GetCharABCWidthsFloatA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharABCWidthsFloatW ordinal = 278, argument = 16 temporary */
static DWORD WINAPI GetCharABCWidthsFloatW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharABCWidthsI ordinal = 279, argument = 20 temporary */
static DWORD WINAPI GetCharABCWidthsI (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetCharABCWidthsW ordinal = 280, argument = 16 temporary */
static DWORD WINAPI GetCharABCWidthsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharWidth32A ordinal = 281, argument = 16 temporary */
static DWORD WINAPI GetCharWidth32A (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharWidth32W ordinal = 282, argument = 16 temporary */
static DWORD WINAPI GetCharWidth32W (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharWidthA ordinal = 283, argument = 16 temporary */
static DWORD WINAPI GetCharWidthA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharWidthFloatA ordinal = 284, argument = 16 temporary */
static DWORD WINAPI GetCharWidthFloatA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharWidthFloatW ordinal = 285, argument = 16 temporary */
static DWORD WINAPI GetCharWidthFloatW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharWidthI ordinal = 286, argument = 20 temporary */
static DWORD WINAPI GetCharWidthI (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetCharWidthInfo ordinal = 287, argument = 0 temporary */
static DWORD WINAPI GetCharWidthInfo (VOID)
{
  return 0;
}


/* GetCharWidthW ordinal = 288, argument = 16 temporary */
static DWORD WINAPI GetCharWidthW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetCharacterPlacementA ordinal = 289, argument = 24 temporary */
static DWORD WINAPI GetCharacterPlacementA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetCharacterPlacementW ordinal = 290, argument = 24 temporary */
static DWORD WINAPI GetCharacterPlacementW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* GetClipBox ordinal = 291, argument = 8 temporary */
static DWORD WINAPI GetClipBox (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetClipRgn ordinal = 292, argument = 8 temporary */
static DWORD WINAPI GetClipRgn (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetColorAdjustment ordinal = 293, argument = 8 temporary */
static DWORD WINAPI GetColorAdjustment (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetColorSpace ordinal = 294, argument = 4 temporary */
static DWORD WINAPI GetColorSpace (DWORD dwArgv0)
{
  return 0;
}


/* GetCurrentObject ordinal = 295, argument = 8 temporary */
static DWORD WINAPI GetCurrentObject (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetCurrentPositionEx ordinal = 296, argument = 8 temporary */
static DWORD WINAPI GetCurrentPositionEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetDCBrushColor ordinal = 297, argument = 4 temporary */
static DWORD WINAPI GetDCBrushColor (DWORD dwArgv0)
{
  return 0;
}


/* GetDCOrgEx ordinal = 298, argument = 8 temporary */
static DWORD WINAPI GetDCOrgEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetDCPenColor ordinal = 299, argument = 4 temporary */
static DWORD WINAPI GetDCPenColor (DWORD dwArgv0)
{
  return 0;
}


/* GetDIBColorTable ordinal = 300, argument = 16 temporary */
static DWORD WINAPI GetDIBColorTable (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetDIBits ordinal = 301, argument = 28 temporary */
static DWORD WINAPI GetDIBits (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GetDeviceCaps ordinal = 302, argument = 8 */
INT WINAPI GetDeviceCaps (HDC hDC, INT nIndex)
{
  return 0;
}


/* GetDeviceGammaRamp ordinal = 303, argument = 8 temporary */
static DWORD WINAPI GetDeviceGammaRamp (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetETM ordinal = 304, argument = 0 temporary */
static DWORD WINAPI GetETM (VOID)
{
  return 0;
}


/* GetEUDCTimeStamp ordinal = 305, argument = 0 temporary */
static DWORD WINAPI GetEUDCTimeStamp (VOID)
{
  return 0;
}


/* GetEUDCTimeStampExW ordinal = 306, argument = 0 temporary */
static DWORD WINAPI GetEUDCTimeStampExW (VOID)
{
  return 0;
}


/* GetEnhMetaFileA ordinal = 307, argument = 4 temporary */
static DWORD WINAPI GetEnhMetaFileA (DWORD dwArgv0)
{
  return 0;
}


/* GetEnhMetaFileBits ordinal = 308, argument = 12 temporary */
static DWORD WINAPI GetEnhMetaFileBits (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetEnhMetaFileDescriptionA ordinal = 309, argument = 12 temporary */
static DWORD WINAPI GetEnhMetaFileDescriptionA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetEnhMetaFileDescriptionW ordinal = 310, argument = 12 temporary */
static DWORD WINAPI GetEnhMetaFileDescriptionW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetEnhMetaFileHeader ordinal = 311, argument = 12 temporary */
static DWORD WINAPI GetEnhMetaFileHeader (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetEnhMetaFilePaletteEntries ordinal = 312, argument = 12 temporary */
static DWORD WINAPI GetEnhMetaFilePaletteEntries (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetEnhMetaFilePixelFormat ordinal = 313, argument = 12 temporary */
static DWORD WINAPI GetEnhMetaFilePixelFormat (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetEnhMetaFileW ordinal = 314, argument = 4 temporary */
static DWORD WINAPI GetEnhMetaFileW (DWORD dwArgv0)
{
  return 0;
}


/* GetFontAssocStatus ordinal = 315, argument = 4 temporary */
static DWORD WINAPI GetFontAssocStatus (DWORD dwArgv0)
{
  return 0;
}


/* GetFontData ordinal = 316, argument = 20 temporary */
static DWORD WINAPI GetFontData (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetFontLanguageInfo ordinal = 317, argument = 4 temporary */
static DWORD WINAPI GetFontLanguageInfo (DWORD dwArgv0)
{
  return 0;
}


/* GetFontResourceInfoW ordinal = 318, argument = 16 temporary */
static DWORD WINAPI GetFontResourceInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetFontUnicodeRanges ordinal = 319, argument = 8 temporary */
static DWORD WINAPI GetFontUnicodeRanges (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetGlyphIndicesA ordinal = 320, argument = 20 temporary */
static DWORD WINAPI GetGlyphIndicesA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetGlyphIndicesW ordinal = 321, argument = 20 temporary */
static DWORD WINAPI GetGlyphIndicesW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetGlyphOutline ordinal = 322, argument = 28 temporary */
/* DWORD WINAPI GetGlyphOutline (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6) */


/* GetGlyphOutlineA ordinal = 323, argument = 28 temporary */
static DWORD WINAPI GetGlyphOutlineA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GetGlyphOutlineW ordinal = 324, argument = 28 temporary */
static DWORD WINAPI GetGlyphOutlineW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GetGlyphOutlineWow ordinal = 325, argument = 0 temporary */
static DWORD WINAPI GetGlyphOutlineWow (VOID)
{
  return 0;
}


/* GetGraphicsMode ordinal = 326, argument = 4 temporary */
static DWORD WINAPI GetGraphicsMode (DWORD dwArgv0)
{
  return 0;
}


/* GetHFONT ordinal = 327, argument = 0 temporary */
static DWORD WINAPI GetHFONT (VOID)
{
  return 0;
}


/* GetICMProfileA ordinal = 328, argument = 12 temporary */
static DWORD WINAPI GetICMProfileA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetICMProfileW ordinal = 329, argument = 12 temporary */
static DWORD WINAPI GetICMProfileW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetKerningPairs ordinal = 330, argument = 12 temporary */
/* DWORD WINAPI GetKerningPairs (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2) */


/* GetKerningPairsA ordinal = 331, argument = 12 temporary */
static DWORD WINAPI GetKerningPairsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetKerningPairsW ordinal = 332, argument = 12 temporary */
static DWORD WINAPI GetKerningPairsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetLayout ordinal = 333, argument = 4 temporary */
static DWORD WINAPI GetLayout (DWORD dwArgv0)
{
  return 0;
}


/* GetLogColorSpaceA ordinal = 334, argument = 12 temporary */
static DWORD WINAPI GetLogColorSpaceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetLogColorSpaceW ordinal = 335, argument = 12 temporary */
static DWORD WINAPI GetLogColorSpaceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetMapMode ordinal = 336, argument = 4 temporary */
static DWORD WINAPI GetMapMode (DWORD dwArgv0)
{
  return 0;
}


/* GetMetaFileA ordinal = 337, argument = 4 temporary */
static DWORD WINAPI GetMetaFileA (DWORD dwArgv0)
{
  return 0;
}


/* GetMetaFileBitsEx ordinal = 338, argument = 12 temporary */
static DWORD WINAPI GetMetaFileBitsEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetMetaFileW ordinal = 339, argument = 4 temporary */
static DWORD WINAPI GetMetaFileW (DWORD dwArgv0)
{
  return 0;
}


/* GetMetaRgn ordinal = 340, argument = 8 temporary */
static DWORD WINAPI GetMetaRgn (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetMiterLimit ordinal = 341, argument = 8 temporary */
static DWORD WINAPI GetMiterLimit (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetNearestColor ordinal = 342, argument = 8 */
COLORREF WINAPI GetNearestColor (HDC hDC, COLORREF crColor)
{
  return crColor;
}


/* GetNearestPaletteIndex ordinal = 343, argument = 8 temporary */
static DWORD WINAPI GetNearestPaletteIndex (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetObjectA ordinal = 344, argument = 12 */
INT WINAPI GetObjectA (HGDIOBJ hObject, INT cbBuffer, LPVOID lpvObject)
{
  return GetObjectW (hObject, cbBuffer, lpvObject);
}


/* GetObjectType ordinal = 345, argument = 4 temporary */
static DWORD WINAPI GetObjectType (DWORD dwArgv0)
{
  return 0;
}


/* GetObjectW ordinal = 346, argument = 12 */
INT WINAPI GetObjectW (HGDIOBJ hObject, INT cbBuffer, LPVOID lpvObject)
{
  if (hObject && GDK_IS_PIXBUF (hObject))
    {
      if (!lpvObject)
        return sizeof (BITMAP);
      if (cbBuffer >= sizeof (BITMAP))
        {
          BitmapInfoHeader *bmih;

          bmih = pixbuf_to_bitmap (GDK_PIXBUF (hObject));
          if (bmih)
            {
              LPBITMAP lpBmp;

              lpBmp = lpvObject;
              lpBmp->bmType = 0;
              lpBmp->bmWidth = bmih_get_width (bmih);
              lpBmp->bmHeight = bmih_get_height (bmih);
              lpBmp->bmWidthBytes = (bmih_get_width (bmih) + 1) / 2 * 2;
              lpBmp->bmPlanes = bmih_get_planes (bmih);
              lpBmp->bmBitsPixel = bmih_get_bit_count (bmih);
              lpBmp->bmBits = NULL;
              g_free (bmih);
              return sizeof (BITMAP);
            }
        }
    }
  return 0;
}


/* GetOutlineTextMetricsA ordinal = 347, argument = 12 temporary */
static DWORD WINAPI GetOutlineTextMetricsA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetOutlineTextMetricsW ordinal = 348, argument = 12 temporary */
static DWORD WINAPI GetOutlineTextMetricsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetPaletteEntries ordinal = 349, argument = 16 temporary */
static DWORD WINAPI GetPaletteEntries (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetPath ordinal = 350, argument = 16 temporary */
static DWORD WINAPI GetPath (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetPixel ordinal = 351, argument = 12 temporary */
static DWORD WINAPI GetPixel (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetPixelFormat ordinal = 352, argument = 4 temporary */
static DWORD WINAPI GetPixelFormat (DWORD dwArgv0)
{
  return 0;
}


/* GetPolyFillMode ordinal = 353, argument = 4 temporary */
static DWORD WINAPI GetPolyFillMode (DWORD dwArgv0)
{
  return 0;
}


/* GetROP2 ordinal = 354, argument = 4 temporary */
static DWORD WINAPI GetROP2 (DWORD dwArgv0)
{
  return 0;
}


/* GetRandomRgn ordinal = 355, argument = 12 temporary */
static DWORD WINAPI GetRandomRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetRasterizerCaps ordinal = 356, argument = 8 temporary */
static DWORD WINAPI GetRasterizerCaps (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetRegionData ordinal = 357, argument = 12 temporary */
static DWORD WINAPI GetRegionData (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetRelAbs ordinal = 358, argument = 8 temporary */
static DWORD WINAPI GetRelAbs (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetRgnBox ordinal = 359, argument = 8 temporary */
static DWORD WINAPI GetRgnBox (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetStockObject ordinal = 360, argument = 4 temporary */
static DWORD WINAPI GetStockObject (DWORD dwArgv0)
{
  return 0;
}


/* GetStretchBltMode ordinal = 361, argument = 4 temporary */
static DWORD WINAPI GetStretchBltMode (DWORD dwArgv0)
{
  return 0;
}


/* GetStringBitmapA ordinal = 362, argument = 0 temporary */
static DWORD WINAPI GetStringBitmapA (VOID)
{
  return 0;
}


/* GetStringBitmapW ordinal = 363, argument = 0 temporary */
static DWORD WINAPI GetStringBitmapW (VOID)
{
  return 0;
}


/* GetSystemPaletteEntries ordinal = 364, argument = 16 */
UINT WINAPI GetSystemPaletteEntries (HDC hDC, UINT iStartIndex, UINT nEntries, LPPALETTEENTRY lppe)
{
  return 0;
}


/* GetSystemPaletteUse ordinal = 365, argument = 4 temporary */
static DWORD WINAPI GetSystemPaletteUse (DWORD dwArgv0)
{
  return 0;
}


/* GetTextAlign ordinal = 366, argument = 4 temporary */
static DWORD WINAPI GetTextAlign (DWORD dwArgv0)
{
  return 0;
}


/* GetTextCharacterExtra ordinal = 367, argument = 4 temporary */
static DWORD WINAPI GetTextCharacterExtra (DWORD dwArgv0)
{
  return 0;
}


/* GetTextCharset ordinal = 368, argument = 4 temporary */
static DWORD WINAPI GetTextCharset (DWORD dwArgv0)
{
  return 0;
}


/* GetTextCharsetInfo ordinal = 369, argument = 12 temporary */
static DWORD WINAPI GetTextCharsetInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetTextColor ordinal = 370, argument = 4 */
COLORREF WINAPI GetTextColor (HDC hDC)
{
  return RGB (hDC->fgcolor.red / 256,
              hDC->fgcolor.green / 256,
              hDC->fgcolor.blue / 256);
}


/* GetTextExtentExPointA ordinal = 371, argument = 28 temporary */
static DWORD WINAPI GetTextExtentExPointA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GetTextExtentExPointI ordinal = 372, argument = 28 temporary */
static DWORD WINAPI GetTextExtentExPointI (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GetTextExtentExPointW ordinal = 373, argument = 28 temporary */
static DWORD WINAPI GetTextExtentExPointW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* GetTextExtentExPointWPri ordinal = 374, argument = 0 temporary */
static DWORD WINAPI GetTextExtentExPointWPri (VOID)
{
  return 0;
}


/* GetTextExtentPoint32A ordinal = 375, argument = 16 */
BOOL WINAPI GetTextExtentPoint32A (HDC hDC, LPCSTR lpString, INT cbString, LPSIZE lpSize)
{
  gchar *utf8str;
  gunichar2 *string;
  BOOL fResult;

  utf8str = w32ldr_utf8_from_mb (lpString);
  string = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  fResult = GetTextExtentPoint32W (hDC, string, lstrlenW (string), lpSize);
  g_free (string);
  return fResult;
}


/* GetTextExtentPoint32W ordinal = 376, argument = 16 */
BOOL WINAPI GetTextExtentPoint32W (HDC hDC, LPCWSTR lpString, INT cbString, LPSIZE lpSize)
{
  int w, h;
  gchar *utf8str;
  PangoLayout *layout;
  const PangoFontDescription *desc;

  if (!hDC || !hDC->widget || !lpString || cbString <= 0 || !lpSize)
    return FALSE;
  utf8str = g_utf16_to_utf8 (lpString, cbString, NULL, NULL, NULL);
  layout = gtk_widget_create_pango_layout (hDC->widget, utf8str);
  g_free (utf8str);
  desc = w32ldr_font_get_description (hDC->font);
  if (desc)
    pango_layout_set_font_description (layout, desc);
  pango_layout_get_pixel_size (layout, &w, &h);
  lpSize->cx = w;
  lpSize->cy = h;
  g_object_unref (G_OBJECT (layout));
  return TRUE;
}


/* GetTextExtentPointA ordinal = 377, argument = 16 temporary */
static DWORD WINAPI GetTextExtentPointA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetTextExtentPointI ordinal = 378, argument = 16 temporary */
static DWORD WINAPI GetTextExtentPointI (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetTextExtentPointW ordinal = 379, argument = 16 temporary */
static DWORD WINAPI GetTextExtentPointW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* GetTextFaceA ordinal = 380, argument = 12 temporary */
static DWORD WINAPI GetTextFaceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetTextFaceAliasW ordinal = 381, argument = 0 temporary */
static DWORD WINAPI GetTextFaceAliasW (VOID)
{
  return 0;
}


/* GetTextFaceW ordinal = 382, argument = 12 temporary */
static DWORD WINAPI GetTextFaceW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* GetTextMetricsA ordinal = 383, argument = 8 temporary */
static DWORD WINAPI GetTextMetricsA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetTextMetricsW ordinal = 384, argument = 8 temporary */
static DWORD WINAPI GetTextMetricsW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetTransform ordinal = 385, argument = 0 temporary */
static DWORD WINAPI GetTransform (VOID)
{
  return 0;
}


/* GetViewportExtEx ordinal = 386, argument = 8 temporary */
static DWORD WINAPI GetViewportExtEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetViewportOrgEx ordinal = 387, argument = 8 temporary */
static DWORD WINAPI GetViewportOrgEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetWinMetaFileBits ordinal = 388, argument = 20 temporary */
static DWORD WINAPI GetWinMetaFileBits (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* GetWindowExtEx ordinal = 389, argument = 8 temporary */
static DWORD WINAPI GetWindowExtEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetWindowOrgEx ordinal = 390, argument = 8 temporary */
static DWORD WINAPI GetWindowOrgEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* GetWorldTransform ordinal = 391, argument = 8 temporary */
static DWORD WINAPI GetWorldTransform (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* HT_Get8BPPFormatPalette ordinal = 392, argument = 0 temporary */
static DWORD WINAPI HT_Get8BPPFormatPalette (VOID)
{
  return 0;
}


/* HT_Get8BPPMaskPalette ordinal = 393, argument = 0 temporary */
static DWORD WINAPI HT_Get8BPPMaskPalette (VOID)
{
  return 0;
}


/* IntersectClipRect ordinal = 394, argument = 20 temporary */
static DWORD WINAPI IntersectClipRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* InvertRgn ordinal = 395, argument = 8 temporary */
static DWORD WINAPI InvertRgn (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* IsValidEnhMetaRecord ordinal = 396, argument = 0 temporary */
static DWORD WINAPI IsValidEnhMetaRecord (VOID)
{
  return 0;
}


/* IsValidEnhMetaRecordOffExt ordinal = 397, argument = 0 temporary */
static DWORD WINAPI IsValidEnhMetaRecordOffExt (VOID)
{
  return 0;
}


/* LPtoDP ordinal = 398, argument = 12 temporary */
static DWORD WINAPI LPtoDP (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* LineDDA ordinal = 399, argument = 24 temporary */
static DWORD WINAPI LineDDA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* LineTo ordinal = 400, argument = 12 temporary */
static DWORD WINAPI LineTo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* MaskBlt ordinal = 401, argument = 48 temporary */
static DWORD WINAPI MaskBlt (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11)
{
  return 0;
}


/* MirrorRgn ordinal = 402, argument = 0 temporary */
static DWORD WINAPI MirrorRgn (VOID)
{
  return 0;
}


/* ModifyWorldTransform ordinal = 403, argument = 12 temporary */
static DWORD WINAPI ModifyWorldTransform (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* MoveToEx ordinal = 404, argument = 16 temporary */
static DWORD WINAPI MoveToEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* NamedEscape ordinal = 405, argument = 0 temporary */
static DWORD WINAPI NamedEscape (VOID)
{
  return 0;
}


/* OffsetClipRgn ordinal = 406, argument = 12 temporary */
static DWORD WINAPI OffsetClipRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OffsetRgn ordinal = 407, argument = 12 temporary */
static DWORD WINAPI OffsetRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OffsetViewportOrgEx ordinal = 408, argument = 16 temporary */
static DWORD WINAPI OffsetViewportOrgEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* OffsetWindowOrgEx ordinal = 409, argument = 16 temporary */
static DWORD WINAPI OffsetWindowOrgEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PATHOBJ_bEnum ordinal = 410, argument = 0 temporary */
static DWORD WINAPI PATHOBJ_bEnum (VOID)
{
  return 0;
}


/* PATHOBJ_bEnumClipLines ordinal = 411, argument = 0 temporary */
static DWORD WINAPI PATHOBJ_bEnumClipLines (VOID)
{
  return 0;
}


/* PATHOBJ_vEnumStart ordinal = 412, argument = 0 temporary */
static DWORD WINAPI PATHOBJ_vEnumStart (VOID)
{
  return 0;
}


/* PATHOBJ_vEnumStartClipLines ordinal = 413, argument = 0 temporary */
static DWORD WINAPI PATHOBJ_vEnumStartClipLines (VOID)
{
  return 0;
}


/* PATHOBJ_vGetBounds ordinal = 414, argument = 0 temporary */
static DWORD WINAPI PATHOBJ_vGetBounds (VOID)
{
  return 0;
}


/* PaintRgn ordinal = 415, argument = 8 temporary */
static DWORD WINAPI PaintRgn (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* PatBlt ordinal = 416, argument = 24 temporary */
static DWORD WINAPI PatBlt (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* PathToRegion ordinal = 417, argument = 4 temporary */
static DWORD WINAPI PathToRegion (DWORD dwArgv0)
{
  return 0;
}


/* Pie ordinal = 418, argument = 36 temporary */
static DWORD WINAPI Pie (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8)
{
  return 0;
}


/* PlayEnhMetaFile ordinal = 419, argument = 12 temporary */
static DWORD WINAPI PlayEnhMetaFile (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PlayEnhMetaFileRecord ordinal = 420, argument = 16 temporary */
static DWORD WINAPI PlayEnhMetaFileRecord (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PlayMetaFile ordinal = 421, argument = 8 temporary */
static DWORD WINAPI PlayMetaFile (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* PlayMetaFileRecord ordinal = 422, argument = 16 temporary */
static DWORD WINAPI PlayMetaFileRecord (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PlgBlt ordinal = 423, argument = 40 temporary */
static DWORD WINAPI PlgBlt (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9)
{
  return 0;
}


/* PolyBezier ordinal = 424, argument = 12 temporary */
static DWORD WINAPI PolyBezier (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PolyBezierTo ordinal = 425, argument = 12 temporary */
static DWORD WINAPI PolyBezierTo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PolyDraw ordinal = 426, argument = 16 temporary */
static DWORD WINAPI PolyDraw (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PolyPatBlt ordinal = 427, argument = 0 temporary */
static DWORD WINAPI PolyPatBlt (VOID)
{
  return 0;
}


/* PolyPolygon ordinal = 428, argument = 16 temporary */
static DWORD WINAPI PolyPolygon (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PolyPolyline ordinal = 429, argument = 16 temporary */
static DWORD WINAPI PolyPolyline (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* PolyTextOutA ordinal = 430, argument = 12 temporary */
static DWORD WINAPI PolyTextOutA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PolyTextOutW ordinal = 431, argument = 12 temporary */
static DWORD WINAPI PolyTextOutW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* Polygon ordinal = 432, argument = 12 temporary */
static DWORD WINAPI Polygon (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* Polyline ordinal = 433, argument = 12 temporary */
static DWORD WINAPI Polyline (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PolylineTo ordinal = 434, argument = 12 temporary */
static DWORD WINAPI PolylineTo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PtInRegion ordinal = 435, argument = 12 temporary */
static DWORD WINAPI PtInRegion (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* PtVisible ordinal = 436, argument = 12 temporary */
static DWORD WINAPI PtVisible (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* QueryFontAssocStatus ordinal = 437, argument = 0 temporary */
static DWORD WINAPI QueryFontAssocStatus (VOID)
{
  return 0;
}


/* RealizePalette ordinal = 438, argument = 4 temporary */
static DWORD WINAPI RealizePalette (DWORD dwArgv0)
{
  return 0;
}


/* RectInRegion ordinal = 439, argument = 8 temporary */
static DWORD WINAPI RectInRegion (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RectVisible ordinal = 440, argument = 8 temporary */
static DWORD WINAPI RectVisible (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Rectangle ordinal = 441, argument = 20 temporary */
static DWORD WINAPI Rectangle (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* RemoveFontMemResourceEx ordinal = 442, argument = 4 temporary */
static DWORD WINAPI RemoveFontMemResourceEx (DWORD dwArgv0)
{
  return 0;
}


/* RemoveFontResourceA ordinal = 443, argument = 4 temporary */
static DWORD WINAPI RemoveFontResourceA (DWORD dwArgv0)
{
  return 0;
}


/* RemoveFontResourceExA ordinal = 444, argument = 12 temporary */
static DWORD WINAPI RemoveFontResourceExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RemoveFontResourceExW ordinal = 445, argument = 12 temporary */
static DWORD WINAPI RemoveFontResourceExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* RemoveFontResourceTracking ordinal = 446, argument = 0 temporary */
static DWORD WINAPI RemoveFontResourceTracking (VOID)
{
  return 0;
}


/* RemoveFontResourceW ordinal = 447, argument = 4 temporary */
static DWORD WINAPI RemoveFontResourceW (DWORD dwArgv0)
{
  return 0;
}


/* ResetDCA ordinal = 448, argument = 8 temporary */
static DWORD WINAPI ResetDCA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ResetDCW ordinal = 449, argument = 8 temporary */
static DWORD WINAPI ResetDCW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ResizePalette ordinal = 450, argument = 8 temporary */
static DWORD WINAPI ResizePalette (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RestoreDC ordinal = 451, argument = 8 temporary */
static DWORD WINAPI RestoreDC (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* RoundRect ordinal = 452, argument = 28 temporary */
static DWORD WINAPI RoundRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* STROBJ_bEnum ordinal = 453, argument = 0 temporary */
static DWORD WINAPI STROBJ_bEnum (VOID)
{
  return 0;
}


/* STROBJ_bEnumPositionsOnly ordinal = 454, argument = 0 temporary */
static DWORD WINAPI STROBJ_bEnumPositionsOnly (VOID)
{
  return 0;
}


/* STROBJ_bGetAdvanceWidths ordinal = 455, argument = 0 temporary */
static DWORD WINAPI STROBJ_bGetAdvanceWidths (VOID)
{
  return 0;
}


/* STROBJ_dwGetCodePage ordinal = 456, argument = 0 temporary */
static DWORD WINAPI STROBJ_dwGetCodePage (VOID)
{
  return 0;
}


/* STROBJ_vEnumStart ordinal = 457, argument = 0 temporary */
static DWORD WINAPI STROBJ_vEnumStart (VOID)
{
  return 0;
}


/* SaveDC ordinal = 458, argument = 4 temporary */
static DWORD WINAPI SaveDC (DWORD dwArgv0)
{
  return 0;
}


/* ScaleViewportExtEx ordinal = 459, argument = 24 temporary */
static DWORD WINAPI ScaleViewportExtEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* ScaleWindowExtEx ordinal = 460, argument = 24 temporary */
static DWORD WINAPI ScaleWindowExtEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* SelectBrushLocal ordinal = 461, argument = 8 temporary */
static DWORD WINAPI SelectBrushLocal (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SelectClipPath ordinal = 462, argument = 8 temporary */
static DWORD WINAPI SelectClipPath (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SelectClipRgn ordinal = 463, argument = 8 temporary */
static DWORD WINAPI SelectClipRgn (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SelectFontLocal ordinal = 464, argument = 8 temporary */
static DWORD WINAPI SelectFontLocal (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SelectObject ordinal = 465, argument = 8 */
HGDIOBJ WINAPI SelectObject (HDC hDC, HGDIOBJ hObject)
{
  HGDIOBJ hObjectOld = NULL;

  if (GDK_IS_PIXBUF (hObject))
    {
      hObjectOld = hDC->pixbuf;
      hDC->pixbuf = hObject;
    }
  else if (W32LDR_IS_BRUSH (hObject))
    {
      hObjectOld = hDC->brush;
      hDC->brush = hObject;
    }
  else if (W32LDR_IS_PEN (hObject))
    {
      hObjectOld = hDC->pen;
      hDC->pen = hObject;
    }
  else if (W32LDR_IS_FONT (hObject))
    {
      hObjectOld = hDC->font;
      hDC->font = hObject;
    }
  return hObjectOld;
}


/* SelectPalette ordinal = 466, argument = 12 temporary */
static DWORD WINAPI SelectPalette (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetAbortProc ordinal = 467, argument = 8 temporary */
static DWORD WINAPI SetAbortProc (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetArcDirection ordinal = 468, argument = 8 temporary */
static DWORD WINAPI SetArcDirection (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetBitmapBits ordinal = 469, argument = 12 temporary */
static DWORD WINAPI SetBitmapBits (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetBitmapDimensionEx ordinal = 470, argument = 16 temporary */
static DWORD WINAPI SetBitmapDimensionEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetBkColor ordinal = 471, argument = 8 */
COLORREF WINAPI SetBkColor (HDC hDC, COLORREF crColor)
{
  COLORREF bgColor;

  bgColor = RGB (hDC->bgcolor.red / 256,
                 hDC->bgcolor.green / 256,
                 hDC->bgcolor.blue / 256);
  hDC->bgcolor.red = GetRValue (hDC->bgcolor.red) * 256;
  hDC->bgcolor.green = GetGValue (hDC->bgcolor.green) * 256;
  hDC->bgcolor.blue = GetBValue (hDC->bgcolor.blue) * 256;
  return bgColor;
}


/* SetBkMode ordinal = 472, argument = 8 */
INT WINAPI SetBkMode (HDC hDC, INT iBkMode)
{
  gboolean transparent;

  transparent = hDC->transparent;
  hDC->transparent = iBkMode == TRANSPARENT;
  return transparent ? TRANSPARENT : OPAQUE;
}


/* SetBoundsRect ordinal = 473, argument = 12 temporary */
static DWORD WINAPI SetBoundsRect (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetBrushOrgEx ordinal = 474, argument = 16 temporary */
static DWORD WINAPI SetBrushOrgEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetColorAdjustment ordinal = 475, argument = 8 temporary */
static DWORD WINAPI SetColorAdjustment (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetColorSpace ordinal = 476, argument = 8 temporary */
static DWORD WINAPI SetColorSpace (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetDCBrushColor ordinal = 477, argument = 8 temporary */
static DWORD WINAPI SetDCBrushColor (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetDCPenColor ordinal = 478, argument = 8 temporary */
static DWORD WINAPI SetDCPenColor (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetDIBColorTable ordinal = 479, argument = 16 temporary */
static DWORD WINAPI SetDIBColorTable (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetDIBits ordinal = 480, argument = 28 temporary */
static DWORD WINAPI SetDIBits (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


/* SetDIBitsToDevice ordinal = 481, argument = 48 temporary */
static DWORD WINAPI SetDIBitsToDevice (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11)
{
  return 0;
}


/* SetDeviceGammaRamp ordinal = 482, argument = 8 temporary */
static DWORD WINAPI SetDeviceGammaRamp (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetEnhMetaFileBits ordinal = 483, argument = 8 temporary */
static DWORD WINAPI SetEnhMetaFileBits (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetFontEnumeration ordinal = 484, argument = 4 temporary */
static DWORD WINAPI SetFontEnumeration (DWORD dwArgv0)
{
  return 0;
}


/* SetGraphicsMode ordinal = 485, argument = 8 temporary */
static DWORD WINAPI SetGraphicsMode (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetICMMode ordinal = 486, argument = 8 temporary */
static DWORD WINAPI SetICMMode (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetICMProfileA ordinal = 487, argument = 8 temporary */
static DWORD WINAPI SetICMProfileA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetICMProfileW ordinal = 488, argument = 8 temporary */
static DWORD WINAPI SetICMProfileW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetLayout ordinal = 489, argument = 8 temporary */
static DWORD WINAPI SetLayout (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetLayoutWidth ordinal = 490, argument = 0 temporary */
static DWORD WINAPI SetLayoutWidth (VOID)
{
  return 0;
}


/* SetMagicColors ordinal = 491, argument = 12 temporary */
static DWORD WINAPI SetMagicColors (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetMapMode ordinal = 492, argument = 8 temporary */
static DWORD WINAPI SetMapMode (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetMapperFlags ordinal = 493, argument = 8 temporary */
static DWORD WINAPI SetMapperFlags (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetMetaFileBitsEx ordinal = 494, argument = 8 temporary */
static DWORD WINAPI SetMetaFileBitsEx (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetMetaRgn ordinal = 495, argument = 4 temporary */
static DWORD WINAPI SetMetaRgn (DWORD dwArgv0)
{
  return 0;
}


/* SetMiterLimit ordinal = 496, argument = 12 temporary */
static DWORD WINAPI SetMiterLimit (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetPaletteEntries ordinal = 497, argument = 16 temporary */
static DWORD WINAPI SetPaletteEntries (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetPixel ordinal = 498, argument = 16 temporary */
static DWORD WINAPI SetPixel (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetPixelFormat ordinal = 499, argument = 12 temporary */
static DWORD WINAPI SetPixelFormat (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetPixelV ordinal = 500, argument = 16 temporary */
static DWORD WINAPI SetPixelV (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetPolyFillMode ordinal = 501, argument = 8 temporary */
static DWORD WINAPI SetPolyFillMode (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetROP2 ordinal = 502, argument = 8 temporary */
static DWORD WINAPI SetROP2 (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetRectRgn ordinal = 503, argument = 20 temporary */
static DWORD WINAPI SetRectRgn (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* SetRelAbs ordinal = 504, argument = 8 temporary */
static DWORD WINAPI SetRelAbs (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetStretchBltMode ordinal = 505, argument = 8 temporary */
static DWORD WINAPI SetStretchBltMode (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetSystemPaletteUse ordinal = 506, argument = 8 temporary */
static DWORD WINAPI SetSystemPaletteUse (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetTextAlign ordinal = 507, argument = 8 temporary */
static DWORD WINAPI SetTextAlign (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetTextCharacterExtra ordinal = 508, argument = 8 temporary */
static DWORD WINAPI SetTextCharacterExtra (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SetTextColor ordinal = 509, argument = 8 */
COLORREF WINAPI SetTextColor (HDC hDC, COLORREF crColor)
{
  COLORREF fgColor;

  fgColor = RGB (hDC->fgcolor.red / 256,
                 hDC->fgcolor.green / 256,
                 hDC->fgcolor.blue / 256);
  hDC->fgcolor.red = GetRValue (hDC->fgcolor.red) * 256;
  hDC->fgcolor.green = GetGValue (hDC->fgcolor.green) * 256;
  hDC->fgcolor.blue = GetBValue (hDC->fgcolor.blue) * 256;
  return fgColor;
}


/* SetTextJustification ordinal = 510, argument = 12 temporary */
static DWORD WINAPI SetTextJustification (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SetViewportExtEx ordinal = 511, argument = 16 temporary */
static DWORD WINAPI SetViewportExtEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetViewportOrgEx ordinal = 512, argument = 16 temporary */
static DWORD WINAPI SetViewportOrgEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetVirtualResolution ordinal = 513, argument = 0 temporary */
static DWORD WINAPI SetVirtualResolution (VOID)
{
  return 0;
}


/* SetWinMetaFileBits ordinal = 514, argument = 16 temporary */
static DWORD WINAPI SetWinMetaFileBits (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetWindowExtEx ordinal = 515, argument = 16 temporary */
static DWORD WINAPI SetWindowExtEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetWindowOrgEx ordinal = 516, argument = 16 temporary */
static DWORD WINAPI SetWindowOrgEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SetWorldTransform ordinal = 517, argument = 8 temporary */
static DWORD WINAPI SetWorldTransform (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* StartDocA ordinal = 518, argument = 8 temporary */
static DWORD WINAPI StartDocA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* StartDocW ordinal = 519, argument = 8 temporary */
static DWORD WINAPI StartDocW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* StartFormPage ordinal = 520, argument = 4 temporary */
static DWORD WINAPI StartFormPage (DWORD dwArgv0)
{
  return 0;
}


/* StartPage ordinal = 521, argument = 4 temporary */
static DWORD WINAPI StartPage (DWORD dwArgv0)
{
  return 0;
}


/* StretchBlt ordinal = 522, argument = 44 temporary */
static DWORD WINAPI StretchBlt (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10)
{
  return 0;
}


/* StretchDIBits ordinal = 523, argument = 52 temporary */
static DWORD WINAPI StretchDIBits (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10, DWORD dwArgv11, DWORD dwArgv12)
{
  return 0;
}


/* StrokeAndFillPath ordinal = 524, argument = 4 temporary */
static DWORD WINAPI StrokeAndFillPath (DWORD dwArgv0)
{
  return 0;
}


/* StrokePath ordinal = 525, argument = 4 temporary */
static DWORD WINAPI StrokePath (DWORD dwArgv0)
{
  return 0;
}


/* SwapBuffers ordinal = 526, argument = 4 temporary */
static DWORD WINAPI SwapBuffers (DWORD dwArgv0)
{
  return 0;
}


/* TextOutA ordinal = 527, argument = 20 */
BOOL WINAPI TextOutA (HDC hDC, INT nXStart, INT nYStart, LPCSTR lpString, INT cbString)
{
  gchar *utf8str;
  gunichar2 *string;
  BOOL fResult;

  utf8str = w32ldr_utf8_from_mb (lpString);
  string = utf8str ? g_utf8_to_utf16 (utf8str, -1, NULL, NULL, NULL) : NULL;
  g_free (utf8str);
  fResult = TextOutW (hDC, nXStart, nYStart, string, lstrlenW (string));
  g_free (string);
  return fResult;
}


/* TextOutW ordinal = 528, argument = 20 */
BOOL WINAPI TextOutW (HDC hDC, INT nXStart, INT nYStart, LPCWSTR lpString, INT cbString)
{
  gchar *utf8str;
  GdkGC *gc;
  PangoLayout *layout;
  const PangoFontDescription *desc;

  if (!hDC || !hDC->widget || !hDC->widget->window
                                                || !lpString || cbString <= 0)
    return FALSE;
  utf8str = g_utf16_to_utf8 (lpString, cbString, NULL, NULL, NULL);
  layout = gtk_widget_create_pango_layout (hDC->widget, utf8str);
  g_free (utf8str);
  desc = w32ldr_font_get_description (hDC->font);
  if (desc)
    pango_layout_set_font_description (layout, desc);
  gc = gdk_gc_new (hDC->widget->window);
  gdk_draw_layout_with_colors (hDC->widget->window, gc, nXStart, nYStart,
                                        layout, &hDC->fgcolor, &hDC->bgcolor);
  g_object_unref (G_OBJECT (gc));
  g_object_unref (G_OBJECT (layout));
  return TRUE;
}


/* TranslateCharsetInfo ordinal = 529, argument = 12 temporary */
static DWORD WINAPI TranslateCharsetInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* UnloadNetworkFonts ordinal = 530, argument = 0 temporary */
static DWORD WINAPI UnloadNetworkFonts (VOID)
{
  return 0;
}


/* UnrealizeObject ordinal = 531, argument = 4 temporary */
static DWORD WINAPI UnrealizeObject (DWORD dwArgv0)
{
  return 0;
}


/* UpdateColors ordinal = 532, argument = 4 temporary */
static DWORD WINAPI UpdateColors (DWORD dwArgv0)
{
  return 0;
}


/* UpdateICMRegKeyA ordinal = 533, argument = 16 temporary */
static DWORD WINAPI UpdateICMRegKeyA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* UpdateICMRegKeyW ordinal = 534, argument = 16 temporary */
static DWORD WINAPI UpdateICMRegKeyW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* WidenPath ordinal = 535, argument = 4 temporary */
static DWORD WINAPI WidenPath (DWORD dwArgv0)
{
  return 0;
}


/* XFORMOBJ_bApplyXform ordinal = 536, argument = 0 temporary */
static DWORD WINAPI XFORMOBJ_bApplyXform (VOID)
{
  return 0;
}


/* XFORMOBJ_iGetXform ordinal = 537, argument = 0 temporary */
static DWORD WINAPI XFORMOBJ_iGetXform (VOID)
{
  return 0;
}


/* XLATEOBJ_cGetPalette ordinal = 538, argument = 0 temporary */
static DWORD WINAPI XLATEOBJ_cGetPalette (VOID)
{
  return 0;
}


/* XLATEOBJ_hGetColorTransform ordinal = 539, argument = 0 temporary */
static DWORD WINAPI XLATEOBJ_hGetColorTransform (VOID)
{
  return 0;
}


/* XLATEOBJ_iXlate ordinal = 540, argument = 0 temporary */
static DWORD WINAPI XLATEOBJ_iXlate (VOID)
{
  return 0;
}


/* XLATEOBJ_piVector ordinal = 541, argument = 0 temporary */
static DWORD WINAPI XLATEOBJ_piVector (VOID)
{
  return 0;
}


/* bInitSystemAndFontsDirectoriesW ordinal = 542, argument = 0 temporary */
static DWORD WINAPI bInitSystemAndFontsDirectoriesW (VOID)
{
  return 0;
}


/* bMakePathNameW ordinal = 543, argument = 0 temporary */
static DWORD WINAPI bMakePathNameW (VOID)
{
  return 0;
}


/* cGetTTFFromFOT ordinal = 544, argument = 0 temporary */
static DWORD WINAPI cGetTTFFromFOT (VOID)
{
  return 0;
}


/* gdiPlaySpoolStream ordinal = 545, argument = 24 temporary */
static DWORD WINAPI gdiPlaySpoolStream (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


W32LdrExport gdi32_exports[] = {
{FALSE,   1, "AbortDoc",                        AbortDoc},
{FALSE,   2, "AbortPath",                       AbortPath},
{FALSE,   3, "AddFontMemResourceEx",            AddFontMemResourceEx},
{FALSE,   4, "AddFontResourceA",                AddFontResourceA},
{FALSE,   5, "AddFontResourceExA",              AddFontResourceExA},
{FALSE,   6, "AddFontResourceExW",              AddFontResourceExW},
{FALSE,   7, "AddFontResourceTracking",         AddFontResourceTracking},
{FALSE,   8, "AddFontResourceW",                AddFontResourceW},
{FALSE,   9, "AngleArc",                        AngleArc},
{FALSE,  10, "AnimatePalette",                  AnimatePalette},
{FALSE,  11, "AnyLinkedFonts",                  AnyLinkedFonts},
{FALSE,  12, "Arc",                             Arc},
{FALSE,  13, "ArcTo",                           ArcTo},
{FALSE,  14, "BRUSHOBJ_hGetColorTransform",     BRUSHOBJ_hGetColorTransform},
{FALSE,  15, "BRUSHOBJ_pvAllocRbrush",          BRUSHOBJ_pvAllocRbrush},
{FALSE,  16, "BRUSHOBJ_pvGetRbrush",            BRUSHOBJ_pvGetRbrush},
{FALSE,  17, "BRUSHOBJ_ulGetBrushColor",        BRUSHOBJ_ulGetBrushColor},
{FALSE,  18, "BeginPath",                       BeginPath},
{TRUE,   19, "BitBlt",                          BitBlt},
{FALSE,  20, "CLIPOBJ_bEnum",                   CLIPOBJ_bEnum},
{FALSE,  21, "CLIPOBJ_cEnumStart",              CLIPOBJ_cEnumStart},
{FALSE,  22, "CLIPOBJ_ppoGetPath",              CLIPOBJ_ppoGetPath},
{FALSE,  23, "CancelDC",                        CancelDC},
{FALSE,  24, "CheckColorsInGamut",              CheckColorsInGamut},
{FALSE,  25, "ChoosePixelFormat",               ChoosePixelFormat},
{FALSE,  26, "Chord",                           Chord},
{FALSE,  27, "CloseEnhMetaFile",                CloseEnhMetaFile},
{FALSE,  28, "CloseFigure",                     CloseFigure},
{FALSE,  29, "CloseMetaFile",                   CloseMetaFile},
{FALSE,  30, "ColorCorrectPalette",             ColorCorrectPalette},
{FALSE,  31, "ColorMatchToTarget",              ColorMatchToTarget},
{FALSE,  32, "CombineRgn",                      CombineRgn},
{FALSE,  33, "CombineTransform",                CombineTransform},
{FALSE,  34, "CopyEnhMetaFileA",                CopyEnhMetaFileA},
{FALSE,  35, "CopyEnhMetaFileW",                CopyEnhMetaFileW},
{FALSE,  36, "CopyMetaFileA",                   CopyMetaFileA},
{FALSE,  37, "CopyMetaFileW",                   CopyMetaFileW},
{FALSE,  38, "CreateBitmap",                    CreateBitmap},
{FALSE,  39, "CreateBitmapIndirect",            CreateBitmapIndirect},
{FALSE,  40, "CreateBrushIndirect",             CreateBrushIndirect},
{FALSE,  41, "CreateColorSpaceA",               CreateColorSpaceA},
{FALSE,  42, "CreateColorSpaceW",               CreateColorSpaceW},
{FALSE,  43, "CreateCompatibleBitmap",          CreateCompatibleBitmap},
{TRUE,   44, "CreateCompatibleDC",              CreateCompatibleDC},
{FALSE,  45, "CreateDCA",                       CreateDCA},
{FALSE,  46, "CreateDCW",                       CreateDCW},
{FALSE,  47, "CreateDIBPatternBrush",           CreateDIBPatternBrush},
{FALSE,  48, "CreateDIBPatternBrushPt",         CreateDIBPatternBrushPt},
{FALSE,  49, "CreateDIBSection",                CreateDIBSection},
{FALSE,  50, "CreateDIBitmap",                  CreateDIBitmap},
{FALSE,  51, "CreateDiscardableBitmap",         CreateDiscardableBitmap},
{FALSE,  52, "CreateEllipticRgn",               CreateEllipticRgn},
{FALSE,  53, "CreateEllipticRgnIndirect",       CreateEllipticRgnIndirect},
{FALSE,  54, "CreateEnhMetaFileA",              CreateEnhMetaFileA},
{FALSE,  55, "CreateEnhMetaFileW",              CreateEnhMetaFileW},
{TRUE,   56, "CreateFontA",                     CreateFontA},
{TRUE,   57, "CreateFontIndirectA",             CreateFontIndirectA},
{FALSE,  58, "CreateFontIndirectExA",           CreateFontIndirectExA},
{FALSE,  59, "CreateFontIndirectExW",           CreateFontIndirectExW},
{TRUE,   60, "CreateFontIndirectW",             CreateFontIndirectW},
{TRUE,   61, "CreateFontW",                     CreateFontW},
{FALSE,  62, "CreateHalftonePalette",           CreateHalftonePalette},
{FALSE,  63, "CreateHatchBrush",                CreateHatchBrush},
{FALSE,  64, "CreateICA",                       CreateICA},
{FALSE,  65, "CreateICW",                       CreateICW},
{FALSE,  66, "CreateMetaFileA",                 CreateMetaFileA},
{FALSE,  67, "CreateMetaFileW",                 CreateMetaFileW},
{FALSE,  68, "CreatePalette",                   CreatePalette},
{FALSE,  69, "CreatePatternBrush",              CreatePatternBrush},
{FALSE,  70, "CreatePen",                       CreatePen},
{FALSE,  71, "CreatePenIndirect",               CreatePenIndirect},
{FALSE,  72, "CreatePolyPolygonRgn",            CreatePolyPolygonRgn},
{FALSE,  73, "CreatePolygonRgn",                CreatePolygonRgn},
{FALSE,  74, "CreateRectRgn",                   CreateRectRgn},
{FALSE,  75, "CreateRectRgnIndirect",           CreateRectRgnIndirect},
{FALSE,  76, "CreateRoundRectRgn",              CreateRoundRectRgn},
{FALSE,  77, "CreateScalableFontResourceA",     CreateScalableFontResourceA},
{FALSE,  78, "CreateScalableFontResourceW",     CreateScalableFontResourceW},
{TRUE,   79, "CreateSolidBrush",                CreateSolidBrush},
{FALSE,  80, "DPtoLP",                          DPtoLP},
{FALSE,  81, "DeleteColorSpace",                DeleteColorSpace},
{TRUE,   82, "DeleteDC",                        DeleteDC},
{FALSE,  83, "DeleteEnhMetaFile",               DeleteEnhMetaFile},
{FALSE,  84, "DeleteMetaFile",                  DeleteMetaFile},
{TRUE,   85, "DeleteObject",                    DeleteObject},
{FALSE,  86, "DescribePixelFormat",             DescribePixelFormat},
{FALSE,  87, "DeviceCapabilitiesExA",           DeviceCapabilitiesExA},
{FALSE,  88, "DeviceCapabilitiesExW",           DeviceCapabilitiesExW},
{FALSE,  89, "DrawEscape",                      DrawEscape},
{FALSE,  90, "Ellipse",                         Ellipse},
{FALSE,  91, "EnableEUDC",                      EnableEUDC},
{FALSE,  92, "EndDoc",                          EndDoc},
{FALSE,  93, "EndFormPage",                     EndFormPage},
{FALSE,  94, "EndPage",                         EndPage},
{FALSE,  95, "EndPath",                         EndPath},
{FALSE,  96, "EngAcquireSemaphore",             EngAcquireSemaphore},
{FALSE,  97, "EngAlphaBlend",                   EngAlphaBlend},
{FALSE,  98, "EngAssociateSurface",             EngAssociateSurface},
{FALSE,  99, "EngBitBlt",                       EngBitBlt},
{FALSE, 100, "EngCheckAbort",                   EngCheckAbort},
{FALSE, 101, "EngComputeGlyphSet",              EngComputeGlyphSet},
{FALSE, 102, "EngCopyBits",                     EngCopyBits},
{FALSE, 103, "EngCreateBitmap",                 EngCreateBitmap},
{FALSE, 104, "EngCreateClip",                   EngCreateClip},
{FALSE, 105, "EngCreateDeviceBitmap",           EngCreateDeviceBitmap},
{FALSE, 106, "EngCreateDeviceSurface",          EngCreateDeviceSurface},
{FALSE, 107, "EngCreatePalette",                EngCreatePalette},
{FALSE, 108, "EngCreateSemaphore",              EngCreateSemaphore},
{FALSE, 109, "EngDeleteClip",                   EngDeleteClip},
{FALSE, 110, "EngDeletePalette",                EngDeletePalette},
{FALSE, 111, "EngDeletePath",                   EngDeletePath},
{FALSE, 112, "EngDeleteSemaphore",              EngDeleteSemaphore},
{FALSE, 113, "EngDeleteSurface",                EngDeleteSurface},
{FALSE, 114, "EngEraseSurface",                 EngEraseSurface},
{FALSE, 115, "EngFillPath",                     EngFillPath},
{FALSE, 116, "EngFindResource",                 EngFindResource},
{FALSE, 117, "EngFreeModule",                   EngFreeModule},
{FALSE, 118, "EngGetCurrentCodePage",           EngGetCurrentCodePage},
{FALSE, 119, "EngGetDriverName",                EngGetDriverName},
{FALSE, 120, "EngGetPrinterDataFileName",       EngGetPrinterDataFileName},
{FALSE, 121, "EngGradientFill",                 EngGradientFill},
{FALSE, 122, "EngLineTo",                       EngLineTo},
{FALSE, 123, "EngLoadModule",                   EngLoadModule},
{FALSE, 124, "EngLockSurface",                  EngLockSurface},
{FALSE, 125, "EngMarkBandingSurface",           EngMarkBandingSurface},
{FALSE, 126, "EngMultiByteToUnicodeN",          EngMultiByteToUnicodeN},
{FALSE, 127, "EngMultiByteToWideChar",          EngMultiByteToWideChar},
{FALSE, 128, "EngPaint",                        EngPaint},
{FALSE, 129, "EngPlgBlt",                       EngPlgBlt},
{FALSE, 130, "EngQueryEMFInfo",                 EngQueryEMFInfo},
{FALSE, 131, "EngQueryLocalTime",               EngQueryLocalTime},
{FALSE, 132, "EngReleaseSemaphore",             EngReleaseSemaphore},
{FALSE, 133, "EngStretchBlt",                   EngStretchBlt},
{FALSE, 134, "EngStretchBltROP",                EngStretchBltROP},
{FALSE, 135, "EngStrokeAndFillPath",            EngStrokeAndFillPath},
{FALSE, 136, "EngStrokePath",                   EngStrokePath},
{FALSE, 137, "EngTextOut",                      EngTextOut},
{FALSE, 138, "EngTransparentBlt",               EngTransparentBlt},
{FALSE, 139, "EngUnicodeToMultiByteN",          EngUnicodeToMultiByteN},
{FALSE, 140, "EngUnlockSurface",                EngUnlockSurface},
{FALSE, 141, "EngWideCharToMultiByte",          EngWideCharToMultiByte},
{FALSE, 142, "EnumEnhMetaFile",                 EnumEnhMetaFile},
{FALSE, 143, "EnumFontFamiliesA",               EnumFontFamiliesA},
{FALSE, 144, "EnumFontFamiliesExA",             EnumFontFamiliesExA},
{FALSE, 145, "EnumFontFamiliesExW",             EnumFontFamiliesExW},
{FALSE, 146, "EnumFontFamiliesW",               EnumFontFamiliesW},
{FALSE, 147, "EnumFontsA",                      EnumFontsA},
{FALSE, 148, "EnumFontsW",                      EnumFontsW},
{FALSE, 149, "EnumICMProfilesA",                EnumICMProfilesA},
{FALSE, 150, "EnumICMProfilesW",                EnumICMProfilesW},
{FALSE, 151, "EnumMetaFile",                    EnumMetaFile},
{FALSE, 152, "EnumObjects",                     EnumObjects},
{FALSE, 153, "EqualRgn",                        EqualRgn},
{FALSE, 154, "Escape",                          Escape},
{FALSE, 155, "EudcLoadLinkW",                   EudcLoadLinkW},
{FALSE, 156, "EudcUnloadLinkW",                 EudcUnloadLinkW},
{FALSE, 157, "ExcludeClipRect",                 ExcludeClipRect},
{FALSE, 158, "ExtCreatePen",                    ExtCreatePen},
{FALSE, 159, "ExtCreateRegion",                 ExtCreateRegion},
{FALSE, 160, "ExtEscape",                       ExtEscape},
{FALSE, 161, "ExtFloodFill",                    ExtFloodFill},
{FALSE, 162, "ExtSelectClipRgn",                ExtSelectClipRgn},
{FALSE, 163, "ExtTextOutA",                     ExtTextOutA},
{FALSE, 164, "ExtTextOutW",                     ExtTextOutW},
{FALSE, 165, "FONTOBJ_cGetAllGlyphHandles",     FONTOBJ_cGetAllGlyphHandles},
{FALSE, 166, "FONTOBJ_cGetGlyphs",              FONTOBJ_cGetGlyphs},
{FALSE, 167, "FONTOBJ_pQueryGlyphAttrs",        FONTOBJ_pQueryGlyphAttrs},
{FALSE, 168, "FONTOBJ_pfdg",                    FONTOBJ_pfdg},
{FALSE, 169, "FONTOBJ_pifi",                    FONTOBJ_pifi},
{FALSE, 170, "FONTOBJ_pvTrueTypeFontFile",      FONTOBJ_pvTrueTypeFontFile},
{FALSE, 171, "FONTOBJ_pxoGetXform",             FONTOBJ_pxoGetXform},
{FALSE, 172, "FONTOBJ_vGetInfo",                FONTOBJ_vGetInfo},
{FALSE, 173, "FillPath",                        FillPath},
{FALSE, 174, "FillRgn",                         FillRgn},
{FALSE, 175, "FixBrushOrgEx",                   FixBrushOrgEx},
{FALSE, 176, "FlattenPath",                     FlattenPath},
{FALSE, 177, "FloodFill",                       FloodFill},
{FALSE, 178, "FontIsLinked",                    FontIsLinked},
{FALSE, 179, "FrameRgn",                        FrameRgn},
{FALSE, 180, "GdiAddFontResourceW",             GdiAddFontResourceW},
{FALSE, 181, "GdiAddGlsBounds",                 GdiAddGlsBounds},
{FALSE, 182, "GdiAddGlsRecord",                 GdiAddGlsRecord},
{FALSE, 183, "GdiAlphaBlend",                   GdiAlphaBlend},
{FALSE, 184, "GdiArtificialDecrementDriver",    GdiArtificialDecrementDriver},
{FALSE, 185, "GdiCleanCacheDC",                 GdiCleanCacheDC},
{FALSE, 186, "GdiComment",                      GdiComment},
{FALSE, 187, "GdiConsoleTextOut",               GdiConsoleTextOut},
{FALSE, 188, "GdiConvertAndCheckDC",            GdiConvertAndCheckDC},
{FALSE, 189, "GdiConvertBitmap",                GdiConvertBitmap},
{FALSE, 190, "GdiConvertBitmapV5",              GdiConvertBitmapV5},
{FALSE, 191, "GdiConvertBrush",                 GdiConvertBrush},
{FALSE, 192, "GdiConvertDC",                    GdiConvertDC},
{FALSE, 193, "GdiConvertEnhMetaFile",           GdiConvertEnhMetaFile},
{FALSE, 194, "GdiConvertFont",                  GdiConvertFont},
{FALSE, 195, "GdiConvertMetaFilePict",          GdiConvertMetaFilePict},
{FALSE, 196, "GdiConvertPalette",               GdiConvertPalette},
{FALSE, 197, "GdiConvertRegion",                GdiConvertRegion},
{FALSE, 198, "GdiConvertToDevmodeW",            GdiConvertToDevmodeW},
{FALSE, 199, "GdiCreateLocalEnhMetaFile",       GdiCreateLocalEnhMetaFile},
{FALSE, 200, "GdiCreateLocalMetaFilePict",      GdiCreateLocalMetaFilePict},
{FALSE, 201, "GdiDeleteLocalDC",                GdiDeleteLocalDC},
{FALSE, 202, "GdiDeleteSpoolFileHandle",        GdiDeleteSpoolFileHandle},
{FALSE, 203, "GdiDescribePixelFormat",          GdiDescribePixelFormat},
{FALSE, 204, "GdiDllInitialize",                GdiDllInitialize},
{FALSE, 205, "GdiEndDocEMF",                    GdiEndDocEMF},
{FALSE, 206, "GdiEndPageEMF",                   GdiEndPageEMF},
{FALSE, 214, "GdiEntry1",                       GdiEntry1},
{FALSE, 207, "GdiEntry10",                      GdiEntry10},
{FALSE, 208, "GdiEntry11",                      GdiEntry11},
{FALSE, 209, "GdiEntry12",                      GdiEntry12},
{FALSE, 210, "GdiEntry13",                      GdiEntry13},
{FALSE, 211, "GdiEntry14",                      GdiEntry14},
{FALSE, 212, "GdiEntry15",                      GdiEntry15},
{FALSE, 213, "GdiEntry16",                      GdiEntry16},
{FALSE, 215, "GdiEntry2",                       GdiEntry2},
{FALSE, 216, "GdiEntry3",                       GdiEntry3},
{FALSE, 217, "GdiEntry4",                       GdiEntry4},
{FALSE, 218, "GdiEntry5",                       GdiEntry5},
{FALSE, 219, "GdiEntry6",                       GdiEntry6},
{FALSE, 220, "GdiEntry7",                       GdiEntry7},
{FALSE, 221, "GdiEntry8",                       GdiEntry8},
{FALSE, 222, "GdiEntry9",                       GdiEntry9},
{FALSE, 223, "GdiFixUpHandle",                  GdiFixUpHandle},
{FALSE, 224, "GdiFlush",                        GdiFlush},
{FALSE, 225, "GdiFullscreenControl",            GdiFullscreenControl},
{FALSE, 226, "GdiGetBatchLimit",                GdiGetBatchLimit},
{FALSE, 227, "GdiGetCharDimensions",            GdiGetCharDimensions},
{FALSE, 228, "GdiGetCodePage",                  GdiGetCodePage},
{FALSE, 229, "GdiGetDC",                        GdiGetDC},
{FALSE, 230, "GdiGetDevmodeForPage",            GdiGetDevmodeForPage},
{FALSE, 231, "GdiGetLocalBrush",                GdiGetLocalBrush},
{FALSE, 232, "GdiGetLocalDC",                   GdiGetLocalDC},
{FALSE, 233, "GdiGetLocalFont",                 GdiGetLocalFont},
{FALSE, 234, "GdiGetPageCount",                 GdiGetPageCount},
{FALSE, 235, "GdiGetPageHandle",                GdiGetPageHandle},
{FALSE, 236, "GdiGetSpoolFileHandle",           GdiGetSpoolFileHandle},
{FALSE, 237, "GdiGetSpoolMessage",              GdiGetSpoolMessage},
{FALSE, 238, "GdiGradientFill",                 GdiGradientFill},
{FALSE, 239, "GdiInitSpool",                    GdiInitSpool},
{FALSE, 240, "GdiInitializeLanguagePack",       GdiInitializeLanguagePack},
{FALSE, 241, "GdiIsMetaFileDC",                 GdiIsMetaFileDC},
{FALSE, 242, "GdiIsMetaPrintDC",                GdiIsMetaPrintDC},
{FALSE, 243, "GdiIsPlayMetafileDC",             GdiIsPlayMetafileDC},
{FALSE, 244, "GdiPlayDCScript",                 GdiPlayDCScript},
{FALSE, 245, "GdiPlayEMF",                      GdiPlayEMF},
{FALSE, 246, "GdiPlayJournal",                  GdiPlayJournal},
{FALSE, 247, "GdiPlayPageEMF",                  GdiPlayPageEMF},
{FALSE, 248, "GdiPlayPrivatePageEMF",           GdiPlayPrivatePageEMF},
{FALSE, 249, "GdiPlayScript",                   GdiPlayScript},
{FALSE, 250, "GdiPrinterThunk",                 GdiPrinterThunk},
{FALSE, 251, "GdiProcessSetup",                 GdiProcessSetup},
{FALSE, 252, "GdiQueryFonts",                   GdiQueryFonts},
{FALSE, 253, "GdiQueryTable",                   GdiQueryTable},
{FALSE, 254, "GdiRealizationInfo",              GdiRealizationInfo},
{FALSE, 255, "GdiReleaseDC",                    GdiReleaseDC},
{FALSE, 256, "GdiReleaseLocalDC",               GdiReleaseLocalDC},
{FALSE, 257, "GdiResetDCEMF",                   GdiResetDCEMF},
{FALSE, 258, "GdiSetAttrs",                     GdiSetAttrs},
{FALSE, 259, "GdiSetBatchLimit",                GdiSetBatchLimit},
{FALSE, 260, "GdiSetLastError",                 GdiSetLastError},
{FALSE, 261, "GdiSetPixelFormat",               GdiSetPixelFormat},
{FALSE, 262, "GdiSetServerAttr",                GdiSetServerAttr},
{FALSE, 263, "GdiStartDocEMF",                  GdiStartDocEMF},
{FALSE, 264, "GdiStartPageEMF",                 GdiStartPageEMF},
{FALSE, 265, "GdiSwapBuffers",                  GdiSwapBuffers},
{FALSE, 266, "GdiTransparentBlt",               GdiTransparentBlt},
{FALSE, 267, "GdiValidateHandle",               GdiValidateHandle},
{FALSE, 268, "GetArcDirection",                 GetArcDirection},
{FALSE, 269, "GetAspectRatioFilterEx",          GetAspectRatioFilterEx},
{FALSE, 270, "GetBitmapBits",                   GetBitmapBits},
{FALSE, 271, "GetBitmapDimensionEx",            GetBitmapDimensionEx},
{TRUE,  272, "GetBkColor",                      GetBkColor},
{TRUE,  273, "GetBkMode",                       GetBkMode},
{FALSE, 274, "GetBoundsRect",                   GetBoundsRect},
{FALSE, 275, "GetBrushOrgEx",                   GetBrushOrgEx},
{FALSE, 276, "GetCharABCWidthsA",               GetCharABCWidthsA},
{FALSE, 277, "GetCharABCWidthsFloatA",          GetCharABCWidthsFloatA},
{FALSE, 278, "GetCharABCWidthsFloatW",          GetCharABCWidthsFloatW},
{FALSE, 279, "GetCharABCWidthsI",               GetCharABCWidthsI},
{FALSE, 280, "GetCharABCWidthsW",               GetCharABCWidthsW},
{FALSE, 281, "GetCharWidth32A",                 GetCharWidth32A},
{FALSE, 282, "GetCharWidth32W",                 GetCharWidth32W},
{FALSE, 283, "GetCharWidthA",                   GetCharWidthA},
{FALSE, 284, "GetCharWidthFloatA",              GetCharWidthFloatA},
{FALSE, 285, "GetCharWidthFloatW",              GetCharWidthFloatW},
{FALSE, 286, "GetCharWidthI",                   GetCharWidthI},
{FALSE, 287, "GetCharWidthInfo",                GetCharWidthInfo},
{FALSE, 288, "GetCharWidthW",                   GetCharWidthW},
{FALSE, 289, "GetCharacterPlacementA",          GetCharacterPlacementA},
{FALSE, 290, "GetCharacterPlacementW",          GetCharacterPlacementW},
{FALSE, 291, "GetClipBox",                      GetClipBox},
{FALSE, 292, "GetClipRgn",                      GetClipRgn},
{FALSE, 293, "GetColorAdjustment",              GetColorAdjustment},
{FALSE, 294, "GetColorSpace",                   GetColorSpace},
{FALSE, 295, "GetCurrentObject",                GetCurrentObject},
{FALSE, 296, "GetCurrentPositionEx",            GetCurrentPositionEx},
{FALSE, 297, "GetDCBrushColor",                 GetDCBrushColor},
{FALSE, 298, "GetDCOrgEx",                      GetDCOrgEx},
{FALSE, 299, "GetDCPenColor",                   GetDCPenColor},
{FALSE, 300, "GetDIBColorTable",                GetDIBColorTable},
{FALSE, 301, "GetDIBits",                       GetDIBits},
{TRUE,  302, "GetDeviceCaps",                   GetDeviceCaps},
{FALSE, 303, "GetDeviceGammaRamp",              GetDeviceGammaRamp},
{FALSE, 304, "GetETM",                          GetETM},
{FALSE, 305, "GetEUDCTimeStamp",                GetEUDCTimeStamp},
{FALSE, 306, "GetEUDCTimeStampExW",             GetEUDCTimeStampExW},
{FALSE, 307, "GetEnhMetaFileA",                 GetEnhMetaFileA},
{FALSE, 308, "GetEnhMetaFileBits",              GetEnhMetaFileBits},
{FALSE, 309, "GetEnhMetaFileDescriptionA",      GetEnhMetaFileDescriptionA},
{FALSE, 310, "GetEnhMetaFileDescriptionW",      GetEnhMetaFileDescriptionW},
{FALSE, 311, "GetEnhMetaFileHeader",            GetEnhMetaFileHeader},
{FALSE, 312, "GetEnhMetaFilePaletteEntries",    GetEnhMetaFilePaletteEntries},
{FALSE, 313, "GetEnhMetaFilePixelFormat",       GetEnhMetaFilePixelFormat},
{FALSE, 314, "GetEnhMetaFileW",                 GetEnhMetaFileW},
{FALSE, 315, "GetFontAssocStatus",              GetFontAssocStatus},
{FALSE, 316, "GetFontData",                     GetFontData},
{FALSE, 317, "GetFontLanguageInfo",             GetFontLanguageInfo},
{FALSE, 318, "GetFontResourceInfoW",            GetFontResourceInfoW},
{FALSE, 319, "GetFontUnicodeRanges",            GetFontUnicodeRanges},
{FALSE, 320, "GetGlyphIndicesA",                GetGlyphIndicesA},
{FALSE, 321, "GetGlyphIndicesW",                GetGlyphIndicesW},
{FALSE, 322, "GetGlyphOutline",                 GetGlyphOutlineA},
{FALSE, 323, "GetGlyphOutlineA",                GetGlyphOutlineA},
{FALSE, 324, "GetGlyphOutlineW",                GetGlyphOutlineW},
{FALSE, 325, "GetGlyphOutlineWow",              GetGlyphOutlineWow},
{FALSE, 326, "GetGraphicsMode",                 GetGraphicsMode},
{FALSE, 327, "GetHFONT",                        GetHFONT},
{FALSE, 328, "GetICMProfileA",                  GetICMProfileA},
{FALSE, 329, "GetICMProfileW",                  GetICMProfileW},
{FALSE, 330, "GetKerningPairs",                 GetKerningPairsA},
{FALSE, 331, "GetKerningPairsA",                GetKerningPairsA},
{FALSE, 332, "GetKerningPairsW",                GetKerningPairsW},
{FALSE, 333, "GetLayout",                       GetLayout},
{FALSE, 334, "GetLogColorSpaceA",               GetLogColorSpaceA},
{FALSE, 335, "GetLogColorSpaceW",               GetLogColorSpaceW},
{FALSE, 336, "GetMapMode",                      GetMapMode},
{FALSE, 337, "GetMetaFileA",                    GetMetaFileA},
{FALSE, 338, "GetMetaFileBitsEx",               GetMetaFileBitsEx},
{FALSE, 339, "GetMetaFileW",                    GetMetaFileW},
{FALSE, 340, "GetMetaRgn",                      GetMetaRgn},
{FALSE, 341, "GetMiterLimit",                   GetMiterLimit},
{TRUE,  342, "GetNearestColor",                 GetNearestColor},
{FALSE, 343, "GetNearestPaletteIndex",          GetNearestPaletteIndex},
{TRUE,  344, "GetObjectA",                      GetObjectA},
{FALSE, 345, "GetObjectType",                   GetObjectType},
{TRUE,  346, "GetObjectW",                      GetObjectW},
{FALSE, 347, "GetOutlineTextMetricsA",          GetOutlineTextMetricsA},
{FALSE, 348, "GetOutlineTextMetricsW",          GetOutlineTextMetricsW},
{FALSE, 349, "GetPaletteEntries",               GetPaletteEntries},
{FALSE, 350, "GetPath",                         GetPath},
{FALSE, 351, "GetPixel",                        GetPixel},
{FALSE, 352, "GetPixelFormat",                  GetPixelFormat},
{FALSE, 353, "GetPolyFillMode",                 GetPolyFillMode},
{FALSE, 354, "GetROP2",                         GetROP2},
{FALSE, 355, "GetRandomRgn",                    GetRandomRgn},
{FALSE, 356, "GetRasterizerCaps",               GetRasterizerCaps},
{FALSE, 357, "GetRegionData",                   GetRegionData},
{FALSE, 358, "GetRelAbs",                       GetRelAbs},
{FALSE, 359, "GetRgnBox",                       GetRgnBox},
{FALSE, 360, "GetStockObject",                  GetStockObject},
{FALSE, 361, "GetStretchBltMode",               GetStretchBltMode},
{FALSE, 362, "GetStringBitmapA",                GetStringBitmapA},
{FALSE, 363, "GetStringBitmapW",                GetStringBitmapW},
{TRUE,  364, "GetSystemPaletteEntries",         GetSystemPaletteEntries},
{FALSE, 365, "GetSystemPaletteUse",             GetSystemPaletteUse},
{FALSE, 366, "GetTextAlign",                    GetTextAlign},
{FALSE, 367, "GetTextCharacterExtra",           GetTextCharacterExtra},
{FALSE, 368, "GetTextCharset",                  GetTextCharset},
{FALSE, 369, "GetTextCharsetInfo",              GetTextCharsetInfo},
{TRUE,  370, "GetTextColor",                    GetTextColor},
{FALSE, 371, "GetTextExtentExPointA",           GetTextExtentExPointA},
{FALSE, 372, "GetTextExtentExPointI",           GetTextExtentExPointI},
{FALSE, 373, "GetTextExtentExPointW",           GetTextExtentExPointW},
{FALSE, 374, "GetTextExtentExPointWPri",        GetTextExtentExPointWPri},
{TRUE,  375, "GetTextExtentPoint32A",           GetTextExtentPoint32A},
{TRUE,  376, "GetTextExtentPoint32W",           GetTextExtentPoint32W},
{FALSE, 377, "GetTextExtentPointA",             GetTextExtentPointA},
{FALSE, 378, "GetTextExtentPointI",             GetTextExtentPointI},
{FALSE, 379, "GetTextExtentPointW",             GetTextExtentPointW},
{FALSE, 380, "GetTextFaceA",                    GetTextFaceA},
{FALSE, 381, "GetTextFaceAliasW",               GetTextFaceAliasW},
{FALSE, 382, "GetTextFaceW",                    GetTextFaceW},
{FALSE, 383, "GetTextMetricsA",                 GetTextMetricsA},
{FALSE, 384, "GetTextMetricsW",                 GetTextMetricsW},
{FALSE, 385, "GetTransform",                    GetTransform},
{FALSE, 386, "GetViewportExtEx",                GetViewportExtEx},
{FALSE, 387, "GetViewportOrgEx",                GetViewportOrgEx},
{FALSE, 388, "GetWinMetaFileBits",              GetWinMetaFileBits},
{FALSE, 389, "GetWindowExtEx",                  GetWindowExtEx},
{FALSE, 390, "GetWindowOrgEx",                  GetWindowOrgEx},
{FALSE, 391, "GetWorldTransform",               GetWorldTransform},
{FALSE, 392, "HT_Get8BPPFormatPalette",         HT_Get8BPPFormatPalette},
{FALSE, 393, "HT_Get8BPPMaskPalette",           HT_Get8BPPMaskPalette},
{FALSE, 394, "IntersectClipRect",               IntersectClipRect},
{FALSE, 395, "InvertRgn",                       InvertRgn},
{FALSE, 396, "IsValidEnhMetaRecord",            IsValidEnhMetaRecord},
{FALSE, 397, "IsValidEnhMetaRecordOffExt",      IsValidEnhMetaRecordOffExt},
{FALSE, 398, "LPtoDP",                          LPtoDP},
{FALSE, 399, "LineDDA",                         LineDDA},
{FALSE, 400, "LineTo",                          LineTo},
{FALSE, 401, "MaskBlt",                         MaskBlt},
{FALSE, 402, "MirrorRgn",                       MirrorRgn},
{FALSE, 403, "ModifyWorldTransform",            ModifyWorldTransform},
{FALSE, 404, "MoveToEx",                        MoveToEx},
{FALSE, 405, "NamedEscape",                     NamedEscape},
{FALSE, 406, "OffsetClipRgn",                   OffsetClipRgn},
{FALSE, 407, "OffsetRgn",                       OffsetRgn},
{FALSE, 408, "OffsetViewportOrgEx",             OffsetViewportOrgEx},
{FALSE, 409, "OffsetWindowOrgEx",               OffsetWindowOrgEx},
{FALSE, 410, "PATHOBJ_bEnum",                   PATHOBJ_bEnum},
{FALSE, 411, "PATHOBJ_bEnumClipLines",          PATHOBJ_bEnumClipLines},
{FALSE, 412, "PATHOBJ_vEnumStart",              PATHOBJ_vEnumStart},
{FALSE, 413, "PATHOBJ_vEnumStartClipLines",     PATHOBJ_vEnumStartClipLines},
{FALSE, 414, "PATHOBJ_vGetBounds",              PATHOBJ_vGetBounds},
{FALSE, 415, "PaintRgn",                        PaintRgn},
{FALSE, 416, "PatBlt",                          PatBlt},
{FALSE, 417, "PathToRegion",                    PathToRegion},
{FALSE, 418, "Pie",                             Pie},
{FALSE, 419, "PlayEnhMetaFile",                 PlayEnhMetaFile},
{FALSE, 420, "PlayEnhMetaFileRecord",           PlayEnhMetaFileRecord},
{FALSE, 421, "PlayMetaFile",                    PlayMetaFile},
{FALSE, 422, "PlayMetaFileRecord",              PlayMetaFileRecord},
{FALSE, 423, "PlgBlt",                          PlgBlt},
{FALSE, 424, "PolyBezier",                      PolyBezier},
{FALSE, 425, "PolyBezierTo",                    PolyBezierTo},
{FALSE, 426, "PolyDraw",                        PolyDraw},
{FALSE, 427, "PolyPatBlt",                      PolyPatBlt},
{FALSE, 428, "PolyPolygon",                     PolyPolygon},
{FALSE, 429, "PolyPolyline",                    PolyPolyline},
{FALSE, 430, "PolyTextOutA",                    PolyTextOutA},
{FALSE, 431, "PolyTextOutW",                    PolyTextOutW},
{FALSE, 432, "Polygon",                         Polygon},
{FALSE, 433, "Polyline",                        Polyline},
{FALSE, 434, "PolylineTo",                      PolylineTo},
{FALSE, 435, "PtInRegion",                      PtInRegion},
{FALSE, 436, "PtVisible",                       PtVisible},
{FALSE, 437, "QueryFontAssocStatus",            QueryFontAssocStatus},
{FALSE, 438, "RealizePalette",                  RealizePalette},
{FALSE, 439, "RectInRegion",                    RectInRegion},
{FALSE, 440, "RectVisible",                     RectVisible},
{FALSE, 441, "Rectangle",                       Rectangle},
{FALSE, 442, "RemoveFontMemResourceEx",         RemoveFontMemResourceEx},
{FALSE, 443, "RemoveFontResourceA",             RemoveFontResourceA},
{FALSE, 444, "RemoveFontResourceExA",           RemoveFontResourceExA},
{FALSE, 445, "RemoveFontResourceExW",           RemoveFontResourceExW},
{FALSE, 446, "RemoveFontResourceTracking",      RemoveFontResourceTracking},
{FALSE, 447, "RemoveFontResourceW",             RemoveFontResourceW},
{FALSE, 448, "ResetDCA",                        ResetDCA},
{FALSE, 449, "ResetDCW",                        ResetDCW},
{FALSE, 450, "ResizePalette",                   ResizePalette},
{FALSE, 451, "RestoreDC",                       RestoreDC},
{FALSE, 452, "RoundRect",                       RoundRect},
{FALSE, 453, "STROBJ_bEnum",                    STROBJ_bEnum},
{FALSE, 454, "STROBJ_bEnumPositionsOnly",       STROBJ_bEnumPositionsOnly},
{FALSE, 455, "STROBJ_bGetAdvanceWidths",        STROBJ_bGetAdvanceWidths},
{FALSE, 456, "STROBJ_dwGetCodePage",            STROBJ_dwGetCodePage},
{FALSE, 457, "STROBJ_vEnumStart",               STROBJ_vEnumStart},
{FALSE, 458, "SaveDC",                          SaveDC},
{FALSE, 459, "ScaleViewportExtEx",              ScaleViewportExtEx},
{FALSE, 460, "ScaleWindowExtEx",                ScaleWindowExtEx},
{FALSE, 461, "SelectBrushLocal",                SelectBrushLocal},
{FALSE, 462, "SelectClipPath",                  SelectClipPath},
{FALSE, 463, "SelectClipRgn",                   SelectClipRgn},
{FALSE, 464, "SelectFontLocal",                 SelectFontLocal},
{TRUE,  465, "SelectObject",                    SelectObject},
{FALSE, 466, "SelectPalette",                   SelectPalette},
{FALSE, 467, "SetAbortProc",                    SetAbortProc},
{FALSE, 468, "SetArcDirection",                 SetArcDirection},
{FALSE, 469, "SetBitmapBits",                   SetBitmapBits},
{FALSE, 470, "SetBitmapDimensionEx",            SetBitmapDimensionEx},
{TRUE,  471, "SetBkColor",                      SetBkColor},
{TRUE,  472, "SetBkMode",                       SetBkMode},
{FALSE, 473, "SetBoundsRect",                   SetBoundsRect},
{FALSE, 474, "SetBrushOrgEx",                   SetBrushOrgEx},
{FALSE, 475, "SetColorAdjustment",              SetColorAdjustment},
{FALSE, 476, "SetColorSpace",                   SetColorSpace},
{FALSE, 477, "SetDCBrushColor",                 SetDCBrushColor},
{FALSE, 478, "SetDCPenColor",                   SetDCPenColor},
{FALSE, 479, "SetDIBColorTable",                SetDIBColorTable},
{FALSE, 480, "SetDIBits",                       SetDIBits},
{FALSE, 481, "SetDIBitsToDevice",               SetDIBitsToDevice},
{FALSE, 482, "SetDeviceGammaRamp",              SetDeviceGammaRamp},
{FALSE, 483, "SetEnhMetaFileBits",              SetEnhMetaFileBits},
{FALSE, 484, "SetFontEnumeration",              SetFontEnumeration},
{FALSE, 485, "SetGraphicsMode",                 SetGraphicsMode},
{FALSE, 486, "SetICMMode",                      SetICMMode},
{FALSE, 487, "SetICMProfileA",                  SetICMProfileA},
{FALSE, 488, "SetICMProfileW",                  SetICMProfileW},
{FALSE, 489, "SetLayout",                       SetLayout},
{FALSE, 490, "SetLayoutWidth",                  SetLayoutWidth},
{FALSE, 491, "SetMagicColors",                  SetMagicColors},
{FALSE, 492, "SetMapMode",                      SetMapMode},
{FALSE, 493, "SetMapperFlags",                  SetMapperFlags},
{FALSE, 494, "SetMetaFileBitsEx",               SetMetaFileBitsEx},
{FALSE, 495, "SetMetaRgn",                      SetMetaRgn},
{FALSE, 496, "SetMiterLimit",                   SetMiterLimit},
{FALSE, 497, "SetPaletteEntries",               SetPaletteEntries},
{FALSE, 498, "SetPixel",                        SetPixel},
{FALSE, 499, "SetPixelFormat",                  SetPixelFormat},
{FALSE, 500, "SetPixelV",                       SetPixelV},
{FALSE, 501, "SetPolyFillMode",                 SetPolyFillMode},
{FALSE, 502, "SetROP2",                         SetROP2},
{FALSE, 503, "SetRectRgn",                      SetRectRgn},
{FALSE, 504, "SetRelAbs",                       SetRelAbs},
{FALSE, 505, "SetStretchBltMode",               SetStretchBltMode},
{FALSE, 506, "SetSystemPaletteUse",             SetSystemPaletteUse},
{FALSE, 507, "SetTextAlign",                    SetTextAlign},
{FALSE, 508, "SetTextCharacterExtra",           SetTextCharacterExtra},
{TRUE,  509, "SetTextColor",                    SetTextColor},
{FALSE, 510, "SetTextJustification",            SetTextJustification},
{FALSE, 511, "SetViewportExtEx",                SetViewportExtEx},
{FALSE, 512, "SetViewportOrgEx",                SetViewportOrgEx},
{FALSE, 513, "SetVirtualResolution",            SetVirtualResolution},
{FALSE, 514, "SetWinMetaFileBits",              SetWinMetaFileBits},
{FALSE, 515, "SetWindowExtEx",                  SetWindowExtEx},
{FALSE, 516, "SetWindowOrgEx",                  SetWindowOrgEx},
{FALSE, 517, "SetWorldTransform",               SetWorldTransform},
{FALSE, 518, "StartDocA",                       StartDocA},
{FALSE, 519, "StartDocW",                       StartDocW},
{FALSE, 520, "StartFormPage",                   StartFormPage},
{FALSE, 521, "StartPage",                       StartPage},
{FALSE, 522, "StretchBlt",                      StretchBlt},
{FALSE, 523, "StretchDIBits",                   StretchDIBits},
{FALSE, 524, "StrokeAndFillPath",               StrokeAndFillPath},
{FALSE, 525, "StrokePath",                      StrokePath},
{FALSE, 526, "SwapBuffers",                     SwapBuffers},
{TRUE,  527, "TextOutA",                        TextOutA},
{TRUE,  528, "TextOutW",                        TextOutW},
{FALSE, 529, "TranslateCharsetInfo",            TranslateCharsetInfo},
{FALSE, 530, "UnloadNetworkFonts",              UnloadNetworkFonts},
{FALSE, 531, "UnrealizeObject",                 UnrealizeObject},
{FALSE, 532, "UpdateColors",                    UpdateColors},
{FALSE, 533, "UpdateICMRegKeyA",                UpdateICMRegKeyA},
{FALSE, 534, "UpdateICMRegKeyW",                UpdateICMRegKeyW},
{FALSE, 535, "WidenPath",                       WidenPath},
{FALSE, 536, "XFORMOBJ_bApplyXform",            XFORMOBJ_bApplyXform},
{FALSE, 537, "XFORMOBJ_iGetXform",              XFORMOBJ_iGetXform},
{FALSE, 538, "XLATEOBJ_cGetPalette",            XLATEOBJ_cGetPalette},
{FALSE, 539, "XLATEOBJ_hGetColorTransform",     XLATEOBJ_hGetColorTransform},
{FALSE, 540, "XLATEOBJ_iXlate",                 XLATEOBJ_iXlate},
{FALSE, 541, "XLATEOBJ_piVector",               XLATEOBJ_piVector},
{FALSE, 542, "bInitSystemAndFontsDirectoriesW", bInitSystemAndFontsDirectoriesW},
{FALSE, 543, "bMakePathNameW",                  bMakePathNameW},
{FALSE, 544, "cGetTTFFromFOT",                  cGetTTFFromFOT},
{FALSE, 545, "gdiPlaySpoolStream",              gdiPlaySpoolStream},
{FALSE,   0, NULL,                              NULL}};
