/*
    Video maid
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "prop.h"


/******************************************************************************
*                                                                             *
* ja:プロパティダイアログ関数群                                               *
*                                                                             *
******************************************************************************/
typedef struct _PropertyDialog
{
  gboolean ok_sensitive, changed_entry, video, audio;
  GtkWidget *dialog, *combo0, *combo1;
  GtkWidget *entry, *spin0, *spin1, *spin2;
  const AviLanguage *lang;
} PropertyDialog;


/* ja:エントリー/スピンボタンでリターンが押された */
static void
prop_dialog_activate (GtkWidget      *widget,
                      PropertyDialog *propdlg)
{
  if (propdlg->ok_sensitive)
    gtk_dialog_response (GTK_DIALOG (propdlg->dialog), GTK_RESPONSE_OK);
}


/* ja:ラジオボタンが変更された */
#define prop_dialog_toggled prop_dialog_changed
/* ja:コンボボックス/エントリー/スピンボタンが変更された */
static void
prop_dialog_changed (GtkWidget      *widget,
                     PropertyDialog *propdlg)
{
  gboolean result = TRUE;
  const gchar *text;
  gint i, rate, scale, value;

  if (propdlg->video)
    {
      text = gtk_entry_get_text
#if GTK_CHECK_VERSION(2,4,0)
                (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (propdlg->combo0))));
#else /* not GTK_CHECK_VERSION(2,4,0) */
                            (GTK_ENTRY (GTK_COMBO (propdlg->combo0)->entry));
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      for (i = 0; propdlg->lang[i].name; i++)
        if (g_strcmp (propdlg->lang[i].name, text) == 0)
          break;
      if (!propdlg->lang[i].name && !misc_str_to_val (&value, text, 16, FALSE))
        result = FALSE;
    }
  if (result && propdlg->audio)
    {
      text = gtk_entry_get_text
#if GTK_CHECK_VERSION(2,4,0)
                (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (propdlg->combo1))));
#else /* not GTK_CHECK_VERSION(2,4,0) */
                            (GTK_ENTRY (GTK_COMBO (propdlg->combo1)->entry));
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      for (i = 0; propdlg->lang[i].name; i++)
        if (g_strcmp (propdlg->lang[i].name, text) == 0)
          break;
      if (!propdlg->lang[i].name && !misc_str_to_val (&value, text, 16, FALSE))
        result = FALSE;
    }
  propdlg->ok_sensitive = result
        && misc_str_to_float (&rate, &scale,
                            gtk_entry_get_text (GTK_ENTRY (propdlg->entry)))
        && rate > 0
        && (!propdlg->video || (gtk_spin_button_get_value_as_int
                                        (GTK_SPIN_BUTTON (propdlg->spin0)) > 0
                && gtk_spin_button_get_value_as_int
                                    (GTK_SPIN_BUTTON (propdlg->spin1)) > 0))
        && (!propdlg->audio || gtk_spin_button_get_value_as_int
                                    (GTK_SPIN_BUTTON (propdlg->spin2)) > 0);
  gtk_dialog_set_response_sensitive (GTK_DIALOG (propdlg->dialog),
                                    GTK_RESPONSE_OK, propdlg->ok_sensitive);
}


/* ja:エントリーが変更された */
static void
prop_dialog_changed_entry (GtkWidget      *widget,
                           PropertyDialog *propdlg)
{
  propdlg->changed_entry = TRUE;
  prop_dialog_changed (widget, propdlg);
}


/*  ja:プロパティダイアログ表示
    propcfg,プロパティ構造体
        RET,TRUE:OK,FALSE:Cancel                                            */
gboolean
property_dialog (PropertyConfig *propcfg)
{
  gboolean result;
  gchar *text, *title;
  gint i;
#if ! GTK_CHECK_VERSION(2,4,0)
  GList *glist;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  GtkStockItem stock_item;
  GtkWidget *combo, *entry0, *entry1, *radio0, *radio1;
  GtkWidget *spin0, *spin1, *spin2, *spin3;
  GtkWidget *label0, *label1, *label2, *label3, *label4;
  GtkWidget *label5, *label6, *label7, *label8;
  GtkWidget *frame0, *frame1, *hbox, *vbox;
  PropertyDialog propdlg;
  static struct
  {
    const gchar *text;
    const gint bit;
  } bit_count[] = {{N_("Monochrome"),  1}, {N_("16 colors"),  4},
                   {N_("256 colors"),  8}, {N_("16 bits"),   16},
                   {N_("Full Color"), 24}, {N_("32 bits"),   32}, {NULL, 0}};

  propdlg.lang = avi_lang_get_struct ();
  /* ja:メインウインドウ */
  gtk_stock_lookup (GTK_STOCK_PROPERTIES, &stock_item);
  title = misc_mnemonic_to_text (stock_item.label);
  propdlg.dialog = gtk_dialog_new_with_buttons
                            (title,
                            GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
#ifdef G_OS_WIN32
                            GTK_STOCK_OK, GTK_RESPONSE_OK,
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
#else /* not G_OS_WIN32 */
                            GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                            GTK_STOCK_OK, GTK_RESPONSE_OK,
#endif /* not G_OS_WIN32 */
                            NULL);
  g_free (title);
  g_signal_connect (G_OBJECT (propdlg.dialog), "key-press-event",
                                    G_CALLBACK (misc_dialog_key_press), NULL);
  /* ja:エントリー */
  propdlg.entry = gtk_entry_new ();
  text = misc_str_from_float (propcfg->rate, propcfg->scale);
  gtk_entry_set_text (GTK_ENTRY (propdlg.entry), text);
  g_free (text);
  g_signal_connect (G_OBJECT (propdlg.entry), "activate",
                            G_CALLBACK (prop_dialog_activate), &propdlg);
  g_signal_connect (G_OBJECT (propdlg.entry), "changed",
                            G_CALLBACK (prop_dialog_changed_entry), &propdlg);
  gtk_editable_select_region (GTK_EDITABLE (propdlg.entry), 0, -1);
  /* ja:ラベル */
  label0 = gtk_label_new_with_mnemonic  (_("_Frame per second"));
  gtk_label_set_mnemonic_widget (GTK_LABEL (label0), propdlg.entry);

  if (propcfg->width > 0 && propcfg->height > 0 && propcfg->bit_count != 0)
    {
      /* ja:コンボボックス */
#if GTK_CHECK_VERSION(2,4,0)
      propdlg.combo0 = gtk_combo_box_entry_new_text ();
      for (i = 0; propdlg.lang[i].name; i++)
        gtk_combo_box_append_text (GTK_COMBO_BOX (propdlg.combo0),
                                                        propdlg.lang[i].name);
#else /* not GTK_CHECK_VERSION(2,4,0) */
      glist = NULL;
      for (i = 0; propdlg.lang[i].name; i++)
        glist = g_list_append (glist, (gpointer)propdlg.lang[i].name);
      propdlg.combo0 = gtk_combo_new ();
      gtk_combo_set_popdown_strings (GTK_COMBO (propdlg.combo0), glist);
      gtk_combo_set_value_in_list (GTK_COMBO (propdlg.combo0), FALSE, FALSE);
      g_list_free (glist);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      for (i = 0; propdlg.lang[i].name; i++)
        if (propdlg.lang[i].id == propcfg->language0)
          {
#if GTK_CHECK_VERSION(2,4,0)
            gtk_entry_set_text
                    (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (propdlg.combo0))),
                                                        propdlg.lang[i].name);
#else /* not GTK_CHECK_VERSION(2,4,0) */
            gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (propdlg.combo0)->entry),
                                                        propdlg.lang[i].name);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
            break;
          }
      if (!propdlg.lang[i].name)
        {
          text = g_strdup_printf ("%X", propcfg->language0);
#if GTK_CHECK_VERSION(2,4,0)
          gtk_entry_set_text
            (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (propdlg.combo0))), text);
#else /* not GTK_CHECK_VERSION(2,4,0) */
          gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (propdlg.combo0)->entry),
                                                                        text);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
          g_free (text);
        }
#if GTK_CHECK_VERSION(2,4,0)
      g_signal_connect
                    (G_OBJECT (gtk_bin_get_child (GTK_BIN (propdlg.combo0))),
                        "changed", G_CALLBACK (prop_dialog_changed), &propdlg);
#else /* not GTK_CHECK_VERSION(2,4,0) */
      g_signal_connect (G_OBJECT (GTK_COMBO (propdlg.combo0)->entry),
                        "changed", G_CALLBACK (prop_dialog_changed), &propdlg);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      /* ja:コンボボックス */
#if GTK_CHECK_VERSION(2,4,0)
      combo = gtk_combo_box_new_text ();
      for (i = 0; bit_count[i].text; i++)
        {
          gtk_combo_box_append_text (GTK_COMBO_BOX (combo),
                                                        _(bit_count[i].text));
          if (bit_count[i].bit == propcfg->bit_count)
            gtk_combo_box_set_active (GTK_COMBO_BOX (combo), i);
        }
      g_signal_connect (G_OBJECT (combo), "changed",
                                G_CALLBACK (prop_dialog_changed), &propdlg);
#else /* not GTK_CHECK_VERSION(2,4,0) */
      glist = NULL;
      for (i = 0; bit_count[i].text; i++)
        glist = g_list_append (glist, (gpointer)_(bit_count[i].text));
      combo = gtk_combo_new ();
      gtk_combo_set_popdown_strings (GTK_COMBO (combo), glist);
      gtk_combo_set_value_in_list (GTK_COMBO (combo), TRUE, FALSE);
      gtk_editable_set_editable
                            (GTK_EDITABLE (GTK_COMBO (combo)->entry), FALSE);
      for (i = 0; bit_count[i].text; i++)
        if (bit_count[i].bit == propcfg->bit_count)
          gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo)->entry),
                                                        _(bit_count[i].text));
      g_signal_connect (G_OBJECT (GTK_COMBO (combo)->entry), "changed",
                                G_CALLBACK (prop_dialog_changed), &propdlg);
      g_list_free (glist);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      /* ja:エントリー */
      entry0 = gtk_entry_new ();
      if (propcfg->name0)
        gtk_entry_set_text (GTK_ENTRY (entry0), propcfg->name0);
      g_signal_connect (G_OBJECT (entry0), "activate",
                                G_CALLBACK (prop_dialog_activate), &propdlg);
      g_signal_connect (G_OBJECT (entry0), "changed",
                                G_CALLBACK (prop_dialog_changed), &propdlg);
      /* ja:スピンボタン */
      spin0 = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
                        (propcfg->priority0, 0, G_MAXSHORT, 1, 5, 0)), 0, 0);
      propdlg.spin0 = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
                                (propcfg->width, 1, G_MAXINT, 1, 5, 0)), 0, 0);
      propdlg.spin1 = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
                            (propcfg->height, 1, G_MAXINT, 1, 5, 0)), 0, 0);
      spin1 = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
                (propcfg->y_pixels_per_meter, 0, G_MAXINT, 1, 5, 0)), 0, 0);
      spin2 = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
                (propcfg->y_pixels_per_meter, 0, G_MAXINT, 1, 5, 0)), 0, 0);
      gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin0), TRUE);
      gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (propdlg.spin0), TRUE);
      gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (propdlg.spin1), TRUE);
      gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin1), TRUE);
      gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin2), TRUE);
      g_signal_connect (G_OBJECT (spin0), "activate",
                                G_CALLBACK (prop_dialog_activate), &propdlg);
      g_signal_connect (G_OBJECT (propdlg.spin0), "activate",
                                G_CALLBACK (prop_dialog_activate), &propdlg);
      g_signal_connect (G_OBJECT (propdlg.spin1), "activate",
                                G_CALLBACK (prop_dialog_activate), &propdlg);
      g_signal_connect (G_OBJECT (spin1), "activate",
                                G_CALLBACK (prop_dialog_activate), &propdlg);
      g_signal_connect (G_OBJECT (spin2), "activate",
                                G_CALLBACK (prop_dialog_activate), &propdlg);
      g_signal_connect (G_OBJECT (spin0), "changed",
                                G_CALLBACK (prop_dialog_changed), &propdlg);
      g_signal_connect (G_OBJECT (propdlg.spin0), "changed",
                                G_CALLBACK (prop_dialog_changed), &propdlg);
      g_signal_connect (G_OBJECT (propdlg.spin1), "changed",
                                G_CALLBACK (prop_dialog_changed), &propdlg);
      g_signal_connect (G_OBJECT (spin1), "changed",
                                G_CALLBACK (prop_dialog_changed), &propdlg);
      g_signal_connect (G_OBJECT (spin2), "changed",
                                G_CALLBACK (prop_dialog_changed), &propdlg);
      /* ja:ラベル */
      label1 = gtk_label_new_with_mnemonic (_("_Name"));
      label2 = gtk_label_new_with_mnemonic (_("_Priority"));
      label3 = gtk_label_new_with_mnemonic (_("_Language"));
      label4 = gtk_label_new_with_mnemonic (_("_Width"));
      label5 = gtk_label_new_with_mnemonic (_("_Height"));
      label6 = gtk_label_new_with_mnemonic (_("_Color"));
      label7 = gtk_label_new_with_mnemonic (_("_X pixels per meter"));
      label8 = gtk_label_new_with_mnemonic (_("_Y pixels per meter"));
      gtk_label_set_mnemonic_widget (GTK_LABEL (label1), entry0);
      gtk_label_set_mnemonic_widget (GTK_LABEL (label2), spin0);
#if GTK_CHECK_VERSION(2,4,0)
      gtk_label_set_mnemonic_widget (GTK_LABEL (label3),
                                gtk_bin_get_child (GTK_BIN (propdlg.combo0)));
#else /* not GTK_CHECK_VERSION(2,4,0) */
      gtk_label_set_mnemonic_widget (GTK_LABEL (label3),
                                            GTK_COMBO (propdlg.combo0)->entry);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      gtk_label_set_mnemonic_widget (GTK_LABEL (label4), propdlg.spin0);
      gtk_label_set_mnemonic_widget (GTK_LABEL (label5), propdlg.spin1);
#if GTK_CHECK_VERSION(2,4,0)
      gtk_label_set_mnemonic_widget (GTK_LABEL (label6), combo);
#else /* not GTK_CHECK_VERSION(2,4,0) */
      gtk_label_set_mnemonic_widget (GTK_LABEL (label6),
                                                    GTK_COMBO (combo)->entry);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      gtk_label_set_mnemonic_widget (GTK_LABEL (label7), spin1);
      gtk_label_set_mnemonic_widget (GTK_LABEL (label8), spin2);

      /* ja:フレームとボックス */
      vbox = gtk_vbox_new (FALSE, SPACING);
      gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);

      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), label1, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), entry0, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), label2, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), spin0, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), label3, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), propdlg.combo0, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), label4, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), propdlg.spin0, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), label5, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), propdlg.spin1, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), label6, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), combo, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), label7, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), spin1, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), label8, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), spin2, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

      frame0 = gtk_frame_new (_("Video"));
      gtk_container_add (GTK_CONTAINER (frame0), vbox);
      propdlg.video = TRUE;
    }
  else
    {
      frame0 = combo = entry0 = spin0 = spin1 = spin2 = NULL;
      propdlg.video = FALSE;
    }

  if (propcfg->samples_per_sec != 0 && propcfg->channels != 0
                                            && propcfg->bits_per_sample != 0)
    {
      GtkWidget *radio2, *radio3;

      /* ja:コンボボックス */
#if GTK_CHECK_VERSION(2,4,0)
      propdlg.combo1 = gtk_combo_box_entry_new_text ();
      for (i = 0; propdlg.lang[i].name; i++)
        gtk_combo_box_append_text (GTK_COMBO_BOX (propdlg.combo1),
                                                        propdlg.lang[i].name);
#else /* not GTK_CHECK_VERSION(2,4,0) */
      glist = NULL;
      for (i = 0; propdlg.lang[i].name; i++)
        glist = g_list_append (glist, (gpointer)propdlg.lang[i].name);
      propdlg.combo1 = gtk_combo_new ();
      gtk_combo_set_popdown_strings (GTK_COMBO (propdlg.combo1), glist);
      gtk_combo_set_value_in_list (GTK_COMBO (propdlg.combo1), FALSE, FALSE);
      g_list_free (glist);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      for (i = 0; propdlg.lang[i].name; i++)
        if (propdlg.lang[i].id == propcfg->language1)
          {
#if GTK_CHECK_VERSION(2,4,0)
            gtk_entry_set_text
                    (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (propdlg.combo1))),
                                                        propdlg.lang[i].name);
#else /* not GTK_CHECK_VERSION(2,4,0) */
            gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (propdlg.combo1)->entry),
                                                        propdlg.lang[i].name);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
            break;
          }
      if (!propdlg.lang[i].name)
        {
          text = g_strdup_printf ("%X", propcfg->language1);
#if GTK_CHECK_VERSION(2,4,0)
          gtk_entry_set_text
            (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (propdlg.combo1))), text);
#else /* not GTK_CHECK_VERSION(2,4,0) */
          gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (propdlg.combo1)->entry),
                                                                        text);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
          g_free (text);
        }
#if GTK_CHECK_VERSION(2,4,0)
      g_signal_connect
                    (G_OBJECT (gtk_bin_get_child (GTK_BIN (propdlg.combo1))),
                        "changed", G_CALLBACK (prop_dialog_changed), &propdlg);
#else /* not GTK_CHECK_VERSION(2,4,0) */
      g_signal_connect (G_OBJECT (GTK_COMBO (propdlg.combo1)->entry),
                        "changed", G_CALLBACK (prop_dialog_changed), &propdlg);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      /* ja:エントリー */
      entry1 = gtk_entry_new ();
      if (propcfg->name1)
        gtk_entry_set_text (GTK_ENTRY (entry1), propcfg->name1);
      g_signal_connect (G_OBJECT (entry1), "activate",
                                G_CALLBACK (prop_dialog_activate), &propdlg);
      g_signal_connect (G_OBJECT (entry1), "changed",
                                G_CALLBACK (prop_dialog_changed), &propdlg);
      /* ja:スピンボタン */
      spin3 = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
                        (propcfg->priority1, 0, G_MAXSHORT, 1, 5, 0)), 0, 0);
      propdlg.spin2 = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
                    (propcfg->samples_per_sec, 1, G_MAXINT, 1, 5, 0)), 0, 0);
      gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin3), TRUE);
      gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (propdlg.spin2), TRUE);
      g_signal_connect (G_OBJECT (spin3), "activate",
                                G_CALLBACK (prop_dialog_activate), &propdlg);
      g_signal_connect (G_OBJECT (propdlg.spin2), "activate",
                                G_CALLBACK (prop_dialog_activate), &propdlg);
      g_signal_connect (G_OBJECT (spin3), "changed",
                                G_CALLBACK (prop_dialog_changed), &propdlg);
      g_signal_connect (G_OBJECT (propdlg.spin2), "changed",
                                G_CALLBACK (prop_dialog_changed), &propdlg);
      /* ja:ラベル */
      label1 = gtk_label_new_with_mnemonic (_("_Name"));
      label2 = gtk_label_new_with_mnemonic (_("_Priority"));
      label3 = gtk_label_new_with_mnemonic (_("_Language"));
      label4 = gtk_label_new_with_mnemonic (_("_Rate"));
      gtk_label_set_mnemonic_widget (GTK_LABEL (label1), entry1);
      gtk_label_set_mnemonic_widget (GTK_LABEL (label2), spin3);
#if GTK_CHECK_VERSION(2,4,0)
      gtk_label_set_mnemonic_widget (GTK_LABEL (label3),
                                gtk_bin_get_child (GTK_BIN (propdlg.combo1)));
#else /* not GTK_CHECK_VERSION(2,4,0) */
      gtk_label_set_mnemonic_widget (GTK_LABEL (label3),
                                            GTK_COMBO (propdlg.combo1)->entry);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
      gtk_label_set_mnemonic_widget (GTK_LABEL (label4), propdlg.spin2);
      /* ja:ラジオボタン */
      radio0 = gtk_radio_button_new_with_mnemonic (NULL, _("_Monophone"));
      radio2 = gtk_radio_button_new_with_mnemonic_from_widget
                                    (GTK_RADIO_BUTTON (radio0), _("_Stereo"));
      radio1 = gtk_radio_button_new_with_mnemonic (NULL, _("_8 bits"));
      radio3 = gtk_radio_button_new_with_mnemonic_from_widget
                                    (GTK_RADIO_BUTTON (radio1), _("_16 bits"));
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
                            (propcfg->channels == 1 ? radio0 : radio2), TRUE);
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
                    (propcfg->bits_per_sample == 8 ? radio1 : radio3), TRUE);
      g_signal_connect (G_OBJECT (radio0), "toggled",
                                G_CALLBACK (prop_dialog_toggled), &propdlg);
      g_signal_connect (G_OBJECT (radio1), "toggled",
                                G_CALLBACK (prop_dialog_toggled), &propdlg);
      g_signal_connect (G_OBJECT (radio2), "toggled",
                                G_CALLBACK (prop_dialog_toggled), &propdlg);
      g_signal_connect (G_OBJECT (radio3), "toggled",
                                G_CALLBACK (prop_dialog_toggled), &propdlg);
      /* ja:フレームとボックス */
      vbox = gtk_vbox_new (FALSE, SPACING);
      gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);

      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), label1, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), entry1, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), label2, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), spin3, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), label3, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), propdlg.combo1, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

      hbox = gtk_hbox_new (FALSE,0);
      gtk_box_pack_start (GTK_BOX (hbox), label4, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), propdlg.spin2, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

      hbox = gtk_hbox_new (FALSE, SPACING);
      gtk_container_set_border_width (GTK_CONTAINER (hbox), SPACING);
      gtk_box_pack_start (GTK_BOX (hbox), radio0, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), radio2, FALSE, FALSE, 0);
      frame1 = gtk_frame_new (_("Channel"));
      gtk_container_add (GTK_CONTAINER (frame1), hbox);
      gtk_box_pack_start (GTK_BOX (vbox), frame1, FALSE, FALSE, 0);

      hbox = gtk_hbox_new (FALSE, SPACING);
      gtk_container_set_border_width (GTK_CONTAINER (hbox), SPACING);
      gtk_box_pack_start (GTK_BOX (hbox), radio1, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), radio3, FALSE, FALSE, 0);
      frame1 = gtk_frame_new (_("Bit"));
      gtk_container_add (GTK_CONTAINER (frame1), hbox);
      gtk_box_pack_start (GTK_BOX (vbox), frame1, FALSE, FALSE, 0);

      frame1 = gtk_frame_new (_("Audio"));
      gtk_container_add (GTK_CONTAINER (frame1), vbox);
      propdlg.audio = TRUE;
    }
  else
    {
      frame1 = entry1 = radio0 = radio1 = spin3 = NULL;
      propdlg.audio = FALSE;
    }

  /* ja:フレームとボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), label0, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), propdlg.entry, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

  if (frame0 && frame1)
    {
      hbox = gtk_hbox_new (FALSE, SPACING);
      gtk_box_pack_start (GTK_BOX (hbox), frame0, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (hbox), frame1, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
    }
  else
    {
      gtk_box_pack_start (GTK_BOX (vbox),
                                    frame0 ? frame0 : frame1, TRUE, TRUE, 0);
    }

  gtk_container_add (GTK_CONTAINER (GTK_DIALOG (propdlg.dialog)->vbox), vbox);

  /* ja:表示 */
  gtk_widget_grab_focus (propdlg.entry);
  gtk_dialog_set_response_sensitive (GTK_DIALOG (propdlg.dialog),
                                                    GTK_RESPONSE_OK, FALSE);
  gtk_widget_show_all (vbox);

  propdlg.ok_sensitive = FALSE;
  propdlg.changed_entry = FALSE;

  result = gtk_dialog_run (GTK_DIALOG (propdlg.dialog)) == GTK_RESPONSE_OK;
  if (result)
    {
      const gchar *text;
      gint i, value;

      if (propdlg.changed_entry)
        {
          gint rate, scale;

          misc_str_to_float (&rate, &scale,
                            gtk_entry_get_text (GTK_ENTRY (propdlg.entry)));
          propcfg->rate = rate;
          propcfg->scale = scale;
        }
      if (propdlg.video)
        {
          /* ja:優先度 */
          propcfg->priority0 = gtk_spin_button_get_value_as_int
                                                    (GTK_SPIN_BUTTON (spin0));
          /* ja:言語 */
          text = gtk_entry_get_text
#if GTK_CHECK_VERSION(2,4,0)
                    (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (propdlg.combo0))));
#else /* not GTK_CHECK_VERSION(2,4,0) */
                            (GTK_ENTRY (GTK_COMBO (propdlg.combo0)->entry));
#endif /* not GTK_CHECK_VERSION(2,4,0) */
          for (i = 0; propdlg.lang[i].name; i++)
            if (g_strcmp (propdlg.lang[i].name, text) == 0)
              {
                propcfg->language0 = propdlg.lang[i].id;
                break;
              }
          if (!propdlg.lang[i].name
                                && misc_str_to_val (&value, text, 16, FALSE))
            propcfg->language0 = value;
          /* ja:名前 */
          text = gtk_entry_get_text (GTK_ENTRY (entry0));
          propcfg->name0 = text && text[0] != '\0' ? g_strdup (text) : NULL;
          /* ja:ビデオ */
          propcfg->width = gtk_spin_button_get_value_as_int
                                            (GTK_SPIN_BUTTON (propdlg.spin0));
          propcfg->height = gtk_spin_button_get_value_as_int
                                            (GTK_SPIN_BUTTON (propdlg.spin1));
#if GTK_CHECK_VERSION(2,4,0)
          i = gtk_combo_box_get_active (GTK_COMBO_BOX (combo));
          if (i >= 0)
            propcfg->bit_count = bit_count[i].bit;
#else /* not GTK_CHECK_VERSION(2,4,0) */
          text = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo)->entry));
          for (i = 0; bit_count[i].text; i++)
            if (g_strcmp (_(bit_count[i].text), text) == 0)
              propcfg->bit_count = bit_count[i].bit;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
          propcfg->x_pixels_per_meter = gtk_spin_button_get_value_as_int
                                                    (GTK_SPIN_BUTTON (spin1));
          propcfg->y_pixels_per_meter = gtk_spin_button_get_value_as_int
                                                    (GTK_SPIN_BUTTON (spin2));
        }
      if (propdlg.audio)
        {
          /* ja:優先度 */
          propcfg->priority1 = gtk_spin_button_get_value_as_int
                                                    (GTK_SPIN_BUTTON (spin3));
          /* ja:言語 */
          text = gtk_entry_get_text
#if GTK_CHECK_VERSION(2,4,0)
                    (GTK_ENTRY (gtk_bin_get_child (GTK_BIN (propdlg.combo1))));
#else /* not GTK_CHECK_VERSION(2,4,0) */
                            (GTK_ENTRY (GTK_COMBO (propdlg.combo1)->entry));
#endif /* not GTK_CHECK_VERSION(2,4,0) */
          for (i = 0; propdlg.lang[i].name; i++)
            if (g_strcmp (propdlg.lang[i].name, text) == 0)
              {
                propcfg->language1 = propdlg.lang[i].id;
                break;
              }
          if (!propdlg.lang[i].name
                                && misc_str_to_val (&value, text, 16, FALSE))
            propcfg->language1 = value;
          /* ja:名前 */
          text = gtk_entry_get_text (GTK_ENTRY (entry1));
          propcfg->name1 = text && text[0] != '\0' ? g_strdup (text) : NULL;
          /* ja:オーディオ */
          propcfg->samples_per_sec = gtk_spin_button_get_value_as_int
                                            (GTK_SPIN_BUTTON (propdlg.spin2));
          propcfg->channels = gtk_toggle_button_get_active
                                        (GTK_TOGGLE_BUTTON (radio0)) ? 1 : 2;
          propcfg->bits_per_sample = gtk_toggle_button_get_active
                                        (GTK_TOGGLE_BUTTON (radio1)) ? 8 : 16;
        }
    }
  gtk_widget_destroy (propdlg.dialog);

  return result;
}
