/*
    gcommon
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __GCOMMON_H__
#define __GCOMMON_H__


#ifdef HAVE_CONFIG_H
# include "config.h"
#endif /* HAVE_CONFIG_H */


#include <stdio.h>
#if STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#elif HAVE_STRINGS_H
# include <strings.h>
#endif /* HAVE_STRINGS_H */
#include <gtk/gtk.h>


#define SPACING 5


#if defined (USE_THREAD) && ! defined (G_THREADS_ENABLED)
# undef USE_THREAD
#endif /* defined (USE_THREAD) && ! defined (G_THREADS_ENABLED) */


#if ! GLIB_CHECK_VERSION(2,14,0)
typedef gint64 goffset;
#endif /* not GLIB_CHECK_VERSION(2,14,0) */
typedef gint64 glonglong;
typedef guint64 gulonglong;


#ifndef G_MININT8
# define G_MININT8 ((gint8)0x80)
#endif /* not G_MININT8 */
#ifndef G_MAXINT8
# define G_MAXINT8 ((gint8)0x7f)
#endif /* not G_MAXINT8 */
#ifndef G_MAXUINT8
# define G_MAXUINT8 ((gint8)0xff)
#endif /* not G_MAXUINT8 */
#ifndef G_MININT16
# define G_MININT16 ((gint16)0x8000)
#endif /* not G_MININT16 */
#ifndef G_MAXINT16
# define G_MAXINT16 ((gint16)0x7fff)
#endif /* not G_MAXINT16 */
#ifndef G_MAXUINT16
# define G_MAXUINT16 ((gint16)0xffff)
#endif /* not G_MAXUINT16 */
#ifndef G_MININT32
# define G_MININT32 ((gint32)0x80000000)
#endif /* not G_MININT32 */
#ifndef G_MAXINT32
# define G_MAXINT32 ((gint32)0x7fffffff)
#endif /* not G_MAXINT32 */
#ifndef G_MAXUINT32
# define G_MAXUINT32 ((gint32)0xffffffff)
#endif /* not G_MAXUINT32 */
#ifndef G_MAXSIZE
# define G_MAXSIZE G_MAXUINT
#endif /* not G_MAXSIZE */


#define g_strlen(s) ((s)?strlen(s):0)
#define g_strcmp(s1,s2) ((s1)&&(s2)?strcmp(s1,s2):0)
#define g_strncmp(s1,s2,n) ((s1)&&(s2)?strncmp(s1,s2,n):0)
#define g_strchr(s,c) ((s)?strchr(s,c):NULL)
#define g_strrchr(s,c) ((s)?strrchr(s,c):NULL)
#define g_strtok(s,delim) ((delim)?strtok(s,delim):NULL)
#define g_memset(s,c,n) ((s)?memset(s,c,n):(s))
#define g_memcmp(s1,s2,n) ((s1)&&(s2)?memcmp(s1,s2,n):0)
#define g_strcpy(dest,src) g_strlcpy(dest,src,G_MAXSIZE)
#define g_strcat(dest,src) g_strlcat(dest,src,G_MAXSIZE)
#define g_strncpy(dest,src,n) ((dest)&&(src)?strncpy(dest,src,n):(dest))
#define g_strncat(dest,src,n) ((dest)&&(src)?strncat(dest,src,n):(dest))
#define g_strstr(haystack,needle) g_strstr_len(haystack,g_strlen(haystack),needle)
#ifdef G_OS_WIN32
# define g_strfilecmp(s1,s2) g_ascii_strcasecmp(s1,s2)
# define g_strfilencmp(s1,s2,n) g_ascii_strncasecmp(s1,s2,n)
#else /* not G_OS_WIN32 */
# define g_strfilecmp(s1,s2) g_strcmp(s1,s2)
# define g_strfilencmp(s1,s2,n) g_strncmp(s1,s2,n)
#endif /* not G_OS_WIN32 */


#if GLIB_CHECK_VERSION(2,4,0)
# include <glib/gi18n.h>
#else /* not GLIB_CHECK_VERSION(2,4,0) */
# ifdef ENABLE_NLS
#  include <libintl.h>
#  define _(String) dgettext(PACKAGE,String)
#  ifdef gettext_noop
#   define N_(String) gettext_noop(String)
#  else /* not gettext_noop */
#   define N_(String) (String)
#  endif /* not gettext_noop */
#  define Q_(String) g_strip_context((String),gettext(String))
# else /* not ENABLE_NLS */
#  define _(String) (String)
#  define N_(String) (String)
#  define Q_(String) (String)
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,String) (String)
#  define dcgettext(Domain,String,Type) (String)
#  define bindtextdomain(Domain,Directory) (Domain)
# endif /* not ENABLE_NLS */
#endif /* not GLIB_CHECK_VERSION(2,4,0) */


#ifndef G_IS_DIR_SEPARATOR
# ifdef G_OS_WIN32
#  define G_IS_DIR_SEPARATOR(c) ((c)==G_DIR_SEPARATOR||(c)=='/')
# else /* not G_OS_WIN32 */
#  define G_IS_DIR_SEPARATOR(c) ((c)==G_DIR_SEPARATOR)
# endif /* not G_OS_WIN32 */
#endif /* not G_IS_DIR_SEPARATOR */


#endif /* __GCOMMON_H__ */
