/*
    avicore
    copyright (c) 1998-2006 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "avibase.h"


/******************************************************************************
*                                                                             *
* ja:AVI言語関数                                                              *
*                                                                             *
******************************************************************************/
AviLanguage *avi_lang = NULL;


#ifdef G_OS_WIN32
# if GLIB_CHECK_VERSION(2,6,0) || defined (UNICODE)
static BOOL CALLBACK
EnumLocaleProcW (LPWSTR lpLocaleString)
{
  gchar *utf8str;
  gint lcid;

  utf8str = g_utf16_to_utf8 (lpLocaleString, -1, NULL, NULL, NULL);
  if (misc_str_to_val (&lcid, utf8str, 16, FALSE))
    {
      gint i;

      for (i = 0; avi_lang[i].name; i++)
        if (avi_lang[i].id == LANGIDFROMLCID (lcid))
          break;
      if (!avi_lang[i].name)
        {
          int nLeng;

          nLeng = GetLocaleInfoW (lcid, LOCALE_SLANGUAGE, NULL, 0);
          if (nLeng > 0)
            {
              LPWSTR lpszName;

              lpszName = g_malloc (nLeng * sizeof (WCHAR));
              if (GetLocaleInfoW (lcid, LOCALE_SLANGUAGE, lpszName, nLeng) > 0)
                {
                  avi_lang = g_realloc (avi_lang, (i + 2)
                                                    * sizeof (AviLanguage));
                  avi_lang[i].name = g_utf16_to_utf8 (lpszName, -1,
                                                            NULL, NULL, NULL);
                  avi_lang[i].id = LANGIDFROMLCID (lcid);
                  avi_lang[i + 1].name = NULL;
                  avi_lang[i + 1].id = 0;
                }
              g_free (lpszName);
            }
        }
    }
  g_free (utf8str);
  return TRUE;
}
# endif /* GLIB_CHECK_VERSION(2,6,0) || defined (UNICODE) */
# if GLIB_CHECK_VERSION(2,6,0) || ! defined (UNICODE)
static BOOL CALLBACK
EnumLocaleProcA (LPSTR lpLocaleString)
{
  gchar *utf8str;
  gint lcid;

  utf8str = g_locale_to_utf8 (lpLocaleString, -1, NULL, NULL, NULL);
  if (misc_str_to_val (&lcid, utf8str, 16, FALSE))
    {
      gint i;

      for (i = 0; avi_lang[i].name; i++)
        if (avi_lang[i].id == LANGIDFROMLCID (lcid))
          break;
      if (!avi_lang[i].name)
        {
          int nLeng;

          nLeng = GetLocaleInfoA (lcid, LOCALE_SLANGUAGE, NULL, 0);
          if (nLeng > 0)
            {
              LPSTR lpszName;

              lpszName = g_malloc (nLeng * sizeof (CHAR));
              if (GetLocaleInfoA (lcid, LOCALE_SLANGUAGE, lpszName, nLeng) > 0)
                {
                  avi_lang = g_realloc (avi_lang, (i + 2)
                                                    * sizeof (AviLanguage));
                  avi_lang[i].name = g_locale_to_utf8 (lpszName, -1,
                                                            NULL, NULL, NULL);
                  avi_lang[i].id = LANGIDFROMLCID (lcid);
                  avi_lang[i + 1].name = NULL;
                  avi_lang[i + 1].id = 0;
                }
              g_free (lpszName);
            }
        }
    }
  g_free (utf8str);
  return TRUE;
}
# endif /* GLIB_CHECK_VERSION(2,6,0) || ! defined (UNICODE) */
#else /* not G_OS_WIN32 */
# define AVI_MAKE_LANG_ID(p,s) ((((guint16)(s))<<10)|(guint16)(p))
# define AVI_LANG_MAIN_NEUTRAL                0x00
# define AVI_LANG_MAIN_AFRIKAANS              0x36
# define AVI_LANG_MAIN_ALBANIAN               0x1c
# define AVI_LANG_MAIN_ARABIC                 0x01
# define AVI_LANG_MAIN_ARMENIAN               0x2b
# define AVI_LANG_MAIN_ASSAMESE               0x4d
# define AVI_LANG_MAIN_AZERI                  0x2c
# define AVI_LANG_MAIN_BASQUE                 0x2d
# define AVI_LANG_MAIN_BENGALI                0x45
# define AVI_LANG_MAIN_BULGARIAN              0x02
# define AVI_LANG_MAIN_BYELORUSSIAN           0x23
# define AVI_LANG_MAIN_CATALAN                0x03
# define AVI_LANG_MAIN_CHINESE                0x04
# define AVI_LANG_MAIN_SERBO_CROATIAN         0x1a
# define AVI_LANG_MAIN_CROATIAN               AVI_LANG_MAIN_SERBO_CROATIAN
# define AVI_LANG_MAIN_SERBIAN                AVI_LANG_MAIN_SERBO_CROATIAN
# define AVI_LANG_MAIN_CZECH                  0x05
# define AVI_LANG_MAIN_DANISH                 0x06
# define AVI_LANG_MAIN_DUTCH                  0x13
# define AVI_LANG_MAIN_ENGLISH                0x09
# define AVI_LANG_MAIN_ESTONIAN               0x25
# define AVI_LANG_MAIN_FAEROESE               0x38
# define AVI_LANG_MAIN_FARSI                  0x29
# define AVI_LANG_MAIN_FINNISH                0x0b
# define AVI_LANG_MAIN_FRENCH                 0x0c
# define AVI_LANG_MAIN_GAELIC                 0x3c
# define AVI_LANG_MAIN_GEORGIAN               0x37
# define AVI_LANG_MAIN_GERMAN                 0x07
# define AVI_LANG_MAIN_GREEK                  0x08
# define AVI_LANG_MAIN_GUJARATI               0x47
# define AVI_LANG_MAIN_HEBREW                 0x0D
# define AVI_LANG_MAIN_HINDI                  0x39
# define AVI_LANG_MAIN_HUNGARIAN              0x0e
# define AVI_LANG_MAIN_ICELANDIC              0x0f
# define AVI_LANG_MAIN_INDONESIAN             0x21
# define AVI_LANG_MAIN_ITALIAN                0x10
# define AVI_LANG_MAIN_JAPANESE               0x11
# define AVI_LANG_MAIN_KANNADA                0x4b
# define AVI_LANG_MAIN_KAZAKH                 0x3f
# define AVI_LANG_MAIN_KONKANI                0x57
# define AVI_LANG_MAIN_KOREAN                 0x12
# define AVI_LANG_MAIN_LATVIAN                0x26
# define AVI_LANG_MAIN_LITHUANIAN             0x27
# define AVI_LANG_MAIN_MACEDONIAN             0x2f
# define AVI_LANG_MAIN_MALAY                  0x3e
# define AVI_LANG_MAIN_MALAYALAM              0x4c
# define AVI_LANG_MAIN_MALTESE                0x3a
# define AVI_LANG_MAIN_MAORI                  0x28
# define AVI_LANG_MAIN_MARATHI                0x4e
# define AVI_LANG_MAIN_NORWEGIAN              0x14
# define AVI_LANG_MAIN_ORIYA                  0x48
# define AVI_LANG_MAIN_POLISH                 0x15
# define AVI_LANG_MAIN_PORTUGUESE             0x16
# define AVI_LANG_MAIN_PUNJABI                0x46
# define AVI_LANG_MAIN_RHAETO_ROMANCE         0x17
# define AVI_LANG_MAIN_ROMANIAN               0x18
# define AVI_LANG_MAIN_RUSSIAN                0x19
# define AVI_LANG_MAIN_SAAMI                  0x3b
# define AVI_LANG_MAIN_SANSKRIT               0x4f
# define AVI_LANG_MAIN_SLOVAK                 0x1b
# define AVI_LANG_MAIN_SLOVENIAN              0x24
# define AVI_LANG_MAIN_SORBIAN                0x2e
# define AVI_LANG_MAIN_SPANISH                0x0a
# define AVI_LANG_MAIN_SUTU                   0x30
# define AVI_LANG_MAIN_SWAHILI                0x41
# define AVI_LANG_MAIN_SWEDISH                0x1d
# define AVI_LANG_MAIN_TAMIL                  0x49
# define AVI_LANG_MAIN_TATAR                  0x44
# define AVI_LANG_MAIN_TELUGU                 0x4a
# define AVI_LANG_MAIN_THAI                   0x1e
# define AVI_LANG_MAIN_TSONGA                 0x31
# define AVI_LANG_MAIN_TSWANA                 0x32
# define AVI_LANG_MAIN_TURKISH                0x1f
# define AVI_LANG_MAIN_UKRAINIAN              0x22
# define AVI_LANG_MAIN_URDU                   0x20
# define AVI_LANG_MAIN_UZBEK                  0x43
# define AVI_LANG_MAIN_VENDA                  0x33
# define AVI_LANG_MAIN_VIETNAMESE             0x2a
# define AVI_LANG_MAIN_XHOSA                  0x34
# define AVI_LANG_MAIN_ZULU                   0x35
# define AVI_LANG_MAIN_ESPERANTO              0x8f
# define AVI_LANG_MAIN_WALON                  0x90
# define AVI_LANG_MAIN_CORNISH                0x91
# define AVI_LANG_MAIN_WELSH                  0x92
# define AVI_LANG_MAIN_BRETON                 0x93
# define AVI_LANG_SUB_NEUTRAL                 0x00
# define AVI_LANG_SUB_DEFAULT                 0x01
# define AVI_LANG_SUB_SYS_DEFAULT             0x02
# define AVI_LANG_SUB_ARABIC                  0x01
# define AVI_LANG_SUB_ARABIC_SAUDI_ARABIA     0x01
# define AVI_LANG_SUB_ARABIC_IRAQ             0x02
# define AVI_LANG_SUB_ARABIC_EGYPT            0x03
# define AVI_LANG_SUB_ARABIC_LIBYA            0x04
# define AVI_LANG_SUB_ARABIC_ALGERIA          0x05
# define AVI_LANG_SUB_ARABIC_MOROCCO          0x06
# define AVI_LANG_SUB_ARABIC_TUNISIA          0x07
# define AVI_LANG_SUB_ARABIC_OMAN             0x08
# define AVI_LANG_SUB_ARABIC_YEMEN            0x09
# define AVI_LANG_SUB_ARABIC_SYRIA            0x0a
# define AVI_LANG_SUB_ARABIC_JORDAN           0x0b
# define AVI_LANG_SUB_ARABIC_LEBANON          0x0c
# define AVI_LANG_SUB_ARABIC_KUWAIT           0x0d
# define AVI_LANG_SUB_ARABIC_UAE              0x0e
# define AVI_LANG_SUB_ARABIC_BAHRAIN          0x0f
# define AVI_LANG_SUB_ARABIC_QATAR            0x10
# define AVI_LANG_SUB_CHINESE_TRADITIONAL     0x01
# define AVI_LANG_SUB_CHINESE_SIMPLIFIED      0x02
# define AVI_LANG_SUB_CHINESE_HONGKONG        0x03
# define AVI_LANG_SUB_CHINESE_SINGAPORE       0x04
# define AVI_LANG_SUB_CHINESE_MACAU           0x05
# define AVI_LANG_SUB_DUTCH                   0x01
# define AVI_LANG_SUB_DUTCH_BELGIAN           0x02
# define AVI_LANG_SUB_DUTCH_SURINAM           0x03
# define AVI_LANG_SUB_ENGLISH_US              0x01
# define AVI_LANG_SUB_ENGLISH_UK              0x02
# define AVI_LANG_SUB_ENGLISH_AUS             0x03
# define AVI_LANG_SUB_ENGLISH_CAN             0x04
# define AVI_LANG_SUB_ENGLISH_NZ              0x05
# define AVI_LANG_SUB_ENGLISH_EIRE            0x06
# define AVI_LANG_SUB_ENGLISH_SAFRICA         0x07
# define AVI_LANG_SUB_ENGLISH_JAMAICA         0x08
# define AVI_LANG_SUB_ENGLISH_CARRIBEAN       0x09
# define AVI_LANG_SUB_ENGLISH_BELIZE          0x0a
# define AVI_LANG_SUB_ENGLISH_TRINIDAD        0x0b
# define AVI_LANG_SUB_ENGLISH_ZIMBABWE        0x0c
# define AVI_LANG_SUB_ENGLISH_PHILIPPINES     0x0d
# define AVI_LANG_SUB_FRENCH                  0x01
# define AVI_LANG_SUB_FRENCH_BELGIAN          0x02
# define AVI_LANG_SUB_FRENCH_CANADIAN         0x03
# define AVI_LANG_SUB_FRENCH_SWISS            0x04
# define AVI_LANG_SUB_FRENCH_LUXEMBOURG       0x05
# define AVI_LANG_SUB_FRENCH_MONACO           0x06
# define AVI_LANG_SUB_GERMAN                  0x01
# define AVI_LANG_SUB_GERMAN_SWISS            0x02
# define AVI_LANG_SUB_GERMAN_AUSTRIAN         0x03
# define AVI_LANG_SUB_GERMAN_LUXEMBOURG       0x04
# define AVI_LANG_SUB_GERMAN_LIECHTENSTEIN    0x05
# define AVI_LANG_SUB_ITALIAN                 0x01
# define AVI_LANG_SUB_ITALIAN_SWISS           0x02
# define AVI_LANG_SUB_KOREAN                  0x01
# define AVI_LANG_SUB_KOREAN_JOHAB            0x02
# define AVI_LANG_SUB_NORWEGIAN_BOKMAL        0x01
# define AVI_LANG_SUB_NORWEGIAN_NYNORSK       0x02
# define AVI_LANG_SUB_PORTUGUESE              0x02
# define AVI_LANG_SUB_PORTUGUESE_BRAZILIAN    0x01
# define AVI_LANG_SUB_SPANISH                 0x01
# define AVI_LANG_SUB_SPANISH_MEXICAN         0x02
# define AVI_LANG_SUB_SPANISH_MODERN          0x03
# define AVI_LANG_SUB_SPANISH_GUATEMALA       0x04
# define AVI_LANG_SUB_SPANISH_COSTARICA       0x05
# define AVI_LANG_SUB_SPANISH_PANAMA          0x06
# define AVI_LANG_SUB_SPANISH_DOMINICAN       0x07
# define AVI_LANG_SUB_SPANISH_VENEZUELA       0x08
# define AVI_LANG_SUB_SPANISH_COLOMBIA        0x09
# define AVI_LANG_SUB_SPANISH_PERU            0x0a
# define AVI_LANG_SUB_SPANISH_ARGENTINA       0x0b
# define AVI_LANG_SUB_SPANISH_ECUADOR         0x0c
# define AVI_LANG_SUB_SPANISH_CHILE           0x0d
# define AVI_LANG_SUB_SPANISH_URUGUAY         0x0e
# define AVI_LANG_SUB_SPANISH_PARAGUAY        0x0f
# define AVI_LANG_SUB_SPANISH_BOLIVIA         0x10
# define AVI_LANG_SUB_SPANISH_EL_SALVADOR     0x11
# define AVI_LANG_SUB_SPANISH_HONDURAS        0x12
# define AVI_LANG_SUB_SPANISH_NICARAGUA       0x13
# define AVI_LANG_SUB_SPANISH_PUERTO_RICO     0x14
# define AVI_LANG_SUB_ROMANIAN                0x01
# define AVI_LANG_SUB_ROMANIAN_MOLDAVIA       0x02
# define AVI_LANG_SUB_RUSSIAN                 0x01
# define AVI_LANG_SUB_RUSSIAN_MOLDAVIA        0x02
# define AVI_LANG_SUB_CROATIAN                0x01
# define AVI_LANG_SUB_SERBIAN                 0x02
# define AVI_LANG_SUB_SERBIAN_LATIN           0x03
# define AVI_LANG_SUB_SWEDISH                 0x01
# define AVI_LANG_SUB_SWEDISH_FINLAND         0x02
# define AVI_LANG_SUB_LITHUANIAN              0x01
# define AVI_LANG_SUB_LITHUANIAN_CLASSIC      0x02
# define AVI_LANG_SUB_AZERI                   0x01
# define AVI_LANG_SUB_AZERI_CYRILLIC          0x02
# define AVI_LANG_SUB_GAELIC                  0x01
# define AVI_LANG_SUB_GAELIC_SCOTTISH         0x02
# define AVI_LANG_SUB_GAELIC_MANX             0x03
# define AVI_LANG_SUB_MALAY                   0x01
# define AVI_LANG_SUB_MALAY_BRUNEI_DARUSSALAM 0x02
# define AVI_LANG_SUB_UZBEK                   0x01
# define AVI_LANG_SUB_UZBEK_CYRILLIC          0x02
# define AVI_LANG_SUB_URDU_PAKISTAN           0x01
#endif /* not G_OS_WIN32 */


/*  ja:言語IDと名前を求める
    RET,言語IDと名前                                                        */
const AviLanguage *
avi_lang_get_struct (void)
{
  if (!avi_lang)
    {
#ifndef G_OS_WIN32
      const static AviLanguage lang[] = {
{N_("Neutral"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_NEUTRAL,        AVI_LANG_SUB_NEUTRAL)},
{N_("User Default"),               AVI_MAKE_LANG_ID (AVI_LANG_MAIN_NEUTRAL,        AVI_LANG_SUB_DEFAULT)},
{N_("System Default"),             AVI_MAKE_LANG_ID (AVI_LANG_MAIN_NEUTRAL,        AVI_LANG_SUB_SYS_DEFAULT)},
{N_("Afrikaans"),                  AVI_MAKE_LANG_ID (AVI_LANG_MAIN_AFRIKAANS,      AVI_LANG_SUB_DEFAULT)},
{N_("Albanian"),                   AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ALBANIAN,       AVI_LANG_SUB_DEFAULT)},
{N_("Arabic"),                     AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ARABIC,         AVI_LANG_SUB_ARABIC)},
{N_("Arabic (Saudi Arabia)"),      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ARABIC,         AVI_LANG_SUB_ARABIC_SAUDI_ARABIA)},
{N_("Arabic (Iraq)"),              AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ARABIC,         AVI_LANG_SUB_ARABIC_IRAQ)},
{N_("Arabic (Egypt)"),             AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ARABIC,         AVI_LANG_SUB_ARABIC_EGYPT)},
{N_("Arabic (Libya)"),             AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ARABIC,         AVI_LANG_SUB_ARABIC_LIBYA)},
{N_("Arabic (Algeria)"),           AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ARABIC,         AVI_LANG_SUB_ARABIC_ALGERIA)},
{N_("Arabic (Morocco)"),           AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ARABIC,         AVI_LANG_SUB_ARABIC_MOROCCO)},
{N_("Arabic (Tunisia)"),           AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ARABIC,         AVI_LANG_SUB_ARABIC_TUNISIA)},
{N_("Arabic (Oman)"),              AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ARABIC,         AVI_LANG_SUB_ARABIC_OMAN)},
{N_("Arabic (Yemen)"),             AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ARABIC,         AVI_LANG_SUB_ARABIC_YEMEN)},
{N_("Arabic (Syria)"),             AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ARABIC,         AVI_LANG_SUB_ARABIC_SYRIA)},
{N_("Arabic (Jordan)"),            AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ARABIC,         AVI_LANG_SUB_ARABIC_JORDAN)},
{N_("Arabic (Lebanon)"),           AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ARABIC,         AVI_LANG_SUB_ARABIC_LEBANON)},
{N_("Arabic (Kuwait)"),            AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ARABIC,         AVI_LANG_SUB_ARABIC_KUWAIT)},
{N_("Arabic (UAE)"),               AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ARABIC,         AVI_LANG_SUB_ARABIC_UAE)},
{N_("Arabic (Bahrain)"),           AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ARABIC,         AVI_LANG_SUB_ARABIC_BAHRAIN)},
{N_("Arabic (Qatar)"),             AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ARABIC,         AVI_LANG_SUB_ARABIC_QATAR)},
{N_("Armenian"),                   AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ARMENIAN,       AVI_LANG_SUB_DEFAULT)},
{N_("Assamese"),                   AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ASSAMESE,       AVI_LANG_SUB_DEFAULT)},
{N_("Azeri"),                      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_AZERI,          AVI_LANG_SUB_AZERI)},
{N_("Azeri (Cyrillic)"),           AVI_MAKE_LANG_ID (AVI_LANG_MAIN_AZERI,          AVI_LANG_SUB_AZERI_CYRILLIC)},
{N_("Basque"),                     AVI_MAKE_LANG_ID (AVI_LANG_MAIN_BASQUE,         AVI_LANG_SUB_DEFAULT)},
{N_("Bengali"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_BENGALI,        AVI_LANG_SUB_DEFAULT)},
{N_("Bulgarian"),                  AVI_MAKE_LANG_ID (AVI_LANG_MAIN_BULGARIAN,      AVI_LANG_SUB_DEFAULT)},
{N_("Byelorussian"),               AVI_MAKE_LANG_ID (AVI_LANG_MAIN_BYELORUSSIAN,   AVI_LANG_SUB_DEFAULT)},
{N_("Catalan"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_CATALAN,        AVI_LANG_SUB_DEFAULT)},
{N_("Chinese (Traditional)"),      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_CHINESE,        AVI_LANG_SUB_CHINESE_TRADITIONAL)},
{N_("Chinese (Simplified)"),       AVI_MAKE_LANG_ID (AVI_LANG_MAIN_CHINESE,        AVI_LANG_SUB_CHINESE_SIMPLIFIED)},
{N_("Chinese (HongKong)"),         AVI_MAKE_LANG_ID (AVI_LANG_MAIN_CHINESE,        AVI_LANG_SUB_CHINESE_HONGKONG)},
{N_("Chinese (Singapore)"),        AVI_MAKE_LANG_ID (AVI_LANG_MAIN_CHINESE,        AVI_LANG_SUB_CHINESE_SINGAPORE)},
{N_("Chinese (Macau)"),            AVI_MAKE_LANG_ID (AVI_LANG_MAIN_CHINESE,        AVI_LANG_SUB_CHINESE_MACAU)},
{N_("Croatian"),                   AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SERBO_CROATIAN, AVI_LANG_SUB_CROATIAN)},
{N_("Serbian"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SERBO_CROATIAN, AVI_LANG_SUB_SERBIAN)},
{N_("Serbian (Latin)"),            AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SERBO_CROATIAN, AVI_LANG_SUB_SERBIAN_LATIN)},
{N_("Czech"),                      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_CZECH,          AVI_LANG_SUB_DEFAULT)},
{N_("Danish"),                     AVI_MAKE_LANG_ID (AVI_LANG_MAIN_DANISH,         AVI_LANG_SUB_DEFAULT)},
{N_("Dutch"),                      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_DUTCH,          AVI_LANG_SUB_DUTCH)},
{N_("Dutch (Belgian)"),            AVI_MAKE_LANG_ID (AVI_LANG_MAIN_DUTCH,          AVI_LANG_SUB_DUTCH_BELGIAN)},
{N_("Dutch (Surinam)"),            AVI_MAKE_LANG_ID (AVI_LANG_MAIN_DUTCH,          AVI_LANG_SUB_DUTCH_SURINAM)},
{N_("English (US)"),               AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ENGLISH,        AVI_LANG_SUB_ENGLISH_US)},
{N_("English (UK)"),               AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ENGLISH,        AVI_LANG_SUB_ENGLISH_UK)},
{N_("English (Australia)"),        AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ENGLISH,        AVI_LANG_SUB_ENGLISH_AUS)},
{N_("English (Canada)"),           AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ENGLISH,        AVI_LANG_SUB_ENGLISH_CAN)},
{N_("English (New Zealand)"),      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ENGLISH,        AVI_LANG_SUB_ENGLISH_NZ)},
{N_("English (Ireland)"),          AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ENGLISH,        AVI_LANG_SUB_ENGLISH_EIRE)},
{N_("English (South Africa)"),     AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ENGLISH,        AVI_LANG_SUB_ENGLISH_SAFRICA)},
{N_("English (Jamaica)"),          AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ENGLISH,        AVI_LANG_SUB_ENGLISH_JAMAICA)},
{N_("English (Carribean)"),        AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ENGLISH,        AVI_LANG_SUB_ENGLISH_CARRIBEAN)},
{N_("English (Belize)"),           AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ENGLISH,        AVI_LANG_SUB_ENGLISH_BELIZE)},
{N_("English (Trinidad)"),         AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ENGLISH,        AVI_LANG_SUB_ENGLISH_TRINIDAD)},
{N_("English (Zimbabwe)"),         AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ENGLISH,        AVI_LANG_SUB_ENGLISH_ZIMBABWE)},
{N_("English (Philippines)"),      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ENGLISH,        AVI_LANG_SUB_ENGLISH_PHILIPPINES)},
{N_("Estonian"),                   AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ESTONIAN,       AVI_LANG_SUB_DEFAULT)},
{N_("Faeroese"),                   AVI_MAKE_LANG_ID (AVI_LANG_MAIN_FAEROESE,       AVI_LANG_SUB_DEFAULT)},
{N_("Farsi"),                      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_FARSI,          AVI_LANG_SUB_DEFAULT)},
{N_("Finnish"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_FINNISH,        AVI_LANG_SUB_DEFAULT)},
{N_("French"),                     AVI_MAKE_LANG_ID (AVI_LANG_MAIN_FRENCH,         AVI_LANG_SUB_FRENCH)},
{N_("French (Belgian)"),           AVI_MAKE_LANG_ID (AVI_LANG_MAIN_FRENCH,         AVI_LANG_SUB_FRENCH_BELGIAN)},
{N_("French (Canadian)"),          AVI_MAKE_LANG_ID (AVI_LANG_MAIN_FRENCH,         AVI_LANG_SUB_FRENCH_CANADIAN)},
{N_("French (Swiss)"),             AVI_MAKE_LANG_ID (AVI_LANG_MAIN_FRENCH,         AVI_LANG_SUB_FRENCH_SWISS)},
{N_("French (Luxembourg)"),        AVI_MAKE_LANG_ID (AVI_LANG_MAIN_FRENCH,         AVI_LANG_SUB_FRENCH_LUXEMBOURG)},
{N_("French (Monaco)"),            AVI_MAKE_LANG_ID (AVI_LANG_MAIN_FRENCH,         AVI_LANG_SUB_FRENCH_MONACO)},
{N_("Gaelic"),                     AVI_MAKE_LANG_ID (AVI_LANG_MAIN_GAELIC,         AVI_LANG_SUB_GAELIC)},
{N_("Gaelic (Scottish)"),          AVI_MAKE_LANG_ID (AVI_LANG_MAIN_GAELIC,         AVI_LANG_SUB_GAELIC_SCOTTISH)},
{N_("Gaelic (Manx)"),              AVI_MAKE_LANG_ID (AVI_LANG_MAIN_GAELIC,         AVI_LANG_SUB_GAELIC_MANX)},
{N_("Georgian"),                   AVI_MAKE_LANG_ID (AVI_LANG_MAIN_GEORGIAN,       AVI_LANG_SUB_DEFAULT)},
{N_("German"),                     AVI_MAKE_LANG_ID (AVI_LANG_MAIN_GERMAN,         AVI_LANG_SUB_GERMAN)},
{N_("German (Swiss)"),             AVI_MAKE_LANG_ID (AVI_LANG_MAIN_GERMAN,         AVI_LANG_SUB_GERMAN_SWISS)},
{N_("German (Austrian)"),          AVI_MAKE_LANG_ID (AVI_LANG_MAIN_GERMAN,         AVI_LANG_SUB_GERMAN_AUSTRIAN)},
{N_("German (Luxembourg)"),        AVI_MAKE_LANG_ID (AVI_LANG_MAIN_GERMAN,         AVI_LANG_SUB_GERMAN_LUXEMBOURG)},
{N_("German (Liechtenstein)"),     AVI_MAKE_LANG_ID (AVI_LANG_MAIN_GERMAN,         AVI_LANG_SUB_GERMAN_LIECHTENSTEIN)},
{N_("Greek"),                      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_GREEK,          AVI_LANG_SUB_DEFAULT)},
{N_("Gujarati"),                   AVI_MAKE_LANG_ID (AVI_LANG_MAIN_GUJARATI,       AVI_LANG_SUB_DEFAULT)},
{N_("Hebrew"),                     AVI_MAKE_LANG_ID (AVI_LANG_MAIN_HEBREW,         AVI_LANG_SUB_DEFAULT)},
{N_("Hindi"),                      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_HINDI,          AVI_LANG_SUB_DEFAULT)},
{N_("Hungarian"),                  AVI_MAKE_LANG_ID (AVI_LANG_MAIN_HUNGARIAN,      AVI_LANG_SUB_DEFAULT)},
{N_("Icelandic"),                  AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ICELANDIC,      AVI_LANG_SUB_DEFAULT)},
{N_("Indonesian"),                 AVI_MAKE_LANG_ID (AVI_LANG_MAIN_INDONESIAN,     AVI_LANG_SUB_DEFAULT)},
{N_("Italian"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ITALIAN,        AVI_LANG_SUB_ITALIAN)},
{N_("Italian (Swiss)"),            AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ITALIAN,        AVI_LANG_SUB_ITALIAN_SWISS)},
{N_("Japanese"),                   AVI_MAKE_LANG_ID (AVI_LANG_MAIN_JAPANESE,       AVI_LANG_SUB_DEFAULT)},
{N_("Kannada"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_KANNADA,        AVI_LANG_SUB_DEFAULT)},
{N_("Kazakh"),                     AVI_MAKE_LANG_ID (AVI_LANG_MAIN_KAZAKH,         AVI_LANG_SUB_DEFAULT)},
{N_("Konkani"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_KONKANI,        AVI_LANG_SUB_DEFAULT)},
{N_("Korean"),                     AVI_MAKE_LANG_ID (AVI_LANG_MAIN_KOREAN,         AVI_LANG_SUB_KOREAN)},
{N_("Korean (Johab)"),             AVI_MAKE_LANG_ID (AVI_LANG_MAIN_KOREAN,         AVI_LANG_SUB_KOREAN_JOHAB)},
{N_("Latvian"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_LATVIAN,        AVI_LANG_SUB_DEFAULT)},
{N_("Lithuanian"),                 AVI_MAKE_LANG_ID (AVI_LANG_MAIN_LITHUANIAN,     AVI_LANG_SUB_LITHUANIAN)},
{N_("Lithuanian (Classic)"),       AVI_MAKE_LANG_ID (AVI_LANG_MAIN_LITHUANIAN,     AVI_LANG_SUB_LITHUANIAN_CLASSIC)},
{N_("Macedonian"),                 AVI_MAKE_LANG_ID (AVI_LANG_MAIN_MACEDONIAN,     AVI_LANG_SUB_DEFAULT)},
{N_("Malay"),                      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_MALAY,          AVI_LANG_SUB_MALAY)},
{N_("Malay (Brunbei Darussalam)"), AVI_MAKE_LANG_ID (AVI_LANG_MAIN_MALAY,          AVI_LANG_SUB_MALAY_BRUNEI_DARUSSALAM)},
{N_("Malayalam"),                  AVI_MAKE_LANG_ID (AVI_LANG_MAIN_MALAYALAM,      AVI_LANG_SUB_DEFAULT)},
{N_("Maltese"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_MALTESE,        AVI_LANG_SUB_DEFAULT)},
{N_("Maori"),                      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_MAORI,          AVI_LANG_SUB_DEFAULT)},
{N_("Marathi"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_MARATHI,        AVI_LANG_SUB_DEFAULT)},
{N_("Norwegian"),                  AVI_MAKE_LANG_ID (AVI_LANG_MAIN_NORWEGIAN,      AVI_LANG_SUB_NORWEGIAN_BOKMAL)},
{N_("Norwegian (Nynorsk)"),        AVI_MAKE_LANG_ID (AVI_LANG_MAIN_NORWEGIAN,      AVI_LANG_SUB_NORWEGIAN_NYNORSK)},
{N_("Oriya"),                      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ORIYA,          AVI_LANG_SUB_DEFAULT)},
{N_("Polish"),                     AVI_MAKE_LANG_ID (AVI_LANG_MAIN_POLISH,         AVI_LANG_SUB_DEFAULT)},
{N_("Portuguese"),                 AVI_MAKE_LANG_ID (AVI_LANG_MAIN_PORTUGUESE,     AVI_LANG_SUB_PORTUGUESE)},
{N_("Portuguese (Brazilian)"),     AVI_MAKE_LANG_ID (AVI_LANG_MAIN_PORTUGUESE,     AVI_LANG_SUB_PORTUGUESE_BRAZILIAN)},
{N_("Punjabi"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_PUNJABI,        AVI_LANG_SUB_DEFAULT)},
{N_("Rhaeto Romance"),             AVI_MAKE_LANG_ID (AVI_LANG_MAIN_RHAETO_ROMANCE, AVI_LANG_SUB_DEFAULT)},
{N_("Romanian"),                   AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ROMANIAN,       AVI_LANG_SUB_ROMANIAN)},
{N_("Romanian (Moldavia)"),        AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ROMANIAN,       AVI_LANG_SUB_ROMANIAN_MOLDAVIA)},
{N_("Russian"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_RUSSIAN,        AVI_LANG_SUB_RUSSIAN)},
{N_("Russian (Moldavia)"),         AVI_MAKE_LANG_ID (AVI_LANG_MAIN_RUSSIAN,        AVI_LANG_SUB_RUSSIAN_MOLDAVIA)},
{N_("Saami"),                      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SAAMI,          AVI_LANG_SUB_DEFAULT)},
{N_("Sanskrit"),                   AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SANSKRIT,       AVI_LANG_SUB_DEFAULT)},
{N_("Slovak"),                     AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SLOVAK,         AVI_LANG_SUB_DEFAULT)},
{N_("Slovenian"),                  AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SLOVENIAN,      AVI_LANG_SUB_DEFAULT)},
{N_("Sorbian"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SORBIAN,        AVI_LANG_SUB_DEFAULT)},
{N_("Spanish"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH)},
{N_("Spanish (Mexican)"),          AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_MEXICAN)},
{N_("Spanish (Modern)"),           AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_MODERN)},
{N_("Spanish (Guatemala)"),        AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_GUATEMALA)},
{N_("Spanish (Costarica)"),        AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_COSTARICA)},
{N_("Spanish (Panama)"),           AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_PANAMA)},
{N_("Spanish (Dominican)"),        AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_DOMINICAN)},
{N_("Spanish (Venezuela)"),        AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_VENEZUELA)},
{N_("Spanish (Colombia)"),         AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_COLOMBIA)},
{N_("Spanish (Peru)"),             AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_PERU)},
{N_("Spanish (Argentina)"),        AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_ARGENTINA)},
{N_("Spanish (Ecuador)"),          AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_ECUADOR)},
{N_("Spanish (Chile)"),            AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_CHILE)},
{N_("Spanish (Uruguay)"),          AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_URUGUAY)},
{N_("Spanish (Paraguay)"),         AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_PARAGUAY)},
{N_("Spanish (Bolivia)"),          AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_BOLIVIA)},
{N_("Spanish (El Salvador)"),      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_EL_SALVADOR)},
{N_("Spanish (Honduras)"),         AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_HONDURAS)},
{N_("Spanish (Nicaragua)"),        AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_NICARAGUA)},
{N_("Spanish (Puerto Rico)"),      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SPANISH,        AVI_LANG_SUB_SPANISH_PUERTO_RICO)},
{N_("Sutu"),                       AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SUTU,           AVI_LANG_SUB_DEFAULT)},
{N_("Swahili"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SWAHILI,        AVI_LANG_SUB_DEFAULT)},
{N_("Swedish"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SWEDISH,        AVI_LANG_SUB_SWEDISH)},
{N_("Swedish (Finland)"),          AVI_MAKE_LANG_ID (AVI_LANG_MAIN_SWEDISH,        AVI_LANG_SUB_SWEDISH_FINLAND)},
{N_("Tamil"),                      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_TAMIL,          AVI_LANG_SUB_DEFAULT)},
{N_("Tatar"),                      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_TATAR,          AVI_LANG_SUB_DEFAULT)},
{N_("Telugu"),                     AVI_MAKE_LANG_ID (AVI_LANG_MAIN_TELUGU,         AVI_LANG_SUB_DEFAULT)},
{N_("Thai"),                       AVI_MAKE_LANG_ID (AVI_LANG_MAIN_THAI,           AVI_LANG_SUB_DEFAULT)},
{N_("Tsonga"),                     AVI_MAKE_LANG_ID (AVI_LANG_MAIN_TSONGA,         AVI_LANG_SUB_DEFAULT)},
{N_("Tswana"),                     AVI_MAKE_LANG_ID (AVI_LANG_MAIN_TSWANA,         AVI_LANG_SUB_DEFAULT)},
{N_("Turkish"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_TURKISH,        AVI_LANG_SUB_DEFAULT)},
{N_("Ukrainian"),                  AVI_MAKE_LANG_ID (AVI_LANG_MAIN_UKRAINIAN,      AVI_LANG_SUB_DEFAULT)},
{N_("Urdu"),                       AVI_MAKE_LANG_ID (AVI_LANG_MAIN_URDU,           AVI_LANG_SUB_URDU_PAKISTAN)},
{N_("Uzbek"),                      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_UZBEK,          AVI_LANG_SUB_UZBEK)},
{N_("Uzbek (Cyrillic)"),           AVI_MAKE_LANG_ID (AVI_LANG_MAIN_UZBEK,          AVI_LANG_SUB_UZBEK_CYRILLIC)},
{N_("Venda"),                      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_VENDA,          AVI_LANG_SUB_DEFAULT)},
{N_("Vietnamese"),                 AVI_MAKE_LANG_ID (AVI_LANG_MAIN_VIETNAMESE,     AVI_LANG_SUB_DEFAULT)},
{N_("Xhosa"),                      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_XHOSA,          AVI_LANG_SUB_DEFAULT)},
{N_("Zulu"),                       AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ZULU,           AVI_LANG_SUB_DEFAULT)},
{N_("Esperanto"),                  AVI_MAKE_LANG_ID (AVI_LANG_MAIN_ESPERANTO,      AVI_LANG_SUB_DEFAULT)},
{N_("Walon"),                      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_WALON,          AVI_LANG_SUB_DEFAULT)},
{N_("Cornish"),                    AVI_MAKE_LANG_ID (AVI_LANG_MAIN_CORNISH,        AVI_LANG_SUB_DEFAULT)},
{N_("Welsh"),                      AVI_MAKE_LANG_ID (AVI_LANG_MAIN_WELSH,          AVI_LANG_SUB_DEFAULT)},
{N_("Breton"),                     AVI_MAKE_LANG_ID (AVI_LANG_MAIN_BRETON,         AVI_LANG_SUB_DEFAULT)},
{NULL,                             0}};
#endif /* not G_OS_WIN32 */
      gint i;

#ifdef G_OS_WIN32
      avi_lang = g_malloc (sizeof (AviLanguage) * 4);
      avi_lang[0].name = g_strdup (_("Neutral"));
      avi_lang[0].id = MAKELANGID (LANG_NEUTRAL, SUBLANG_NEUTRAL);
      avi_lang[1].name = g_strdup (_("User Default"));
      avi_lang[1].id = MAKELANGID (LANG_NEUTRAL, SUBLANG_DEFAULT);
      avi_lang[2].name = g_strdup (_("System Default"));
      avi_lang[2].id = MAKELANGID (LANG_NEUTRAL, SUBLANG_SYS_DEFAULT);
      avi_lang[3].name = NULL;
      avi_lang[3].id = 0;
# if GLIB_CHECK_VERSION(2,6,0)
      if (G_WIN32_HAVE_WIDECHAR_API ())
# endif /* GLIB_CHECK_VERSION(2,6,0) */
# if GLIB_CHECK_VERSION(2,6,0) || defined (UNICODE)
        EnumSystemLocalesW (EnumLocaleProcW, LCID_SUPPORTED);
# endif /* GLIB_CHECK_VERSION(2,6,0) || defined (UNICODE) */
# if GLIB_CHECK_VERSION(2,6,0)
      else
# endif /* GLIB_CHECK_VERSION(2,6,0) */
# if GLIB_CHECK_VERSION(2,6,0) || ! defined (UNICODE)
        EnumSystemLocalesA (EnumLocaleProcA, LCID_SUPPORTED);
# endif /* GLIB_CHECK_VERSION(2,6,0) || ! defined (UNICODE) */
#else /* not G_OS_WIN32 */
      for (i = 0; lang[i].name; i++);
      avi_lang = g_malloc ((i + 1) * sizeof (AviLanguage));
      for (i = 0; lang[i].name; i++)
        {
          avi_lang[i].name = g_strdup (_(lang[i].name));
          avi_lang[i].id = lang[i].id;
        }
      avi_lang[i].name = NULL;
      avi_lang[i].id = 0;
#endif /* not G_OS_WIN32 */
      /* ja:ソート */
      for (i = 4; avi_lang[i].name; i++)
        {
          gint j;
          const gchar *name;
          guint16 id;

          name = avi_lang[i].name;
          id = avi_lang[i].id;
          for (j = i - 1; j >= 3 && g_strcmp (avi_lang[j].name, name) > 0; j--)
            avi_lang[j + 1] = avi_lang[j];
          avi_lang[j + 1].name = name;
          avi_lang[j + 1].id = id;
        }
    }
  return avi_lang;
}


/*  ja:言語IDから名前を求める
     ID,言語ID
    RET,名前                                                                */
const gchar *
avi_lang_get_name (const guint16 id)
{
  const AviLanguage *lang;

  lang = avi_lang_get_struct ();
  if (lang)
    {
      gint i;

      for (i = 0; lang[i].name; i++)
        if (lang[i].id == id)
          return lang[i].name;
    }
  return NULL;
}
