/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __W32MENU_H__
#define __W32MENU_H__


#include "user32.h"


/* ja:メニュー */
#define MF_INSERT          0x00000000
#define MF_CHANGE          0x00000080
#define MF_APPEND          0x00000100
#define MF_DELETE          0x00000200
#define MF_REMOVE          0x00001000
#define MF_BYCOMMAND       0x00000000
#define MF_BYPOSITION      0x00000400
#define MF_SEPARATOR       0x00000800
#define MF_ENABLED         0x00000000
#define MF_GRAYED          0x00000001
#define MF_DISABLED        0x00000002
#define MF_UNCHECKED       0x00000000
#define MF_CHECKED         0x00000008
#define MF_USECHECKBITMAPS 0x00000200
#define MF_STRING          0x00000000
#define MF_BITMAP          0x00000004
#define MF_OWNERDRAW       0x00000100
#define MF_POPUP           0x00000010
#define MF_MENUBARBREAK    0x00000020
#define MF_MENUBREAK       0x00000040
#define MF_UNHILITE        0x00000000
#define MF_HILITE          0x00000080
#define MF_DEFAULT         0x00001000
#define MF_SYSMENU         0x00002000
#define MF_HELP            0x00004000
#define MF_RIGHTJUSTIFY    0x00004000
#define MF_MOUSESELECT     0x00008000
#define MF_END             0x00000080
#define MFS_GRAYED        0x00000003
#define MFS_DISABLED      MFS_GRAYED
#define MFS_CHECKED       MF_CHECKED
#define MFS_HILITE        MF_HILITE
#define MFS_ENABLED       MF_ENABLED
#define MFS_UNCHECKED     MF_UNCHECKED
#define MFS_UNHILITE      MF_UNHILITE
#define MFS_DEFAULT       MF_DEFAULT
#define MFS_MASK          0x0000108b
#define MFS_HOTTRACKDRAWN 0x10000000
#define MFS_CACHEDBMP     0x20000000
#define MFS_BOTTOMGAPDROP 0x40000000
#define MFS_TOPGAPDROP    0x80000000
#define MFS_GAPDROP       0xc0000000
#define MFT_STRING       MF_STRING
#define MFT_BITMAP       MF_BITMAP
#define MFT_MENUBARBREAK MF_MENUBARBREAK
#define MFT_MENUBREAK    MF_MENUBREAK
#define MFT_OWNERDRAW    MF_OWNERDRAW
#define MFT_RADIOCHECK   0x00000200
#define MFT_SEPARATOR    MF_SEPARATOR
#define MFT_RIGHTORDER   0x00002000
#define MFT_RIGHTJUSTIFY MF_RIGHTJUSTIFY
#define MIIM_STATE      0x00000001
#define MIIM_ID         0x00000002
#define MIIM_SUBMENU    0x00000004
#define MIIM_CHECKMARKS 0x00000008
#define MIIM_TYPE       0x00000010
#define MIIM_DATA       0x00000020
#define MIIM_STRING     0x00000040
#define MIIM_BITMAP     0x00000080
#define MIIM_FTYPE      0x00000100
#define TPM_LEFTBUTTON   0x0000
#define TPM_RIGHTBUTTON  0x0002
#define TPM_LEFTALIGN    0x0000
#define TPM_CENTERALIGN  0x0004
#define TPM_RIGHTALIGN   0x0008
#define TPM_TOPALIGN     0x0000
#define TPM_VCENTERALIGN 0x0010
#define TPM_BOTTOMALIGN  0x0020
#define TPM_HORIZONTAL   0x0000
#define TPM_VERTICAL     0x0040
#define TPM_RETURNCMD    0x0100
typedef GtkWidget *HMENU;
typedef WORD MENUTEMPLATE;
typedef PWORD PMENUTEMPLATE;
typedef LPWORD LPMENUTEMPLATE;
typedef CONST PWORD PCMENUTEMPLATE;
typedef CONST LPWORD LPCMENUTEMPLATE;
#include "pshpack1.h"
typedef struct _MENUITEMTEMPLATEHEADER
{
  WORD versionNumber;
  WORD offset;
} MENUITEMTEMPLATEHEADER, *PMENUITEMTEMPLATEHEADER, *LPMENUITEMTEMPLATEHEADER;
typedef struct _MENUITEMTEMPLATE
{
  WORD mtOption;
  WORD mtID;
  WCHAR mtString[1];
} MENUITEMTEMPLATE, *PMENUITEMTEMPLATE, *LPMENUITEMTEMPLATE;
typedef struct _MENUEX_TEMPLATE_HEADER
{
  WORD wVersion;
  WORD wOffset;
  DWORD dwHelpId;
} MENUEX_TEMPLATE_HEADER, *PMENUEX_TEMPLATE_HEADER, *LPMENUEX_TEMPLATE_HEADER;
typedef struct _MENUEX_TEMPLATE_ITEM
{
  DWORD dwType;
  DWORD dwState;
  UINT uId;
  WORD bResInfo;
  WCHAR szText[1];
  DWORD dwHelpId;
} MENUEX_TEMPLATE_ITEM, *PMENUEX_TEMPLATE_ITEM, *LPMENUEX_TEMPLATE_ITEM;
typedef struct _MENUITEMINFOA
{
  UINT cbSize;
  UINT fMask;
  UINT fType;
  UINT fState;
  UINT wID;
  HMENU hSubMenu;
  HBITMAP hbmpChecked;
  HBITMAP hbmpUnchecked;
  ULONG_PTR dwItemData;
  LPSTR dwTypeData;
  UINT cch;
  HBITMAP hbmpItem;
} MENUITEMINFOA, *PMENUITEMINFOA, *LPMENUITEMINFOA;
typedef struct _MENUITEMINFOW
{
  UINT cbSize;
  UINT fMask;
  UINT fType;
  UINT fState;
  UINT wID;
  HMENU hSubMenu;
  HBITMAP hbmpChecked;
  HBITMAP hbmpUnchecked;
  ULONG_PTR dwItemData;
  LPWSTR dwTypeData;
  UINT cch;
  HBITMAP hbmpItem;
} MENUITEMINFOW, *PMENUITEMINFOW, *LPMENUITEMINFOW;
#include "poppack.h"
#ifdef UNICODE
# define MENUITEMINFO MENUITEMINFOW
# define PMENUITEMINFO PMENUITEMINFOW
# define LPMENUITEMINFO LPMENUITEMINFOW
#else /* not UNICODE */
# define MENUITEMINFO MENUITEMINFOA
# define PMENUITEMINFO PMENUITEMINFOA
# define LPMENUITEMINFO LPMENUITEMINFOA
#endif /* not UNICODE */
#include "pshpack1.h"
typedef struct _TPMPARAMS
{
  UINT cbSize;
  RECT rcExclude;
} TPMPARAMS, *PTPMPARAMS, *LPTPMPARAMS;
#include "poppack.h"


#endif /* not __W32MENU_H__ */
