/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __KERNEL32_H__
#define __KERNEL32_H__


#include "w32ldr.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#include "misc/fileio.h"

/* ja:一般 */
#define MAX_PATH 260
#define INVALID_HANDLE_VALUE (GINT_TO_POINTER(-1))
#define DONT_RESOLVE_DLL_REFERENCES   0x00000001
#define LOAD_LIBRARY_AS_DATAFILE      0x00000002
#define LOAD_WITH_ALTERED_SEARCH_PATH 0x00000008
typedef LPVOID LPCRITICAL_SECTION;
typedef INT CALLBACK (*FARPROC)();

/* ja:ウエイト */
#define WAIT_FAILED      0xffffffff
#define WAIT_OBJECT_0    0x00000000
#define WAIT_ABANDONED   0x00000080
#define WAIT_ABANDONED_0 WAIT_ABANDONED
#define WAIT_TIMEOUT     0x00000102
#define INFINITE         0xffffffff

/* ja:プロセス */
#include "pshpack1.h"
typedef struct _PROCESS_INFORMATION
{
  HANDLE hProcess;
  HANDLE hThread;
  DWORD dwProcessId;
  DWORD dwThreadId;
} PROCESS_INFORMATION, *PPROCESS_INFORMATION, *LPPROCESS_INFORMATION;
#include "poppack.h"
#define FOREGROUND_BLUE      0x0001
#define FOREGROUND_GREEN     0x0002
#define FOREGROUND_RED       0x0004
#define FOREGROUND_INTENSITY 0x0008
#define BACKGROUND_BLUE      0x0010
#define BACKGROUND_GREEN     0x0020
#define BACKGROUND_RED       0x0040
#define BACKGROUND_INTENSITY 0x0080
#define STARTF_USESHOWWINDOW    0x00000001
#define STARTF_USESIZE          0x00000002
#define STARTF_USEPOSITION      0x00000004
#define STARTF_USECOUNTCHARS    0x00000008
#define STARTF_USEFILLATTRIBUTE 0x00000010
#define STARTF_RUNFULLSCREEN    0x00000020
#define STARTF_FORCEONFEEDBACK  0x00000040
#define STARTF_FORCEOFFFEEDBACK 0x00000080
#define STARTF_USESTDHANDLES    0x00000100
#define STARTF_USEHOTKEY        0x00000200
#include "pshpack1.h"
typedef struct _STARTUPINFOA
{
  DWORD cb;
  LPSTR lpReserved;
  LPSTR lpDesktop;
  LPSTR lpTitle;
  DWORD dwX;
  DWORD dwY;
  DWORD dwXSize;
  DWORD dwYSize;
  DWORD dwXCountChars;
  DWORD dwYCountChars;
  DWORD dwFillAttribute;
  DWORD dwFlags;
  WORD wShowWindow;
  WORD cbReserved2;
  BYTE *lpReserved2;
  HANDLE hStdInput;
  HANDLE hStdOutput;
  HANDLE hStdError;
} STARTUPINFOA, *LPSTARTUPINFOA;
typedef struct _STARTUPINFOW
{
  DWORD cb;
  LPWSTR lpReserved;
  LPWSTR lpDesktop;
  LPWSTR lpTitle;
  DWORD dwX;
  DWORD dwY;
  DWORD dwXSize;
  DWORD dwYSize;
  DWORD dwXCountChars;
  DWORD dwYCountChars;
  DWORD dwFillAttribute;
  DWORD dwFlags;
  WORD wShowWindow;
  WORD cbReserved2;
  BYTE *lpReserved2;
  HANDLE hStdInput;
  HANDLE hStdOutput;
  HANDLE hStdError;
} STARTUPINFOW, *LPSTARTUPINFOW;
#include "poppack.h"
#ifdef UNICODE
# define STARTUPINFO STARTUPINFOW
# define LPSTARTUPINFO LPSTARTUPINFOW
#else /* not UNICODE */
# define STARTUPINFO STARTUPINFOA
# define LPSTARTUPINFO LPSTARTUPINFOA
#endif /* not UNICODE */

/* ja:スレッド */
#define THREAD_BASE_PRIORITY_LOWRT 15
#define THREAD_BASE_PRIORITY_MAX   2
#define THREAD_BASE_PRIORITY_MIN   (-2)
#define THREAD_BASE_PRIORITY_IDLE  (-15)
#define THREAD_PRIORITY_LOWEST        THREAD_BASE_PRIORITY_MIN
#define THREAD_PRIORITY_BELOW_NORMAL  (THREAD_PRIORITY_LOWEST+1)
#define THREAD_PRIORITY_NORMAL        0
#define THREAD_PRIORITY_HIGHEST       THREAD_BASE_PRIORITY_MAX
#define THREAD_PRIORITY_ABOVE_NORMAL  (THREAD_PRIORITY_HIGHEST-1)
#define THREAD_PRIORITY_ERROR_RETURN  (0x7fffffff)
#define THREAD_PRIORITY_TIME_CRITICAL THREAD_BASE_PRIORITY_LOWRT
#define THREAD_PRIORITY_IDLE          THREAD_BASE_PRIORITY_IDLE

/* ja:メモリ */
#define GMEM_FIXED          0x0000
#define GMEM_MOVEABLE       0x0002
#define GMEM_NOCOMPACT      0x0010
#define GMEM_NODISCARD      0x0020
#define GMEM_ZEROINIT       0x0040
#define GMEM_MODIFY         0x0080
#define GMEM_DISCARDABLE    0x0100
#define GMEM_NOT_BANKED     0x1000
#define GMEM_SHARE          0x2000
#define GMEM_DDESHARE       0x2000
#define GMEM_NOTIFY         0x4000
#define GMEM_LOWER          GMEM_NOT_BANKED
#define GMEM_VALID_FLAGS    0x7f72
#define GMEM_INVALID_HANDLE 0x8000
#define GHND                (GMEM_MOVEABLE|GMEM_ZEROINIT)
#define GPTR                (GMEM_FIXED|GMEM_ZEROINIT)
#define LMEM_FIXED          GMEM_FIXED
#define LMEM_MOVEABLE       GMEM_MOVEABLE
#define LMEM_NOCOMPACT      GMEM_NOCOMPACT
#define LMEM_NODISCARD      GMEM_NODISCARD
#define LMEM_ZEROINIT       GMEM_ZEROINIT
#define LMEM_MODIFY         GMEM_MODIFY
#define LMEM_DISCARDABLE    GMEM_DISCARDABLE
#define LMEM_NOT_BANKED     GMEM_NOT_BANKED
#define LMEM_SHARE          GMEM_SHARE
#define LMEM_DDESHARE       GMEM_DDESHARE
#define LMEM_NOTIFY         GMEM_NOTIFY
#define LMEM_LOWER          GMEM_NOT_BANKED
#define LMEM_VALID_FLAGS    GMEM_VALID_FLAGS
#define LMEM_INVALID_HANDLE GMEM_INVALID_HANDLE
#define LHND                GHND
#define LPTR                GPTR
#define MEM_COMMIT      0x00001000
#define MEM_RESERVE     0x00002000
#define MEM_DECOMMIT    0x00004000
#define MEM_RELEASE     0x00008000
#define MEM_RESET       0x00080000
#define MEM_TOP_DOWN    0x00100000
#define MEM_WRITE_WATCH 0x00200000
#define MEM_PHYSICAL    0x00400000
typedef LPVOID HGLOBAL, HLOCAL;
#include "pshpack1.h"
typedef struct _MEMORY_BASIC_INFORMATION
{
  LPVOID BaseAddress;
  LPVOID AllocationBase;
  DWORD AllocationProtect;
  SIZE_T RegionSize;
  DWORD State;
  DWORD Protect;
  DWORD Type;
} MEMORY_BASIC_INFORMATION, *PMEMORY_BASIC_INFORMATION, *LPMEMORY_BASIC_INFORMATION;
typedef struct tagMEMORYSTATUS
{
  DWORD dwLength;
  DWORD dwMemoryLoad;
  SIZE_T dwTotalPhys;
  SIZE_T dwAvailPhys;
  SIZE_T dwTotalPageFile;
  SIZE_T dwAvailPageFile;
  SIZE_T dwTotalVirtual;
  SIZE_T dwAvailVirtual;
} MEMORYSTATUS, *PMEMORYSTATUS, *LPMEMORYSTATUS;
#include "poppack.h"

/* ja:ファイル */
#define STD_INPUT_HANDLE         (-10)
#define STD_OUTPUT_HANDLE        (-11)
#define STD_ERROR_HANDLE         (-12)
#define INVALID_SET_FILE_POINTER (-1)
#define FILE_TYPE_UNKNOWN        0x0000
#define FILE_TYPE_DISK           0x0001
#define FILE_TYPE_CHAR           0x0002
#define FILE_TYPE_PIPE           0x0003
#define FILE_TYPE_REMOTE         0x8000
#define GENERIC_READ             0x80000000
#define GENERIC_WRITE            0x40000000
#define FILE_SHARE_READ          1
#define FILE_SHARE_WRITE         2
#define FILE_SHARE_DELETE        4
#define CREATE_NEW               1
#define CREATE_ALWAYS            2
#define OPEN_EXISTING            3
#define OPEN_ALWAYS              4
#define TRUNCATE_EXISTING        5
#define FILE_BEGIN               0
#define FILE_CURRENT             1
#define FILE_END                 2
#include "pshpack1.h"
typedef struct _OVERLAPPED
{
  ULONG_PTR Internal;
  ULONG_PTR InternalHigh;
  DWORD Offset;
  DWORD OffsetHigh;
  HANDLE hEvent;
} OVERLAPPED, *POVERLAPPED, *LPOVERLAPPED;
#include "poppack.h"
/* ja:ファイル(属性) */
#define FILE_ATTRIBUTE_READONLY            0x00000001
#define FILE_ATTRIBUTE_HIDDEN              0x00000002
#define FILE_ATTRIBUTE_SYSTEM              0x00000004
#define FILE_ATTRIBUTE_DIRECTORY           0x00000010
#define FILE_ATTRIBUTE_ARCHIVE             0x00000020
#define FILE_ATTRIBUTE_NORMAL              0x00000080
#define FILE_ATTRIBUTE_TEMPORARY           0x00000100
#define FILE_ATTRIBUTE_SPARSE_FILE         0x00000200
#define FILE_ATTRIBUTE_REPARSE_POINT       0x00000400
#define FILE_ATTRIBUTE_COMPRESSED          0x00000800
#define FILE_ATTRIBUTE_OFFLINE             0x00001000
#define FILE_ATTRIBUTE_NOT_CONTENT_INDEXED 0x00002000
#define FILE_ATTRIBUTE_ENCRYPTED           0x00004000
/* ja:ファイル(メモリマップ) */
#define PAGE_READONLY       0x00000002
#define PAGE_READWRITE      0x00000004
#define PAGE_WRITECOPY      0x00000008
#define SEC_IMAGE           0x01000000
#define SEC_RESERVE         0x04000000
#define SEC_COMMIT          0x08000000
#define SEC_NOCACHE         0x10000000
#define FILE_MAP_COPY       1
#define FILE_MAP_WRITE      2
#define FILE_MAP_READ       4
#define FILE_MAP_ALL_ACCESS 0x000f001f
/* ja:ファイル(Win16互換) */
#define HFILE_ERROR (GINT_TO_POINTER(-1))
typedef FileIO *HFILE;
/* ja:ファイル検索 */
#include "pshpack1.h"
typedef struct _WIN32_FIND_DATAA
{
  DWORD dwFileAttributes;
  FILETIME ftCreationTime;
  FILETIME ftLastAccessTime;
  FILETIME ftLastWriteTime;
  DWORD nFileSizeHigh;
  DWORD nFileSizeLow;
  DWORD dwReserved0;
  DWORD dwReserved1;
  CHAR cFileName[MAX_PATH];
  CHAR cAlternateFileName[14];
} WIN32_FIND_DATAA, *PWIN32_FIND_DATAA, *LPWIN32_FIND_DATAA;
typedef struct _WIN32_FIND_DATAW
{
  DWORD dwFileAttributes;
  FILETIME ftCreationTime;
  FILETIME ftLastAccessTime;
  FILETIME ftLastWriteTime;
  DWORD nFileSizeHigh;
  DWORD nFileSizeLow;
  DWORD dwReserved0;
  DWORD dwReserved1;
  WCHAR cFileName[MAX_PATH];
  WCHAR cAlternateFileName[14];
} WIN32_FIND_DATAW, *PWIN32_FIND_DATAW, *LPWIN32_FIND_DATAW;
#include "poppack.h"
#ifdef UNICODE
# define WIN32_FIND_DATA WIN32_FIND_DATAW
# define PWIN32_FIND_DATA PWIN32_FIND_DATAW
# define LPWIN32_FIND_DATA LPWIN32_FIND_DATAW
#else /* not UNICODE */
# define WIN32_FIND_DATA WIN32_FIND_DATAA
# define PWIN32_FIND_DATA PWIN32_FIND_DATAA
# define LPWIN32_FIND_DATA LPWIN32_FIND_DATAA
#endif /* not UNICODE */

/* ja:文字列比較 */
#define CSTR_LESS_THAN    1
#define CSTR_EQUAL        2
#define CSTR_GREATER_THAN 3
#define NORM_IGNORECASE     0x00001
#define NORM_IGNORENONSPACE 0x00002
#define NORM_IGNORESYMBOLS  0x00004
#define NORM_STRINGSORT     0x01000
#define NORM_IGNOREKANATYPE 0x10000
#define NORM_IGNOREWIDTH    0x20000

/* ja:言語/ロケール/コードページ */
#define MAX_DEFAULTCHAR 2
#define MAX_LEADBYTES   12
#define CP_ACP        0
#define CP_OEMCP      1
#define CP_MACCP      2
#define CP_THREAD_ACP 3
#define CP_SYMBOL     42
#define CP_UTF7       65000
#define CP_UTF8       65001
#define LCMAP_LOWERCASE 0x00000100
#define LCMAP_UPPERCASE 0x00000200
#define LCMAP_SORTKEY   0x00000400
#define LCMAP_BYTEREV   0x00000800
#define MAKELCID(l,s)        (MAKELONG(l,s))
#define MAKELANGID(p,s)      ((((WORD)(s))<<10)|(WORD)(p))
#define PRIMARYLANGID(l)     ((WORD)(l)&0x3ff)
#define SUBLANGID(l)         ((WORD)(l)>>10)
#define LANGIDFROMLCID(lcid) ((WORD)(lcid))
#define SORTIDFROMLCID(lcid) ((WORD)((((DWORD)(lcid))>>16)&0x0f))
#define LANG_NEUTRAL                0x00
#define LANG_AFRIKAANS              0x36
#define LANG_ALBANIAN               0x1c
#define LANG_ARABIC                 0x01
#define LANG_ARMENIAN               0x2b
#define LANG_ASSAMESE               0x4d
#define LANG_AZERI                  0x2c
#define LANG_BASQUE                 0x2d
#define LANG_BENGALI                0x45
#define LANG_BULGARIAN              0x02
#define LANG_BYELORUSSIAN           0x23
#define LANG_CATALAN                0x03
#define LANG_CHINESE                0x04
#define LANG_SERBO_CROATIAN         0x1a
#define LANG_CROATIAN               LANG_SERBO_CROATIAN
#define LANG_SERBIAN                LANG_SERBO_CROATIAN
#define LANG_CZECH                  0x05
#define LANG_DANISH                 0x06
#define LANG_DUTCH                  0x13
#define LANG_ENGLISH                0x09
#define LANG_ESTONIAN               0x25
#define LANG_FAEROESE               0x38
#define LANG_FARSI                  0x29
#define LANG_FINNISH                0x0b
#define LANG_FRENCH                 0x0c
#define LANG_GAELIC                 0x3c
#define LANG_GEORGIAN               0x37
#define LANG_GERMAN                 0x07
#define LANG_GREEK                  0x08
#define LANG_GUJARATI               0x47
#define LANG_HEBREW                 0x0d
#define LANG_HINDI                  0x39
#define LANG_HUNGARIAN              0x0e
#define LANG_ICELANDIC              0x0f
#define LANG_INDONESIAN             0x21
#define LANG_ITALIAN                0x10
#define LANG_JAPANESE               0x11
#define LANG_KANNADA                0x4b
#define LANG_KAZAKH                 0x3f
#define LANG_KONKANI                0x57
#define LANG_KOREAN                 0x12
#define LANG_LATVIAN                0x26
#define LANG_LITHUANIAN             0x27
#define LANG_MACEDONIAN             0x2f
#define LANG_MALAY                  0x3e
#define LANG_MALAYALAM              0x4c
#define LANG_MALTESE                0x3a
#define LANG_MAORI                  0x28
#define LANG_MARATHI                0x4e
#define LANG_NORWEGIAN              0x14
#define LANG_ORIYA                  0x48
#define LANG_POLISH                 0x15
#define LANG_PORTUGUESE             0x16
#define LANG_PUNJABI                0x46
#define LANG_RHAETO_ROMANCE         0x17
#define LANG_ROMANIAN               0x18
#define LANG_RUSSIAN                0x19
#define LANG_SAAMI                  0x3b
#define LANG_SANSKRIT               0x4f
#define LANG_SLOVAK                 0x1b
#define LANG_SLOVENIAN              0x24
#define LANG_SORBIAN                0x2e
#define LANG_SPANISH                0x0a
#define LANG_SUTU                   0x30
#define LANG_SWAHILI                0x41
#define LANG_SWEDISH                0x1d
#define LANG_TAMIL                  0x49
#define LANG_TATAR                  0x44
#define LANG_TELUGU                 0x4a
#define LANG_THAI                   0x1e
#define LANG_TSONGA                 0x31
#define LANG_TSWANA                 0x32
#define LANG_TURKISH                0x1f
#define LANG_UKRAINIAN              0x22
#define LANG_URDU                   0x20
#define LANG_UZBEK                  0x43
#define LANG_VENDA                  0x33
#define LANG_VIETNAMESE             0x2a
#define LANG_XHOSA                  0x34
#define LANG_ZULU                   0x35
#define LANG_ESPERANTO              0x8f
#define LANG_WALON                  0x90
#define LANG_CORNISH                0x91
#define LANG_WELSH                  0x92
#define LANG_BRETON                 0x93
#define SUBLANG_NEUTRAL                 0x00
#define SUBLANG_DEFAULT                 0x01
#define SUBLANG_SYS_DEFAULT             0x02
#define SUBLANG_ARABIC                  0x01
#define SUBLANG_ARABIC_SAUDI_ARABIA     0x01
#define SUBLANG_ARABIC_IRAQ             0x02
#define SUBLANG_ARABIC_EGYPT            0x03
#define SUBLANG_ARABIC_LIBYA            0x04
#define SUBLANG_ARABIC_ALGERIA          0x05
#define SUBLANG_ARABIC_MOROCCO          0x06
#define SUBLANG_ARABIC_TUNISIA          0x07
#define SUBLANG_ARABIC_OMAN             0x08
#define SUBLANG_ARABIC_YEMEN            0x09
#define SUBLANG_ARABIC_SYRIA            0x0a
#define SUBLANG_ARABIC_JORDAN           0x0b
#define SUBLANG_ARABIC_LEBANON          0x0c
#define SUBLANG_ARABIC_KUWAIT           0x0d
#define SUBLANG_ARABIC_UAE              0x0e
#define SUBLANG_ARABIC_BAHRAIN          0x0f
#define SUBLANG_ARABIC_QATAR            0x10
#define SUBLANG_CHINESE_TRADITIONAL     0x01
#define SUBLANG_CHINESE_SIMPLIFIED      0x02
#define SUBLANG_CHINESE_HONGKONG        0x03
#define SUBLANG_CHINESE_SINGAPORE       0x04
#define SUBLANG_CHINESE_MACAU           0x05
#define SUBLANG_DUTCH                   0x01
#define SUBLANG_DUTCH_BELGIAN           0x02
#define SUBLANG_DUTCH_SURINAM           0x03
#define SUBLANG_ENGLISH_US              0x01
#define SUBLANG_ENGLISH_UK              0x02
#define SUBLANG_ENGLISH_AUS             0x03
#define SUBLANG_ENGLISH_CAN             0x04
#define SUBLANG_ENGLISH_NZ              0x05
#define SUBLANG_ENGLISH_EIRE            0x06
#define SUBLANG_ENGLISH_SAFRICA         0x07
#define SUBLANG_ENGLISH_JAMAICA         0x08
#define SUBLANG_ENGLISH_CARRIBEAN       0x09
#define SUBLANG_ENGLISH_BELIZE          0x0a
#define SUBLANG_ENGLISH_TRINIDAD        0x0b
#define SUBLANG_ENGLISH_ZIMBABWE        0x0c
#define SUBLANG_ENGLISH_PHILIPPINES     0x0d
#define SUBLANG_FRENCH                  0x01
#define SUBLANG_FRENCH_BELGIAN          0x02
#define SUBLANG_FRENCH_CANADIAN         0x03
#define SUBLANG_FRENCH_SWISS            0x04
#define SUBLANG_FRENCH_LUXEMBOURG       0x05
#define SUBLANG_FRENCH_MONACO           0x06
#define SUBLANG_GERMAN                  0x01
#define SUBLANG_GERMAN_SWISS            0x02
#define SUBLANG_GERMAN_AUSTRIAN         0x03
#define SUBLANG_GERMAN_LUXEMBOURG       0x04
#define SUBLANG_GERMAN_LIECHTENSTEIN    0x05
#define SUBLANG_ITALIAN                 0x01
#define SUBLANG_ITALIAN_SWISS           0x02
#define SUBLANG_KOREAN                  0x01
#define SUBLANG_KOREAN_JOHAB            0x02
#define SUBLANG_NORWEGIAN_BOKMAL        0x01
#define SUBLANG_NORWEGIAN_NYNORSK       0x02
#define SUBLANG_PORTUGUESE              0x02
#define SUBLANG_PORTUGUESE_BRAZILIAN    0x01
#define SUBLANG_SPANISH                 0x01
#define SUBLANG_SPANISH_MEXICAN         0x02
#define SUBLANG_SPANISH_MODERN          0x03
#define SUBLANG_SPANISH_GUATEMALA       0x04
#define SUBLANG_SPANISH_COSTARICA       0x05
#define SUBLANG_SPANISH_PANAMA          0x06
#define SUBLANG_SPANISH_DOMINICAN       0x07
#define SUBLANG_SPANISH_VENEZUELA       0x08
#define SUBLANG_SPANISH_COLOMBIA        0x09
#define SUBLANG_SPANISH_PERU            0x0a
#define SUBLANG_SPANISH_ARGENTINA       0x0b
#define SUBLANG_SPANISH_ECUADOR         0x0c
#define SUBLANG_SPANISH_CHILE           0x0d
#define SUBLANG_SPANISH_URUGUAY         0x0e
#define SUBLANG_SPANISH_PARAGUAY        0x0f
#define SUBLANG_SPANISH_BOLIVIA         0x10
#define SUBLANG_SPANISH_EL_SALVADOR     0x11
#define SUBLANG_SPANISH_HONDURAS        0x12
#define SUBLANG_SPANISH_NICARAGUA       0x13
#define SUBLANG_SPANISH_PUERTO_RICO     0x14
#define SUBLANG_ROMANIAN                0x01
#define SUBLANG_ROMANIAN_MOLDAVIA       0x02
#define SUBLANG_RUSSIAN                 0x01
#define SUBLANG_RUSSIAN_MOLDAVIA        0x02
#define SUBLANG_CROATIAN                0x01
#define SUBLANG_SERBIAN                 0x02
#define SUBLANG_SERBIAN_LATIN           0x03
#define SUBLANG_SWEDISH                 0x01
#define SUBLANG_SWEDISH_FINLAND         0x02
#define SUBLANG_LITHUANIAN              0x01
#define SUBLANG_LITHUANIAN_CLASSIC      0x02
#define SUBLANG_AZERI                   0x01
#define SUBLANG_AZERI_CYRILLIC          0x02
#define SUBLANG_GAELIC                  0x01
#define SUBLANG_GAELIC_SCOTTISH         0x02
#define SUBLANG_GAELIC_MANX             0x03
#define SUBLANG_MALAY                   0x01
#define SUBLANG_MALAY_BRUNEI_DARUSSALAM 0x02
#define SUBLANG_UZBEK                   0x01
#define SUBLANG_UZBEK_CYRILLIC          0x02
#define SUBLANG_URDU_PAKISTAN           0x01
typedef WORD LANGID;
typedef DWORD CALID;
typedef DWORD CALTYPE;
typedef DWORD LCID;
typedef DWORD LCTYPE;
typedef BOOL CALLBACK (*CALINFO_ENUMPROCA)(LPSTR);
typedef BOOL CALLBACK (*CALINFO_ENUMPROCW)(LPWSTR);
typedef DWORD CALLBACK (*LPTHREAD_START_ROUTINE)(LPVOID);
#ifdef UNICODE
# define CALINFO_ENUMPROC CALINFO_ENUMPROCW
#else /* not UNICODE */
# define CALINFO_ENUMPROC CALINFO_ENUMPROCA
#endif /* not UNICODE */
#include "pshpack1.h"
typedef struct
{
  UINT MaxCharSize;
  BYTE DefaultChar[MAX_DEFAULTCHAR];
  BYTE LeadByte[MAX_LEADBYTES];
} CPINFO, *LPCPINFO;
typedef struct
{
  UINT MaxCharSize;
  BYTE DefaultChar[MAX_DEFAULTCHAR];
  BYTE LeadByte[MAX_LEADBYTES];
  WCHAR UnicodeDefaultChar;
  UINT CodePage;
  CHAR CodePageName[MAX_PATH];
} CPINFOEXA, *LPCPINFOEXA;
typedef struct
{
  UINT MaxCharSize;
  BYTE DefaultChar[MAX_DEFAULTCHAR];
  BYTE LeadByte[MAX_LEADBYTES];
  WCHAR UnicodeDefaultChar;
  UINT CodePage;
  WCHAR CodePageName[MAX_PATH];
} CPINFOEXW, *LPCPINFOEXW;
#include "poppack.h"
#ifdef UNICODE
# define CPINFOEX CPINFOEXW
# define LPCPINFOEX LPCPINFOEXW
#else /* not UNICODE */
# define CPINFOEX CPINFOEXA
# define LPCPINFOEX LPCPINFOEXA
#endif /* not UNICODE */

/* ja:環境 */
#define VER_PLATFORM_WIN32s        0
#define VER_PLATFORM_WIN32_WINDOWS 1
#define VER_PLATFORM_WIN32_NT      2
#include "pshpack1.h"
typedef union _LARGE_INTEGER
{
#if G_BYTE_ORDER == G_LITTLE_ENDIAN
  struct
  {
    DWORD LowPart;
    LONG  HighPart;
  };
  struct
  {
    DWORD LowPart;
    LONG  HighPart;
  } u;
#else /* not G_BYTE_ORDER == G_LITTLE_ENDIAN */
  struct
  {
    LONG  HighPart;
    DWORD LowPart;
  };
  struct
  {
    LONG  HighPart;
    DWORD LowPart;
  } u;
#endif /* not G_BYTE_ORDER == G_LITTLE_ENDIAN */
  LONGLONG QuadPart;
} LARGE_INTEGER, *PLARGE_INTEGER, *LPLARGE_INTEGER;
typedef union _ULARGE_INTEGER
{
#if G_BYTE_ORDER == G_LITTLE_ENDIAN
  struct
  {
    DWORD LowPart;
    DWORD HighPart;
  };
  struct
  {
    DWORD LowPart;
    DWORD HighPart;
  } u;
#else /* not G_BYTE_ORDER == G_LITTLE_ENDIAN */
  struct
  {
    DWORD HighPart;
    DWORD LowPart;
  };
  struct
  {
    DWORD HighPart;
    DWORD LowPart;
  } u;
#endif /* not G_BYTE_ORDER == G_LITTLE_ENDIAN */
  ULONGLONG QuadPart;
} ULARGE_INTEGER, *PULARGE_INTEGER, *LPULARGE_INTEGER;
typedef struct
{
  DWORD dwOSVersionInfoSize;
  DWORD dwMajorVersion;
  DWORD dwMinorVersion;
  DWORD dwBuildNumber;
  DWORD dwPlatformId;
  CHAR szCSDVersion[128];
} OSVERSIONINFOA, *POSVERSIONINFOA, *LPOSVERSIONINFOA;
typedef struct
{
  DWORD dwOSVersionInfoSize;
  DWORD dwMajorVersion;
  DWORD dwMinorVersion;
  DWORD dwBuildNumber;
  DWORD dwPlatformId;
  WCHAR szCSDVersion[128];
} OSVERSIONINFOW, *POSVERSIONINFOW, *LPOSVERSIONINFOW;
#include "poppack.h"
#ifdef UNICODE
# define OSVERSIONINFO OSVERSIONINFOW
# define POSVERSIONINFO POSVERSIONINFOW
# define LPOSVERSIONINFO LPOSVERSIONINFOW
#else /* not UNICODE */
# define OSVERSIONINFO OSVERSIONINFOA
# define POSVERSIONINFO POSVERSIONINFOA
# define LPOSVERSIONINFO LPOSVERSIONINFOA
#endif /* not UNICODE */
/* dwProcessorType */
#define PROCESSOR_INTEL_386     386
#define PROCESSOR_INTEL_486     486
#define PROCESSOR_INTEL_PENTIUM 586
#include "pshpack1.h"
typedef struct _SYSTEM_INFO
{
  union {
    DWORD dwOemId;
    struct {
      WORD wProcessorArchitecture;
      WORD wReserved;
    } DUMMYSTRUCTNAME;
  } DUMMYUNIONNAME;
  DWORD dwPageSize;
  LPVOID lpMinimumApplicationAddress;
  LPVOID lpMaximumApplicationAddress;
  DWORD dwActiveProcessorMask;
  DWORD dwNumberOfProcessors;
  DWORD dwProcessorType;
  DWORD dwAllocationGranularity;
  WORD wProcessorLevel;
  WORD wProcessorRevision;
} SYSTEM_INFO, *LPSYSTEM_INFO;
typedef struct _SYSTEMTIME
{
  WORD wYear;
  WORD wMonth;
  WORD wDayOfWeek;
  WORD wDay;
  WORD wHour;
  WORD wMinute;
  WORD wSecond;
  WORD wMilliseconds;
} SYSTEMTIME, *PSYSTEMTIME, *LPSYSTEMTIME;
typedef CONST SYSTEMTIME *PCSYSTEMTIME, *LPCSYSTEMTIME;
#define TIME_ZONE_ID_INVALID  0xffffffff
#define TIME_ZONE_ID_UNKNOWN  0
#define TIME_ZONE_ID_STANDARD 1
#define TIME_ZONE_ID_DAYLIGHT 2
typedef struct _TIME_ZONE_INFORMATION
{
  LONG Bias;
  WCHAR StandardName[32];
  SYSTEMTIME StandardDate;
  LONG StandardBias;
  WCHAR DaylightName[32];
  SYSTEMTIME DaylightDate;
  LONG DaylightBias;
} TIME_ZONE_INFORMATION, *PTIME_ZONE_INFORMATION, *LPTIME_ZONE_INFORMATION;
typedef CONST TIME_ZONE_INFORMATION *PCTIME_ZONE_INFORMATION, *LPCTIME_ZONE_INFORMATION;
#include "poppack.h"

/* ja:コンソール */
#include "pshpack1.h"
typedef struct tagCOORD
{
  SHORT X;
  SHORT Y;
} COORD, *PCOORD, *LPCOORD;
#include "poppack.h"

/* ja:非公開 */
#define EXCEPTION_MAXIMUM_PARAMETERS 15
#define MAXIMUM_SUPPORTED_EXTENSION 512
#define SIZE_OF_80387_REGISTERS 80
typedef struct _FLOATING_SAVE_AREA FLOATING_SAVE_AREA, *PFLOATING_SAVE_AREA, *LPFLOATING_SAVE_AREA;
typedef struct _CONTEXT86 CONTEXT86, *PCONTEXT86, *LPCONTEXT86, CONTEXT, *PCONTEXT, *LPCONTEXT;
typedef struct _EXCEPTION_FRAME EXCEPTION_FRAME, *PEXCEPTION_FRAME, *LPEXCEPTION_FRAME;
typedef struct _EXCEPTION_POINTERS EXCEPTION_POINTERS, *PEXCEPTION_POINTERS, *LPEXCEPTION_POINTERS;
typedef struct _EXCEPTION_RECORD EXCEPTION_RECORD, *PEXCEPTION_RECORD, *LPEXCEPTION_RECORD;
typedef struct _EXCEPTION_REGISTRATION_RECORD EXCEPTION_REGISTRATION_RECORD, *PEXCEPTION_REGISTRATION_RECORD, *LPEXCEPTION_REGISTRATION_RECORD;
typedef struct _SCOPETABLE SCOPETABLE, *PSCOPETABLE, *LPSCOPETABLE;
typedef DWORD (*PEXCEPTION_HANDLER)(PEXCEPTION_RECORD, PEXCEPTION_REGISTRATION_RECORD, PCONTEXT, EXCEPTION_REGISTRATION_RECORD **);
typedef DWORD (*LPEXCEPTION_HANDLER)(LPEXCEPTION_RECORD, LPEXCEPTION_REGISTRATION_RECORD, LPCONTEXT, EXCEPTION_REGISTRATION_RECORD **);
typedef LONG (CALLBACK *PTOP_LEVEL_EXCEPTION_FILTER)(PEXCEPTION_POINTERS);
typedef LONG (CALLBACK *LPTOP_LEVEL_EXCEPTION_FILTER)(LPEXCEPTION_POINTERS);
#include "pshpack1.h"
struct _FLOATING_SAVE_AREA
{
  DWORD ControlWord;
  DWORD StatusWord;
  DWORD TagWord;
  DWORD ErrorOffset;
  DWORD ErrorSelector;
  DWORD DataOffset;
  DWORD DataSelector;
  BYTE RegisterArea[SIZE_OF_80387_REGISTERS];
  DWORD Cr0NpxState;
};
struct _CONTEXT86
{
  DWORD ContextFlags;
  DWORD Dr0;
  DWORD Dr1;
  DWORD Dr2;
  DWORD Dr3;
  DWORD Dr6;
  DWORD Dr7;
  FLOATING_SAVE_AREA FloatSave;
  DWORD SegGs;
  DWORD SegFs;
  DWORD SegEs;
  DWORD SegDs;
  DWORD Edi;
  DWORD Esi;
  DWORD Ebx;
  DWORD Edx;
  DWORD Ecx;
  DWORD Eax;
  DWORD Ebp;
  DWORD Eip;
  DWORD SegCs;
  DWORD EFlags;
  DWORD Esp;
  DWORD SegSs;
  BYTE ExtendedRegisters[MAXIMUM_SUPPORTED_EXTENSION];
};
struct _EXCEPTION_FRAME
{
  EXCEPTION_REGISTRATION_RECORD *prev;
  void (*handler)(PEXCEPTION_RECORD, PEXCEPTION_REGISTRATION_RECORD, PCONTEXT, PEXCEPTION_RECORD);
  PSCOPETABLE scopetable;
  int trylevel;
  int _ebp;
  PEXCEPTION_POINTERS xpointers;
};
struct _EXCEPTION_POINTERS
{
  PEXCEPTION_RECORD ExceptionRecord;
  PCONTEXT ContextRecord;
};
struct _EXCEPTION_RECORD
{
  DWORD ExceptionCode;
  DWORD ExceptionFlags;
  struct _EXCEPTION_RECORD *ExceptionRecord;
  PVOID ExceptionAddress;
  DWORD NumberParameters;
  ULONG_PTR ExceptionInformation[EXCEPTION_MAXIMUM_PARAMETERS];
};
struct _EXCEPTION_REGISTRATION_RECORD
{
  struct _EXCEPTION_REGISTRATION_RECORD *Prev;
  PEXCEPTION_HANDLER Handler;
};
struct _SCOPETABLE
{
  int previousTryLevel;
  int (*lpfnFilter)(PEXCEPTION_POINTERS);
  int (*lpfnHandler)(void);
};
#include "poppack.h"


extern W32LdrExport kernel32_exports[];


ATOM WINAPI AddAtomA (LPCSTR lpString);
ATOM WINAPI AddAtomW (LPCWSTR lpString);
BOOL WINAPI AllocConsole (VOID);
BOOL WINAPI CloseHandle (HANDLE hObject);
LONG WINAPI CompareFileTime (LPCFILETIME lpFileTime1, LPCFILETIME lpFileTime2);
INT WINAPI CompareStringA (LCID Locale, DWORD dwCmpFlags, LPCSTR lpString1, INT cchCount1, LPCSTR lpString2, INT cchCount2);
INT WINAPI CompareStringW (LCID Locale, DWORD dwCmpFlags, LPCWSTR lpString1, INT cchCount1, LPCWSTR lpString2, INT cchCount2);
BOOL WINAPI CopyFileA (LPCSTR lpExistingFileName, LPCSTR lpNewFileName, BOOL bFailIfExists);
BOOL WINAPI CopyFileW (LPCWSTR lpExistingFileName, LPCWSTR lpNewFileName, BOOL bFailIfExists);
BOOL WINAPI CreateDirectoryA (LPCSTR lpPathName, LPSECURITY_ATTRIBUTES lpSecurityAttributes);
BOOL WINAPI CreateDirectoryW (LPCWSTR lpPathName, LPSECURITY_ATTRIBUTES lpSecurityAttributes);
HANDLE WINAPI CreateEventA (LPSECURITY_ATTRIBUTES lpEventAttributes, BOOL bManualReset, BOOL bInitialState, LPCSTR lpName);
HANDLE WINAPI CreateEventW (LPSECURITY_ATTRIBUTES lpEventAttributes, BOOL bManualReset, BOOL bInitialState, LPCWSTR lpName);
HANDLE WINAPI CreateFileA (LPCSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile);
HANDLE WINAPI CreateFileMappingA (HANDLE hFile, LPSECURITY_ATTRIBUTES lpAttributes, DWORD flProtect, DWORD dwMaximumSizeHigh, DWORD dwMaximumSizeLow, LPCSTR lpName);
HANDLE WINAPI CreateFileMappingW (HANDLE hFile, LPSECURITY_ATTRIBUTES lpAttributes, DWORD flProtect, DWORD dwMaximumSizeHigh, DWORD dwMaximumSizeLow, LPCWSTR lpName);
HANDLE WINAPI CreateFileW (LPCWSTR lpFileName, DWORD dwDesiredAccess, DWORD dwShareMode, LPSECURITY_ATTRIBUTES lpSecurityAttributes, DWORD dwCreationDisposition, DWORD dwFlagsAndAttributes, HANDLE hTemplateFile);
HANDLE WINAPI CreateMutexA (LPSECURITY_ATTRIBUTES lpMutexAttributes, BOOL bInitialOwner, LPCSTR lpName);
HANDLE WINAPI CreateMutexW (LPSECURITY_ATTRIBUTES lpMutexAttributes, BOOL bInitialOwner, LPCWSTR lpName);
BOOL WINAPI CreateProcessA (LPCSTR lpApplicationName, LPSTR lpCommandLine, LPSECURITY_ATTRIBUTES lpProcessAttributes, LPSECURITY_ATTRIBUTES lpThreadAttributes, BOOL bInheritHandles, DWORD dwCreationFlags, LPVOID lpEnvironment, LPCSTR lpCurrentDirectory, LPSTARTUPINFOA lpStartupInfo, LPPROCESS_INFORMATION lpProcessInformation);
BOOL WINAPI CreateProcessW (LPCWSTR lpApplicationName, LPWSTR lpCommandLine, LPSECURITY_ATTRIBUTES lpProcessAttributes, LPSECURITY_ATTRIBUTES lpThreadAttributes, BOOL bInheritHandles, DWORD dwCreationFlags, LPVOID lpEnvironment, LPCWSTR lpCurrentDirectory, LPSTARTUPINFOW lpStartupInfo, LPPROCESS_INFORMATION lpProcessInformation);
HANDLE WINAPI CreateSemaphoreA (LPSECURITY_ATTRIBUTES lpSemaphoreAttributes, LONG lInitialCount, LONG lMaximumCount, LPCSTR lpName);
HANDLE WINAPI CreateSemaphoreW (LPSECURITY_ATTRIBUTES lpSemaphoreAttributes, LONG lInitialCount, LONG lMaximumCount, LPCWSTR lpName);
HANDLE WINAPI CreateThread (LPSECURITY_ATTRIBUTES lpThreadAttributes, DWORD dwStackSize, LPTHREAD_START_ROUTINE lpStartAddress, LPVOID lpParameter, DWORD dwCreationFlags, LPDWORD lpThreadId);
ATOM WINAPI DeleteAtom (ATOM nAtom);
VOID WINAPI DeleteCriticalSection (LPCRITICAL_SECTION lpCriticalSection);
BOOL WINAPI DeleteFileA (LPCSTR lpFileName);
BOOL WINAPI DeleteFileW (LPCWSTR lpFileName);
BOOL WINAPI DisableThreadLibraryCalls (HMODULE hLibModule);
VOID WINAPI EnterCriticalSection (LPCRITICAL_SECTION lpCriticalSection);
BOOL WINAPI EnumCalendarInfoA (CALINFO_ENUMPROCA lpCalInfoEnumProc, LCID Locale, CALID Calendar, CALTYPE CalType);
BOOL WINAPI EnumCalendarInfoW (CALINFO_ENUMPROCW lpCalInfoEnumProc, LCID Locale, CALID Calendar, CALTYPE CalType);
VOID WINAPI ExitProcess (UINT uExitCode);
VOID WINAPI ExitThread (UINT uExitCode);
BOOL WINAPI FileTimeToLocalFileTime (LPCFILETIME lpFileTime, LPFILETIME lpLocalFileTime);
BOOL WINAPI FileTimeToSystemTime (LPCFILETIME lpFileTime, LPSYSTEMTIME lpSystemTime);
ATOM WINAPI FindAtomA (LPCSTR lpString);
ATOM WINAPI FindAtomW (LPCWSTR lpString);
BOOL WINAPI FindClose (HANDLE hFind);
HANDLE WINAPI FindFirstFileA (LPCSTR lpFileName, LPWIN32_FIND_DATAA lpFindFileData);
HANDLE WINAPI FindFirstFileW (LPCWSTR lpFileName, LPWIN32_FIND_DATAW lpFindFileData);
BOOL WINAPI FindNextFileA (HANDLE hFind, LPWIN32_FIND_DATAA lpFindFileData);
BOOL WINAPI FindNextFileW (HANDLE hFind, LPWIN32_FIND_DATAW lpFindFileData);
HRSRC WINAPI FindResourceA (HMODULE hModule, LPCSTR lpName, LPCSTR lpType);
HRSRC WINAPI FindResourceExA (HMODULE hModule, LPCSTR lpType, LPCSTR lpName, WORD wLanguage);
HRSRC WINAPI FindResourceExW (HMODULE hModule, LPCWSTR lpType, LPCWSTR lpName, WORD wLanguage);
HRSRC WINAPI FindResourceW (HMODULE hModule, LPCWSTR lpName, LPCWSTR lpType);
BOOL WINAPI FlushFileBuffers (HANDLE hFile);
BOOL WINAPI FreeEnvironmentStringsA (LPSTR lpszEnvironmentBlock);
BOOL WINAPI FreeEnvironmentStringsW (LPWSTR lpszEnvironmentBlock);
BOOL WINAPI FreeLibrary (HMODULE hModule);
BOOL WINAPI FreeResource (HGLOBAL hResData);
UINT WINAPI GetACP (VOID);
UINT WINAPI GetAtomNameA (ATOM nAtom, LPSTR lpBuffer, INT nSize);
UINT WINAPI GetAtomNameW (ATOM nAtom, LPWSTR lpBuffer, INT nSize);
BOOL WINAPI GetCPInfo (UINT CodePage, LPCPINFO lpCPInfo);
BOOL WINAPI GetCPInfoExA (UINT CodePage, DWORD dwFlags, LPCPINFOEXA lpCPInfoEx);
BOOL WINAPI GetCPInfoExW (UINT CodePage, DWORD dwFlags, LPCPINFOEXW lpCPInfoEx);
LPSTR WINAPI GetCommandLineA (VOID);
LPWSTR WINAPI GetCommandLineW (VOID);
DWORD WINAPI GetCurrentDirectoryA (DWORD nBufferLength, LPSTR lpBuffer);
DWORD WINAPI GetCurrentDirectoryW (DWORD nBufferLength, LPWSTR lpBuffer);
HANDLE WINAPI GetCurrentProcess (VOID);
HANDLE WINAPI GetCurrentThread (VOID);
DWORD WINAPI GetCurrentThreadId (VOID);
BOOL GetDiskFreeSpaceA (LPCSTR lpRootPathName, LPDWORD lpSectorsPerCluster, LPDWORD lpBytesPerSector, LPDWORD lpNumberOfFreeClusters, LPDWORD lpTotalNumberOfClusters);
BOOL WINAPI GetDiskFreeSpaceExA (LPCSTR lpDirectoryName, PULARGE_INTEGER lpFreeBytesAvailableToCaller, PULARGE_INTEGER lpTotalNumberOfBytes, PULARGE_INTEGER lpTotalNumberOfFreeBytes);
BOOL WINAPI GetDiskFreeSpaceExW (LPCWSTR lpDirectoryName, PULARGE_INTEGER lpFreeBytesAvailableToCaller, PULARGE_INTEGER lpTotalNumberOfBytes, PULARGE_INTEGER lpTotalNumberOfFreeBytes);
BOOL WINAPI GetDiskFreeSpaceW (LPCWSTR lpRootPathName, LPDWORD lpSectorsPerCluster, LPDWORD lpBytesPerSector, LPDWORD lpNumberOfFreeClusters, LPDWORD lpTotalNumberOfClusters);
LPVOID WINAPI GetEnvironmentStringsA (VOID);
LPVOID WINAPI GetEnvironmentStringsW (VOID);
DWORD WINAPI GetEnvironmentVariableA (LPCSTR lpName, LPSTR lpBuffer, DWORD nSize);
DWORD WINAPI GetEnvironmentVariableW (LPCWSTR lpName, LPWSTR lpBuffer, DWORD nSize);
DWORD WINAPI GetFileAttributesA (LPCSTR lpFileName);
DWORD WINAPI GetFileAttributesW (LPCWSTR lpFileName);
DWORD WINAPI GetFileSize (HANDLE hFile, LPDWORD lpFileSizeHigh);
BOOL WINAPI GetFileTime (HANDLE hFile, LPFILETIME lpCreationTime, LPFILETIME lpLastAccessTime, LPFILETIME lpLastWriteTime);
DWORD WINAPI GetFileType (HANDLE hFile);
DWORD WINAPI GetFullPathNameA (LPCSTR lpFileName, DWORD nBufferLength, LPSTR lpBuffer, LPSTR *lpFilePart);
DWORD WINAPI GetFullPathNameW (LPCWSTR lpFileName, DWORD nBufferLength, LPWSTR lpBuffer, LPWSTR *lpFilePart);
DWORD WINAPI GetLastError (VOID);
VOID WINAPI GetLocalTime (LPSYSTEMTIME lpSystemTime);
INT WINAPI GetLocaleInfoA (LCID Locale, LCTYPE LCType, LPSTR lpLCData, INT cchData);
INT WINAPI GetLocaleInfoW (LCID Locale, LCTYPE LCType, LPWSTR lpLCData, INT cchData);
DWORD WINAPI GetLogicalDriveStringsA (DWORD nBufferLength, LPSTR lpBuffer);
DWORD WINAPI GetLogicalDriveStringsW (DWORD nBufferLength, LPWSTR lpBuffer);
DWORD WINAPI GetModuleFileNameA (HMODULE hModule, LPSTR lpFilename, DWORD nSize);
DWORD WINAPI GetModuleFileNameW (HMODULE hModule, LPWSTR lpFilename, DWORD nSize);
HMODULE WINAPI GetModuleHandleA (LPCSTR lpModuleName);
HMODULE WINAPI GetModuleHandleW (LPCWSTR lpModuleName);
UINT WINAPI GetOEMCP (VOID);
UINT WINAPI GetPrivateProfileIntA (LPCSTR lpAppName, LPCSTR lpKeyName, INT nDefault, LPCSTR lpFileName);
UINT WINAPI GetPrivateProfileIntW (LPCWSTR lpAppName, LPCWSTR lpKeyName, INT nDefault, LPCWSTR lpFileName);
DWORD WINAPI GetPrivateProfileSectionA (LPCSTR lpAppName, LPSTR lpReturnedString, DWORD nSize, LPCSTR lpFileName);
DWORD WINAPI GetPrivateProfileSectionNamesA (LPSTR lpszReturnBuffer, DWORD nSize, LPCSTR lpFileName);
DWORD WINAPI GetPrivateProfileSectionW (LPCWSTR lpAppName, LPWSTR lpReturnedString, DWORD nSize, LPCWSTR lpFileName);
DWORD WINAPI GetPrivateProfileStringA (LPCSTR lpAppName, LPCSTR lpKeyName, LPCSTR lpDefault, LPSTR lpReturnedString, DWORD nSize, LPCSTR lpFileName);
DWORD WINAPI GetPrivateProfileStringW (LPCWSTR lpAppName, LPCWSTR lpKeyName, LPCWSTR lpDefault, LPWSTR lpReturnedString, DWORD nSize, LPCWSTR lpFileName);
BOOL WINAPI GetPrivateProfileStructA (LPCSTR lpszSection, LPCSTR lpszKey, LPVOID lpStruct, UINT uSizeStruct, LPCSTR szFile);
BOOL WINAPI GetPrivateProfileStructW (LPCWSTR lpszSection, LPCWSTR lpszKey, LPVOID lpStruct, UINT uSizeStruct, LPCWSTR szFile);
FARPROC WINAPI GetProcAddress (HMODULE hModule, LPCSTR lpProcName);
BOOL WINAPI GetProcessAffinityMask (HANDLE hProcess, LPDWORD lpProcessAffinityMask, LPDWORD lpSystemAffinityMask);
HANDLE WINAPI GetProcessHeap (VOID);
DWORD WINAPI GetProcessHeaps (DWORD NumberOfHeaps, HANDLE *ProcessHeaps);
UINT WINAPI GetProfileIntA (LPCSTR lpAppName, LPCSTR lpKeyName, INT nDefault);
UINT WINAPI GetProfileIntW (LPCWSTR lpAppName, LPCWSTR lpKeyName, INT nDefault);
DWORD WINAPI GetProfileSectionA (LPCSTR lpAppName, LPSTR lpReturnedString, DWORD nSize);
DWORD WINAPI GetProfileSectionW (LPCWSTR lpAppName, LPWSTR lpReturnedString, DWORD nSize);
DWORD WINAPI GetProfileStringA (LPCSTR lpAppName, LPCSTR lpKeyName, LPCSTR lpDefault, LPSTR lpReturnedString, DWORD nSize);
DWORD WINAPI GetProfileStringW (LPCWSTR lpAppName, LPCWSTR lpKeyName, LPCWSTR lpDefault, LPWSTR lpReturnedString, DWORD nSize);
DWORD WINAPI GetShortPathNameA (LPCSTR lpszLongPath, LPSTR lpszShortPath, DWORD cchBuffer);
DWORD WINAPI GetShortPathNameW (LPCWSTR lpszLongPath, LPWSTR lpszShortPath, DWORD cchBuffer);
VOID WINAPI GetStartupInfoA (LPSTARTUPINFOA lpsi);
VOID WINAPI GetStartupInfoW (LPSTARTUPINFOW lpsi);
HANDLE WINAPI GetStdHandle (DWORD nStdHandle);
BOOL WINAPI GetStringTypeA (LCID Locale, DWORD dwInfoType, LPCSTR lpSrcStr, INT cchSrc, LPWORD lpCharType);
BOOL WINAPI GetStringTypeW (DWORD dwInfoType, LPCWSTR lpSrcStr, INT cchSrc, LPWORD lpCharType);
DWORD WINAPI GetSystemDefaultLCID (VOID);
LANGID WINAPI GetSystemDefaultLangID (VOID);
LANGID WINAPI GetSystemDefaultUILanguage (VOID);
UINT WINAPI GetSystemDirectoryA (LPSTR lpBuffer, UINT uSize);
UINT WINAPI GetSystemDirectoryW (LPWSTR lpBuffer, UINT uSize);
VOID WINAPI GetSystemInfo (LPSYSTEM_INFO lpSystemInfo);
VOID WINAPI GetSystemTime (LPSYSTEMTIME lpSystemTime);
VOID WINAPI GetSystemTimeAsFileTime (LPFILETIME lpSystemTimeAsFileTime);
UINT WINAPI GetTempFileNameA (LPCSTR lpPathName, LPCSTR lpPrefixString, UINT uUnique, LPSTR lpTempFileName);
UINT WINAPI GetTempFileNameW (LPCWSTR lpPathName, LPCWSTR lpPrefixString, UINT uUnique, LPWSTR lpTempFileName);
DWORD WINAPI GetTempPathA (DWORD nBufferLength, LPSTR lpBuffer);
DWORD WINAPI GetTempPathW (DWORD nBufferLength, LPWSTR lpBuffer);
LCID WINAPI GetThreadLocale (VOID);
INT WINAPI GetThreadPriority (HANDLE hThread);
DWORD WINAPI GetTickCount (VOID);
DWORD WINAPI GetTimeZoneInformation (LPTIME_ZONE_INFORMATION lpTimeZoneInformation);
DWORD WINAPI GetUserDefaultLCID (VOID);
LANGID WINAPI GetUserDefaultLangID (VOID);
LANGID WINAPI GetUserDefaultUILanguage (VOID);
DWORD WINAPI GetVersion (VOID);
BOOL WINAPI GetVersionExA (LPOSVERSIONINFOA lpVersionInfo);
BOOL WINAPI GetVersionExW (LPOSVERSIONINFOW lpVersionInfo);
ATOM WINAPI GlobalAddAtomA (LPCSTR lpString);
ATOM WINAPI GlobalAddAtomW (LPCWSTR lpString);
HGLOBAL WINAPI GlobalAlloc (UINT uFlags, UINT uBytes);
ATOM WINAPI GlobalDeleteAtom (ATOM nAtom);
ATOM WINAPI GlobalFindAtomA (LPCSTR lpString);
ATOM WINAPI GlobalFindAtomW (LPCWSTR lpString);
UINT WINAPI GlobalFlags (HGLOBAL hMem);
HGLOBAL WINAPI GlobalFree (HGLOBAL hMem);
UINT WINAPI GlobalGetAtomNameA (ATOM nAtom, LPSTR lpBuffer, INT nSize);
UINT WINAPI GlobalGetAtomNameW (ATOM nAtom, LPWSTR lpBuffer, INT nSize);
HGLOBAL WINAPI GlobalHandle (LPCVOID pMem);
LPVOID WINAPI GlobalLock (HGLOBAL hMem);
HGLOBAL WINAPI GlobalReAlloc (HGLOBAL hMem, UINT uBytes, UINT uFlags);
UINT WINAPI GlobalSize (HGLOBAL hMem);
UINT WINAPI GlobalUnlock (HGLOBAL hMem);
LPVOID WINAPI HeapAlloc (HANDLE hHeap, DWORD dwFlags, DWORD dwBytes);
HANDLE WINAPI HeapCreate (DWORD flOptions, DWORD dwInitialSize, DWORD dwMaximumSize);
BOOL WINAPI HeapDestroy (HANDLE hHeap);
BOOL WINAPI HeapFree (HANDLE hHeap, DWORD dwFlags, LPVOID lpMem);
LPVOID WINAPI HeapReAlloc (HANDLE hHeap, DWORD dwFlags, LPVOID lpMem, DWORD dwBytes);
DWORD WINAPI HeapSize (HANDLE hHeap, DWORD dwFlags, LPCVOID lpMem);
BOOL WINAPI InitAtomTable (DWORD nSize);
VOID WINAPI InitializeCriticalSection (LPCRITICAL_SECTION lpCriticalSection);
PVOID WINAPI InterlockedCompareExchange (PVOID *Destination, PVOID Exchange, PVOID Comperand);
LONG WINAPI InterlockedDecrement (LPLONG lpAddend);
LONG WINAPI InterlockedExchange (LPLONG Target, LONG Value);
LONG WINAPI InterlockedExchangeAdd (PLONG lpAddend, LONG Increment);
LONG WINAPI InterlockedIncrement (LPLONG lpAddend);
BOOL WINAPI IsBadCodePtr (FARPROC lpfn);
BOOL WINAPI IsBadReadPtr (LPVOID lp, UINT ucb);
BOOL WINAPI IsBadWritePtr (LPVOID lp, UINT ucb);
BOOL WINAPI IsDBCSLeadByte (BYTE bTestChar);
BOOL IsDBCSLeadByteEx (UINT CodePage, BYTE bTestChar);
INT WINAPI LCMapStringA (LCID Locale, DWORD dwMapFlags, LPCSTR lpSrcStr, INT cchSrc, LPSTR lpDestStr, INT cchDest);
INT WINAPI LCMapStringW (LCID Locale, DWORD dwMapFlags, LPCWSTR lpSrcStr, INT cchSrc, LPWSTR lpDestStr, INT cchDest);
VOID WINAPI LeaveCriticalSection (LPCRITICAL_SECTION lpCriticalSection);
HINSTANCE WINAPI LoadLibraryA (LPCSTR lpFileName);
HINSTANCE WINAPI LoadLibraryExA (LPCSTR lpLibFileName, HANDLE hFile, DWORD dwFlags);
HINSTANCE WINAPI LoadLibraryExW (LPCWSTR lpLibFileName, HANDLE hFile, DWORD dwFlags);
HINSTANCE WINAPI LoadLibraryW (LPCWSTR lpFileName);
HGLOBAL WINAPI LoadResource (HMODULE hModule, HRSRC hResInfo);
HLOCAL WINAPI LocalAlloc (UINT uFlags, UINT uBytes);
BOOL WINAPI LocalFileTimeToFileTime (LPCFILETIME lpLocalFileTime, LPFILETIME lpFileTime);
UINT WINAPI LocalFlags (HLOCAL hMem);
HLOCAL WINAPI LocalFree (HLOCAL hMem);
HLOCAL WINAPI LocalHandle (LPCVOID pMem);
LPVOID WINAPI LocalLock (HLOCAL hMem);
HLOCAL WINAPI LocalReAlloc (HLOCAL hMem, UINT uBytes, UINT uFlags);
UINT WINAPI LocalSize (HLOCAL hMem);
UINT WINAPI LocalUnlock (HLOCAL hMem);
LPVOID WINAPI LockResource (HGLOBAL hResData);
LPVOID WINAPI MapViewOfFile (HANDLE hFileMappingObject, DWORD dwDesiredAccess, DWORD dwFileOffsetHigh, DWORD dwFileOffsetLow, SIZE_T dwNumberOfBytesToMap);
LPVOID WINAPI MapViewOfFileEx (HANDLE hFileMappingObject, DWORD dwDesiredAccess, DWORD dwFileOffsetHigh, DWORD dwFileOffsetLow, SIZE_T dwNumberOfBytesToMap, LPVOID lpBaseAddress);
BOOL WINAPI MoveFileA (LPCSTR lpExistingFileName, LPCSTR lpNewFileName);
BOOL WINAPI MoveFileExA (LPCSTR lpExistingFileName, LPCSTR lpNewFileName, DWORD dwFlags);
BOOL WINAPI MoveFileExW (LPCWSTR lpExistingFileName, LPCWSTR lpNewFileName, DWORD dwFlags);
BOOL WINAPI MoveFileW (LPCWSTR lpExistingFileName, LPCWSTR lpNewFileName);
INT WINAPI MulDiv (INT nNumber, INT nNumerator, INT nDenominator);
INT WINAPI MultiByteToWideChar (UINT CodePage, DWORD dwFlags, LPCSTR lpMultiByteStr, INT cchMultiByte, LPWSTR lpWideCharStr, INT cchWideChar);
HANDLE WINAPI OpenEventA (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCSTR lpName);
HANDLE WINAPI OpenEventW (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCWSTR lpName);
HANDLE WINAPI OpenFileMappingA (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCSTR lpName);
HANDLE WINAPI OpenFileMappingW (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCWSTR lpName);
HANDLE WINAPI OpenMutexA (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCSTR lpName);
HANDLE WINAPI OpenMutexW (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCWSTR lpName);
HANDLE WINAPI OpenSemaphoreA (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCSTR lpName);
HANDLE WINAPI OpenSemaphoreW (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCWSTR lpName);
VOID WINAPI OutputDebugStringA (LPCSTR lpOutputString);
VOID WINAPI OutputDebugStringW (LPCWSTR lpOutputString);
BOOL WINAPI PulseEvent (HANDLE hEvent);
BOOL WINAPI QueryPerformanceCounter (LARGE_INTEGER *lpPerformanceCount);
BOOL WINAPI QueryPerformanceFrequency (LARGE_INTEGER *lpFrequency);
VOID WINAPI RaiseException (DWORD dwExceptionCode, DWORD dwExceptionFlags, DWORD nNumberOfArguments, CONST ULONG_PTR *lpArguments);
BOOL WINAPI ReadFile (HANDLE hFile, LPVOID lpBuffer, DWORD nNumberOfBytesToRead, LPDWORD lpNumberOfBytesRead, LPOVERLAPPED lpOverlapped);
BOOL WINAPI ReleaseMutex (HANDLE hMutex);
BOOL WINAPI ReleaseSemaphore (HANDLE hSemaphore, LONG lReleaseCount, LPLONG lpPreviousCount);
BOOL WINAPI RemoveDirectoryA (LPCSTR lpPathName);
BOOL WINAPI RemoveDirectoryW (LPCWSTR lpPathName);
BOOL WINAPI ResetEvent (HANDLE hEvent);
DWORD WINAPI ResumeThread (HANDLE hThread);
VOID WINAPI RtlUnwind (PVOID TargetFrame, PVOID TargetIp, PEXCEPTION_RECORD ExceptionRecord, PVOID ReturnValue);
BOOL WINAPI SetConsoleScreenBufferSize (HANDLE hConsoleOutput, COORD dwSize);
BOOL WINAPI SetCurrentDirectoryA (LPCSTR lpPathName);
BOOL WINAPI SetCurrentDirectoryW (LPCWSTR lpPathName);
BOOL WINAPI SetEndOfFile (HANDLE hFile);
BOOL WINAPI SetEnvironmentVariableA (LPCSTR lpName, LPCSTR lpValue);
BOOL WINAPI SetEnvironmentVariableW (LPCWSTR lpName, LPCWSTR lpValue);
BOOL WINAPI SetEvent (HANDLE hEvent);
DWORD WINAPI SetFilePointer (HANDLE hFile, LONG lDistanceToMove, PLONG lpDistanceToMoveHigh, DWORD dwMoveMethod);
BOOL WINAPI SetFileTime (HANDLE hFile, LPCFILETIME lpCreationTime, LPCFILETIME lpLastAccessTime, LPCFILETIME lpLastWriteTime);
UINT WINAPI SetHandleCount (UINT uNumber);
VOID WINAPI SetLastError (DWORD dwErrCode);
BOOL WINAPI SetProcessAffinityMask (HANDLE hProcess, DWORD dwProcessAffinityMask);
BOOL WINAPI SetStdHandle (DWORD nStdHandle, HANDLE hHandle);
DWORD WINAPI SetThreadAffinityMask (HANDLE hThread, DWORD dwThreadAffinityMask);
BOOL WINAPI SetThreadPriority (HANDLE hThread, INT nPriority);
BOOL WINAPI SetTimeZoneInformation (LPCTIME_ZONE_INFORMATION lpTimeZoneInformation);
LPTOP_LEVEL_EXCEPTION_FILTER WINAPI SetUnhandledExceptionFilter (LPTOP_LEVEL_EXCEPTION_FILTER lpTopLevelExceptionFilter);
DWORD WINAPI SizeofResource (HMODULE hModule, HRSRC hResInfo);
VOID WINAPI Sleep (DWORD dwMilliseconds);
DWORD WINAPI SuspendThread (HANDLE hThread);
BOOL WINAPI SystemTimeToFileTime (LPCSYSTEMTIME lpSystemTime, LPFILETIME lpFileTime);
BOOL WINAPI TerminateProcess (HANDLE hProcess, UINT uExitCode);
DWORD WINAPI TlsAlloc (VOID);
BOOL WINAPI TlsFree (DWORD dwTlsIndex);
LPVOID WINAPI TlsGetValue (DWORD dwTlsIndex);
BOOL WINAPI TlsSetValue (DWORD dwTlsIndex, LPVOID lpTlsValue);
BOOL WINAPI TryEnterCriticalSection (LPCRITICAL_SECTION lpCriticalSection);
BOOL WINAPI UnmapViewOfFile (LPCVOID lpBaseAddress);
DWORD WINAPI VerLanguageNameA (DWORD wLang, LPSTR szLang, DWORD nSize);
DWORD WINAPI VerLanguageNameW (DWORD wLang, LPWSTR szLang, DWORD nSize);
LPVOID WINAPI VirtualAlloc (LPVOID lpAddress, DWORD dwSize, DWORD flAllocationType, DWORD flProtect);
BOOL WINAPI VirtualFree (LPVOID lpAddress, DWORD dwSize, DWORD dwFreeType);
BOOL WINAPI VirtualLock (LPVOID lpAddress, DWORD dwSize);
BOOL WINAPI VirtualProtect (LPVOID lpAddress, DWORD dwSize, DWORD flNewProtect, PDWORD lpflOldProtect);
DWORD WINAPI VirtualQuery (LPCVOID lpAddress, PMEMORY_BASIC_INFORMATION lpBuffer, DWORD dwLength);
BOOL WINAPI VirtualUnlock (LPVOID lpAddress, DWORD dwSize);
DWORD WINAPI WaitForMultipleObjects (DWORD nCount, CONST HANDLE *lpHandles, BOOL fWaitAll, DWORD dwMilliseconds);
DWORD WINAPI WaitForSingleObject (HANDLE hHandle, DWORD dwMilliseconds);
INT WINAPI WideCharToMultiByte (UINT CodePage, DWORD dwFlags, LPCWSTR lpWideCharStr, INT cchWideChar, LPSTR lpMultiByteStr, INT cchMultiByte, LPCSTR lpDefaultChar, LPBOOL lpUsedDefaultChar);
BOOL WINAPI WriteConsoleA (HANDLE hConsoleOutput, LPCVOID lpBuffer, DWORD nNumberOfCharsToWrite, LPDWORD lpNumberOfCharsWritten, LPVOID lpReserved);
BOOL WINAPI WriteConsoleW (HANDLE hConsoleOutput, LPCVOID lpBuffer, DWORD nNumberOfCharsToWrite, LPDWORD lpNumberOfCharsWritten, LPVOID lpReserved);
BOOL WINAPI WriteFile (HANDLE hFile, LPCVOID lpBuffer, DWORD nNumberOfBytesToWrite, LPDWORD lpNumberOfBytesWritten, LPOVERLAPPED lpOverlapped);
BOOL WINAPI WritePrivateProfileSectionA (LPCSTR lpAppName, LPCSTR lpString, LPCSTR lpFileName);
BOOL WINAPI WritePrivateProfileSectionW (LPCWSTR lpAppName, LPCWSTR lpString, LPCWSTR lpFileName);
BOOL WINAPI WritePrivateProfileStringA (LPCSTR lpAppName, LPCSTR lpKeyName, LPCSTR lpString, LPCSTR lpFileName);
BOOL WINAPI WritePrivateProfileStringW (LPCWSTR lpAppName, LPCWSTR lpKeyName, LPCWSTR lpString, LPCWSTR lpFileName);
BOOL WINAPI WritePrivateProfileStructA (LPCSTR lpszSection, LPCSTR lpszKey, LPVOID lpStruct, UINT uSizeStruct, LPCSTR szFile);
BOOL WINAPI WritePrivateProfileStructW (LPCWSTR lpszSection, LPCWSTR lpszKey, LPVOID lpStruct, UINT uSizeStruct, LPCWSTR szFile);
BOOL WINAPI WriteProfileSectionA (LPCSTR lpAppName, LPCSTR lpString);
BOOL WINAPI WriteProfileSectionW (LPCWSTR lpAppName, LPCWSTR lpString);
BOOL WINAPI WriteProfileStringA (LPCSTR lpAppName, LPCSTR lpKeyName, LPCSTR lpString);
BOOL WINAPI WriteProfileStringW (LPCWSTR lpAppName, LPCWSTR lpKeyName, LPCWSTR lpString);
HFILE WINAPI _lclose (HFILE hFile);
HFILE WINAPI _lcreat (LPCSTR lpPathName, INT iAttribute);
LONG WINAPI _llseek (HFILE hFile, LONG lOffset, INT iOrigin);
HFILE WINAPI _lopen (LPCSTR lpPathName, INT iReadWrite);
UINT WINAPI _lread (HFILE hFile, LPVOID lpBuffer, UINT uBytes);
UINT WINAPI _lwrite (HFILE hFile, LPVOID lpBuffer, UINT uBytes);
LPSTR WINAPI lstrcatA (LPSTR lpString1, LPCSTR lpString2);
LPWSTR WINAPI lstrcatW (LPWSTR lpString1, LPCWSTR lpString2);
INT WINAPI lstrcmpA (LPCSTR lpString1, LPCSTR lpString2);
INT WINAPI lstrcmpW (LPCWSTR lpString1, LPCWSTR lpString2);
INT WINAPI lstrcmpiA (LPCSTR lpString1, LPCSTR lpString2);
INT WINAPI lstrcmpiW (LPCWSTR lpString1, LPCWSTR lpString2);
LPSTR WINAPI lstrcpyA (LPSTR lpString1, LPCSTR lpString2);
LPWSTR WINAPI lstrcpyW (LPWSTR lpString1, LPCWSTR lpString2);
LPSTR WINAPI lstrcpynA (LPSTR lpString1, LPCSTR lpString2, INT iMaxLength);
LPWSTR WINAPI lstrcpynW (LPWSTR lpString1, LPCWSTR lpString2, INT iMaxLength);
INT WINAPI lstrlenA (LPCSTR lpString);
INT WINAPI lstrlenW (LPCWSTR lpString);


#ifdef UNICODE
# define AddAtom AddAtomW
# define CompareString CompareStringW
# define CopyFile CopyFileW
# define CreateDirectory CreateDirectoryW
# define CreateEvent CreateEventW
# define CreateFile CreateFileW
# define CreateFileMapping CreateFileMappingW
# define CreateMutex CreateMutexW
# define CreateProcess CreateProcessW
# define CreateSemaphore CreateSemaphoreW
# define DeleteFile DeleteFileW
# define EnumCalendarInfo EnumCalendarInfoW
# define FindAtom FindAtomW
# define FindFirstFile FindFirstFileW
# define FindNextFile FindNextFileW
# define FindResource FindResourceW
# define FindResourceEx FindResourceExW
# define FreeEnvironmentStrings FreeEnvironmentStringsW
# define GetAtomName GetAtomNameW
# define GetCPInfoEx GetCPInfoExW
# define GetCommandLine GetCommandLineW
# define GetCurrentDirectory GetCurrentDirectoryW
# define GetDiskFreeSpace GetDiskFreeSpaceW
# define GetDiskFreeSpaceEx GetDiskFreeSpaceExW
# define GetEnvironmentStrings GetEnvironmentStringsW
# define GetEnvironmentVariable GetEnvironmentVariableW
# define GetFileAttributes GetFileAttributesW
# define GetFullPathName GetFullPathNameW
# define GetLocaleInfo GetLocaleInfoW
# define GetLogicalDriveStrings GetLogicalDriveStringsW
# define GetModuleFileName GetModuleFileNameW
# define GetModuleHandle GetModuleHandleW
# define GetPrivateProfileInt GetPrivateProfileIntW
# define GetPrivateProfileSection GetPrivateProfileSectionW
# define GetPrivateProfileString GetPrivateProfileStringW
# define GetPrivateProfileStruct GetPrivateProfileStructW
# define GetProfileInt GetProfileIntW
# define GetProfileSection GetProfileSectionW
# define GetProfileString GetProfileStringW
# define GetShortPathName GetShortPathNameW
# define GetStartupInfo GetStartupInfoW
# define GetStringType GetStringTypeW
# define GetSystemDirectory GetSystemDirectoryW
# define GetTempFileName GetTempFileNameW
# define GetTempPath GetTempPathW
# define GetVersionEx GetVersionExW
# define GlobalAddAtom GlobalAddAtomW
# define GlobalFindAtom GlobalFindAtomW
# define GlobalGetAtomName GlobalGetAtomNameW
# define LCMapString LCMapStringW
# define LoadLibrary LoadLibraryW
# define LoadLibraryEx LoadLibraryExW
# define MoveFile MoveFileW
# define MoveFileEx MoveFileExW
# define OpenEvent OpenEventW
# define OpenFileMapping OpenFileMappingW
# define OpenMutex OpenMutexW
# define OpenSemaphore OpenSemaphoreW
# define OutputDebugString OutputDebugStringW
# define RemoveDirectory RemoveDirectoryW
# define SetCurrentDirectory SetCurrentDirectoryW
# define SetEnvironmentVariable SetEnvironmentVariableW
# define VerLanguageName VerLanguageNameW
# define WriteConsole WriteConsoleW
# define WritePrivateProfileSection WritePrivateProfileSectionW
# define WritePrivateProfileString WritePrivateProfileStringW
# define WritePrivateProfileStruct WritePrivateProfileStructW
# define WriteProfileSection WriteProfileSectionW
# define WriteProfileString WriteProfileStringW
# define lstrcat lstrcatW
# define lstrcmp lstrcmpW
# define lstrcmpi lstrcmpiW
# define lstrcpy lstrcpyW
# define lstrcpyn lstrcpynW
# define lstrlen lstrlenW
#else /* not UNICODE*/
# define AddAtom AddAtomA
# define CompareString CompareStringA
# define CopyFile CopyFileA
# define CreateDirectory CreateDirectoryA
# define CreateEvent CreateEventA
# define CreateFile CreateFileA
# define CreateFileMapping CreateFileMappingA
# define CreateMutex CreateMutexA
# define CreateProcess CreateProcessA
# define CreateSemaphore CreateSemaphoreA
# define DeleteFile DeleteFileA
# define EnumCalendarInfo EnumCalendarInfoA
# define FindAtom FindAtomA
# define FindFirstFile FindFirstFileA
# define FindNextFile FindNextFileA
# define FindResource FindResourceA
# define FindResourceEx FindResourceExA
# define FreeEnvironmentStrings FreeEnvironmentStringsA
# define GetAtomName GetAtomNameA
# define GetCPInfoEx GetCPInfoExA
# define GetCommandLine GetCommandLineA
# define GetCurrentDirectory GetCurrentDirectoryA
# define GetDiskFreeSpace GetDiskFreeSpaceA
# define GetDiskFreeSpaceEx GetDiskFreeSpaceExA
# define GetEnvironmentStrings GetEnvironmentStringsA
# define GetEnvironmentVariable GetEnvironmentVariableA
# define GetFileAttributes GetFileAttributesA
# define GetFullPathName GetFullPathNameA
# define GetLocaleInfo GetLocaleInfoA
# define GetLogicalDriveStrings GetLogicalDriveStringsA
# define GetModuleFileName GetModuleFileNameA
# define GetModuleHandle GetModuleHandleA
# define GetPrivateProfileInt GetPrivateProfileIntA
# define GetPrivateProfileSection GetPrivateProfileSectionA
# define GetPrivateProfileString GetPrivateProfileStringA
# define GetPrivateProfileStruct GetPrivateProfileStructA
# define GetProfileInt GetProfileIntA
# define GetProfileSection GetProfileSectionA
# define GetProfileString GetProfileStringA
# define GetShortPathName GetShortPathNameA
# define GetStartupInfo GetStartupInfoA
# define GetStringType GetStringTypeA
# define GetSystemDirectory GetSystemDirectoryA
# define GetTempFileName GetTempFileNameA
# define GetTempPath GetTempPathA
# define GetVersionEx GetVersionExA
# define GlobalAddAtom GlobalAddAtomA
# define GlobalFindAtom GlobalFindAtomA
# define GlobalGetAtomName GlobalGetAtomNameA
# define LCMapString LCMapStringA
# define LoadLibrary LoadLibraryA
# define LoadLibraryEx LoadLibraryExA
# define MoveFile MoveFileA
# define MoveFileEx MoveFileExA
# define OpenEvent OpenEventA
# define OpenFileMapping OpenFileMappingA
# define OpenMutex OpenMutexA
# define OpenSemaphore OpenSemaphoreA
# define OutputDebugString OutputDebugStringA
# define RemoveDirectory RemoveDirectoryA
# define SetCurrentDirectory SetCurrentDirectoryA
# define SetEnvironmentVariable SetEnvironmentVariableA
# define VerLanguageName VerLanguageNameA
# define WriteConsole WriteConsoleA
# define WritePrivateProfileSection WritePrivateProfileSectionA
# define WritePrivateProfileString WritePrivateProfileStringA
# define WritePrivateProfileStruct WritePrivateProfileStructA
# define WriteProfileSection WriteProfileSectionA
# define WriteProfileString WriteProfileStringA
# define lstrcat lstrcatA
# define lstrcmp lstrcmpA
# define lstrcmpi lstrcmpiA
# define lstrcpy lstrcpyA
# define lstrcpyn lstrcpynA
# define lstrlen lstrlenA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __KERNEL32_H__ */
