/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __W32PRIVATE_H__
#define __W32PRIVATE_H__


#include "user32.h"
#include "commctrl.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


typedef struct _W32LdrClassData
{
  WNDPROC lpfnWndProc;
  HINSTANCE hInstance;
  gboolean widechar;
  gchar *classname;
  gchar *menuname;
  guint16 atom;
} W32LdrClassData;
typedef struct _W32LdrWindowData
{
  DWORD dwStyle;
  DWORD dwExStyle;
  WNDPROC lpfnWndProc;
  HINSTANCE hInstance;
  HWND hWndParent;
  WORD wID;
  DWORD dwUserData;
  DLGPROC lpDialogFunc;
  LRESULT lResult;
  DWORD dwUser;
  LPCREATESTRUCTA csa;
  LPCREATESTRUCTW csw;
  DWORD dwInitParam;
  gboolean widechar;
  gboolean resizable;
  gchar *classname;
  GtkWidget *focus;
  GtkWidget **child;
} W32LdrWindowData;
typedef struct _W32LdrOverlapData
{
  W32LdrWindowData wd;
  GtkWidget *table;
  GtkWidget *fixed;
  GtkWidget *menu;
  GtkWidget *hscroll;
  GtkWidget *vscroll;
} W32LdrOverlapData;
typedef struct _W32LdrPageData
{
  W32LdrWindowData wd;
  gboolean edited;
  gchar *title;
  LPPROPSHEETPAGEA lppspa;
  LPPROPSHEETPAGEW lppspw;
} W32LdrPageData;


/******************************************************************************
*                                                                             *
* ja:プロトタイプ宣言                                                         *
*                                                                             *
******************************************************************************/
GtkWidget *
w32ldr_control_create_button (const gchar    *windowname,
                              const guint32   style,
                              const guint32   exstyle,
                              const gint      width,
                              const gint      height,
                              const guint16   id,
                              HWND            hWndParent,
                              HINSTANCE       hInstance,
                              const gboolean  widechar);


GtkWidget *
w32ldr_control_create_edit (const gchar    *windowname,
                            const guint32   style,
                            const guint32   exstyle,
                            const gint      width,
                            const gint      height,
                            const guint16   id,
                            HWND            hWndParent,
                            HINSTANCE       hInstance,
                            const gboolean  widechar);


GtkWidget *
w32ldr_control_create_static (const gchar    *windowname,
                              const guint32   style,
                              const guint32   exstyle,
                              const gint      width,
                              const gint      height,
                              const guint16   id,
                              HWND            hWndParent,
                              HINSTANCE       hInstance,
                              const gboolean  widechar);


GtkWidget *
w32ldr_control_create_list (const gchar    *windowname,
                            const guint32   style,
                            const guint32   exstyle,
                            const gint      width,
                            const gint      height,
                            const guint16   id,
                            HWND            hWndParent,
                            HINSTANCE       hInstance,
                            const gboolean  widechar);


GtkWidget *
w32ldr_control_create_scroll (const gchar    *windowname,
                              const guint32   style,
                              const guint32   exstyle,
                              const gint      width,
                              const gint      height,
                              const guint16   id,
                              HWND            hWndParent,
                              HINSTANCE       hInstance,
                              const gboolean  widechar);


GtkWidget *
w32ldr_control_create_combo (const gchar    *windowname,
                             const guint32   style,
                             const guint32   exstyle,
                             const gint      width,
                             const gint      height,
                             const guint16   id,
                             HWND            hWndParent,
                             HINSTANCE       hInstance,
                             const gboolean  widechar);


GtkWidget *
w32ldr_control_create_tool (const gchar    *windowname,
                            const guint32   style,
                            const guint32   exstyle,
                            const gint      width,
                            const gint      height,
                            const guint16   id,
                            HWND            hWndParent,
                            HINSTANCE       hInstance,
                            const gboolean  widechar);


GtkWidget *
w32ldr_control_create_stat (const gchar    *windowname,
                            const guint32   style,
                            const guint32   exstyle,
                            const gint      width,
                            const gint      height,
                            const guint16   id,
                            HWND            hWndParent,
                            HINSTANCE       hInstance,
                            const gboolean  widechar);


GtkWidget *
w32ldr_control_create_prsht (const gchar    *windowname,
                             const guint32   style,
                             const guint32   exstyle,
                             const gint      width,
                             const gint      height,
                             const guint16   id,
                             HWND            hWndParent,
                             HINSTANCE       hInstance,
                             const gboolean  widechar);


GtkWidget *
w32ldr_control_create_lview (const gchar    *windowname,
                             const guint32   style,
                             const guint32   exstyle,
                             const gint      width,
                             const gint      height,
                             const guint16   id,
                             HWND            hWndParent,
                             HINSTANCE       hInstance,
                             const gboolean  widechar);


GtkWidget *
w32ldr_control_create_tview (const gchar    *windowname,
                             const guint32   style,
                             const guint32   exstyle,
                             const gint      width,
                             const gint      height,
                             const guint16   id,
                             HWND            hWndParent,
                             HINSTANCE       hInstance,
                             const gboolean  widechar);


GtkWidget *
w32ldr_control_create_prgrs (const gchar    *windowname,
                             const guint32   style,
                             const guint32   exstyle,
                             const gint      width,
                             const gint      height,
                             const guint16   id,
                             HWND            hWndParent,
                             HINSTANCE       hInstance,
                             const gboolean  widechar);


GtkWidget *
w32ldr_control_create_updwn (const gchar    *windowname,
                             const guint32   style,
                             const guint32   exstyle,
                             const gint      width,
                             const gint      height,
                             const guint16   id,
                             HWND            hWndParent,
                             HINSTANCE       hInstance,
                             const gboolean  widechar);


/******************************************************************************
*                                                                             *
* ja:クラス関数群                                                             *
*                                                                             *
******************************************************************************/
extern GHashTable *ghash_class;


ATOM
w32ldr_RegisterClassEx (UINT            style,
                        WNDPROC         lpfnWndProc,
                        INT             cbClsExtra,
                        INT             cbWndExtra,
                        HINSTANCE       hInstance,
                        HICON           hIcon,
                        HCURSOR         hCursor,
                        HBRUSH          hbrBackground,
                        const gchar    *menuname,
                        const gchar    *classname,
                        HICON           hIconSm,
                        const gboolean  widechar);


/******************************************************************************
*                                                                             *
* ja:ダイアログ関数群                                                         *
*                                                                             *
******************************************************************************/
HWND
w32ldr_CreateDialogIndirectParam (HINSTANCE      hInstance,
                                  LPCDLGTEMPLATE lpDialogTemplate,
                                  HWND           hWndParent,
                                  DLGPROC        lpDialogFunc,
                                  LPARAM         dwInitParam,
                                  const gboolean modal,
                                  const gboolean widechar);


/******************************************************************************
*                                                                             *
* ja:ダイアログサポート関数群                                                 *
*                                                                             *
******************************************************************************/
gsize
w32ldr_dialog_get_template_size (LPCDLGTEMPLATE lpDialogTemplate);


LPDLGTEMPLATE
w32ldr_dialog_dup_template (LPCDLGTEMPLATE lpDialogTemplate);


gchar *
w32ldr_dialog_get_title (LPCDLGTEMPLATE lpDialogTemplate);


/******************************************************************************
*                                                                             *
* ja:メニュー関数群                                                           *
*                                                                             *
******************************************************************************/
HMENU
w32ldr_LoadMenuIndirect (HINSTANCE       hInstance,
                         LPCMENUTEMPLATE lpMenuTemplate);


/******************************************************************************
*                                                                             *
* ja:メニューサポート関数群                                                   *
*                                                                             *
******************************************************************************/
GdkPixbuf *
w32ldr_menu_get_pixbuf_check (void);


GdkPixbuf *
w32ldr_menu_get_pixbuf_radio (void);


gint
w32ldr_menu_get_item_pos (GtkWidget   *menu,
                          const guint  item);


GtkWidget *
w32ldr_menu_get_item (GtkWidget   *menu,
                      const gint   pos,
                      const guint  flags);


/******************************************************************************
*                                                                             *
* ja:ウインドウ関数群                                                         *
*                                                                             *
******************************************************************************/
HWND
w32ldr_CreateWindowEx (DWORD           dwExStyle,
                       const gchar    *classname,
                       const gchar    *windowname,
                       DWORD           dwStyle,
                       const gint      x,
                       const gint      y,
                       const gint      width,
                       const gint      height,
                       HWND            hWndParent,
                       HMENU           hMenu,
                       HINSTANCE       hInstance,
                       LPVOID          lpvParam,
                       const gboolean  widechar);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __W32PRIVATE_H__ */
