/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __W32TVIEW_H__
#define __W32TVIEW_H__


#include "user32.h"


/* ja:ツリービュー */
#define WC_TREEVIEWA "SysTreeView32"
#define WC_TREEVIEWW (w32ldr_tchar_to_wc("SysTreeView32"))
#ifdef UNICODE
# define WC_TREEVIEW WC_TREEVIEWW
#else /* not UNICODE */
# define WC_TREEVIEW WC_TREEVIEWA
#endif /* not UNICODE */

typedef LPVOID HTREEITEM;

#define TVS_HASBUTTONS      0x0001
#define TVS_HASLINES        0x0002
#define TVS_LINESATROOT     0x0004
#define TVS_EDITLABELS      0x0008
#define TVS_DISABLEDRAGDROP 0x0010
#define TVS_SHOWSELALWAYS   0x0020
#define TVS_RTLREADING      0x0040
#define TVS_NOTOOLTIPS      0x0080
#define TVS_CHECKBOXES      0x0100
#define TVS_TRACKSELECT     0x0200
#define TVS_SINGLEEXPAND    0x0400
#define TVS_INFOTIP         0x0800
#define TVS_FULLROWSELECT   0x1000
#define TVS_NOSCROLL        0x2000
#define TVS_NONEVENHEIGHT   0x4000
#define TVS_NOHSCROLL       0x8000
#define TV_FIRST                0x1100
#define TVM_INSERTITEMA         (TV_FIRST+0)
#define TVM_INSERTITEMW         (TV_FIRST+50)
#define TVM_DELETEITEM          (TV_FIRST+1)
#define TVM_EXPAND              (TV_FIRST+2)
#define TVM_GETITEMRECT         (TV_FIRST+4)
#define TVM_GETCOUNT            (TV_FIRST+5)
#define TVM_GETINDENT           (TV_FIRST+6)
#define TVM_SETINDENT           (TV_FIRST+7)
#define TVM_GETIMAGELIST        (TV_FIRST+8)
#define TVM_SETIMAGELIST        (TV_FIRST+9)
#define TVM_GETNEXTITEM         (TV_FIRST+10)
#define TVM_SELECTITEM          (TV_FIRST+11)
#define TVM_GETITEMA            (TV_FIRST+12)
#define TVM_GETITEMW            (TV_FIRST+62)
#define TVM_SETITEMA            (TV_FIRST+13)
#define TVM_SETITEMW            (TV_FIRST+63)
#define TVM_EDITLABELA          (TV_FIRST+14)
#define TVM_EDITLABELW          (TV_FIRST+65)
#define TVM_GETEDITCONTROL      (TV_FIRST+15)
#define TVM_GETVISIBLECOUNT     (TV_FIRST+16)
#define TVM_HITTEST             (TV_FIRST+17)
#define TVM_CREATEDRAGIMAGE     (TV_FIRST+18)
#define TVM_SORTCHILDREN        (TV_FIRST+19)
#define TVM_ENSUREVISIBLE       (TV_FIRST+20)
#define TVM_SORTCHILDRENCB      (TV_FIRST+21)
#define TVM_ENDEDITLABELNOW     (TV_FIRST+22)
#define TVM_GETISEARCHSTRINGA   (TV_FIRST+23)
#define TVM_GETISEARCHSTRINGW   (TV_FIRST+64)
#define TVM_SETTOOLTIPS         (TV_FIRST+24)
#define TVM_GETTOOLTIPS         (TV_FIRST+25)
#define TVM_SETINSERTMARK       (TV_FIRST+26)
#define TVM_SETITEMHEIGHT       (TV_FIRST+27)
#define TVM_GETITEMHEIGHT       (TV_FIRST+28)
#define TVM_SETBKCOLOR          (TV_FIRST+29)
#define TVM_SETTEXTCOLOR        (TV_FIRST+30)
#define TVM_GETBKCOLOR          (TV_FIRST+31)
#define TVM_GETTEXTCOLOR        (TV_FIRST+32)
#define TVM_SETSCROLLTIME       (TV_FIRST+33)
#define TVM_GETSCROLLTIME       (TV_FIRST+34)
#define TVM_SETINSERTMARKCOLOR  (TV_FIRST+37)
#define TVM_GETINSERTMARKCOLOR  (TV_FIRST+38)
#define TVM_GETITEMSTATE        (TV_FIRST+39)
#define TVM_SETLINECOLOR        (TV_FIRST+40)
#define TVM_GETLINECOLOR        (TV_FIRST+41)
#define TVM_SETUNICODEFORMAT    CCM_SETUNICODEFORMAT
#define TVM_GETUNICODEFORMAT    CCM_GETUNICODEFORMAT
#define TVM_MAPACCIDTOHTREEITEM (TV_FIRST+42)
#define TVM_MAPHTREEITEMTOACCID (TV_FIRST+43)
#ifdef UNICODE
# define TVM_INSERTITEM       TVM_INSERTITEMW
# define TVM_GETITEM          TVM_GETITEMW
# define TVM_SETITEM          TVM_SETITEMW
# define TVM_EDITLABEL        TVM_EDITLABELW
# define TVM_GETISEARCHSTRING TVM_GETISEARCHSTRINGW
#else /* not UNICODE */
# define TVM_INSERTITEM       TVM_INSERTITEMA
# define TVM_GETITEM          TVM_GETITEMA
# define TVM_SETITEM          TVM_SETITEMA
# define TVM_EDITLABEL        TVM_EDITLABELA
# define TVM_GETISEARCHSTRING TVM_GETISEARCHSTRINGA
#endif /* not UNICODE */
#define TVN_FIRST           (-400)
#define TVN_LAST            (-499)
#define TVN_SELCHANGINGA    (TVN_FIRST-1)
#define TVN_SELCHANGINGW    (TVN_FIRST-50)
#define TVN_SELCHANGEDA     (TVN_FIRST-2)
#define TVN_SELCHANGEDW     (TVN_FIRST-51)
#define TVN_GETDISPINFOA    (TVN_FIRST-3)
#define TVN_GETDISPINFOW    (TVN_FIRST-52)
#define TVN_SETDISPINFOA    (TVN_FIRST-4)
#define TVN_SETDISPINFOW    (TVN_FIRST-53)
#define TVN_ITEMEXPANDINGA  (TVN_FIRST-5)
#define TVN_ITEMEXPANDINGW  (TVN_FIRST-54)
#define TVN_ITEMEXPANDEDA   (TVN_FIRST-6)
#define TVN_ITEMEXPANDEDW   (TVN_FIRST-55)
#define TVN_BEGINDRAGA      (TVN_FIRST-7)
#define TVN_BEGINDRAGW      (TVN_FIRST-56)
#define TVN_BEGINRDRAGA     (TVN_FIRST-8)
#define TVN_BEGINRDRAGW     (TVN_FIRST-57)
#define TVN_DELETEITEMA     (TVN_FIRST-9)
#define TVN_DELETEITEMW     (TVN_FIRST-58)
#define TVN_BEGINLABELEDITA (TVN_FIRST-10)
#define TVN_BEGINLABELEDITW (TVN_FIRST-59)
#define TVN_ENDLABELEDITA   (TVN_FIRST-11)
#define TVN_ENDLABELEDITW   (TVN_FIRST-60)
#define TVN_KEYDOWN         (TVN_FIRST-12)
#ifdef UNICODE
# define TVN_SELCHANGING    TVN_SELCHANGINGW
# define TVN_SELCHANGED     TVN_SELCHANGEDW
# define TVN_GETDISPINFO    TVN_GETDISPINFOW
# define TVN_SETDISPINFO    TVN_SETDISPINFOW
# define TVN_ITEMEXPANDING  TVN_ITEMEXPANDINGW
# define TVN_ITEMEXPANDED   TVN_ITEMEXPANDEDW
# define TVN_BEGINDRAG      TVN_BEGINDRAGW
# define TVN_BEGINRDRAG     TVN_BEGINRDRAGW
# define TVN_DELETEITEM     TVN_DELETEITEMW
# define TVN_BEGINLABELEDIT TVN_BEGINLABELEDITW
# define TVN_ENDLABELEDIT   TVN_ENDLABELEDITW
#else /* not UNICODE */
# define TVN_SELCHANGING    TVN_SELCHANGINGA
# define TVN_SELCHANGED     TVN_SELCHANGEDA
# define TVN_GETDISPINFO    TVN_GETDISPINFOA
# define TVN_SETDISPINFO    TVN_SETDISPINFOA
# define TVN_ITEMEXPANDING  TVN_ITEMEXPANDINGA
# define TVN_ITEMEXPANDED   TVN_ITEMEXPANDEDA
# define TVN_BEGINDRAG      TVN_BEGINDRAGA
# define TVN_BEGINRDRAG     TVN_BEGINRDRAGA
# define TVN_DELETEITEM     TVN_DELETEITEMA
# define TVN_BEGINLABELEDIT TVN_BEGINLABELEDITA
# define TVN_ENDLABELEDIT   TVN_ENDLABELEDITA
#endif /* not UNICODE */

#define TVSIL_NORMAL 0
#define TVSIL_STATE  2

#define TVE_COLLAPSE      0x0001
#define TVE_EXPAND        0x0002
#define TVE_TOGGLE        0x0003
#define TVE_COLLAPSERESET 0x8000

#define TVGN_ROOT            0
#define TVGN_NEXT            1
#define TVGN_PREVIOUS        2
#define TVGN_PARENT          3
#define TVGN_CHILD           4
#define TVGN_FIRSTVISIBLE    5
#define TVGN_NEXTVISIBLE     6
#define TVGN_PREVIOUSVISIBLE 7
#define TVGN_DROPHILITE      8
#define TVGN_CARET           9

#define TVI_ROOT  ((HTREEITEM)GUINT_TO_POINTER(0xffff0000))
#define TVI_FIRST ((HTREEITEM)GUINT_TO_POINTER(0xffff0001))
#define TVI_LAST  ((HTREEITEM)GUINT_TO_POINTER(0xffff0002))
#define TVI_SORT  ((HTREEITEM)GUINT_TO_POINTER(0xffff0003))

#define TVIF_TEXT           0x0001
#define TVIF_IMAGE          0x0002
#define TVIF_PARAM          0x0004
#define TVIF_STATE          0x0008
#define TVIF_HANDLE         0x0010
#define TVIF_SELECTEDIMAGE  0x0020
#define TVIF_CHILDREN       0x0040
#define TVIS_FOCUSED        0x0001
#define TVIS_SELECTED       0x0002
#define TVIS_CUT            0x0004
#define TVIS_DROPHILITED    0x0008
#define TVIS_BOLD           0x0010
#define TVIS_EXPANDED       0x0020
#define TVIS_EXPANDEDONCE   0x0040
#define TVIS_OVERLAYMASK    0x0f00
#define TVIS_STATEIMAGEMASK 0xf000
#define TVIS_USERMASK       TVIS_STATEIMAGEMASK
#include "pshpack1.h"
typedef struct _TV_ITEMA
{
  UINT mask;
  HTREEITEM hItem;
  UINT state;
  UINT stateMask;
  LPSTR pszText;
  INT cchTextMax;
  INT iImage;
  INT iSelectedImage;
  INT cChildren;
  LPARAM lParam;
} TV_ITEMA, *PTV_ITEMA, *LPTV_ITEMA;
typedef struct _TV_ITEMW
{
  UINT mask;
  HTREEITEM hItem;
  UINT state;
  UINT stateMask;
  LPWSTR pszText;
  INT cchTextMax;
  INT iImage;
  INT iSelectedImage;
  INT cChildren;
  LPARAM lParam;
} TV_ITEMW, *PTV_ITEMW, *LPTV_ITEMW;
#include "poppack.h"
#ifdef UNICODE
# define TV_ITEM TV_ITEMW
# define PTV_ITEM PTV_ITEMW
# define LPTV_ITEM LPTV_ITEMW
#else /* not UNICODE */
# define TV_ITEM TV_ITEMA
# define PTV_ITEM PTV_ITEMA
# define LPTV_ITEM LPTV_ITEMA
#endif /* not UNICODE */

#include "pshpack1.h"
typedef struct _TV_INSERTSTRUCTA
{
  HTREEITEM hParent;
  HTREEITEM hInsertAfter;
  TV_ITEMA item;
} TV_INSERTSTRUCTA, *PTV_INSERTSTRUCTA, *LPTV_INSERTSTRUCTA;
typedef struct _TVINSERTSTRUCTW
{
  HTREEITEM hParent;
  HTREEITEM hInsertAfter;
  TV_ITEMW item;
} TV_INSERTSTRUCTW, *PTV_INSERTSTRUCTW, *LPTV_INSERTSTRUCTW;
#include "poppack.h"
#ifdef UNICODE
# define TV_INSERTSTRUCT TV_INSERTSTRUCTW
# define PTV_INSERTSTRUCT PTV_INSERTSTRUCTW
# define LPTV_INSERTSTRUCT LPTV_INSERTSTRUCTW
#else /* not UNICODE */
# define TV_INSERTSTRUCT TV_INSERTSTRUCTA
# define PTV_INSERTSTRUCT PTV_INSERTSTRUCTA
# define LPTV_INSERTSTRUCT LPTV_INSERTSTRUCTA
#endif /* not UNICODE */

#define TVHT_NOWHERE         0x0001
#define TVHT_ONITEMICON      0x0002
#define TVHT_ONITEMLABEL     0x0004
#define TVHT_ONITEMINDENT    0x0008
#define TVHT_ONITEMBUTTON    0x0010
#define TVHT_ONITEMRIGHT     0x0020
#define TVHT_ONITEMSTATEICON 0x0040
#define TVHT_ONITEM          0x0046
#define TVHT_ABOVE           0x0100
#define TVHT_BELOW           0x0200
#define TVHT_TORIGHT         0x0400
#define TVHT_TOLEFT          0x0800
#include "pshpack1.h"
typedef struct _TV_HITTESTINFO
{
  POINT pt;
  UINT flags;
  HTREEITEM hItem;
} TV_HITTESTINFO, *PTV_HITTESTINFO, *LPTV_HITTESTINFO;

typedef struct _NM_TREEVIEWA
{
  NMHDR hdr;
  UINT action;
  TV_ITEMA itemOld;
  TV_ITEMA itemNew;
  POINT ptDrag;
} NM_TREEVIEWA, *PNM_TREEVIEWA, *LPNM_TREEVIEWA;
typedef struct _NM_TREEVIEWW
{
  NMHDR hdr;
  UINT action;
  TV_ITEMW itemOld;
  TV_ITEMW itemNew;
  POINT ptDrag;
} NM_TREEVIEWW, *PNM_TREEVIEWW, *LPNM_TREEVIEWW;
#include "poppack.h"
#ifdef UNICODE
# define NM_TREEVIEW NM_TREEVIEWW
# define PNM_TREEVIEW PNM_TREEVIEWW
# define LPNM_TREEVIEW LPNM_TREEVIEWW
#else /* not UNICODE */
# define NM_TREEVIEW NM_TREEVIEWA
# define PNM_TREEVIEW PNM_TREEVIEWA
# define LPNM_TREEVIEW LPNM_TREEVIEWA
#endif /* not UNICODE */

typedef INT CALLBACK (*PFNTVCOMPARE)(LPARAM, LPARAM, LPARAM);
#include "pshpack1.h"
typedef struct _TV_SORTCB
{
  HTREEITEM hParent;
  PFNTVCOMPARE lpfnCompare;
  LPARAM lParam;
} TV_SORTCB, *PTV_SORTCB, *LPTV_SORTCB;
#include "poppack.h"

#define TreeView_CreateDragImage(hWnd,hItem) GINT_TO_POINTER(SendMessage(hWnd,TVM_CREATEDRAGIMAGE,0,GPOINTER_TO_INT(hItem)))
#define TreeView_DeleteAllItems(hWnd) SendMessage(hWnd,TVM_DELETEITEM,0,GPOINTER_TO_INT(TVI_ROOT))
#define TreeView_DeleteItem(hWnd,hItem) SendMessage(hWnd,TVM_DELETEITEM,0,GPOINTER_TO_INT(hItem))
#define TreeView_EditLabelA(hWnd,hItem) GINT_TO_POINTER(SendMessage(hWnd,TVM_EDITLABELA,0,GPOINTER_TO_INT(hItem)))
#define TreeView_EditLabelW(hWnd,hItem) GINT_TO_POINTER(SendMessage(hWnd,TVM_EDITLABELW,0,GPOINTER_TO_INT(hItem)))
#define TreeView_EndEditLabelNow(hWnd,bCancel) SendMessage(hWnd,TVM_ENDEDITLABELNOW,0,bCancel)
#define TreeView_EnsureVisible(hWnd,hItem) SendMessage(hWnd,TVM_ENSUREVISIBLE,0,GPOINTER_TO_INT(hItem))
#define TreeView_Expand(hWnd,hItem,flas) SendMessage(hWnd,TVM_EXPAND,flag,GPOINTER_TO_INT(hItem))
#define TreeView_GetChild(hWnd,hItem) GINT_TO_POINTER(SendMessage(hWnd,TVM_GETNEXTITEM,TVGN_CHILD,GPOINTER_TO_INT(hItem)))
#define TreeView_GetCount(hWnd) SendMessage(hWnd,TVM_GETCOUNT,0,0)
#define TreeView_GetDropHilite(hWnd) GINT_TO_POINTER(SendMessage(hWnd,TVM_GETNEXTITEM,TVGN_DROPHILITE,0))
#define TreeView_GetEditControl(hWnd) GINT_TO_POINTER(SendMessage(hWnd,TVM_GETEDITCONTROL,0,0))
#define TreeView_GetFirstVisible(hWnd,hItem) GINT_TO_POINTER(SendMessage(hWnd,TVM_GETNEXTITEM,TVGN_FIRSTVISIBLE,GPOINTER_TO_INT(hItem)))
#define TreeView_GetImageList(hWnd,nImageList) GINT_TO_POINTER(SendMessage(hWnd,TVM_GETIMAGELIST,nImageList,0))
#define TreeView_GetIndent(hWnd) SendMessage(hWnd,TVM_GETINDENT,0,0)
#define TreeView_GetISearchStringA(hWnd,lpsz) SendMessageA(hWnd,TVM_GETISEARCHSTRINGA,0,GPOINTER_TO_INT(lpsz))
#define TreeView_GetISearchStringW(hWnd,lpsz) SendMessageW(hWnd,TVM_GETISEARCHSTRINGW,0,GPOINTER_TO_INT(lpsz))
#define TreeView_GetItemA(hWnd,pitem) SendMessageA(hWnd,TVM_GETITEMA,0,GPOINTER_TO_INT(pitem))
#define TreeView_GetItemW(hWnd,pitem) SendMessageW(hWnd,TVM_GETITEMW,0,GPOINTER_TO_INT(pitem))
#define TreeView_GetItemRect(hWnd,hItem,prc,bItemRect) (*(HTREEITEM *)(prc)=(hItem),SendMessage(hWnd,TVM_GETITEMRECT,bItemRect,GPOINTER_TO_INT(prc)))
#define TreeView_GetNextItem(hWnd,hItem,flag) GINT_TO_POINTER(SendMessage(hWnd,TVM_GETNEXTITEM,flag,GPOINTER_TO_INT(hItem)))
#define TreeView_GetNextSibling(hWnd,hItem) GINT_TO_POINTER(SendMessage(hWnd,TVM_GETNEXTITEM,TVGN_NEXT,GPOINTER_TO_INT(hItem)))
#define TreeView_GetNextVisible(hWnd,hItem) GINT_TO_POINTER(SendMessage(hWnd,TVM_GETNEXTITEM,TVGN_NEXTVISIBLE,GPOINTER_TO_INT(hItem)))
#define TreeView_GetParent(hWnd,hItem) GINT_TO_POINTER(SendMessage(hWnd,TVM_GETNEXTITEM,TVGN_PARENT,GPOINTER_TO_INT(hItem)))
#define TreeView_GetPrevSibling(hWnd,hItem) GINT_TO_POINTER(SendMessage(hWnd,TVM_GETNEXTITEM,TVGN_PREVIOUS,GPOINTER_TO_INT(hItem)))
#define TreeView_GetPrevVisible(hWnd,hItem) GINT_TO_POINTER(SendMessage(hWnd,TVM_GETNEXTITEM,TVGN_FIRSTVISIBLE,GPOINTER_TO_INT(hItem)))
#define TreeView_GetRoot(hWnd) GINT_TO_POINTER(SendMessage(hWnd,TVM_GETNEXTITEM,TVGN_ROOT,0))
#define TreeView_GetSelection(hWnd) GINT_TO_POINTER(SendMessage(hWnd,TVM_GETNEXTITEM,TVGN_CARET,0))
#define TreeView_GetVisibleCount(hWnd) SendMessage(hWnd,TVM_GETVISIBLECOUNT,0,0)
#define TreeView_HitTest(hWnd,lpht) GINT_TO_POINTER(SendMessage(hWnd,TVM_HITTEST,0,GPOINTER_TO_INT(lpht)))
#define TreeView_InsertItemA(hWnd,lpis) GINT_TO_POINTER(SendMessageA(hWnd,TVM_INSERTITEMA,0,GPOINTER_TO_INT(lpis)))
#define TreeView_InsertItemW(hWnd,lpis) GINT_TO_POINTER(SendMessageW(hWnd,TVM_INSERTITEMW,0,GPOINTER_TO_INT(lpis)))
#define TreeView_Select(hWnd,hItem,flag) SendMessage(hWnd,TVM_SELECTITEM,flag,GPOINTER_TO_INT(hItem))
#define TreeView_SelectDropTarget(hWnd,hItem) SendMessage(hWnd,TVM_GETNEXTITEM,TVGN_DROPHILITE,GPOINTER_TO_INT(hItem))
#define TreeView_SelectItem(hWnd,hItem) SendMessage(hWnd,TVM_GETNEXTITEM,TVGN_CARET,GPOINTER_TO_INT(hItem))
#define TreeView_SelectSetFirstVisible(hWnd,hItem) SendMessage(hWnd,TVM_SELECTITEM,TVGN_FIRSTVISIBLE,GPOINTER_TO_INT(hItem))
#define TreeView_SetImageList(hWnd,hImage,nImageList) GINT_TO_POINTER(SendMessage(hWnd,TVM_SETIMAGELIST,nImageList,GPOINTER_TO_INT(hImage)))
#define TreeView_SetIndent(hWnd,nIndent) SendMessage(hWnd,TVM_SETINDENT,nIndent,0)
#define TreeView_SetItemA(hWnd,pitem) SendMessageA(hWnd,TVM_SETITEMA,0,GPOINTER_TO_INT(pitem))
#define TreeView_SetItemW(hWnd,pitem) SendMessageW(hWnd,TVM_SETITEMW,0,GPOINTER_TO_INT(pitem))
#define TreeView_SortChildren(hWnd,hItem,nRecurse) SendMessage(hWnd,TVM_SORTCHILDREN,nRecurse,GPOINTER_TO_INT(hItem))
#define TreeView_SortChildrenCB(hWnd,psort,nRecurse) SendMessage(hWnd,TVM_SORTCHILDRENCB,nRecurse,GPOINTER_TO_INT(psort))
#ifdef UNICODE
# define TreeView_EditLabel TreeView_EditLabelW
# define TreeView_GetISearchString TreeView_GetISearchStringW
# define TreeView_GetItem TreeView_GetItemW
# define TreeView_InsertItem TreeView_InsertItemW
# define TreeView_SetItem TreeView_SetItemW
#else /* not UNICODE */
# define TreeView_EditLabel TreeView_EditLabelA
# define TreeView_GetISearchString TreeView_GetISearchStringA
# define TreeView_GetItem TreeView_GetItemA
# define TreeView_InsertItem TreeView_InsertItemA
# define TreeView_SetItem TreeView_SetItemA
#endif /* not UNICODE */


#endif /* not __W32TVIEW_H__ */
