/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "shell32.h"
#include "kernel32.h"


#ifdef W32LDR_HEADER
#include "advapi32.h"
#include "ole32.h"
#include "user32.h"

typedef struct _W32LdrDrop *HDROP;

#define S_OK 0
#ifndef NOERROR
# define NOERROR 0
#endif /* not NOERROR */
#define E_FAIL 0x80004005
typedef struct _IMalloc IMalloc, *LPMALLOC;
#include "pshpack1.h"
typedef struct _IMallocVtbl
{
  HRESULT (WINAPI *QueryInterface)(IMalloc *This, REFIID riid, void **ppvObject);
  ULONG (WINAPI *AddRef)(IMalloc *This);
  ULONG (WINAPI *Release)(IMalloc *This);
  void *(WINAPI *Alloc)(IMalloc *This, SIZE_T cb);
  void *(WINAPI *Realloc)(IMalloc *This, void *pv, SIZE_T cb);
  void (WINAPI *Free)(IMalloc *This, void *pv);
  SIZE_T (WINAPI *GetSize)(IMalloc *This, void *pv);
  int (WINAPI *DidAlloc)(IMalloc *This, void *pv);
  void (WINAPI *HeapMinimize)(IMalloc *This);
} IMallocVtbl;
struct _IMalloc
{
  struct _IMallocVtbl *lpVtbl;
  ULONG ulCounter;
};
#include "poppack.h"

#include "pshpack1.h"
typedef struct _SHITEMID
{
  WORD cb;
  BYTE abID[1];
} SHITEMID, *PSHITEMID, *LPSHITEMID;
typedef CONST SHITEMID *PCSHITEMID, *LPCSHITEMID;
typedef struct _ITEMIDLIST
{
  SHITEMID mkid;
} ITEMIDLIST, *PITEMIDLIST, *LPITEMIDLIST;
typedef CONST ITEMIDLIST *PCITEMIDLIST, *LPCITEMIDLIST;
#include "poppack.h"
#define BIF_RETURNONLYFSDIRS   0x0001
#define BIF_DONTGOBELOWDOMAIN  0x0002
#define BIF_STATUSTEXT         0x0004
#define BIF_RETURNFSANCESTORS  0x0008
#define BIF_EDITBOX            0x0010
#define BIF_VALIDATE           0x0020
#define BIF_NEWDIALOGSTYLE     0x0040
#define BIF_USENEWUI           0x0050
#define BIF_BROWSEINCLUDEURLS  0x0080
#define BIF_UAHINT             0x0100
#define BIF_NONEWFOLDERBUTTON  0x0200
#define BIF_NOTRANSLATETARGETS 0x0400
#define BIF_BROWSEFORCOMPUTER  0x1000
#define BIF_BROWSEFORPRINTER   0x2000
#define BIF_BROWSEINCLUDEFILES 0x4000
#define BIF_SHAREABLE          0x8000
typedef INT (CALLBACK *BFFCALLBACK)(HWND, UINT, LPARAM, LPARAM);
#include "pshpack8.h"
typedef struct _BROWSEINFOA
{
  HWND hwndOwner;
  LPCITEMIDLIST pidlRoot;
  LPSTR pszDisplayName;
  LPCSTR lpszTitle;
  UINT ulFlags;
  BFFCALLBACK lpfn;
  LPARAM lParam;
  INT iImage;
} BROWSEINFOA, *PBROWSEINFOA, *LPBROWSEINFOA;
typedef struct _BROWSEINFOW
{
  HWND hwndOwner;
  LPCITEMIDLIST pidlRoot;
  LPWSTR pszDisplayName;
  LPCWSTR lpszTitle;
  UINT ulFlags;
  BFFCALLBACK lpfn;
  LPARAM lParam;
  INT iImage;
} BROWSEINFOW, *PBROWSEINFOW, *LPBROWSEINFOW;
#include "poppack.h"
#ifdef UNICODE
# define BROWSEINFO   BROWSEINFOW
# define PBROWSEINFO  PBROWSEINFOW
# define LPBROWSEINFO LPBROWSEINFOW
#else /* not UNICODE */
# define BROWSEINFO   BROWSEINFOA
# define PBROWSEINFO  PBROWSEINFOA
# define LPBROWSEINFO LPBROWSEINFOA
#endif /* not UNICODE */

#define SEE_MASK_CLASSNAME      0x00000001
#define SEE_MASK_CLASSKEY       0x00000003
#define SEE_MASK_IDLIST         0x00000004
#define SEE_MASK_INVOKEIDLIST   0x0000000c
#define SEE_MASK_ICON           0x00000010
#define SEE_MASK_HOTKEY         0x00000020
#define SEE_MASK_NOCLOSEPROCESS 0x00000040
#define SEE_MASK_CONNECTNETDRV  0x00000080
#define SEE_MASK_FLAG_DDEWAIT   0x00000100
#define SEE_MASK_DOENVSUBST     0x00000200
#define SEE_MASK_FLAG_NO_UI     0x00000400
#define SEE_MASK_UNICODE        0x00004000
#define SEE_MASK_NO_CONSOLE     0x00008000
#define SEE_MASK_HMONITOR       0x00200000
#include "pshpack1.h"
typedef struct _SHELLEXECUTEINFOA
{
  DWORD cbSize;
  ULONG fMask;
  HWND hwnd;
  LPCSTR lpVerb;
  LPCSTR lpFile;
  LPCSTR lpParameters;
  LPCSTR lpDirectory;
  INT nShow;
  HINSTANCE hInstApp;
  LPVOID lpIDList;
  LPCSTR lpClass;
  HKEY hkeyClass;
  DWORD dwHotKey;
  union
  {
    HANDLE hIcon;
    HANDLE hMonitor;
  } DUMMYUNIONNAME;
  HANDLE hProcess;
} SHELLEXECUTEINFOA, *PSHELLEXECUTEINFOA, *LPSHELLEXECUTEINFOA;
typedef struct _SHELLEXECUTEINFOW
{
  DWORD cbSize;
  ULONG fMask;
  HWND hwnd;
  LPCWSTR lpVerb;
  LPCWSTR lpFile;
  LPCWSTR lpParameters;
  LPCWSTR lpDirectory;
  INT nShow;
  HINSTANCE hInstApp;
  LPVOID lpIDList;
  LPCWSTR lpClass;
  HKEY hkeyClass;
  DWORD dwHotKey;
  union
  {
    HANDLE hIcon;
    HANDLE hMonitor;
  } DUMMYUNIONNAME;
  HANDLE hProcess;
} SHELLEXECUTEINFOW, *PSHELLEXECUTEINFOW, *LPSHELLEXECUTEINFOW;
#include "poppack.h"
#ifdef UNICODE
# define SHELLEXECUTEINFO SHELLEXECUTEINFOW
# define PSHELLEXECUTEINFO PSHELLEXECUTEINFOW
# define LPSHELLEXECUTEINFO LPSHELLEXECUTEINFOW
#else /* not UNICODE */
# define SHELLEXECUTEINFO SHELLEXECUTEINFOA
# define PSHELLEXECUTEINFO PSHELLEXECUTEINFOA
# define LPSHELLEXECUTEINFO LPSHELLEXECUTEINFOA
#endif /* not UNICODE */

#define FO_MOVE   0x0001
#define FO_COPY   0x0002
#define FO_DELETE 0x0003
#define FO_RENAME 0x0004
#define FOF_MULTIDESTFILES        0x0001
#define FOF_CONFIRMMOUSE          0x0002
#define FOF_SILENT                0x0004
#define FOF_RENAMEONCOLLISION     0x0008
#define FOF_NOCONFIRMATION        0x0010
#define FOF_WANTMAPPINGHANDLE     0x0020
#define FOF_ALLOWUNDO             0x0040
#define FOF_FILESONLY             0x0080
#define FOF_SIMPLEPROGRESS        0x0100
#define FOF_NOCONFIRMMKDIR        0x0200
#define FOF_NOERRORUI             0x0400
#define FOF_NOCOPYSECURITYATTRIBS 0x0800
#define FOF_NORECURSION           0x1000
#define FOF_NO_CONNECTED_ELEMENTS 0x2000
#define FOF_WANTNUKEWARNING       0x4000
#define FOF_NORECURSEREPARSE      0x8000
typedef WORD FILEOP_FLAGS;
#include "pshpack1.h"
typedef struct _SHFILEOPSTRUCTA
{
  HWND hwnd;
  UINT wFunc;
  LPCSTR pFrom;
  LPCSTR pTo;
  FILEOP_FLAGS fFlags;
  BOOL fAnyOperationsAborted;
  LPVOID hNameMappings;
  LPCSTR lpszProgressTitle;
} SHFILEOPSTRUCTA, *PSHFILEOPSTRUCTA, *LPSHFILEOPSTRUCTA;
typedef struct _SHFILEOPSTRUCTW
{
  HWND hwnd;
  UINT wFunc;
  LPCWSTR pFrom;
  LPCWSTR pTo;
  FILEOP_FLAGS fFlags;
  BOOL fAnyOperationsAborted;
  LPVOID hNameMappings;
  LPCWSTR lpszProgressTitle;
} SHFILEOPSTRUCTW, *PSHFILEOPSTRUCTW, *LPSHFILEOPSTRUCTW;
#include "poppack.h"
#ifdef UNICODE
# define SHFILEOPSTRUCT SHFILEOPSTRUCTW
# define PSHFILEOPSTRUCT PSHFILEOPSTRUCTW
# define LPSHFILEOPSTRUCT LPSHFILEOPSTRUCTW
#else /* not UNICODE */
# define SHFILEOPSTRUCT SHFILEOPSTRUCTA
# define PSHFILEOPSTRUCT PSHFILEOPSTRUCTA
# define LPSHFILEOPSTRUCT LPSHFILEOPSTRUCTA
#endif /* not UNICODE */
#endif /* W32LDR_HEADER */


/* CheckEscapesA ordinal = 81, argument = 8 temporary */
static DWORD WINAPI CheckEscapesA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CheckEscapesW ordinal = 125, argument = 8 temporary */
static DWORD WINAPI CheckEscapesW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* CommandLineToArgvW ordinal = 133, argument = 8 temporary */
static DWORD WINAPI CommandLineToArgvW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Control_FillCache_RunDLL ordinal = 135, argument = 0 temporary */
/* DWORD WINAPI Control_FillCache_RunDLL (VOID) */


/* Control_FillCache_RunDLLA ordinal = 138, argument = 0 temporary */
static DWORD WINAPI Control_FillCache_RunDLLA (VOID)
{
  return 0;
}


/* Control_FillCache_RunDLLW ordinal = 148, argument = 0 temporary */
static DWORD WINAPI Control_FillCache_RunDLLW (VOID)
{
  return 0;
}


/* Control_RunDLL ordinal = 150, argument = 0 temporary */
/* DWORD WINAPI Control_RunDLL (VOID) */


/* Control_RunDLLA ordinal = 199, argument = 0 temporary */
static DWORD WINAPI Control_RunDLLA (VOID)
{
  return 0;
}


/* Control_RunDLLAsUserW ordinal = 226, argument = 0 temporary */
static DWORD WINAPI Control_RunDLLAsUserW (VOID)
{
  return 0;
}


/* Control_RunDLLW ordinal = 228, argument = 0 temporary */
static DWORD WINAPI Control_RunDLLW (VOID)
{
  return 0;
}


/* DllCanUnloadNow ordinal = 229, argument = 0 temporary,conflict */
static DWORD WINAPI shell32_DllCanUnloadNow (VOID)
{
  return 0;
}


/* DllGetClassObject ordinal = 233, argument = 0 temporary,conflict */
static DWORD WINAPI shell32_DllGetClassObject (VOID)
{
  return 0;
}


/* DllGetVersion ordinal = 234, argument = 0 temporary,conflict */
static DWORD WINAPI shell32_DllGetVersion (VOID)
{
  return 0;
}


/* DllInstall ordinal = 235, argument = 0 temporary,conflict */
static DWORD WINAPI shell32_DllInstall (VOID)
{
  return 0;
}


/* DllRegisterServer ordinal = 236, argument = 0 temporary,conflict */
static DWORD WINAPI shell32_DllRegisterServer (VOID)
{
  return 0;
}


/* DllUnregisterServer ordinal = 237, argument = 0 temporary,conflict */
static DWORD WINAPI shell32_DllUnregisterServer (VOID)
{
  return 0;
}


/* DoEnvironmentSubstA ordinal = 238, argument = 8 temporary */
static DWORD WINAPI DoEnvironmentSubstA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* DoEnvironmentSubstW ordinal = 241, argument = 8 temporary */
static DWORD WINAPI DoEnvironmentSubstW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* DragAcceptFiles ordinal = 245, argument = 8 */
VOID WINAPI DragAcceptFiles (HWND hWnd, BOOL fAccept)
{
}


typedef struct _W32LdrDrop
{
  gchar **files;
  gint length;
} W32LdrDrop;


/* DragFinish ordinal = 246, argument = 4 */
VOID WINAPI DragFinish (HDROP hDrop)
{
  if (hDrop)
    {
      g_strfreev (hDrop->files);
      g_free (hDrop);
    }
}


/* DragQueryFile ordinal = 247, argument = 16 */
/* UINT WINAPI DragQueryFile (HDROP hDrop, UINT iFile, LPSTR lpszFile, UINT cch) */


/* DragQueryFileA ordinal = 248, argument = 16 */
UINT WINAPI DragQueryFileA (HDROP hDrop, UINT iFile, LPSTR lpszFile, UINT cch)
{
  UINT uResult = 0;

  if (hDrop)
    {
      if (iFile == 0xffffffff)
        {
          uResult = hDrop->length;
        }
      else if (iFile < hDrop->length)
        {
          gchar *mb;

          mb = w32ldr_utf8_to_mb (hDrop->files[iFile]);
          uResult = g_strlen (mb);
          if (lpszFile)
            {
              if (cch <= uResult)
                uResult = 0;
              else
                g_strcpy (lpszFile, mb);
            }
          g_free (mb);
        }
    }
  return uResult;
}


/* DragQueryFileAorW ordinal = 253, argument = 24 temporary */
static DWORD WINAPI DragQueryFileAorW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5)
{
  return 0;
}


/* DragQueryFileW ordinal = 254, argument = 16 */
UINT WINAPI DragQueryFileW (HDROP hDrop, UINT iFile, LPWSTR lpszFile, UINT cch)
{
  UINT uResult = 0;

  if (hDrop)
    {
      if (iFile == 0xffffffff)
        {
          uResult = hDrop->length;
        }
      else if (iFile < hDrop->length)
        {
          gunichar2 *wc;

          wc = g_utf8_to_utf16 (hDrop->files[iFile], -1, NULL, NULL, NULL);
          uResult = lstrlenW (wc);
          if (lpszFile)
            {
              if (cch <= uResult)
                uResult = 0;
              else
                lstrcpyW (lpszFile, wc);
            }
          g_free (wc);
        }
    }
  return uResult;
}


/* DragQueryPoint ordinal = 255, argument = 8 */
BOOL WINAPI DragQueryPoint (HDROP hDrop, LPPOINT lppt)
{
  if (hDrop)
    {
      if (lppt)
        lppt->x = lppt->y = 0;
      return TRUE;
    }
  return FALSE;
}


/* DuplicateIcon ordinal = 260, argument = 8 temporary */
static DWORD WINAPI DuplicateIcon (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ExtractAssociatedIconA ordinal = 261, argument = 12 temporary */
static DWORD WINAPI ExtractAssociatedIconA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ExtractAssociatedIconExA ordinal = 262, argument = 16 temporary */
static DWORD WINAPI ExtractAssociatedIconExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* ExtractAssociatedIconExW ordinal = 263, argument = 16 temporary */
static DWORD WINAPI ExtractAssociatedIconExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* ExtractAssociatedIconW ordinal = 264, argument = 12 temporary */
static DWORD WINAPI ExtractAssociatedIconW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ExtractIconA ordinal = 265, argument = 12 temporary */
static DWORD WINAPI ExtractIconA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ExtractIconEx ordinal = 266, argument = 20 temporary */
/* DWORD WINAPI ExtractIconEx (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4) */


/* ExtractIconExA ordinal = 267, argument = 20 temporary */
static DWORD WINAPI ExtractIconExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ExtractIconExW ordinal = 268, argument = 20 temporary */
static DWORD WINAPI ExtractIconExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ExtractIconResInfoA ordinal = 269, argument = 20 temporary */
static DWORD WINAPI ExtractIconResInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ExtractIconResInfoW ordinal = 270, argument = 20 temporary */
static DWORD WINAPI ExtractIconResInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* ExtractIconW ordinal = 271, argument = 12 temporary */
static DWORD WINAPI ExtractIconW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* ExtractVersionResource16W ordinal = 272, argument = 8 temporary */
static DWORD WINAPI ExtractVersionResource16W (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* FindExeDlgProc ordinal = 273, argument = 16 temporary */
static DWORD WINAPI FindExeDlgProc (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* FindExecutableA ordinal = 274, argument = 12 */
HINSTANCE WINAPI FindExecutableA (LPCSTR lpFile, LPCSTR lpDirectory, LPSTR lpResult)
{
  return GUINT_TO_POINTER (31);
}


/* FindExecutableW ordinal = 275, argument = 12 */
HINSTANCE WINAPI FindExecutableW (LPCWSTR lpFile, LPCWSTR lpDirectory, LPWSTR lpResult)
{
  return GUINT_TO_POINTER (31);
}


/* FixupOptionalComponents ordinal = 276, argument = 0 temporary */
static DWORD WINAPI FixupOptionalComponents (VOID)
{
  return 0;
}


/* FreeIconList ordinal = 277, argument = 8 temporary */
static DWORD WINAPI FreeIconList (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* InternalExtractIconListA ordinal = 278, argument = 12 temporary */
static DWORD WINAPI InternalExtractIconListA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* InternalExtractIconListW ordinal = 279, argument = 12 temporary */
static DWORD WINAPI InternalExtractIconListW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* OCInstall ordinal = 44, argument = 0 temporary */
static DWORD WINAPI OCInstall (VOID)
{
  return 0;
}


/* OpenAs_RunDLL ordinal = 280, argument = 0 temporary */
/* DWORD WINAPI OpenAs_RunDLL (VOID) */


/* OpenAs_RunDLLA ordinal = 281, argument = 0 temporary */
static DWORD WINAPI OpenAs_RunDLLA (VOID)
{
  return 0;
}


/* OpenAs_RunDLLW ordinal = 282, argument = 0 temporary */
static DWORD WINAPI OpenAs_RunDLLW (VOID)
{
  return 0;
}


/* PrintersGetCommand_RunDLL ordinal = 283, argument = 0 temporary */
/* DWORD WINAPI PrintersGetCommand_RunDLL (VOID) */


/* PrintersGetCommand_RunDLLA ordinal = 284, argument = 0 temporary */
static DWORD WINAPI PrintersGetCommand_RunDLLA (VOID)
{
  return 0;
}


/* PrintersGetCommand_RunDLLW ordinal = 285, argument = 0 temporary */
static DWORD WINAPI PrintersGetCommand_RunDLLW (VOID)
{
  return 0;
}


/* RealShellExecuteA ordinal = 286, argument = 40 temporary */
static DWORD WINAPI RealShellExecuteA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9)
{
  return 0;
}


/* RealShellExecuteExA ordinal = 287, argument = 44 temporary */
static DWORD WINAPI RealShellExecuteExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10)
{
  return 0;
}


/* RealShellExecuteExW ordinal = 288, argument = 44 temporary */
static DWORD WINAPI RealShellExecuteExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9, DWORD dwArgv10)
{
  return 0;
}


/* RealShellExecuteW ordinal = 289, argument = 40 temporary */
static DWORD WINAPI RealShellExecuteW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7, DWORD dwArgv8, DWORD dwArgv9)
{
  return 0;
}


/* RegenerateUserEnvironment ordinal = 290, argument = 8 temporary */
static DWORD WINAPI RegenerateUserEnvironment (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SHAddToRecentDocs ordinal = 291, argument = 8 temporary */
static DWORD WINAPI SHAddToRecentDocs (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SHAppBarMessage ordinal = 292, argument = 8 temporary */
static DWORD WINAPI SHAppBarMessage (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SHBindToParent ordinal = 293, argument = 16 temporary */
static DWORD WINAPI SHBindToParent (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


static LPITEMIDLIST
shell32_filename_to_idl (const gchar *file)
{
  LPITEMIDLIST pidl = NULL;

  if (file)
    {
      gchar **path;
      gint i;
      gsize leng = sizeof (WORD);
      LPITEMIDLIST p;

      path = g_strsplit (file, G_DIR_SEPARATOR_S, 0);
      for (i = 0; path[i]; i++)
        if ((path[i])[0] != '\0')
          leng += g_strlen (path[i]) * sizeof (gchar) + sizeof (WORD);
      p = pidl = LocalAlloc (LMEM_FIXED, leng);
      for (i = 0; path[i]; i++)
        if ((path[i])[0] != '\0')
          {
            p->mkid.cb = g_strlen (path[i]) * sizeof (gchar) + sizeof (WORD);
            g_strcpy ((gchar *)p->mkid.abID, path[i]);
            p = (LPITEMIDLIST)((guint8 *)p + p->mkid.cb);
          }
      g_strfreev (path);
      p->mkid.cb = 0;
    }
  return pidl;
}


/* SHBrowseForFolder ordinal = 294, argument = 4 */
/* LPITEMIDLIST WINAPI SHBrowseForFolder (LPBROWSEINFOA lpbi) */


/* SHBrowseForFolderA ordinal = 295, argument = 4 */
LPITEMIDLIST WINAPI SHBrowseForFolderA (LPBROWSEINFOA lpbi)
{
  gchar *title, *path;
  GtkWidget *dialog;
#if GTK_CHECK_VERSION(2,4,0)
  GtkWidget *parent;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  LPITEMIDLIST pidl = NULL;

  if (!lpbi || (lpbi->ulFlags & (BIF_BROWSEFORCOMPUTER | BIF_BROWSEFORPRINTER
                                                    | BIF_RETURNFSANCESTORS)))
    return NULL;
  title = w32ldr_utf8_from_mb (lpbi->lpszTitle);
#if GTK_CHECK_VERSION(2,4,0)
  for (parent = lpbi->hwndOwner; parent;
                                    parent = gtk_widget_get_parent (parent))
    if (GTK_IS_WINDOW (parent))
      break;
  dialog = gtk_file_chooser_dialog_new (title,
                        parent ? GTK_WINDOW (parent) : NULL,
                        GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
                        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                        GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
                        NULL);
  path = gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT
                    ? gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog))
                    : NULL;
#else /* not GTK_CHECK_VERSION(2,4,0) */
  dialog = gtk_file_selection_new (title);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (dialog));
  gtk_widget_hide
            (gtk_widget_get_parent (GTK_FILE_SELECTION (dialog)->file_list));
  gtk_widget_hide (GTK_FILE_SELECTION (dialog)->selection_entry);
  path = gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK
    ? g_strdup (gtk_file_selection_get_filename (GTK_FILE_SELECTION (dialog)))
    : NULL;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_widget_destroy (dialog);
  g_free (title);
  if (path)
    {
      gchar *mb;

      mb = w32ldr_filename_to_mb (path);
      g_strcpy (lpbi->pszDisplayName, mb);
      g_free (mb);
      pidl = shell32_filename_to_idl (path);
      g_free (path);
      lpbi->iImage = 0;
    }
  return pidl;
}


/* SHBrowseForFolderW ordinal = 296, argument = 4 */
LPITEMIDLIST WINAPI SHBrowseForFolderW (LPBROWSEINFOW lpbi)
{
  gchar *title, *path;
  GtkWidget *dialog;
#if GTK_CHECK_VERSION(2,4,0)
  GtkWidget *parent;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  LPITEMIDLIST pidl = NULL;

  if (!lpbi || (lpbi->ulFlags & (BIF_BROWSEFORCOMPUTER | BIF_BROWSEFORPRINTER
                                                    | BIF_RETURNFSANCESTORS)))
    return NULL;
  title = lpbi->lpszTitle ? g_utf16_to_utf8 (lpbi->lpszTitle, -1,
                                                    NULL, NULL, NULL) : NULL;
#if GTK_CHECK_VERSION(2,4,0)
  for (parent = lpbi->hwndOwner; parent;
                                    parent = gtk_widget_get_parent (parent))
    if (GTK_IS_WINDOW (parent))
      break;
  dialog = gtk_file_chooser_dialog_new (title,
                        parent ? GTK_WINDOW (parent) : NULL,
                        GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
                        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                        GTK_STOCK_OK, GTK_RESPONSE_ACCEPT,
                        NULL);
  path = gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT
                    ? gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog))
                    : NULL;
#else /* not GTK_CHECK_VERSION(2,4,0) */
  dialog = gtk_file_selection_new (title);
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (dialog));
  gtk_widget_hide
            (gtk_widget_get_parent (GTK_FILE_SELECTION (dialog)->file_list));
  gtk_widget_hide (GTK_FILE_SELECTION (dialog)->selection_entry);
  path = gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK
    ? g_strdup (gtk_file_selection_get_filename (GTK_FILE_SELECTION (dialog)))
    : NULL;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  gtk_widget_destroy (dialog);
  g_free (title);
  if (path)
    {
      gunichar2 *wc;

      wc = w32ldr_filename_to_wc (path);
      lstrcpyW (lpbi->pszDisplayName, wc);
      g_free (wc);
      pidl = shell32_filename_to_idl (path);
      g_free (path);
      lpbi->iImage = 0;
    }
  return pidl;
}


/* SHChangeNotify ordinal = 297, argument = 16 temporary */
static DWORD WINAPI SHChangeNotify (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SHChangeNotifySuspendResume ordinal = 298, argument = 0 temporary */
static DWORD WINAPI SHChangeNotifySuspendResume (VOID)
{
  return 0;
}


/* SHCreateDirectoryExA ordinal = 299, argument = 12 temporary */
static DWORD WINAPI SHCreateDirectoryExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SHCreateDirectoryExW ordinal = 300, argument = 12 temporary */
static DWORD WINAPI SHCreateDirectoryExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SHCreateProcessAsUserW ordinal = 301, argument = 4 temporary */
static DWORD WINAPI SHCreateProcessAsUserW (DWORD dwArgv0)
{
  return 0;
}


/* SHEmptyRecycleBinA ordinal = 302, argument = 12 temporary */
static DWORD WINAPI SHEmptyRecycleBinA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SHEmptyRecycleBinW ordinal = 303, argument = 12 temporary */
static DWORD WINAPI SHEmptyRecycleBinW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SHExtractIconsW ordinal = 304, argument = 32 temporary */
static DWORD WINAPI SHExtractIconsW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6, DWORD dwArgv7)
{
  return 0;
}


/* SHFileOperation ordinal = 305, argument = 4 */
/* INT WINAPI SHFileOperation (LPSHFILEOPSTRUCTA lpFileOp) */


/* SHFileOperationA ordinal = 306, argument = 4 */
INT WINAPI SHFileOperationA (LPSHFILEOPSTRUCTA lpFileOp)
{
  gboolean result = TRUE;
  const gchar *mb_from, *mb_to;

  if (!lpFileOp || !lpFileOp->pFrom
                        || (lpFileOp->wFunc != FO_DELETE && !lpFileOp->pTo))
    return 0;
  mb_to = lpFileOp->wFunc != FO_DELETE ? lpFileOp->pTo : NULL;
  for (mb_from = lpFileOp->pFrom; result && *mb_from != '\0';
                                            mb_from += g_strlen (mb_from) + 1)
    {
      gchar *file, *dir;
      LPSTR lpszSrc, lpszSrcName, lpszDst = NULL, lpszDstName = NULL;
      HANDLE hFind;
      WIN32_FIND_DATAA wfData;

      if (mb_to && *mb_to == '\0')
        return 0;
      hFind = FindFirstFileA (mb_from, &wfData);
      if (hFind == INVALID_HANDLE_VALUE)
        return 0;
      file = w32ldr_filename_from_mb (mb_from);
      dir = g_path_get_dirname (file);
      lpszSrc = w32ldr_filename_to_mb (dir);
      g_free (dir);
      g_free (file);
      lpszSrc = g_realloc (lpszSrc,
                        (g_strlen (lpszSrc) + MAX_PATH + 1) * sizeof (CHAR));
      g_strcat (lpszSrc, "\\");
      lpszSrcName = lpszSrc + g_strlen (lpszSrc);
      if (mb_to)
        {
          lpszDst = g_realloc (lpszDst,
                            (g_strlen (mb_to) + MAX_PATH + 1) * sizeof (CHAR));
          g_strcpy (lpszDst, mb_to);
          file = w32ldr_filename_from_mb (mb_to);
          if (g_file_test (file, G_FILE_TEST_IS_DIR))
            {
              g_strcat (lpszDst, "\\");
              lpszDstName = lpszDst + g_strlen (lpszDst);
            }
        }
      do
        {
          g_strcpy (lpszSrcName, wfData.cFileName);
          if (lpszDstName)
            g_strcpy (lpszDstName, wfData.cFileName);
          switch (lpFileOp->wFunc)
            {
              case FO_MOVE:
              case FO_RENAME:
                result = MoveFileA (lpszSrc, lpszDst);
                break;
              case FO_DELETE:
                file = w32ldr_filename_from_mb (lpszSrc);
                result = fileio_remove (file);
                g_free (file);
                break;
              default:
                result = FALSE;
            }
        }
      while (result && FindNextFileA (hFind, &wfData));
      FindClose (hFind);
      g_free (lpszSrc);
      g_free (lpszDst);
      if (mb_to && (lpFileOp->fFlags & FOF_MULTIDESTFILES))
        mb_to += g_strlen (mb_to) + 1;
    }
  return 1;
}


/* SHFileOperationW ordinal = 307, argument = 4 */
INT WINAPI SHFileOperationW (LPSHFILEOPSTRUCTW lpFileOp)
{
  gboolean result = TRUE;
  const gunichar2 *wc_from, *wc_to;

  if (!lpFileOp || !lpFileOp->pFrom
                        || (lpFileOp->wFunc != FO_DELETE && !lpFileOp->pTo))
    return 0;
  wc_to = lpFileOp->wFunc != FO_DELETE ? lpFileOp->pTo : NULL;
  for (wc_from = lpFileOp->pFrom; result && *wc_from != '\0';
                                            wc_from += lstrlenW (wc_from) + 1)
    {
      gchar *file, *dir;
      LPWSTR lpszSrc, lpszSrcName, lpszDst = NULL, lpszDstName = NULL;
      HANDLE hFind;
      WIN32_FIND_DATAW wfData;
      CONST WCHAR wSep[2] = {'\\', '\0'};

      if (wc_to && *wc_to == '\0')
        return 0;
      hFind = FindFirstFileW (wc_from, &wfData);
      if (hFind == INVALID_HANDLE_VALUE)
        return 0;
      file = w32ldr_filename_from_wc (wc_from);
      dir = g_path_get_dirname (file);
      lpszSrc = w32ldr_filename_to_wc (dir);
      g_free (dir);
      g_free (file);
      lpszSrc = g_realloc (lpszSrc,
                        (lstrlenW (lpszSrc) + MAX_PATH + 1) * sizeof (WCHAR));
      lstrcatW (lpszSrc, wSep);
      lpszSrcName = lpszSrc + lstrlenW (lpszSrc);
      if (wc_to)
        {
          lpszDst = g_realloc (lpszDst,
                        (lstrlenW (wc_to) + MAX_PATH + 1) * sizeof (WCHAR));
          lstrcpyW (lpszDst, wc_to);
          file = w32ldr_filename_from_wc (wc_to);
          if (g_file_test (file, G_FILE_TEST_IS_DIR))
            {
              lstrcatW (lpszDst, wSep);
              lpszDstName = lpszDst + lstrlenW (lpszDst);
            }
        }
      do
        {
          lstrcpyW (lpszSrcName, wfData.cFileName);
          if (lpszDstName)
            lstrcpyW (lpszDstName, wfData.cFileName);
          switch (lpFileOp->wFunc)
            {
              case FO_MOVE:
              case FO_RENAME:
                result = MoveFileW (lpszSrc, lpszDst);
                break;
              case FO_DELETE:
                file = w32ldr_filename_from_wc (lpszSrc);
                result = fileio_remove (file);
                g_free (file);
                break;
              default:
                result = FALSE;
            }
        }
      while (result && FindNextFileW (hFind, &wfData));
      FindClose (hFind);
      g_free (lpszSrc);
      g_free (lpszDst);
      if (wc_to && (lpFileOp->fFlags & FOF_MULTIDESTFILES))
        wc_to += lstrlenW (wc_to) + 1;
    }
  return 1;
}


/* SHFormatDrive ordinal = 308, argument = 16 temporary */
static DWORD WINAPI SHFormatDrive (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SHFreeNameMappings ordinal = 309, argument = 4 temporary */
static DWORD WINAPI SHFreeNameMappings (DWORD dwArgv0)
{
  return 0;
}


/* SHGetDataFromIDListA ordinal = 310, argument = 20 temporary */
static DWORD WINAPI SHGetDataFromIDListA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* SHGetDataFromIDListW ordinal = 311, argument = 20 temporary */
static DWORD WINAPI SHGetDataFromIDListW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* SHGetDesktopFolder ordinal = 312, argument = 4 temporary */
static DWORD WINAPI SHGetDesktopFolder (DWORD dwArgv0)
{
  return 0;
}


/* SHGetDiskFreeSpaceA ordinal = 313, argument = 16 temporary */
static DWORD WINAPI SHGetDiskFreeSpaceA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SHGetDiskFreeSpaceExA ordinal = 314, argument = 16 temporary */
static DWORD WINAPI SHGetDiskFreeSpaceExA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SHGetDiskFreeSpaceExW ordinal = 315, argument = 16 temporary */
static DWORD WINAPI SHGetDiskFreeSpaceExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SHGetFileInfo ordinal = 316, argument = 20 temporary */
/* DWORD WINAPI SHGetFileInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4) */


/* SHGetFileInfoA ordinal = 317, argument = 20 temporary */
static DWORD WINAPI SHGetFileInfoA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* SHGetFileInfoW ordinal = 318, argument = 20 temporary */
static DWORD WINAPI SHGetFileInfoW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* SHGetFolderLocation ordinal = 319, argument = 20 temporary */
static DWORD WINAPI SHGetFolderLocation (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* SHGetFolderPathA ordinal = 320, argument = 20 temporary */
static DWORD WINAPI SHGetFolderPathA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* SHGetFolderPathW ordinal = 321, argument = 20 temporary */
static DWORD WINAPI SHGetFolderPathW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* SHGetIconOverlayIndexA ordinal = 322, argument = 8 temporary */
static DWORD WINAPI SHGetIconOverlayIndexA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SHGetIconOverlayIndexW ordinal = 323, argument = 8 temporary */
static DWORD WINAPI SHGetIconOverlayIndexW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SHGetInstanceExplorer ordinal = 324, argument = 4 temporary */
static DWORD WINAPI SHGetInstanceExplorer (DWORD dwArgv0)
{
  return 0;
}


static HRESULT WINAPI imalloc_QueryInterface (IMalloc *This, REFIID riid, void **ppvObject)
{
  return S_OK;
}
static ULONG WINAPI imalloc_AddRef (IMalloc *This)
{
  This->ulCounter++;
  return This->ulCounter;
}
static ULONG WINAPI imalloc_Release (IMalloc *This)
{
  This->ulCounter--;
  if (This->ulCounter > 0)
    return This->ulCounter;
  g_free (This->lpVtbl);
  g_free (This);
  return 0;
}
static void WINAPI *imalloc_Alloc (IMalloc *This, SIZE_T cb)
{
  return LocalAlloc (LMEM_FIXED, cb);
}
static void WINAPI *imalloc_Realloc (IMalloc *This, void *pv, SIZE_T cb)
{
  return LocalReAlloc (pv, cb, 0);
}
static void WINAPI imalloc_Free (IMalloc *This, void *pv)
{
  LocalFree (pv);
}
static SIZE_T WINAPI imalloc_GetSize (IMalloc *This, void *pv)
{
  return LocalSize (pv);
}
static int WINAPI imalloc_DidAlloc (IMalloc *This, void *pv)
{
  return TRUE;
}
static void WINAPI imalloc_HeapMinimize (IMalloc *This)
{
}


/* SHGetMalloc ordinal = 325, argument = 4 */
HRESULT WINAPI SHGetMalloc (LPMALLOC *ppMalloc)
{
  if (ppMalloc)
    {
      LPMALLOC pMalloc;

      pMalloc = g_malloc (sizeof (IMalloc));
      pMalloc->ulCounter = 1;
      pMalloc->lpVtbl = g_malloc (sizeof (IMallocVtbl));
      pMalloc->lpVtbl->QueryInterface = imalloc_QueryInterface;
      pMalloc->lpVtbl->AddRef = imalloc_AddRef;
      pMalloc->lpVtbl->Release = imalloc_Release;
      pMalloc->lpVtbl->Alloc = imalloc_Alloc;
      pMalloc->lpVtbl->Realloc = imalloc_Realloc;
      pMalloc->lpVtbl->Free = imalloc_Free;
      pMalloc->lpVtbl->GetSize = imalloc_GetSize;
      pMalloc->lpVtbl->DidAlloc = imalloc_DidAlloc;
      pMalloc->lpVtbl->HeapMinimize = imalloc_HeapMinimize;
      *ppMalloc = pMalloc;
    }
  return NOERROR;
}


/* SHGetNewLinkInfo ordinal = 326, argument = 20 temporary */
/* DWORD WINAPI SHGetNewLinkInfo (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4) */


/* SHGetNewLinkInfoA ordinal = 179, argument = 0 temporary */
static DWORD WINAPI SHGetNewLinkInfoA (VOID)
{
  return 0;
}


/* SHGetNewLinkInfoW ordinal = 180, argument = 0 temporary */
static DWORD WINAPI SHGetNewLinkInfoW (VOID)
{
  return 0;
}


/* SHGetPathFromIDList ordinal = 327, argument = 8 */
/* BOOL WINAPI SHGetPathFromIDList (LPCITEMIDLIST pidl, LPSTR pszPath) */


/* SHGetPathFromIDListA ordinal = 328, argument = 8 */
BOOL WINAPI SHGetPathFromIDListA (LPCITEMIDLIST pidl, LPSTR pszPath)
{
  gchar *file, *mb;

  if (!pidl || !pszPath)
    return FALSE;
  file = g_strdup (G_DIR_SEPARATOR_S);
  while (pidl->mkid.cb >= sizeof (WORD))
    {
      gchar *name, *tmp;

      name = g_malloc ((pidl->mkid.cb - sizeof (WORD) + 1) * sizeof (gchar));
      g_memmove (name, pidl->mkid.abID, pidl->mkid.cb - sizeof (WORD));
      name[pidl->mkid.cb - sizeof (WORD)] = '\0';
      tmp = g_build_filename (file, name, NULL);
      g_free (file);
      g_free (name);
      file = tmp;
      pidl = (LPCITEMIDLIST)((guint8 *)pidl + pidl->mkid.cb);
    }
  mb = w32ldr_filename_to_mb (file);
  g_free (file);
  g_strcpy (pszPath, mb);
  g_free (mb);
  return TRUE;
}


/* SHGetPathFromIDListW ordinal = 329, argument = 8 */
BOOL WINAPI SHGetPathFromIDListW (LPCITEMIDLIST pidl, LPWSTR pszPath)
{
  gchar *file;
  gunichar2 *wc;

  if (!pidl || !pszPath)
    return FALSE;
  file = g_strdup (G_DIR_SEPARATOR_S);
  while (pidl->mkid.cb >= sizeof (WORD))
    {
      gchar *name, *tmp;

      name = g_malloc ((pidl->mkid.cb - sizeof (WORD) + 1) * sizeof (gchar));
      g_memmove (name, pidl->mkid.abID, pidl->mkid.cb - sizeof (WORD));
      name[pidl->mkid.cb - sizeof (WORD)] = '\0';
      tmp = g_build_filename (file, name, NULL);
      g_free (file);
      g_free (name);
      file = tmp;
      pidl = (LPCITEMIDLIST)((guint8 *)pidl + pidl->mkid.cb);
    }
  wc = w32ldr_filename_to_wc (file);
  g_free (file);
  lstrcpyW (pszPath, wc);
  g_free (wc);
  return TRUE;
}


/* SHGetSettings ordinal = 330, argument = 8 temporary */
static DWORD WINAPI SHGetSettings (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SHGetSpecialFolderLocation ordinal = 331, argument = 12 temporary */
static DWORD WINAPI SHGetSpecialFolderLocation (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SHGetSpecialFolderPathA ordinal = 332, argument = 16 temporary */
static DWORD WINAPI SHGetSpecialFolderPathA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SHGetSpecialFolderPathW ordinal = 333, argument = 16 temporary */
static DWORD WINAPI SHGetSpecialFolderPathW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SHHelpShortcuts_RunDLL ordinal = 334, argument = 0 temporary */
/* DWORD WINAPI SHHelpShortcuts_RunDLL (VOID) */


/* SHHelpShortcuts_RunDLLA ordinal = 335, argument = 0 temporary */
static DWORD WINAPI SHHelpShortcuts_RunDLLA (VOID)
{
  return 0;
}


/* SHHelpShortcuts_RunDLLW ordinal = 336, argument = 0 temporary */
static DWORD WINAPI SHHelpShortcuts_RunDLLW (VOID)
{
  return 0;
}


/* SHInvokePrinterCommandA ordinal = 337, argument = 20 temporary */
static DWORD WINAPI SHInvokePrinterCommandA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* SHInvokePrinterCommandW ordinal = 338, argument = 20 temporary */
static DWORD WINAPI SHInvokePrinterCommandW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4)
{
  return 0;
}


/* SHIsFileAvailableOffline ordinal = 339, argument = 8 temporary */
static DWORD WINAPI SHIsFileAvailableOffline (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SHLoadInProc ordinal = 340, argument = 4 temporary */
static DWORD WINAPI SHLoadInProc (DWORD dwArgv0)
{
  return 0;
}


/* SHLoadNonloadedIconOverlayIdentifiers ordinal = 341, argument = 0 temporary */
static DWORD WINAPI SHLoadNonloadedIconOverlayIdentifiers (VOID)
{
  return 0;
}


/* SHPathPrepareForWriteA ordinal = 342, argument = 16 temporary */
static DWORD WINAPI SHPathPrepareForWriteA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SHPathPrepareForWriteW ordinal = 343, argument = 16 temporary */
static DWORD WINAPI SHPathPrepareForWriteW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* SHQueryRecycleBinA ordinal = 344, argument = 8 temporary */
static DWORD WINAPI SHQueryRecycleBinA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SHQueryRecycleBinW ordinal = 345, argument = 8 temporary */
static DWORD WINAPI SHQueryRecycleBinW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SHUpdateRecycleBinIcon ordinal = 346, argument = 0 temporary */
static DWORD WINAPI SHUpdateRecycleBinIcon (VOID)
{
  return 0;
}


/* SheChangeDirA ordinal = 347, argument = 4 temporary */
static DWORD WINAPI SheChangeDirA (DWORD dwArgv0)
{
  return 0;
}


/* SheChangeDirExA ordinal = 348, argument = 4 temporary */
static DWORD WINAPI SheChangeDirExA (DWORD dwArgv0)
{
  return 0;
}


/* SheChangeDirExW ordinal = 349, argument = 4 temporary */
static DWORD WINAPI SheChangeDirExW (DWORD dwArgv0)
{
  return 0;
}


/* SheChangeDirW ordinal = 350, argument = 4 temporary */
static DWORD WINAPI SheChangeDirW (DWORD dwArgv0)
{
  return 0;
}


/* SheConvertPathW ordinal = 351, argument = 12 temporary */
static DWORD WINAPI SheConvertPathW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SheFullPathA ordinal = 352, argument = 12 temporary */
static DWORD WINAPI SheFullPathA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SheFullPathW ordinal = 353, argument = 12 temporary */
static DWORD WINAPI SheFullPathW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SheGetCurDrive ordinal = 354, argument = 0 temporary */
static DWORD WINAPI SheGetCurDrive (VOID)
{
  return 0;
}


/* SheGetDirA ordinal = 355, argument = 8 temporary */
static DWORD WINAPI SheGetDirA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SheGetDirExW ordinal = 356, argument = 12 temporary */
static DWORD WINAPI SheGetDirExW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* SheGetDirW ordinal = 357, argument = 8 temporary */
static DWORD WINAPI SheGetDirW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SheGetPathOffsetW ordinal = 358, argument = 4 temporary */
static DWORD WINAPI SheGetPathOffsetW (DWORD dwArgv0)
{
  return 0;
}


/* SheRemoveQuotesA ordinal = 359, argument = 4 temporary */
static DWORD WINAPI SheRemoveQuotesA (DWORD dwArgv0)
{
  return 0;
}


/* SheRemoveQuotesW ordinal = 360, argument = 4 temporary */
static DWORD WINAPI SheRemoveQuotesW (DWORD dwArgv0)
{
  return 0;
}


/* SheSetCurDrive ordinal = 361, argument = 4 temporary */
static DWORD WINAPI SheSetCurDrive (DWORD dwArgv0)
{
  return 0;
}


/* SheShortenPathA ordinal = 362, argument = 8 temporary */
static DWORD WINAPI SheShortenPathA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* SheShortenPathW ordinal = 363, argument = 8 temporary */
static DWORD WINAPI SheShortenPathW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* ShellAboutA ordinal = 364, argument = 16 temporary */
static DWORD WINAPI ShellAboutA (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* ShellAboutW ordinal = 365, argument = 16 temporary */
static DWORD WINAPI ShellAboutW (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3)
{
  return 0;
}


/* ShellExec_RunDLL ordinal = 366, argument = 0 temporary */
/* DWORD WINAPI ShellExec_RunDLL (VOID) */


/* ShellExec_RunDLLA ordinal = 367, argument = 0 temporary */
static DWORD WINAPI ShellExec_RunDLLA (VOID)
{
  return 0;
}


/* ShellExec_RunDLLW ordinal = 368, argument = 0 temporary */
static DWORD WINAPI ShellExec_RunDLLW (VOID)
{
  return 0;
}


/* ShellExecuteA ordinal = 369, argument = 24 */
HINSTANCE WINAPI ShellExecuteA (HWND hWnd, LPCSTR lpOperation, LPCSTR lpFile, LPCSTR lpParameters, LPCSTR lpDirectory, INT nShowCmd)
{
  return NULL;
}


/* ShellExecuteEx ordinal = 370, argument = 4 temporary */
/* DWORD WINAPI ShellExecuteEx (DWORD dwArgv0) */


/* ShellExecuteExA ordinal = 371, argument = 4 */
BOOL WINAPI ShellExecuteExA (LPSHELLEXECUTEINFOA lpExecInfo)
{
  return FALSE;
}


/* ShellExecuteExW ordinal = 372, argument = 4 */
BOOL WINAPI ShellExecuteExW (LPSHELLEXECUTEINFOW lpExecInfo)
{
  return FALSE;
}


/* ShellExecuteW ordinal = 373, argument = 24 */
HINSTANCE WINAPI ShellExecuteW (HWND hWnd, LPCWSTR lpOperation, LPCWSTR lpFile, LPCWSTR lpParameters, LPCWSTR lpDirectory, INT nShowCmd)
{
  return NULL;
}


/* ShellHookProc ordinal = 374, argument = 12 temporary */
static DWORD WINAPI ShellHookProc (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2)
{
  return 0;
}


/* Shell_NotifyIcon ordinal = 375, argument = 8 temporary */
/* DWORD WINAPI Shell_NotifyIcon (DWORD dwArgv0, DWORD dwArgv1) */


/* Shell_NotifyIconA ordinal = 376, argument = 8 temporary */
static DWORD WINAPI Shell_NotifyIconA (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* Shell_NotifyIconW ordinal = 377, argument = 8 temporary */
static DWORD WINAPI Shell_NotifyIconW (DWORD dwArgv0, DWORD dwArgv1)
{
  return 0;
}


/* StrChrA ordinal = 378, argument = 0 temporary */
static DWORD WINAPI StrChrA (VOID)
{
  return 0;
}


/* StrChrIA ordinal = 379, argument = 0 temporary */
static DWORD WINAPI StrChrIA (VOID)
{
  return 0;
}


/* StrChrIW ordinal = 380, argument = 0 temporary */
static DWORD WINAPI StrChrIW (VOID)
{
  return 0;
}


/* StrChrW ordinal = 381, argument = 0 temporary */
static DWORD WINAPI StrChrW (VOID)
{
  return 0;
}


/* StrCmpNA ordinal = 382, argument = 0 temporary */
static DWORD WINAPI StrCmpNA (VOID)
{
  return 0;
}


/* StrCmpNIA ordinal = 383, argument = 0 temporary */
static DWORD WINAPI StrCmpNIA (VOID)
{
  return 0;
}


/* StrCmpNIW ordinal = 384, argument = 0 temporary */
static DWORD WINAPI StrCmpNIW (VOID)
{
  return 0;
}


/* StrCmpNW ordinal = 385, argument = 0 temporary */
static DWORD WINAPI StrCmpNW (VOID)
{
  return 0;
}


/* StrCpyNA ordinal = 386, argument = 0 temporary */
static DWORD WINAPI StrCpyNA (VOID)
{
  return 0;
}


/* StrCpyNW ordinal = 387, argument = 0 temporary */
static DWORD WINAPI StrCpyNW (VOID)
{
  return 0;
}


/* StrNCmpA ordinal = 388, argument = 0 temporary */
static DWORD WINAPI StrNCmpA (VOID)
{
  return 0;
}


/* StrNCmpIA ordinal = 389, argument = 0 temporary */
static DWORD WINAPI StrNCmpIA (VOID)
{
  return 0;
}


/* StrNCmpIW ordinal = 390, argument = 0 temporary */
static DWORD WINAPI StrNCmpIW (VOID)
{
  return 0;
}


/* StrNCmpW ordinal = 391, argument = 0 temporary */
static DWORD WINAPI StrNCmpW (VOID)
{
  return 0;
}


/* StrNCpyA ordinal = 392, argument = 0 temporary */
static DWORD WINAPI StrNCpyA (VOID)
{
  return 0;
}


/* StrNCpyW ordinal = 393, argument = 0 temporary */
static DWORD WINAPI StrNCpyW (VOID)
{
  return 0;
}


/* StrRChrA ordinal = 394, argument = 0 temporary */
static DWORD WINAPI StrRChrA (VOID)
{
  return 0;
}


/* StrRChrIA ordinal = 395, argument = 0 temporary */
static DWORD WINAPI StrRChrIA (VOID)
{
  return 0;
}


/* StrRChrIW ordinal = 396, argument = 0 temporary */
static DWORD WINAPI StrRChrIW (VOID)
{
  return 0;
}


/* StrRChrW ordinal = 397, argument = 0 temporary */
static DWORD WINAPI StrRChrW (VOID)
{
  return 0;
}


/* StrRStrA ordinal = 398, argument = 0 temporary */
static DWORD WINAPI StrRStrA (VOID)
{
  return 0;
}


/* StrRStrIA ordinal = 399, argument = 0 temporary */
static DWORD WINAPI StrRStrIA (VOID)
{
  return 0;
}


/* StrRStrIW ordinal = 400, argument = 0 temporary */
static DWORD WINAPI StrRStrIW (VOID)
{
  return 0;
}


/* StrRStrW ordinal = 401, argument = 0 temporary */
static DWORD WINAPI StrRStrW (VOID)
{
  return 0;
}


/* StrStrA ordinal = 402, argument = 0 temporary */
static DWORD WINAPI StrStrA (VOID)
{
  return 0;
}


/* StrStrIA ordinal = 403, argument = 0 temporary */
static DWORD WINAPI StrStrIA (VOID)
{
  return 0;
}


/* StrStrIW ordinal = 404, argument = 0 temporary */
static DWORD WINAPI StrStrIW (VOID)
{
  return 0;
}


/* StrStrW ordinal = 405, argument = 0 temporary */
static DWORD WINAPI StrStrW (VOID)
{
  return 0;
}


/* WOWShellExecute ordinal = 406, argument = 28 temporary */
static DWORD WINAPI WOWShellExecute (DWORD dwArgv0, DWORD dwArgv1, DWORD dwArgv2, DWORD dwArgv3, DWORD dwArgv4, DWORD dwArgv5, DWORD dwArgv6)
{
  return 0;
}


W32LdrExport shell32_exports[] = {
{FALSE,  81, "CheckEscapesA",                         CheckEscapesA},
{FALSE, 125, "CheckEscapesW",                         CheckEscapesW},
{FALSE, 133, "CommandLineToArgvW",                    CommandLineToArgvW},
{FALSE, 135, "Control_FillCache_RunDLL",              Control_FillCache_RunDLLA},
{FALSE, 138, "Control_FillCache_RunDLLA",             Control_FillCache_RunDLLA},
{FALSE, 148, "Control_FillCache_RunDLLW",             Control_FillCache_RunDLLW},
{FALSE, 150, "Control_RunDLL",                        Control_RunDLLA},
{FALSE, 199, "Control_RunDLLA",                       Control_RunDLLA},
{FALSE, 226, "Control_RunDLLAsUserW",                 Control_RunDLLAsUserW},
{FALSE, 228, "Control_RunDLLW",                       Control_RunDLLW},
{FALSE, 229, "DllCanUnloadNow",                       shell32_DllCanUnloadNow},
{FALSE, 233, "DllGetClassObject",                     shell32_DllGetClassObject},
{FALSE, 234, "DllGetVersion",                         shell32_DllGetVersion},
{FALSE, 235, "DllInstall",                            shell32_DllInstall},
{FALSE, 236, "DllRegisterServer",                     shell32_DllRegisterServer},
{FALSE, 237, "DllUnregisterServer",                   shell32_DllUnregisterServer},
{FALSE, 238, "DoEnvironmentSubstA",                   DoEnvironmentSubstA},
{FALSE, 241, "DoEnvironmentSubstW",                   DoEnvironmentSubstW},
{TRUE,  245, "DragAcceptFiles",                       DragAcceptFiles},
{TRUE,  246, "DragFinish",                            DragFinish},
{TRUE,  247, "DragQueryFile",                         DragQueryFileA},
{TRUE,  248, "DragQueryFileA",                        DragQueryFileA},
{FALSE, 253, "DragQueryFileAorW",                     DragQueryFileAorW},
{TRUE,  254, "DragQueryFileW",                        DragQueryFileW},
{TRUE,  255, "DragQueryPoint",                        DragQueryPoint},
{FALSE, 260, "DuplicateIcon",                         DuplicateIcon},
{FALSE, 261, "ExtractAssociatedIconA",                ExtractAssociatedIconA},
{FALSE, 262, "ExtractAssociatedIconExA",              ExtractAssociatedIconExA},
{FALSE, 263, "ExtractAssociatedIconExW",              ExtractAssociatedIconExW},
{FALSE, 264, "ExtractAssociatedIconW",                ExtractAssociatedIconW},
{FALSE, 265, "ExtractIconA",                          ExtractIconA},
{FALSE, 266, "ExtractIconEx",                         ExtractIconExA},
{FALSE, 267, "ExtractIconExA",                        ExtractIconExA},
{FALSE, 268, "ExtractIconExW",                        ExtractIconExW},
{FALSE, 269, "ExtractIconResInfoA",                   ExtractIconResInfoA},
{FALSE, 270, "ExtractIconResInfoW",                   ExtractIconResInfoW},
{FALSE, 271, "ExtractIconW",                          ExtractIconW},
{FALSE, 272, "ExtractVersionResource16W",             ExtractVersionResource16W},
{FALSE, 273, "FindExeDlgProc",                        FindExeDlgProc},
{TRUE,  274, "FindExecutableA",                       FindExecutableA},
{TRUE,  275, "FindExecutableW",                       FindExecutableW},
{FALSE, 276, "FixupOptionalComponents",               FixupOptionalComponents},
{FALSE, 277, "FreeIconList",                          FreeIconList},
{FALSE, 278, "InternalExtractIconListA",              InternalExtractIconListA},
{FALSE, 279, "InternalExtractIconListW",              InternalExtractIconListW},
{FALSE,  44, "OCInstall",                             OCInstall},
{FALSE, 280, "OpenAs_RunDLL",                         OpenAs_RunDLLA},
{FALSE, 281, "OpenAs_RunDLLA",                        OpenAs_RunDLLA},
{FALSE, 282, "OpenAs_RunDLLW",                        OpenAs_RunDLLW},
{FALSE, 283, "PrintersGetCommand_RunDLL",             PrintersGetCommand_RunDLLA},
{FALSE, 284, "PrintersGetCommand_RunDLLA",            PrintersGetCommand_RunDLLA},
{FALSE, 285, "PrintersGetCommand_RunDLLW",            PrintersGetCommand_RunDLLW},
{FALSE, 286, "RealShellExecuteA",                     RealShellExecuteA},
{FALSE, 287, "RealShellExecuteExA",                   RealShellExecuteExA},
{FALSE, 288, "RealShellExecuteExW",                   RealShellExecuteExW},
{FALSE, 289, "RealShellExecuteW",                     RealShellExecuteW},
{FALSE, 290, "RegenerateUserEnvironment",             RegenerateUserEnvironment},
{FALSE, 291, "SHAddToRecentDocs",                     SHAddToRecentDocs},
{FALSE, 292, "SHAppBarMessage",                       SHAppBarMessage},
{FALSE, 293, "SHBindToParent",                        SHBindToParent},
{TRUE,  294, "SHBrowseForFolder",                     SHBrowseForFolderA},
{TRUE,  295, "SHBrowseForFolderA",                    SHBrowseForFolderA},
{TRUE,  296, "SHBrowseForFolderW",                    SHBrowseForFolderW},
{FALSE, 297, "SHChangeNotify",                        SHChangeNotify},
{FALSE, 298, "SHChangeNotifySuspendResume",           SHChangeNotifySuspendResume},
{FALSE, 299, "SHCreateDirectoryExA",                  SHCreateDirectoryExA},
{FALSE, 300, "SHCreateDirectoryExW",                  SHCreateDirectoryExW},
{FALSE, 301, "SHCreateProcessAsUserW",                SHCreateProcessAsUserW},
{FALSE, 302, "SHEmptyRecycleBinA",                    SHEmptyRecycleBinA},
{FALSE, 303, "SHEmptyRecycleBinW",                    SHEmptyRecycleBinW},
{FALSE, 304, "SHExtractIconsW",                       SHExtractIconsW},
{TRUE,  305, "SHFileOperation",                       SHFileOperationA},
{TRUE,  306, "SHFileOperationA",                      SHFileOperationA},
{TRUE,  307, "SHFileOperationW",                      SHFileOperationW},
{FALSE, 308, "SHFormatDrive",                         SHFormatDrive},
{FALSE, 309, "SHFreeNameMappings",                    SHFreeNameMappings},
{FALSE, 310, "SHGetDataFromIDListA",                  SHGetDataFromIDListA},
{FALSE, 311, "SHGetDataFromIDListW",                  SHGetDataFromIDListW},
{FALSE, 312, "SHGetDesktopFolder",                    SHGetDesktopFolder},
{FALSE, 313, "SHGetDiskFreeSpaceA",                   SHGetDiskFreeSpaceA},
{FALSE, 314, "SHGetDiskFreeSpaceExA",                 SHGetDiskFreeSpaceExA},
{FALSE, 315, "SHGetDiskFreeSpaceExW",                 SHGetDiskFreeSpaceExW},
{FALSE, 316, "SHGetFileInfo",                         SHGetFileInfoA},
{FALSE, 317, "SHGetFileInfoA",                        SHGetFileInfoA},
{FALSE, 318, "SHGetFileInfoW",                        SHGetFileInfoW},
{FALSE, 319, "SHGetFolderLocation",                   SHGetFolderLocation},
{FALSE, 320, "SHGetFolderPathA",                      SHGetFolderPathA},
{FALSE, 321, "SHGetFolderPathW",                      SHGetFolderPathW},
{FALSE, 322, "SHGetIconOverlayIndexA",                SHGetIconOverlayIndexA},
{FALSE, 323, "SHGetIconOverlayIndexW",                SHGetIconOverlayIndexW},
{FALSE, 324, "SHGetInstanceExplorer",                 SHGetInstanceExplorer},
{TRUE,  325, "SHGetMalloc",                           SHGetMalloc},
{FALSE, 326, "SHGetNewLinkInfo",                      SHGetNewLinkInfoA},
{FALSE, 179, "SHGetNewLinkInfoA",                     SHGetNewLinkInfoA},
{FALSE, 180, "SHGetNewLinkInfoW",                     SHGetNewLinkInfoW},
{TRUE,  327, "SHGetPathFromIDList",                   SHGetPathFromIDListA},
{TRUE,  328, "SHGetPathFromIDListA",                  SHGetPathFromIDListA},
{TRUE,  329, "SHGetPathFromIDListW",                  SHGetPathFromIDListW},
{FALSE, 330, "SHGetSettings",                         SHGetSettings},
{FALSE, 331, "SHGetSpecialFolderLocation",            SHGetSpecialFolderLocation},
{FALSE, 332, "SHGetSpecialFolderPathA",               SHGetSpecialFolderPathA},
{FALSE, 333, "SHGetSpecialFolderPathW",               SHGetSpecialFolderPathW},
{FALSE, 334, "SHHelpShortcuts_RunDLL",                SHHelpShortcuts_RunDLLA},
{FALSE, 335, "SHHelpShortcuts_RunDLLA",               SHHelpShortcuts_RunDLLA},
{FALSE, 336, "SHHelpShortcuts_RunDLLW",               SHHelpShortcuts_RunDLLW},
{FALSE, 337, "SHInvokePrinterCommandA",               SHInvokePrinterCommandA},
{FALSE, 338, "SHInvokePrinterCommandW",               SHInvokePrinterCommandW},
{FALSE, 339, "SHIsFileAvailableOffline",              SHIsFileAvailableOffline},
{FALSE, 340, "SHLoadInProc",                          SHLoadInProc},
{FALSE, 341, "SHLoadNonloadedIconOverlayIdentifiers", SHLoadNonloadedIconOverlayIdentifiers},
{FALSE, 342, "SHPathPrepareForWriteA",                SHPathPrepareForWriteA},
{FALSE, 343, "SHPathPrepareForWriteW",                SHPathPrepareForWriteW},
{FALSE, 344, "SHQueryRecycleBinA",                    SHQueryRecycleBinA},
{FALSE, 345, "SHQueryRecycleBinW",                    SHQueryRecycleBinW},
{FALSE, 346, "SHUpdateRecycleBinIcon",                SHUpdateRecycleBinIcon},
{FALSE, 347, "SheChangeDirA",                         SheChangeDirA},
{FALSE, 348, "SheChangeDirExA",                       SheChangeDirExA},
{FALSE, 349, "SheChangeDirExW",                       SheChangeDirExW},
{FALSE, 350, "SheChangeDirW",                         SheChangeDirW},
{FALSE, 351, "SheConvertPathW",                       SheConvertPathW},
{FALSE, 352, "SheFullPathA",                          SheFullPathA},
{FALSE, 353, "SheFullPathW",                          SheFullPathW},
{FALSE, 354, "SheGetCurDrive",                        SheGetCurDrive},
{FALSE, 355, "SheGetDirA",                            SheGetDirA},
{FALSE, 356, "SheGetDirExW",                          SheGetDirExW},
{FALSE, 357, "SheGetDirW",                            SheGetDirW},
{FALSE, 358, "SheGetPathOffsetW",                     SheGetPathOffsetW},
{FALSE, 359, "SheRemoveQuotesA",                      SheRemoveQuotesA},
{FALSE, 360, "SheRemoveQuotesW",                      SheRemoveQuotesW},
{FALSE, 361, "SheSetCurDrive",                        SheSetCurDrive},
{FALSE, 362, "SheShortenPathA",                       SheShortenPathA},
{FALSE, 363, "SheShortenPathW",                       SheShortenPathW},
{FALSE, 364, "ShellAboutA",                           ShellAboutA},
{FALSE, 365, "ShellAboutW",                           ShellAboutW},
{FALSE, 366, "ShellExec_RunDLL",                      ShellExec_RunDLLA},
{FALSE, 367, "ShellExec_RunDLLA",                     ShellExec_RunDLLA},
{FALSE, 368, "ShellExec_RunDLLW",                     ShellExec_RunDLLW},
{TRUE,  369, "ShellExecuteA",                         ShellExecuteA},
{TRUE,  370, "ShellExecuteEx",                        ShellExecuteExA},
{TRUE,  371, "ShellExecuteExA",                       ShellExecuteExA},
{TRUE,  372, "ShellExecuteExW",                       ShellExecuteExW},
{TRUE,  373, "ShellExecuteW",                         ShellExecuteW},
{FALSE, 374, "ShellHookProc",                         ShellHookProc},
{FALSE, 375, "Shell_NotifyIcon",                      Shell_NotifyIconA},
{FALSE, 376, "Shell_NotifyIconA",                     Shell_NotifyIconA},
{FALSE, 377, "Shell_NotifyIconW",                     Shell_NotifyIconW},
{FALSE, 378, "StrChrA",                               StrChrA},
{FALSE, 379, "StrChrIA",                              StrChrIA},
{FALSE, 380, "StrChrIW",                              StrChrIW},
{FALSE, 381, "StrChrW",                               StrChrW},
{FALSE, 382, "StrCmpNA",                              StrCmpNA},
{FALSE, 383, "StrCmpNIA",                             StrCmpNIA},
{FALSE, 384, "StrCmpNIW",                             StrCmpNIW},
{FALSE, 385, "StrCmpNW",                              StrCmpNW},
{FALSE, 386, "StrCpyNA",                              StrCpyNA},
{FALSE, 387, "StrCpyNW",                              StrCpyNW},
{FALSE, 388, "StrNCmpA",                              StrNCmpA},
{FALSE, 389, "StrNCmpIA",                             StrNCmpIA},
{FALSE, 390, "StrNCmpIW",                             StrNCmpIW},
{FALSE, 391, "StrNCmpW",                              StrNCmpW},
{FALSE, 392, "StrNCpyA",                              StrNCpyA},
{FALSE, 393, "StrNCpyW",                              StrNCpyW},
{FALSE, 394, "StrRChrA",                              StrRChrA},
{FALSE, 395, "StrRChrIA",                             StrRChrIA},
{FALSE, 396, "StrRChrIW",                             StrRChrIW},
{FALSE, 397, "StrRChrW",                              StrRChrW},
{FALSE, 398, "StrRStrA",                              StrRStrA},
{FALSE, 399, "StrRStrIA",                             StrRStrIA},
{FALSE, 400, "StrRStrIW",                             StrRStrIW},
{FALSE, 401, "StrRStrW",                              StrRStrW},
{FALSE, 402, "StrStrA",                               StrStrA},
{FALSE, 403, "StrStrIA",                              StrStrIA},
{FALSE, 404, "StrStrIW",                              StrStrIW},
{FALSE, 405, "StrStrW",                               StrStrW},
{FALSE, 406, "WOWShellExecute",                       WOWShellExecute},
{FALSE,   0, NULL,                                    NULL}};
