/*
    avicore
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __AVI_CLIP_H__
#define __AVI_CLIP_H__


#include "avicore.h"
#ifdef G_OS_WIN32
# include <windows.h>
#endif /* G_OS_WIN32 */


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define AVI_TYPE_CLIP            (avi_clip_get_type ())
#define AVI_CLIP(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), AVI_TYPE_CLIP, AviClip))
#define AVI_CLIP_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), AVI_TYPE_CLIP, AviClipClass))
#define AVI_IS_CLIP(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AVI_TYPE_CLIP))
#define AVI_IS_CLIP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AVI_TYPE_CLIP))
#define AVI_CLIP_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), AVI_TYPE_CLIP, AviClipClass))


typedef struct _AviClip      AviClip;
typedef struct _AviClipClass AviClipClass;


struct _AviClip
{
  /*< private >*/
  GObject       parent;

  /*< public >*/

  /*< private >*/
  gulong        handler_destroy;
  GtkWidget    *window;
#ifndef G_OS_WIN32
  GtkClipboard *clipboard;
#endif /* not G_OS_WIN32 */
};
struct _AviClipClass
{
  GObjectClass parent_class;

  /* -- signals -- */
  void (*paste) (AviClip  *clip,
                 AviEdit **avi_edit);
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
avi_clip_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:クリップボード関数群                                                     *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    window,ウィジェット
       RET,オブジェクト                                                     */
GObject *
avi_clip_new (GtkWidget *window);


/*  ja:クリップボードにコピーする
        clip,オブジェクト
    avi_edit,AVI編集ハンドル                                                */
void
avi_clip_copy (AviClip  *clip,
               AviEdit **avi_edit);


/*  ja:クリップボードから貼り付ける
    clip,オブジェクト                                                       */
void
avi_clip_paste (AviClip *clip);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __AVI_CLIP_H__ */
