/*
    w32loader
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __W32LDR_FONT_H__
#define __W32LDR_FONT_H__


#include "gcommon.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define W32LDR_TYPE_FONT            (w32ldr_font_get_type ())
#define W32LDR_FONT(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), W32LDR_TYPE_FONT, W32LdrFont))
#define W32LDR_FONT_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), W32LDR_TYPE_FONT, W32LdrFontClass))
#define W32LDR_IS_FONT(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), W32LDR_TYPE_FONT))
#define W32LDR_IS_FONT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), W32LDR_TYPE_FONT))
#define W32LDR_FONT_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), W32LDR_TYPE_FONT, W32LdrFontClass))


typedef struct _W32LdrFont      W32LdrFont;
typedef struct _W32LdrFontClass W32LdrFontClass;


struct _W32LdrFont
{
  /*< private >*/
  GObject               parent;
  PangoFontDescription *desc;
};
struct _W32LdrFontClass
{
  GObjectClass parent_class;
};


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
w32ldr_font_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:フォント関数群                                                           *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,オブジェクト                                                        */
W32LdrFont *
w32ldr_font_new (void);


/*  ja:新規作成
    desc,フォント
     RET,オブジェクト                                                       */
W32LdrFont *
w32ldr_font_new_with_description (const PangoFontDescription *desc);


/*  ja:フォントをコピーする
    w32font,オブジェクト
         RET,オブジェクト                                                   */
W32LdrFont *
w32ldr_font_copy (W32LdrFont *w32font);


/*  ja:フォントを取得する
    w32font,オブジェクト
       RET,フォント                                                        */
const PangoFontDescription *
w32ldr_font_get_description (W32LdrFont *w32font);


/*  ja:フォントを設定する
    w32font,オブジェクト
       desc,フォント                                                        */
void
w32ldr_font_set_description (W32LdrFont                 *w32font,
                             const PangoFontDescription *desc);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __W32LDR_FONT_H__ */
