/*
    w32loader
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __VERSION_H__
#define __VERSION_H__


#include "w32ldr.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


extern W32LdrExport version_exports[];


BOOL WINAPI GetFileVersionInfoA (LPSTR lptstrFilename, DWORD dwHandle, DWORD dwLen, LPVOID lpData);
DWORD WINAPI GetFileVersionInfoSizeA (LPSTR lptstrFilename, LPDWORD lpdwHandle);
DWORD WINAPI GetFileVersionInfoSizeW (LPWSTR lptstrFilename, LPDWORD lpdwHandle);
BOOL WINAPI GetFileVersionInfoW (LPWSTR lptstrFilename, DWORD dwHandle, DWORD dwLen, LPVOID lpData);
BOOL WINAPI VerQueryValueA (LPCVOID pBlock, LPSTR lpSubBlock, LPVOID *lplpBuffer, UINT_PTR puLen);
BOOL WINAPI VerQueryValueW (LPCVOID pBlock, LPWSTR lpSubBlock, LPVOID *lplpBuffer, UINT_PTR puLen);


#ifdef UNICODE
# define GetFileVersionInfo GetFileVersionInfoW
# define GetFileVersionInfoSize GetFileVersionInfoSizeW
# define VerQueryValue VerQueryValueW
#else /* not UNICODE*/
# define GetFileVersionInfo GetFileVersionInfoA
# define GetFileVersionInfoSize GetFileVersionInfoSizeA
# define VerQueryValue VerQueryValueA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __VERSION_H__ */
