/*
    w32loader
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __ADVAPI32_H__
#define __ADVAPI32_H__


#include "w32ldr.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/* ja:時間 */
typedef struct _FILETIME
{
  DWORD dwLowDateTime;
  DWORD dwHighDateTime;
} FILETIME, *PFILETIME, *LPFILETIME;
/* ja:レジストリ */
#define ERROR_SUCCESS       0
#define ERROR_NO_MORE_ITEMS 259
#define ERROR_UNKNOWN       99999
#define HKEY_CLASSES_ROOT     (GUINT_TO_POINTER(0x80000000))
#define HKEY_CURRENT_USER     (GUINT_TO_POINTER(0x80000001))
#define HKEY_LOCAL_MACHINE    (GUINT_TO_POINTER(0x80000002))
#define HKEY_USERS            (GUINT_TO_POINTER(0x80000003))
#define HKEY_PERFORMANCE_DATA (GUINT_TO_POINTER(0x80000004))
#define HKEY_CURRENT_CONFIG   (GUINT_TO_POINTER(0x80000005))
#define HKEY_DYN_DATA         (GUINT_TO_POINTER(0x80000006))
#define KEY_QUERY_VALUE        0x00000001
#define KEY_SET_VALUE          0x00000002
#define KEY_CREATE_SUB_KEY     0x00000004
#define KEY_ENUMERATE_SUB_KEYS 0x00000008
#define KEY_NOTIFY             0x00000010
#define KEY_CREATE_LINK        0x00000020
#define REG_NONE      0
#define REG_SZ        1
#define REG_EXPAND_SZ 2
#define REG_BINARY    3
#define REG_DWORD     4
typedef gchar *HKEY, **PHKEY, **LPHKEY;
typedef DWORD REGSAM;


extern W32LdrExport advapi32_exports[];


LONG WINAPI RegCloseKey (HKEY hKey);
LONG WINAPI RegConnectRegistryA (LPCSTR lpMachineName, HKEY hKey, PHKEY phkResult);
LONG WINAPI RegConnectRegistryW (LPCWSTR lpMachineName, HKEY hKey, PHKEY phkResult);
LONG WINAPI RegCreateKeyA (HKEY hKey, LPCSTR lpSubKey, PHKEY phkResult);
LONG WINAPI RegCreateKeyExA (HKEY hKey, LPCSTR lpSubKey, DWORD Reserved, LPSTR lpClass, DWORD dwOptions, REGSAM samDesired, LPSECURITY_ATTRIBUTES lpSecurityAttributes, PHKEY phkResult, LPDWORD lpdwDisposition);
LONG WINAPI RegCreateKeyExW (HKEY hKey, LPCWSTR lpSubKey, DWORD Reserved, LPWSTR lpClass, DWORD dwOptions, REGSAM samDesired, LPSECURITY_ATTRIBUTES lpSecurityAttributes, PHKEY phkResult, LPDWORD lpdwDisposition);
LONG WINAPI RegCreateKeyW (HKEY hKey, LPCWSTR lpSubKey, PHKEY phkResult);
LONG WINAPI RegDeleteKeyA (HKEY hKey, LPCSTR lpSubKey);
LONG WINAPI RegDeleteKeyW (HKEY hKey, LPCWSTR lpSubKey);
LONG WINAPI RegDeleteValueA (HKEY hKey, LPCSTR lpValueName);
LONG WINAPI RegDeleteValueW (HKEY hKey, LPCWSTR lpValueName);
LONG WINAPI RegDisablePredefinedCache (VOID);
LONG WINAPI RegEnumKeyA (HKEY hKey, DWORD dwIndex, LPSTR lpName, DWORD cchName);
LONG WINAPI RegEnumKeyExA (HKEY hKey, DWORD dwIndex, LPSTR lpName, LPDWORD lpcName, LPDWORD lpReserved, LPSTR lpClass, LPDWORD lpcClass, PFILETIME lpftLastWriteTime);
LONG WINAPI RegEnumKeyExW (HKEY hKey, DWORD dwIndex, LPWSTR lpName, LPDWORD lpcName, LPDWORD lpReserved, LPWSTR lpClass, LPDWORD lpcClass, PFILETIME lpftLastWriteTime);
LONG WINAPI RegEnumKeyW (HKEY hKey, DWORD dwIndex, LPWSTR lpName, DWORD cchName);
LONG WINAPI RegEnumValueA (HKEY hKey, DWORD dwIndex, LPSTR lpValueName, LPDWORD lpcValueName, LPDWORD lpReserved, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData);
LONG WINAPI RegEnumValueW (HKEY hKey, DWORD dwIndex, LPWSTR lpValueName, LPDWORD lpcValueName, LPDWORD lpReserved, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData);
LONG WINAPI RegFlushKey (HKEY hKey);
LONG WINAPI RegLoadKeyA (HKEY hKey, LPCSTR lpSubKey, LPCSTR lpFile);
LONG WINAPI RegLoadKeyW (HKEY hKey, LPCWSTR lpSubKey, LPCWSTR lpFile);
LONG WINAPI RegNotifyChangeKeyValue (HKEY hKey, BOOL bWatchSubtree, DWORD dwNotifyFilter, HANDLE hEvent, BOOL fAsynchronous);
LONG WINAPI RegOpenCurrentUser (REGSAM samDesired, PHKEY phkResult);
LONG WINAPI RegOpenKeyA (HKEY hKey, LPCSTR lpSubKey, PHKEY phkResult);
LONG WINAPI RegOpenKeyExA (HKEY hKey, LPCSTR lpSubKey, DWORD ulOptions, REGSAM samDesired, PHKEY phkResult);
LONG WINAPI RegOpenKeyExW (HKEY hKey, LPCWSTR lpSubKey, DWORD ulOptions, REGSAM samDesired, PHKEY phkResult);
LONG WINAPI RegOpenKeyW (HKEY hKey, LPCWSTR lpSubKey, PHKEY phkResult);
LONG WINAPI RegOpenUserClassesRoot (HANDLE hToken, DWORD dwOptions, REGSAM samDesired, PHKEY phkResult);
LONG WINAPI RegOverridePredefKey (HKEY hKey, HKEY hNewHKey);
LONG WINAPI RegQueryValueA (HKEY hKey, LPCSTR lpSubKey, LPSTR lpValue, PLONG lpcbValue);
LONG WINAPI RegQueryValueExA (HKEY hKey, LPCSTR lpValueName, LPDWORD lpReserved, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData);
LONG WINAPI RegQueryValueExW (HKEY hKey, LPCWSTR lpValueName, LPDWORD lpReserved, LPDWORD lpType, LPBYTE lpData, LPDWORD lpcbData);
LONG WINAPI RegQueryValueW (HKEY hKey, LPCWSTR lpSubKey, LPSTR lpValue, PLONG lpcbValue);
LONG WINAPI RegReplaceKeyA (HKEY hKey, LPCSTR lpSubKey, LPCSTR lpNewFile, LPCSTR lpOldFile);
LONG WINAPI RegReplaceKeyW (HKEY hKey, LPCWSTR lpSubKey, LPCWSTR lpNewFile, LPCWSTR lpOldFile);
LONG WINAPI RegRestoreKeyA (HKEY hKey, LPCSTR lpFile, DWORD dwFlags);
LONG WINAPI RegRestoreKeyW (HKEY hKey, LPCWSTR lpFile, DWORD dwFlags);
LONG WINAPI RegSaveKeyA (HKEY hKey, LPCSTR lpFile, LPSECURITY_ATTRIBUTES lpSecurityAttributes);
LONG WINAPI RegSaveKeyW (HKEY hKey, LPCWSTR lpFile, LPSECURITY_ATTRIBUTES lpSecurityAttributes);
LONG WINAPI RegSetValueA (HKEY hKey, LPCSTR lpSubKey, DWORD dwType, LPCSTR lpData, DWORD cbData);
LONG WINAPI RegSetValueExA (HKEY hKey, LPCSTR lpValueName, DWORD Reserved, DWORD dwType, CONST BYTE *lpData, DWORD cbData);
LONG WINAPI RegSetValueExW (HKEY hKey, LPCWSTR lpValueName, DWORD Reserved, DWORD dwType, CONST BYTE *lpData, DWORD cbData);
LONG WINAPI RegSetValueW (HKEY hKey, LPCWSTR lpSubKey, DWORD dwType, LPCWSTR lpData, DWORD cbData);
LONG WINAPI RegUnLoadKeyA (HKEY hKey, LPCSTR lpSubKey);
LONG WINAPI RegUnLoadKeyW (HKEY hKey, LPCWSTR lpSubKey);


#ifdef UNICODE
# define RegConnectRegistry RegConnectRegistryW
# define RegCreateKey RegCreateKeyW
# define RegCreateKeyEx RegCreateKeyExW
# define RegDeleteKey RegDeleteKeyW
# define RegDeleteValue RegDeleteValueW
# define RegEnumKey RegEnumKeyW
# define RegEnumKeyEx RegEnumKeyExW
# define RegEnumValue RegEnumValueW
# define RegLoadKey RegLoadKeyW
# define RegOpenKey RegOpenKeyW
# define RegOpenKeyEx RegOpenKeyExW
# define RegQueryValue RegQueryValueW
# define RegQueryValueEx RegQueryValueExW
# define RegReplaceKey RegReplaceKeyW
# define RegRestoreKey RegRestoreKeyW
# define RegSaveKey RegSaveKeyW
# define RegSetValue RegSetValueW
# define RegSetValueEx RegSetValueExW
# define RegUnLoadKey RegUnLoadKeyW
#else /* not UNICODE*/
# define RegConnectRegistry RegConnectRegistryA
# define RegCreateKey RegCreateKeyA
# define RegCreateKeyEx RegCreateKeyExA
# define RegDeleteKey RegDeleteKeyA
# define RegDeleteValue RegDeleteValueA
# define RegEnumKey RegEnumKeyA
# define RegEnumKeyEx RegEnumKeyExA
# define RegEnumValue RegEnumValueA
# define RegLoadKey RegLoadKeyA
# define RegOpenKey RegOpenKeyA
# define RegOpenKeyEx RegOpenKeyExA
# define RegQueryValue RegQueryValueA
# define RegQueryValueEx RegQueryValueExA
# define RegReplaceKey RegReplaceKeyA
# define RegRestoreKey RegRestoreKeyA
# define RegSaveKey RegSaveKeyA
# define RegSetValue RegSetValueA
# define RegSetValueEx RegSetValueExA
# define RegUnLoadKey RegUnLoadKeyA
#endif /* not UNICODE */


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __ADVAPI32_H__ */
