/*
    avicore
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#ifndef __ACM_H__
#define __ACM_H__


#include "common.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define ACM_ATTR_NATIVE             0
#define ACM_ATTR_WIN32              1


typedef struct _AcmObject AcmObject;


/******************************************************************************
*                                                                             *
* ja:ACM初期化                                                                *
*                                                                             *
******************************************************************************/
/*  ja:ACMを初期化する
    RET,TRUE:正常終了,FALSE:エラー                                          */
gboolean
acm_init (void);


/*  ja:ACMを終了する
    RET,TRUE:正常終了,FALSE:エラー                                          */
gboolean
acm_exit (void);


/******************************************************************************
*                                                                             *
* ja:ACM基本                                                                  *
*                                                                             *
******************************************************************************/
/*  ja:登録されているタグを取得する
    RET,タグのリスト,NULL:登録なし                                          */
GList *
acm_get_tag_list (void);


/*  ja:Codecを開く
    tag,タグ
    RET,AcmObject,NULL:エラー                                               */
AcmObject *
acm_open (const guint16 tag);


/*  ja:Codecを閉じる
    acm_object,AcmObject
           RET,TRUE:正常終了,FALSE:エラー                                   */
gboolean
acm_close (AcmObject *acm_object);


/*  ja:Codecの参照数を増やす
    acm_object,AcmObject
           RET,TRUE:正常終了,FALSE:エラー                                   */
gboolean
acm_ref (AcmObject *acm_object);


/*  ja:Codecの参照数を減らす
    acm_object,AcmObject
           RET,TRUE:正常終了,FALSE:エラー                                   */
gboolean
acm_unref (AcmObject *acm_object);


/*  ja:Codecをコピーする
    acm_object,AcmObject
           RET,AcmObject,NULL:エラー                                        */
AcmObject *
acm_dup (AcmObject *acm_object);


/******************************************************************************
*                                                                             *
* ja:ACM情報                                                                  *
*                                                                             *
******************************************************************************/
/*  ja:Codecのタグを取得する
    acm_object,AcmObject
           RET,タグ,0:エラー                                                */
guint16
acm_get_tag (AcmObject *acm_object);


/*  ja:Codecの名前を取得する
    acm_object,AcmObject
           RET,名前,NULL:エラー                                             */
const gchar *
acm_get_name (AcmObject *acm_object);


/*  ja:Codecの属性を取得する
    acm_object,AcmObject
           RET,ACM_ATTR_NATIVE,ACM_ATTR_WIN32                               */
gint
acm_get_attribute (AcmObject *acm_object);


/******************************************************************************
*                                                                             *
* ja:ACMダイアログ                                                            *
*                                                                             *
******************************************************************************/
/*  ja:Aboutダイアログのサポートを確認する
    acm_object,AcmObject
           RET,TRUE:有効,FALSE:無効                                         */
gboolean
acm_is_dialog_about (AcmObject *acm_object);


/*  ja:Aboutダイアログを表示する
    acm_object,AcmObject                                                    */
void
acm_dialog_about (AcmObject *acm_object);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __ACM_H__ */
