/*
    avicore
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "avibase.h"
#include "avifileextra.h"


static void avi_file_extra_class_init (AviFileExtraClass *klass);
static void avi_file_extra_init       (AviFileExtra      *fileextra);


static GtkWindowClass *parent_class = NULL;


/******************************************************************************
*                                                                             *
******************************************************************************/
GtkType
avi_file_extra_get_type (void)
{
  static GType file_extra_type = 0;

  if (!file_extra_type)
    {
      const static GTypeInfo fileextra_info =
      {
        sizeof (AviFileExtraClass),
        NULL,               /* base_init */
        NULL,               /* base_finalize */
        (GClassInitFunc)avi_file_extra_class_init,
        NULL,               /* class_finalize */
        NULL,               /* class_data */
        sizeof (AviFileExtra),
        0,                  /* n_preallocs */
        (GInstanceInitFunc)avi_file_extra_init,
      };

      file_extra_type = g_type_register_static (GTK_TYPE_VBOX, "AviFileExtra",
                                                        &fileextra_info, 0);
    }

  return file_extra_type;
}


static void
avi_file_extra_class_init (AviFileExtraClass *class)
{
  GObjectClass *gobject_class;
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;

  gobject_class = (GObjectClass*) class;
  object_class = (GtkObjectClass*) class;
  widget_class = (GtkWidgetClass*) class;

  parent_class = g_type_class_peek_parent (class);
}


static void
avi_file_extra_init (AviFileExtra *fileextra)
{
  fileextra->avi_edit = NULL;
  fileextra->video = 0;
  fileextra->audio = 0;
  fileextra->frame = NULL;
  fileextra->notebook = NULL;
  fileextra->spin0 = NULL;
  fileextra->spin1 = NULL;
  fileextra->radio0 = NULL;
  fileextra->radio1 = NULL;
  fileextra->radio2 = NULL;
  fileextra->radio3 = NULL;
}


/******************************************************************************
*                                                                             *
* ja:ダイアログ関数                                                           *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,ウィジェット                                                        */
GtkWidget *
avi_file_extra_new (void)
{
  return GTK_WIDGET (g_object_new (AVI_TYPE_FILE_EXTRA, NULL));
}


/*  ja:AVI編集ハンドルを取得する
    fileextra,ウィジェット
          RET,AVI編集ハンドル,NULL:設定なし                                 */
/*AviEdit**
avi_file_extra_get_handle (AviFileExtra *fileextra)
{
  return fileextra ? fileextra->avi_edit : NULL;
}*/


/******************************************************************************
*                                                                             *
*                                                                             *
*                                                                             *
******************************************************************************/
struct _AviFileExtraStream
{
  AviEdit *avi_edit;      /* AVI編集構造体 */
  GtkWidget *button, *check, *combo;
  GtkWidget *label0, *label1, *label2, *spin0, *spin1, *spin2;
};
typedef struct _AviFileExtraStream AviFileExtraStream;


/* ja:ラジオボタン(AVI)が押された */
static void
avi_file_extra_toggled_avi (GtkWidget    *widget,
                            AviFileExtra *fileextra)
{
  if (fileextra->frame)
    gtk_widget_set_sensitive (GTK_WIDGET (fileextra->frame), FALSE);
  if (fileextra->notebook)
    {
      gtk_widget_set_sensitive (GTK_WIDGET (fileextra->notebook), TRUE);
      if (GTK_IS_NOTEBOOK (fileextra->notebook))
        {
          gint i;
          GList *glist;

          glist = gtk_container_children (GTK_CONTAINER (fileextra->notebook));
          for (i = g_list_length (glist) - 1; i >= 0; i--)
            gtk_widget_set_sensitive (GTK_WIDGET (g_list_nth_data (glist, i)),
                                                                        TRUE);
          g_list_free (glist);
        }
    }
}


/* ja:ラジオボタン(ビットマップ)が押された */
static void
avi_file_extra_toggled_bitmap (GtkWidget    *widget,
                               AviFileExtra *fileextra)
{
  gtk_widget_set_sensitive (GTK_WIDGET (fileextra->frame), TRUE);
  if (fileextra->video > 1)
    {
      gint i;
      GList *glist;

      gtk_widget_set_sensitive (GTK_WIDGET (fileextra->notebook), TRUE);
      glist = gtk_container_children (GTK_CONTAINER (fileextra->notebook));
      for (i = g_list_length (glist) - 1; i >= 0; i--)
        gtk_widget_set_sensitive (GTK_WIDGET (g_list_nth_data (glist, i)),
                                                                        FALSE);
      g_list_free (glist);
    }
  else if (fileextra->notebook)
    {
      gtk_widget_set_sensitive (GTK_WIDGET (fileextra->notebook), FALSE);
    }
}


/* ja:ラジオボタン(WAVE)が押された */
static void
avi_file_extra_toggled_wave (GtkWidget    *widget,
                             AviFileExtra *fileextra)
{
  if (fileextra->frame)
    gtk_widget_set_sensitive (GTK_WIDGET (fileextra->frame), FALSE);
  if (fileextra->audio > 1)
    {
      gint i;
      GList *glist;

      gtk_widget_set_sensitive (GTK_WIDGET (fileextra->notebook), TRUE);
      glist = gtk_container_children (GTK_CONTAINER (fileextra->notebook));
      for (i = g_list_length (glist) - 1; i >= 0; i--)
        gtk_widget_set_sensitive (GTK_WIDGET (g_list_nth_data (glist, i)),
                                                                        FALSE);
      g_list_free (glist);
    }
  else if (fileextra->notebook)
    {
      gtk_widget_set_sensitive (GTK_WIDGET (fileextra->notebook), FALSE);
    }
}


/* ja:ラジオボタン(シナリオオブジェクト)が押された */
static void
avi_file_extra_toggled_scenario (GtkWidget    *widget,
                                 AviFileExtra *fileextra)
{
  if (fileextra->frame)
    gtk_widget_set_sensitive (GTK_WIDGET (fileextra->frame), FALSE);
  if (fileextra->notebook)
    gtk_widget_set_sensitive (GTK_WIDGET (fileextra->notebook), FALSE);
}


/* ja:ラジオボタン(ビデオストリーム)が押された */
static void
avi_file_extra_toggled_video (GtkWidget    *widget,
                              AviFileExtra *fileextra)
{
  gint max;

  max = GPOINTER_TO_INT (g_object_get_data (G_OBJECT (widget), "user_data"));
  gtk_spin_button_set_range (GTK_SPIN_BUTTON (fileextra->spin0), 0, max);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (fileextra->spin0), 0);
  gtk_spin_button_set_range (GTK_SPIN_BUTTON (fileextra->spin1), 0, max);
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (fileextra->spin1), max);
}


/* ja:コンボボックスの内容が変わったとき */
static void
avi_file_extra_changed (GtkWidget          *widget,
                        AviFileExtraStream *avi_stream)
{
  gint quality, key_frame;
#if GTK_CHECK_VERSION(2,4,0)
  GtkTreeIter iter;
#else /* not GTK_CHECK_VERSION(2,4,0) */
  const gchar *text;
  gint i;
  GList *glist;
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  IcmObject *icm_object = NULL;

#if GTK_CHECK_VERSION(2,4,0)
  if (gtk_combo_box_get_active_iter (GTK_COMBO_BOX (avi_stream->combo), &iter))
    gtk_tree_model_get
        (gtk_combo_box_get_model (GTK_COMBO_BOX (avi_stream->combo)), &iter,
                                                        1, &icm_object, -1);
#else /* not GTK_CHECK_VERSION(2,4,0) */
  text = gtk_entry_get_text (GTK_ENTRY (widget));
  glist = gtk_container_children
                        (GTK_CONTAINER (GTK_COMBO (avi_stream->combo)->list));
  for (i = g_list_length (glist) - 1; i >= 0; i--)
    {
      gchar *label;

      gtk_label_get (GTK_LABEL (gtk_bin_get_child
                            (GTK_BIN (g_list_nth_data (glist, i)))), &label);
      if (g_strcmp (label, text) == 0)
        {
          icm_object = g_object_get_data
                        (G_OBJECT (g_list_nth_data (glist, i)), "user_data");
          break;
        }
    }
  g_list_free (glist);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
  g_object_set_data (G_OBJECT (avi_stream->combo), "user_data", icm_object);

  quality = icm_object ? icm_compress_get_default_quality (icm_object) : -1;
  key_frame = icm_object ? icm_compress_get_default_key_frame (icm_object) : 0;
  /* ja:スピンボタン */
  if (avi_stream->spin0)
    {
      gtk_widget_set_sensitive (GTK_WIDGET (avi_stream->label0), quality >= 0);
      gtk_widget_set_sensitive (GTK_WIDGET (avi_stream->spin0), quality >= 0);
      if (quality >= 0)
        gtk_spin_button_set_value (GTK_SPIN_BUTTON (avi_stream->spin0),
                                                                    quality);
    }
  if (avi_stream->spin1)
    {
      gtk_widget_set_sensitive (GTK_WIDGET (avi_stream->label1),
                                                                key_frame > 0);
      gtk_widget_set_sensitive (GTK_WIDGET (avi_stream->spin1), key_frame > 0);
      if (key_frame > 0)
        gtk_spin_button_set_value (GTK_SPIN_BUTTON (avi_stream->spin1),
                                                                    key_frame);
    }
  if (avi_stream->spin2)
    {
      if (icm_object && (icm_get_flags (icm_object) & ICM_FLAG_CRUNCH) != 0)
        {
          gtk_widget_set_sensitive (GTK_WIDGET (avi_stream->label2), TRUE);
          gtk_widget_set_sensitive (GTK_WIDGET (avi_stream->spin2), TRUE);
        }
      else
        {
          gtk_widget_set_sensitive (GTK_WIDGET (avi_stream->label2), FALSE);
          gtk_widget_set_sensitive (GTK_WIDGET (avi_stream->spin2), FALSE);
        }
    }
  /* ja:チェックボタン */
  if (avi_stream->check)
    gtk_widget_set_sensitive (GTK_WIDGET (avi_stream->check),
                                                        icm_object != NULL);
  /* ja:ボタン */
  if (avi_stream->button)
    gtk_widget_set_sensitive (GTK_WIDGET (avi_stream->button),
                        icm_object && icm_is_dialog_configure (icm_object));
}


/* ja:設定ボタンが押された */
static void
avi_file_extra_clicked_config (GtkWidget *widget,
                               GtkWidget *combo)
{
  icm_dialog_configure (g_object_get_data (G_OBJECT (combo),"user_data"));
}


/* ja:ページの破棄 */
static void
avi_file_extra_destroy_vbox (GtkWidget          *widget,
                             AviFileExtraStream *avi_stream)
{
  g_free (avi_stream);
}


/* ja:コンボボックスの破棄 */
#if GTK_CHECK_VERSION(2,4,0)
static void
avi_file_extra_destroy_combo (GtkWidget *widget,
                              gpointer   user_data)
{
  gint i;
  GtkTreeIter iter;
  GtkTreeModel *model;

  model = gtk_combo_box_get_model (GTK_COMBO_BOX (widget));
  for (i = 0; gtk_tree_model_iter_nth_child (model, &iter, NULL, i); i++)
    {
      IcmObject *icm_object;

      gtk_tree_model_get (model, &iter, 1, &icm_object, -1);
      icm_close (icm_object);
    }
}
#else /* not GTK_CHECK_VERSION(2,4,0) */
static void
avi_file_extra_destroy_list (GtkWidget *widget,
                             gpointer   user_data)
{
  gint i;
  GList *glist;

  glist = gtk_container_children (GTK_CONTAINER (widget));
  for (i = g_list_length (glist) - 1; i >= 0; i--)
    icm_close (g_object_get_data (G_OBJECT (g_list_nth_data (glist, i)),
                                                                "user_data"));
  g_list_free (glist);
}
#endif /* not GTK_CHECK_VERSION(2,4,0) */


/*  ja:AVI編集ハンドルを設定する
     fileextra,ウィジェット
    avi_edit,AVI編集ハンドル,NULL:設定なし                                  */
void
avi_file_extra_set_handle (AviFileExtra  *fileextra,
                           AviEdit      **avi_edit)
{
  gint i, streams, video = 0, audio = 0;
  GList *glist;
  GSList *gslist;           /* ja:ラジオボタン */
  GtkWidget *label0;
  GtkWidget *frame, *hbox0;

  if (!fileextra)
    return;
  glist = gtk_container_get_children (GTK_CONTAINER (fileextra));
  if (glist)
    {
      for (i = g_list_length (glist) - 1; i >= 0; i--)
        gtk_container_remove (GTK_CONTAINER (fileextra),
                                    GTK_WIDGET (g_list_nth_data (glist, i)));
      g_list_free (glist);
    }
  fileextra->avi_edit = avi_edit;
  fileextra->video = 0;
  fileextra->audio = 0;
  fileextra->frame = NULL;
  fileextra->notebook = NULL;
  fileextra->spin0 = NULL;
  fileextra->spin1 = NULL;
  fileextra->radio0 = NULL;
  fileextra->radio1 = NULL;
  fileextra->radio2 = NULL;
  fileextra->radio3 = NULL;
  if (!avi_edit)
    return;
  for (streams = 0; avi_edit[streams]; streams++)
    switch (avi_type (avi_edit [streams]))
      {
        case AVI_TYPE_VIDEO: video++; break;
        case AVI_TYPE_AUDIO: audio++; break;
        default: return;
      }
  if (streams <= 0)
    return;
  fileextra->video = video;
  fileextra->audio = audio;
  /* en:AVI */
  if (fileextra->video > 0 || fileextra->audio > 1)
    {
      gint length;
      GList *glist_handler;     /* ja:登録されている4文字コード */
      GSList *gslist_v = NULL;  /* ja:ラジオボタン */
      GSList *gslist_a = NULL;  /* ja:ラジオボタン */

      /* ja:ラジオボタン */
      fileextra->radio0 = gtk_radio_button_new_with_mnemonic (NULL, _("_AVI"));
      g_signal_connect (G_OBJECT (fileextra->radio0), "toggled",
                        G_CALLBACK (avi_file_extra_toggled_avi), fileextra);
      gslist = gtk_radio_button_group (GTK_RADIO_BUTTON (fileextra->radio0));
      if (streams > 1)
        {
          /* ja:ノートブック */
          fileextra->notebook = gtk_notebook_new ();
          gtk_notebook_set_scrollable (GTK_NOTEBOOK (fileextra->notebook),
                                                                        TRUE);
        }
      else
        {
          /* ja:フレーム */
          fileextra->notebook = gtk_frame_new ("");
        }
      video = audio = 0;
      glist_handler = icm_get_handler_list ();
      length = g_list_length (glist_handler);
      for (i = 0; i < streams; i++)
        {
          gchar *text;
          GtkWidget *vbox;
          AviFileExtraStream *avi_stream;

          avi_stream = g_malloc0 (sizeof (AviFileExtraStream));
          avi_stream->avi_edit = avi_edit[i];
          vbox = gtk_vbox_new (FALSE, SPACING);
          gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
          g_object_set_data (G_OBJECT (vbox), "user_data", avi_stream);
          g_signal_connect (G_OBJECT (vbox), "destroy",
                        G_CALLBACK (avi_file_extra_destroy_vbox), avi_stream);
          if (avi_type (avi_edit[i]) == AVI_TYPE_VIDEO)
            {
              gint j;
              GList *glist_object;      /* ja:IcmObjectのリスト */
              GList *glist_name;        /* ja:名前のリスト */

              /* ja:未圧縮 */
              glist_object = g_list_append (NULL, NULL);
              glist_name = g_list_append (NULL, g_strdup (_("Uncompress")));
              /* ja:各4文字コードについて */
              for (j = 0; j < length; j++)
                {
                  IcmObject *icm_object;

                  icm_object = icm_open
                                ((guint32)g_list_nth_data (glist_handler, j),
                                ICM_MODE_COMPRESS);
                  if (!icm_object)
                    continue;
                  if (!icm_compress_query (icm_object, avi_edit[i]->bmih))
                    {
                      icm_close (icm_object);
                      continue;
                    }
                  /* ja:スピンボタン */
                  if (!avi_stream->spin0
                        && icm_compress_get_default_quality (icm_object) >= 0)
                        avi_stream->spin0 = gtk_spin_button_new (GTK_ADJUSTMENT
                                (gtk_adjustment_new (-1, -1, 10000, 1, 5, 0)),
                                 0, 0);
                  if (!avi_stream->spin1
                        && icm_compress_get_default_key_frame (icm_object) > 0)
                        avi_stream->spin1 = gtk_spin_button_new (GTK_ADJUSTMENT
                                (gtk_adjustment_new (0, 0, G_MAXINT, 1, 5, 0)),
                                 0, 0);
                  if (!avi_stream->spin2
                        && (icm_get_flags (icm_object) & ICM_FLAG_CRUNCH) != 0)
                        avi_stream->spin2 = gtk_spin_button_new (GTK_ADJUSTMENT
                                (gtk_adjustment_new (0, 0, G_MAXINT, 1, 5, 0)),
                                 0, 0);
                  /* ja:ボタン */
                  if (!avi_stream->button
                                    && icm_is_dialog_configure (icm_object))
                      avi_stream->button = gtk_button_new_with_mnemonic
                                                        (_("Con_figure..."));
                  glist_object = g_list_append (glist_object, icm_object);
                  glist_name = g_list_append (glist_name,
                                        (gpointer)icm_get_name (icm_object));
                }
              if (g_list_length (glist_name) > 1)
                {
#if GTK_CHECK_VERSION(2,4,0)
                  GtkListStore *store;
                  GtkCellRenderer *renderer;
#endif /* GTK_CHECK_VERSION(2,4,0) */

                  /* ja:チェックボタン */
                  avi_stream->check = gtk_check_button_new_with_mnemonic
                                                            (_("_Recompress"));
                  gtk_toggle_button_set_active
                                (GTK_TOGGLE_BUTTON (avi_stream->check), FALSE);
                  gtk_widget_set_sensitive (avi_stream->check, FALSE);
                  /* ja:コンボボックス */
#if GTK_CHECK_VERSION(2,4,0)
                  store = gtk_list_store_new (2,
                                                G_TYPE_STRING, G_TYPE_POINTER);
                  for (j = g_list_length (glist_name) - 1; j >= 0; j--)
                    {
                      GtkTreeIter iter;

                      gtk_list_store_prepend (store, &iter);
                      gtk_list_store_set (store, &iter,
                                    0, g_list_nth_data (glist_name, j),
                                    1, g_list_nth_data (glist_object, j), -1);
                    }
                  avi_stream->combo = gtk_combo_box_new_with_model
                                                    (GTK_TREE_MODEL (store));
                  g_object_unref (store);
                  renderer = gtk_cell_renderer_text_new ();
                  gtk_cell_layout_pack_start
                        (GTK_CELL_LAYOUT (avi_stream->combo), renderer, TRUE);
                  gtk_cell_layout_set_attributes
                                (GTK_CELL_LAYOUT (avi_stream->combo), renderer,
                                                            "text", 0, NULL);
                  gtk_combo_box_set_active (GTK_COMBO_BOX (avi_stream->combo),
                                                                            0);
                  g_signal_connect (G_OBJECT (avi_stream->combo), "changed",
                            G_CALLBACK (avi_file_extra_changed), avi_stream);
                  g_signal_connect (G_OBJECT (avi_stream->combo), "destroy",
                            G_CALLBACK (avi_file_extra_destroy_combo), NULL);
#else /* not GTK_CHECK_VERSION(2,4,0) */
                  avi_stream->combo = gtk_combo_new ();
                  gtk_combo_set_popdown_strings (GTK_COMBO (avi_stream->combo),
                                                                glist_name);
                  glist = gtk_container_children
                        (GTK_CONTAINER (GTK_COMBO (avi_stream->combo)->list));
                  for (j = g_list_length (glist) - 1; j >= 0; j--)
                    g_object_set_data (G_OBJECT (g_list_nth_data (glist, j)),
                                       "user_data",
                                       g_list_nth_data (glist_object, j));
                  gtk_combo_set_value_in_list (GTK_COMBO (avi_stream->combo),
                                                                TRUE, FALSE);
                  gtk_editable_set_editable (GTK_EDITABLE (GTK_COMBO
                                        (avi_stream->combo)->entry), FALSE);
                  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO
                            (avi_stream->combo)->entry),
                            (const gchar *)g_list_nth_data (glist_name, 0));
                  g_signal_connect (G_OBJECT (GTK_COMBO
                        (avi_stream->combo)->entry), "changed",
                        G_CALLBACK (avi_file_extra_changed), avi_stream);
                  g_signal_connect (G_OBJECT (GTK_COMBO
                        (avi_stream->combo)->list), "destroy",
                        G_CALLBACK (avi_file_extra_destroy_list), NULL);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
                  /* ja:ラベル */
                  label0 = gtk_label_new_with_mnemonic (_("_Compressor"));
#if GTK_CHECK_VERSION(2,4,0)
                  gtk_label_set_mnemonic_widget (GTK_LABEL (label0),
                                                            avi_stream->combo);
#else /* not GTK_CHECK_VERSION(2,4,0) */
                  gtk_label_set_mnemonic_widget (GTK_LABEL (label0),
                                        GTK_COMBO (avi_stream->combo)->entry);
#endif /* not GTK_CHECK_VERSION(2,4,0) */
                }
              else
                {
                  label0 = gtk_label_new ((const gchar *)
                                              g_list_nth_data (glist_name, 0));
                }
              g_list_free (glist_object);
              g_list_free (glist_name);
              if (avi_stream->spin0)
                {
                  gtk_spin_button_set_numeric
                                (GTK_SPIN_BUTTON (avi_stream->spin0), TRUE);
/*                g_signal_connect (G_OBJECT (avi_stream->spin0), "activate",
                            G_CALLBACK (avi_file_extra_activate), fileextra);
*/                avi_stream->label0 = gtk_label_new_with_mnemonic
                                                            (_("_Quality"));
                  gtk_label_set_mnemonic_widget
                        (GTK_LABEL (avi_stream->label0), avi_stream->spin0);
                  gtk_widget_set_sensitive (avi_stream->spin0, FALSE);
                  gtk_widget_set_sensitive (avi_stream->label0, FALSE);
                }
              if (avi_stream->spin1)
                {
                  gtk_spin_button_set_numeric
                                    (GTK_SPIN_BUTTON(avi_stream->spin1), TRUE);
/*                g_signal_connect (G_OBJECT (avi_stream->spin1), "activate",
                            G_CALLBACK (avi_file_extra_activate), fileextra);
*/                avi_stream->label1 = gtk_label_new_with_mnemonic
                                                            (_("_Key Frame"));
                  gtk_label_set_mnemonic_widget
                        (GTK_LABEL (avi_stream->label1), avi_stream->spin1);
                  gtk_widget_set_sensitive (avi_stream->spin1, FALSE);
                  gtk_widget_set_sensitive (avi_stream->label1, FALSE);
                }
              if (avi_stream->spin2)
                {
                  gtk_spin_button_set_numeric
                                    (GTK_SPIN_BUTTON(avi_stream->spin2), TRUE);
/*                g_signal_connect (G_OBJECT (avi_stream->spin2), "activate",
                            G_CALLBACK (avi_file_extra_activate), fileextra);
*/                avi_stream->label2 = gtk_label_new_with_mnemonic
                                                            (_("_Data Rate"));
                  gtk_label_set_mnemonic_widget
                        (GTK_LABEL (avi_stream->label2), avi_stream->spin2);
                  gtk_widget_set_sensitive (avi_stream->spin2, FALSE);
                  gtk_widget_set_sensitive (avi_stream->label2, FALSE);
                }
              if (avi_stream->button)
                {
                  g_signal_connect (G_OBJECT (avi_stream->button), "clicked",
                                    G_CALLBACK (avi_file_extra_clicked_config),
                                                            avi_stream->combo);
                  GTK_WIDGET_SET_FLAGS (avi_stream->button, GTK_CAN_DEFAULT);
                  gtk_widget_set_sensitive (avi_stream->button, FALSE);
                }
              /* ja:フレームとボックス */
              if (avi_stream->combo)
                {
                  hbox0 = gtk_hbox_new (FALSE, 0);
                  gtk_box_pack_start (GTK_BOX (hbox0),
                                            label0, FALSE, FALSE, 0);
                  gtk_box_pack_start (GTK_BOX (hbox0),
                                            avi_stream->combo, TRUE, TRUE, 0);
                  gtk_box_pack_start (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
                }
              else
                {
                  gtk_box_pack_start (GTK_BOX (vbox), label0, FALSE, FALSE, 0);
                }
              if (avi_stream->spin0)
                {
                  hbox0 = gtk_hbox_new (FALSE, 0);
                  gtk_box_pack_start (GTK_BOX (hbox0),
                                        avi_stream->label0, FALSE, FALSE, 0);
                  gtk_box_pack_start (GTK_BOX (hbox0),
                                        avi_stream->spin0, TRUE, TRUE, 0);
                  gtk_box_pack_start (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
                }
              if (avi_stream->spin1)
                {
                  hbox0 = gtk_hbox_new (FALSE, 0);
                  gtk_box_pack_start (GTK_BOX (hbox0),
                                        avi_stream->label1, FALSE, FALSE, 0);
                  gtk_box_pack_start (GTK_BOX (hbox0),
                                        avi_stream->spin1, TRUE, TRUE, 0);
                  gtk_box_pack_start (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
                }
              if (avi_stream->spin2)
                {
                  hbox0 = gtk_hbox_new (FALSE, 0);
                  gtk_box_pack_start (GTK_BOX (hbox0),
                                        avi_stream->label2, FALSE, FALSE, 0);
                  gtk_box_pack_start (GTK_BOX (hbox0),
                                        avi_stream->spin2, TRUE, TRUE, 0);
                  gtk_box_pack_start (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
                }
              if (avi_stream->check || avi_stream->button)
                {
                  hbox0 = gtk_hbox_new (FALSE, SPACING);
                  if (avi_stream->check)
                    gtk_box_pack_start (GTK_BOX (hbox0),
                                        avi_stream->check, TRUE, TRUE, 0);
                  if (avi_stream->button)
                    gtk_box_pack_end (GTK_BOX (hbox0),
                                        avi_stream->button, FALSE, FALSE, 0);
                  gtk_box_pack_end (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
                }
              video++;
            }
          else
            {
              gtk_box_pack_start (GTK_BOX (vbox),
                                    gtk_label_new (_("PCM")), FALSE, FALSE, 0);
              audio++;
            }
          text = avi_get_name (avi_edit[i])
                                ? g_strdup (avi_get_name (avi_edit[i]))
                                : avi_type (avi_edit[i]) == AVI_TYPE_VIDEO
                                        ? g_strdup_printf ("Video #%d", video)
                                        : g_strdup_printf ("Audio #%d", audio);
          if (GTK_IS_NOTEBOOK (fileextra->notebook))
            {
              GtkWidget *radio;

              if (avi_type (avi_edit[i]) == AVI_TYPE_VIDEO
                                                    && fileextra->video > 1)
                {
                  radio = gtk_radio_button_new_with_label (gslist_v, text);
                  g_object_set_data (G_OBJECT (radio), "user_data",
                            GINT_TO_POINTER (avi_length (avi_edit[i]) - 1));
                  g_signal_connect (G_OBJECT (radio), "toggled",
                                    G_CALLBACK (avi_file_extra_toggled_video),
                                    fileextra);
                  gslist_v = gtk_radio_button_group (GTK_RADIO_BUTTON (radio));
                }
              else if (avi_type (avi_edit[i]) == AVI_TYPE_AUDIO
                                                    && fileextra->audio > 1)
                {
                  radio = gtk_radio_button_new_with_label (gslist_a, text);
                  gslist_a = gtk_radio_button_group (GTK_RADIO_BUTTON (radio));
                }
              else
                {
                  radio = NULL;
                }
              gtk_notebook_append_page (GTK_NOTEBOOK (fileextra->notebook),
                                vbox, radio ? radio : gtk_label_new (text));
            }
          else
            {
              gtk_container_add (GTK_CONTAINER (fileextra->notebook), vbox);
              gtk_frame_set_label (GTK_FRAME (fileextra->notebook), text);
            }
          g_free (text);
        }
    }
  else
    {
      gslist = NULL;
    }
  /* ja:ビットマップ */
  if (fileextra->video > 0)
    {
      GtkWidget *label1, *hbox1;

      /* ja:ラジオボタン */
      fileextra->radio1 = gtk_radio_button_new_with_mnemonic
                                                        (gslist, _("_Bitmap"));
      g_signal_connect (G_OBJECT (fileextra->radio1), "toggled",
                    G_CALLBACK (avi_file_extra_toggled_bitmap), fileextra);
      gslist = gtk_radio_button_group (GTK_RADIO_BUTTON (fileextra->radio1));
      /* ja:スピンボタン */
      for (i = 0; i < streams; i++)
        if (avi_type (avi_edit[i]) == AVI_TYPE_VIDEO)
          break;
      fileextra->spin0 = gtk_spin_button_new (GTK_ADJUSTMENT
            (gtk_adjustment_new (0, 0, avi_length (avi_edit[i]) - 1, 1, 5, 0)),
             0, 0);
      fileextra->spin1 = gtk_spin_button_new (GTK_ADJUSTMENT
            (gtk_adjustment_new (avi_length (avi_edit[i]) - 1,
                                    0, avi_length (avi_edit[i]) - 1, 1, 5, 0)),
             0, 0);
      gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (fileextra->spin0), TRUE);
      gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (fileextra->spin1), TRUE);
/*    g_signal_connect (G_OBJECT (fileextra->spin0), "activate",
                            G_CALLBACK (avi_file_extra_activate), fileextra);
      g_signal_connect (G_OBJECT (fileextra->spin1), "activate",
                            G_CALLBACK (avi_file_extra_activate), fileextra);
*/    /* ja:ラベル */
      label0 = gtk_label_new_with_mnemonic (_("_Start"));
      gtk_label_set_mnemonic_widget (GTK_LABEL (label0), fileextra->spin0);
      label1 = gtk_label_new_with_mnemonic (_("_End"));
      gtk_label_set_mnemonic_widget (GTK_LABEL (label1), fileextra->spin1);
      /* ja:フレームとボックス */
      hbox0 = gtk_hbox_new (FALSE, SPACING);
      gtk_container_set_border_width (GTK_CONTAINER (hbox0), SPACING);
      hbox1 = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox1), label0, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox1), fileextra->spin0, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (hbox0), hbox1, FALSE, FALSE, 0);
      hbox1 = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox1), label1, FALSE, FALSE, 0);
      gtk_box_pack_start (GTK_BOX (hbox1), fileextra->spin1, TRUE, TRUE, 0);
      gtk_box_pack_start (GTK_BOX (hbox0), hbox1, FALSE, FALSE, 0);
      fileextra->frame = gtk_frame_new (_("Range"));
      gtk_container_add (GTK_CONTAINER (fileextra->frame), hbox0);
      gtk_widget_set_sensitive (fileextra->frame, FALSE);
    }
  /* en:WAVE */
  if (fileextra->audio > 0)
    {
      /* ja:ラジオボタン */
      fileextra->radio2 = gtk_radio_button_new_with_mnemonic
                                                        (gslist, _("_WAVE"));
      g_signal_connect (G_OBJECT (fileextra->radio2), "toggled",
                        G_CALLBACK (avi_file_extra_toggled_wave), fileextra);
      gslist = gtk_radio_button_group (GTK_RADIO_BUTTON (fileextra->radio2));
    }
  /* ja:シナリオオブジェクト */
  /* ja:ラジオボタン */
  fileextra->radio3 = gtk_radio_button_new_with_mnemonic
                                            (gslist, _("Scenario _Object"));
  g_signal_connect (G_OBJECT (fileextra->radio3), "toggled",
                    G_CALLBACK (avi_file_extra_toggled_scenario), fileextra);

  /* ja:フレームとボックス */
  hbox0 = gtk_hbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (hbox0), SPACING);
  if (fileextra->radio0)
    gtk_box_pack_start (GTK_BOX (hbox0), fileextra->radio0, FALSE, FALSE, 0);
  if (fileextra->radio1)
    gtk_box_pack_start (GTK_BOX (hbox0), fileextra->radio1, FALSE, FALSE, 0);
  if (fileextra->radio2)
    gtk_box_pack_start (GTK_BOX (hbox0), fileextra->radio2, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox0), fileextra->radio3, FALSE, FALSE, 0);
  frame = gtk_frame_new (_("Format"));
  gtk_container_add (GTK_CONTAINER (frame), hbox0);

  gtk_box_pack_start (GTK_BOX (fileextra), frame, FALSE, FALSE, 0);
  gtk_widget_show_all (frame);
  if (fileextra->frame)
    {
      gtk_box_pack_start (GTK_BOX (fileextra),
                                            fileextra->frame, FALSE, FALSE, 0);
      gtk_widget_show_all (fileextra->frame);
    }
  if (fileextra->notebook)
    {
      gtk_box_pack_start (GTK_BOX (fileextra),
                                        fileextra->notebook, FALSE, FALSE, 0);
      gtk_widget_show_all (fileextra->notebook);
    }
}


/*  ja:保存用のオプションを取得する
    fileextra,ウィジェット
        RET,オプション,NULL:エラー                                          */
AviSave *
avi_file_extra_get_option (AviFileExtra *fileextra)
{
  gint i, streams;
  GList *glist;
  GtkWidget *child, *radio;
  AviFileExtraStream *avi_stream;
  AviSave *avi_save;

  if (!fileextra)
    return NULL;
  avi_save = g_malloc0 (sizeof (AviSave));
  if (fileextra->radio0
    && gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (fileextra->radio0)))
    {
      avi_save->type = AVI_FILE_AVI;
      if (GTK_IS_NOTEBOOK (fileextra->notebook))
        {
          glist = gtk_container_children (GTK_CONTAINER (fileextra->notebook));
          streams = g_list_length (glist);
          g_list_free (glist);
        }
      else
        {
          streams = 1;
        }
      avi_save->avi_opt = g_malloc0 ((streams + 1) * sizeof (AviOptions));
      for (i = 0; i < streams; i++)
        {
          IcmObject *icm_object;

          if (GTK_IS_NOTEBOOK (fileextra->notebook))
            {
              child = gtk_notebook_get_nth_page
                                    (GTK_NOTEBOOK (fileextra->notebook), i);
            }
          else
            {
              child = gtk_bin_get_child (GTK_BIN (fileextra->notebook));
            }
          avi_stream = g_object_get_data (G_OBJECT (child), "user_data");
          avi_save->avi_opt[i].type = avi_type (avi_stream->avi_edit);
          if (avi_stream->combo && (icm_object = g_object_get_data
                                (G_OBJECT (avi_stream->combo), "user_data")))
            {
              avi_save->avi_opt[i].handler = icm_get_handler (icm_object);
              avi_save->avi_opt[i].quality = avi_stream->spin0
                                && GTK_WIDGET_IS_SENSITIVE (avi_stream->spin0)
                                    ? gtk_spin_button_get_value_as_int
                                    (GTK_SPIN_BUTTON (avi_stream->spin0)) : -1;
              avi_save->avi_opt[i].key_frame = avi_stream->spin1
                                && GTK_WIDGET_IS_SENSITIVE (avi_stream->spin1)
                                    ? gtk_spin_button_get_value_as_int
                                    (GTK_SPIN_BUTTON (avi_stream->spin1)) : 0;
              avi_save->avi_opt[i].data_rate = avi_stream->spin2
                                && GTK_WIDGET_IS_SENSITIVE (avi_stream->spin2)
                                    ? gtk_spin_button_get_value_as_int
                                    (GTK_SPIN_BUTTON (avi_stream->spin2)) : 0;
              avi_save->avi_opt[i].recompress = avi_stream->check
                                && GTK_WIDGET_IS_SENSITIVE (avi_stream->check)
                                && gtk_toggle_button_get_active
                                    (GTK_TOGGLE_BUTTON (avi_stream->check));
              avi_save->avi_opt[i].param_size
                                            = icm_get_state_size (icm_object);
              if (avi_save->avi_opt[i].param_size > 0)
                {
                  avi_save->avi_opt[i].param
                                = g_malloc (avi_save->avi_opt[i].param_size);
                  icm_get_state (icm_object, avi_save->avi_opt[i].param,
                                            avi_save->avi_opt[i].param_size);
                }
              avi_save->avi_opt[i].bmih_size = icm_compress_get_format_size
                                    (icm_object, avi_stream->avi_edit->bmih);
              avi_save->avi_opt[i].bmih
                                = g_malloc (avi_save->avi_opt[i].bmih_size);
              if (!icm_compress_get_format (icm_object,
                    avi_stream->avi_edit->bmih, avi_save->avi_opt[i].bmih))
                {
                  g_free (avi_save->avi_opt[i].bmih);
                  avi_save->avi_opt[i].bmih = NULL;
                  avi_save->avi_opt[i].bmih_size = 0;
                }
            }
        }
    }
  else if (fileextra->radio1
    && gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (fileextra->radio1)))
    {
      avi_save->type = AVI_FILE_BITMAP;
      avi_save->start = gtk_spin_button_get_value_as_int
                                        (GTK_SPIN_BUTTON (fileextra->spin0));
      avi_save->end = gtk_spin_button_get_value_as_int
                                        (GTK_SPIN_BUTTON (fileextra->spin1));
      if (avi_save->start > avi_save->end)
        {
          gint value;

          value = avi_save->start;
          avi_save->start = avi_save->end;
          avi_save->end = value;
        }
      if (GTK_IS_NOTEBOOK (fileextra->notebook))
        {
          glist = gtk_container_children (GTK_CONTAINER (fileextra->notebook));
          streams = g_list_length (glist);
          g_list_free (glist);
          for (i = 0; i < streams; i++)
            {
              child = gtk_notebook_get_nth_page
                                (GTK_NOTEBOOK (fileextra->notebook), i);
              radio = gtk_notebook_get_tab_label
                                (GTK_NOTEBOOK (fileextra->notebook), child);
              avi_stream = g_object_get_data (G_OBJECT (child), "user_data");
              if (avi_type (avi_stream->avi_edit) == AVI_TYPE_VIDEO
                && (!GTK_IS_RADIO_BUTTON (radio)
                || gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radio))))
                break;
            }
          avi_save->stream = i;
        }
    }
  else if (fileextra->radio2
    && gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (fileextra->radio2)))
    {
      avi_save->type = AVI_FILE_WAVE;
      if (GTK_IS_NOTEBOOK (fileextra->notebook))
        {
          glist = gtk_container_children (GTK_CONTAINER (fileextra->notebook));
          streams = g_list_length (glist);
          g_list_free (glist);
          for (i = 0; i < streams; i++)
            {
              child = gtk_notebook_get_nth_page
                                (GTK_NOTEBOOK (fileextra->notebook), i);
              radio = gtk_notebook_get_tab_label
                                (GTK_NOTEBOOK (fileextra->notebook), child);
              avi_stream = g_object_get_data (G_OBJECT (child), "user_data");
              if (avi_type (avi_stream->avi_edit) == AVI_TYPE_AUDIO
                && (!GTK_IS_RADIO_BUTTON (radio)
                || gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radio))))
                break;
            }
          avi_save->stream = i;
        }
    }
  else if (fileextra->radio3
    && gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (fileextra->radio3)))
    {
      avi_save->type = AVI_FILE_SCENARIO;
    }
  else
    {
      g_free (avi_save);
      avi_save = NULL;
    }
  return avi_save;
}
