/*
    Video maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "version.h"
#include "misc/license.h"
#include <gdk/gdkkeysyms.h>


/******************************************************************************
*                                                                             *
* ja:バージョン情報関数群                                                     *
*                                                                             *
******************************************************************************/
/* ja:ツリービュー変更 */
static void
version_dialog_changed (GtkTreeSelection *select,
                        GtkWidget        *button)
{
  GtkTreeIter iter;
  GtkTreeModel *model;
  GtkTreeView *tview;
  IcmObject *icm_object = NULL;

  if (gtk_tree_selection_get_selected (select, &model, &iter))
    gtk_tree_model_get (model, &iter, 3, &icm_object, -1);
  tview = gtk_tree_selection_get_tree_view (select);
  g_object_set_data (G_OBJECT (tview), "user_data", icm_object);
  gtk_widget_set_sensitive (button, icm_object != NULL);
}


/* ja:ツリービュー破棄 */
static void
version_dialog_row_deleted (GtkTreeModel *model,
                            GtkTreePath  *path,
                            gpointer      user_data)
{
  GtkTreeIter iter;
  IcmObject *icm_object;

  gtk_tree_model_get_iter (model, &iter, path);
  gtk_tree_model_get (model, &iter, 3, &icm_object, -1);
  if (icm_object)
    icm_close (icm_object);
}


/* ja:Aboutボタンが押された */
static void
version_dialog_clicked (GtkWidget *widget,
                        GtkWidget *ctree)
{
  icm_dialog_about (g_object_get_data (G_OBJECT (ctree), "user_data"));
}


/* ja:ESCが押された */
static gboolean
version_dialog_key_press (GtkWidget   *widget,
                          GdkEventKey *event,
                          gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_widget_destroy(widget);
  return FALSE;
}


void
version_dialog (void)
{
  gchar *str[3];
  gint i,length;
  GList *glist;
  GdkPixbuf *pixbuf;
  GtkTextBuffer *buffer;
  GtkTextIter where;
  GtkTreeIter iter,iter_parent;
  GtkTreeSelection *select;
  GtkTreeStore *store;
  GtkTreeViewColumn *column;
  GtkWidget *button, *notebook, *text, *tview;
  GtkWidget *dialog, *scroll, *hbox0, *hbox1, *vbox;
  IcmObject *icm_object;
  IcmInfo icm_info;
const static gchar *authors =
"Main Program :\n"
"    Kazuki IWAMOTO\n"
"Document :\n"
"\n"
"Logo :\n"
"\n"
"Translate :\n"
"\n"
"dllloader :\n"
"    Hiroshi Takekawa\n"
"Packager :\n"
"    yasuo-s\n"
"Special Thanks :\n"
"    midori\n"
"    MINAMI Hirokazu\n"
"    Takuro Ashie\n"
"    ryoma\n"
"    And all Video maid users";
/* XPM */
static const gchar *vmaid_xpm[] = {
"32 32 16 1",
"   c None",
".  c #000000",
"+  c #800000",
"@  c #008000",
"#  c #808000",
"$  c #000080",
"%  c #800080",
"&  c #008080",
"*  c #808080",
"=  c #C0C0C0",
"-  c #FF0000",
";  c #00FF00",
">  c #FFFF00",
",  c #0000FF",
"'  c #FF00FF",
")  c #00FFFF",
"                                ",
"                                ",
"++++++++++++++++++++++++++++++++",
" ++   ++   ++   ++   ++   ++   +",
" ++   ++   ++   ++   ++   ++   +",
" ++   ++   ++   ++   ++   ++   +",
"++++++++++++++++++++++++++++++++",
". . + . . . . . . . . . . .+. . ",
" . .+. . . . . ' . . . . . + . .",
". . + . . . . ''  . . . . .+. . ",
" . .+. . . . ''' . . . . . + . .",
". . + . . .  '''      . . .+. . ",
" . .+. . -  '''',,,,,, . . + . .",
". . + .  ---'''',,,,, . . .+. . ",
" . .+. .  ----'',,,) . . . + . .",
". . + . . -----',)))  . . .+. . ",
" . .+. . . --->;)))))  . . + . .",
". . + . .  ->>>;;)))) . . .+. . ",
" . .+. .  >>>>>;;;;))) . . + . .",
". . + .  >>>>>>;;;;  )  . .+. . ",
" . .+. .       ;;; .   . . + . .",
". . + . . . .  ;;;  . . . .+. . ",
" . .+. . . . . ;;  . . . . + . .",
". . + . . . .  ;  . . . . .+. . ",
" . .+. . . . .   . . . . . + . .",
"++++++++++++++++++++++++++++++++",
" ++   ++   ++   ++   ++   ++   +",
" ++   ++   ++   ++   ++   ++   +",
" ++   ++   ++   ++   ++   ++   +",
"++++++++++++++++++++++++++++++++",
"                                ",
"                                "};

  /* ja:メインウインドウ */
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (dialog), _("About Video maid"));
  gtk_window_set_default_size (GTK_WINDOW (dialog),
                    gdk_screen_width () * 2 / 3, gdk_screen_height () * 2 / 3);
  g_signal_connect (G_OBJECT (dialog), "key-press-event",
                                G_CALLBACK (version_dialog_key_press), NULL);
  g_signal_connect (G_OBJECT (dialog), "destroy", gtk_main_quit, NULL);
  /* ja:ノートブック */
  notebook = gtk_notebook_new ();
  gtk_notebook_set_scrollable (GTK_NOTEBOOK (notebook), TRUE);
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), n_pos);

  /* ja:ライセンス */
  /* ja:テキスト */
  text = gtk_text_view_new ();
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text));
  gtk_text_buffer_set_text (buffer, gnu_gpl, -1);
  gtk_text_buffer_get_start_iter (buffer, &where);
  gtk_text_buffer_place_cursor (buffer, &where);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (text), FALSE);
  /* ja:スクロールウインドウ */
  scroll = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (scroll), text);
  /* ja:ノートブック */
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), scroll,
                                                gtk_label_new (_("License")));

  /* ja:作者 */
  /* ja:テキスト */
  text = gtk_text_view_new ();
  buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW (text));
  gtk_text_buffer_set_text (buffer, authors, -1);
  gtk_text_buffer_get_start_iter (buffer, &where);
  gtk_text_buffer_place_cursor (buffer, &where);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (text), FALSE);
  /* ja:スクロールウインドウ */
  scroll = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (scroll), text);
  /* ja:ノートブック */
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), scroll,
                                                gtk_label_new (_("Authors")));

  /* ja:プラグイン */
  /* ja:ボタン */
  button = gtk_button_new_with_mnemonic (_("_About..."));
  /* ja:ツリービュー */
  store = gtk_tree_store_new (4, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING,
                                                            G_TYPE_POINTER);
  gtk_tree_store_append (store, &iter_parent, NULL);
  gtk_tree_store_set (store, &iter_parent,  0, _("Video Compressor"),
                                            1, NULL,
                                            2, NULL,
                                            3, NULL,
                                            -1);
  glist = icm_get_handler_list ();
  if (glist)
    {
      length = g_list_length (glist);
      for (i = 0; i < length; i++)
        {
          icm_object = icm_open ((guint32)g_list_nth_data (glist, i),
                                                            ICM_MODE_QUERY);
          if (icm_object)
            {
              if (icm_get_info (icm_object, &icm_info))
                {
                  str[1] = icm_handler_to_string (icm_info.handler);
                  switch (icm_info.attribute)
                    {
                      case ICM_ATTR_NATIVE:
                        str[2] = _("Video maid Native");
                        break;
                      case ICM_ATTR_WIN32:
#ifdef G_OS_WIN32
                        str[2] = _("Win32 Native");
#else /* not G_OS_WIN32 */
                        str[2] = _("Win32 Emulation");
#endif /* not G_OS_WIN32 */
                        break;
                      default:
                        str[2] = _("Unknown");
                    }
                  gtk_tree_store_append (store, &iter, &iter_parent);
                  gtk_tree_store_set (store, &iter, 0, icm_info.name,
                                                    1, str[1],
                                                    2, str[2],
                                                    3, NULL,
                                                    -1);
                  g_free (str[1]);
                  g_free (icm_info.name);
                  if (icm_is_dialog_about (icm_object))
                    gtk_tree_store_set (store, &iter, 3, icm_object, -1);
                  else
                    icm_close (icm_object);
                }
              else
                {
                  icm_close (icm_object);
                }
            }
        }
      g_list_free (glist);
    }
  tview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
  gtk_tree_view_set_enable_search (GTK_TREE_VIEW (tview), FALSE);
  str[0] = _("Name");
  str[1] = _("Code");
  str[2] = _("Attribute");
  for (i = 0; i < 3; i++)
    {
      column = gtk_tree_view_column_new_with_attributes (str[i],
                            gtk_cell_renderer_text_new (), "text", i, NULL);
      gtk_tree_view_column_set_resizable (column, TRUE);
      gtk_tree_view_append_column (GTK_TREE_VIEW (tview), column);
    }
  select = gtk_tree_view_get_selection (GTK_TREE_VIEW (tview));
  gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
  g_signal_connect (G_OBJECT (select), "changed",
                                G_CALLBACK (version_dialog_changed), button);
  g_signal_connect (G_OBJECT (store), "row-deleted",
                                G_CALLBACK (version_dialog_row_deleted), NULL);
  g_object_unref (G_OBJECT (store));
  /* ja:スクロールウインドウ */
  scroll = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_container_add (GTK_CONTAINER (scroll), tview);
  /* ja:ボタン */
  g_signal_connect (G_OBJECT (button), "clicked",
                                G_CALLBACK (version_dialog_clicked), tview);
  gtk_widget_set_sensitive (button, FALSE);
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
  /* ja:フレームとボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), scroll, TRUE, TRUE, 0);
  hbox0 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox0), button, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
  /* ja:ノートブック */
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), vbox,
                                                gtk_label_new (_("Codecs")));

  /* ja:ボタン */
  button = gtk_button_new_with_label (_("OK"));
  g_signal_connect_swapped (G_OBJECT (button), "clicked",
                        G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
  GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);

  /* ja:フレームとボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  hbox0 = gtk_hbox_new (FALSE, SPACING);
  pixbuf = gdk_pixbuf_new_from_xpm_data (vmaid_xpm);
  gtk_box_pack_start (GTK_BOX (hbox0),
                        gtk_image_new_from_pixbuf (pixbuf), FALSE, FALSE, 0);
  g_object_unref (pixbuf);
  gtk_box_pack_start (GTK_BOX (hbox0),
                gtk_label_new (VMAID_VERSION_NOTICE"\n"VMAID_COPYRIGHT_NOTICE),
                                                            FALSE, FALSE, 0);
  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox1), hbox0, TRUE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox1, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), notebook, TRUE, TRUE, 0);
  hbox0 = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_end (GTK_BOX (hbox0), button, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), vbox);

  /* ja:表示 */
  gtk_widget_grab_focus (button);

  gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
  gtk_grab_add (dialog);
  gtk_widget_show_all (dialog);
  gtk_main ();
}
