/*
    winmain
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <windows.h>
#include "common.h"


int
main (int, char **);


int WINAPI
WinMain (HINSTANCE hInstance,
         HINSTANCE hPrevInstance,
         LPSTR     lpszCmdLine,
         int       nCmdShow)
{
#if GLIB_CHECK_VERSION(2,6,0)
  int ret = -1;
  gint argc;
  gchar **argv, *utf8str = NULL;

  utf8str = G_WIN32_HAVE_WIDECHAR_API()
                ? g_utf16_to_utf8  (GetCommandLineW (), -1, NULL, NULL, NULL)
                : g_locale_to_utf8 (GetCommandLineA (), -1, NULL, NULL, NULL);
  if (utf8str && g_shell_parse_argv (utf8str, &argc, &argv, NULL))
    {
      ret = main (argc, argv);
      g_strfreev (argv);
    }
  g_free (utf8str);
  return ret;
#else /* not GLIB_CHECK_VERSION(2,6,0) */
  return main (__argc, __argv);
#endif /* not GLIB_CHECK_VERSION(2,6,0) */
}
