require "hardware_detect"
require "hardware_load"
require "log"


class HardwareDetect

	def initialize(sysfs, kmodule, pcidb_file, usbids_file)
		@sysfs = sysfs
		@kmodule = kmodule
		@pcidb_file  = pcidb_file
		@usbids_file = usbids_file


		# sources
		@pciids_v  = Hash.new
		@pciids_d  = Hash.new
		@pcimap_c  = Hash.new
		@pcimap_v  = Hash.new
		@pcimap_vd = Hash.new

		@usbids_v  = Hash.new
		@usbids_d  = Hash.new
		@usbmap_ic = Hash.new
		@usbmap_vd = Hash.new


		# detected
		@detected_pci = Array.new
		@detected_usb = Array.new
	end


	def showDetectedPCI
		# XXX: ログレベル
		# XXX: フォーマットが美しくない
		@detected_pci.each {|dev|
			$log.debug "vendor: #{dev.vendor}  #{@pciids_v[dev.vendor]}"
			$log.debug "device: #{dev.device}  #{@pciids_d[dev.device]}"
			$log.debug "class:  #{dev.pclass}"
			$log.debug "modules: #{dev.modules.uniq.join(", ")}"
			$log.debug "---"
		}
	end


	def showDetectedUSB
		# XXX: ログレベル
		# XXX: フォーマットが美しくない
		@detected_usb.each {|dev|
			if dev.vendor != nil
				#$log.debug "vendor: #{dev.vendor}  #{@usbids_v.key?(dev.vendor) && @usbids_v[dev.vendor].strip}"  # @usbids_vは最後に改行が入っている
				$log.debug "vendor: #{dev.vendor}  #{@usbids_v[dev.vendor]}"
				$log.debug "device: #{dev.device}  #{@usbids_d[dev.device]}"
			end
			if dev.iclass != nil
				$log.debug "interface: #{dev.iclass}"
			end
			$log.debug "modules: #{dev.modules.uniq.join(", ")}"
			$log.debug "---"
		}
	end


	# Wrapper functions
	def detect
		# PCI
		begin
			detectPCI
		rescue
			$log.info "No PCI device found"
			$log.debug "  :#{$!}"
		end
		loadDetectedPCI rescue $log.warn $!

		# USB
		begin
			detectUSB
		rescue
			$log.info "No USB device found"
			$log.debug "  :#{$!}"
		end
		loadDetectedUSB rescue $log.warn $!
	end

	def show
		showDetectedPCI
		showDetectedUSB
	end
end



$log.debug "#{File.basename(__FILE__, ".*")} loaded"
