# FileUtilsは外部ライブラリになるので避ける

def copy_file(src, dst, dst_mode = 0644)
	open(src) {|s|
		open(dst, "w") {|d|
			d.write(s.read)
		}
	}
	File.chmod(dst_mode, dst)
end

def mkblockdev(initrdfs, path, major, minor, mode, owner, group)
	if !File.blockdev?(path)
		if File.exist?(path)
			File.delete(path)
		end
		initrdfs.cmd_mknod(path, "b", major, minor)
		File.chown(owner, group)
		File.chmod(mode, path)
	end
end

def mkchardev(initrdfs, path, major, minor, mode, owner, group)
	if !File.chardev?(path)
		if File.exist?(path)
			File.delete(path)
		end
		initrdfs.cmd_mknod(path, "c", major, minor)
		File.chown(owner, group)
		File.chmod(mode, path)
	end
end



