/*
 * Decompiled with CFR 0.152.
 */
package chexaformation;

import chexaformation.Main;
import chexaformation.TeamListPanel;
import chexaformation.cheFile;
import chexaformation.cheNameDocument;
import chexaformation.cheOkeData;
import chexaformation.cheTeamData;
import chexaformation.mainForm;
import chexaformation.okeView;
import chexaformation.transDestHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;

public class TeamPanel
extends JPanel {
    DefaultListModel okedata = new DefaultListModel();
    cheFile che = new cheFile();
    cheTeamData team = new cheTeamData();
    private JButton addOKE;
    private JButton closeTEAM;
    private JButton delOKE;
    private JScrollPane jScrollPane1;
    private JButton loadTEAM;
    private JList memberList;
    private JTextField ownerName;
    private JButton pos0;
    private JButton pos1;
    private JButton pos2;
    private JButton pos3;
    private JButton pos4;
    private JButton pos5;
    private JButton pos6;
    private JButton pos7;
    private JButton pos8;
    private JPanel positionPanel;
    private JButton saveTEAM;
    private JLabel teamIcon;
    private JTextField teamName;
    private JLabel titleEmblem;
    private JLabel titleOwner;
    private JLabel titleTeam;

    public TeamPanel() {
        this.okedata.addElement(null);
        this.okedata.addElement(null);
        this.okedata.addElement(null);
        this.initComponents();
    }

    public void update_title() {
        File fn = new File(this.che.get_fname());
        JDialog dlg = (JDialog)this.getRootPane().getParent();
        String title = ResourceBundle.getBundle("chexaformation/resource").getString("titleTeamPanel");
        title = title + fn.getName();
        dlg.setTitle(title);
    }

    public void load_team(cheTeamData p) {
        p.copy(this.team);
        this.teamName.setText(this.team.get_team_name());
        this.ownerName.setText(this.team.get_owner_name());
        this.teamIcon.setIcon(this.team.get_emblem().getImgicon());
        this.che.set_fname(p.get_data_name());
        this.update_title();
        this.update_memberlist();
    }

    public void load_oke(int nidx, cheOkeData p, int n) {
        this.team.add_member(nidx, p, n);
        if (nidx == 0) {
            this.team.set_emblem(p);
            this.teamIcon.setIcon(this.team.get_emblem().getImgicon());
        }
        this.update_memberlist();
    }

    private void resetTeamDetail() {
        this.okedata.clear();
        this.pos0.setText("-");
        this.pos1.setText("-");
        this.pos2.setText("-");
        this.pos3.setText("-");
        this.pos4.setText("-");
        this.pos5.setText("-");
        this.pos6.setText("-");
        this.pos7.setText("-");
        this.pos8.setText("-");
    }

    public void update_memberlist() {
        this.resetTeamDetail();
        for (int i = 0; i < 3; ++i) {
            int n;
            this.okedata.addElement(this.team);
            if (this.team.get_member(i) == null || (n = this.team.get_position(i)) == -1) continue;
            JButton wk = (JButton)this.positionPanel.getComponent(n);
            wk.setText(Integer.toString(i + 1));
        }
    }

    public cheOkeData get_current_oke() {
        int nsel = this.memberList.getSelectedIndex();
        if (nsel != -1) {
            return this.team.get_member(nsel);
        }
        return null;
    }

    public int get_current_oke_pos() {
        int nsel = this.memberList.getSelectedIndex();
        if (nsel != -1) {
            return this.team.get_position(nsel);
        }
        return -1;
    }

    private TeamListPanel get_teamlist() {
        mainForm form = (mainForm)this.getRootPane().getParent().getParent();
        return form.get_teamlist();
    }

    private void initComponents() {
        this.titleTeam = new JLabel();
        this.teamName = new JTextField();
        this.titleOwner = new JLabel();
        this.ownerName = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.memberList = new JList();
        this.positionPanel = new JPanel();
        this.pos0 = new JButton();
        this.pos1 = new JButton();
        this.pos2 = new JButton();
        this.pos3 = new JButton();
        this.pos4 = new JButton();
        this.pos5 = new JButton();
        this.pos6 = new JButton();
        this.pos7 = new JButton();
        this.pos8 = new JButton();
        this.addOKE = new JButton();
        this.delOKE = new JButton();
        this.loadTEAM = new JButton();
        this.closeTEAM = new JButton();
        this.saveTEAM = new JButton();
        this.teamIcon = new JLabel();
        this.titleEmblem = new JLabel();
        this.titleTeam.setFont(new Font("Monospaced", 0, 12));
        ResourceBundle bundle = ResourceBundle.getBundle("chexaformation/resource");
        this.titleTeam.setText(bundle.getString("labelTeamName"));
        this.teamName.setDocument(new cheNameDocument());
        this.teamName.setFont(new Font("Monospaced", 0, 12));
        this.teamName.setText(this.team.get_team_name());
        this.titleOwner.setFont(new Font("Monospaced", 0, 12));
        this.titleOwner.setText(bundle.getString("labelOwnerName"));
        this.ownerName.setDocument(new cheNameDocument());
        this.ownerName.setFont(new Font("Monospaced", 0, 12));
        this.ownerName.setText(this.team.get_owner_name());
        this.jScrollPane1.setFont(new Font("MingLiU", 0, 12));
        this.memberList.setFont(new Font("Monospaced", 0, 12));
        this.memberList.setModel(this.okedata);
        this.memberList.setSelectionMode(0);
        this.memberList.setCellRenderer(new okeView());
        this.memberList.setDragEnabled(true);
        this.jScrollPane1.setViewportView(this.memberList);
        this.memberList.setTransferHandler(new transDestHandler());
        this.positionPanel.setBorder(BorderFactory.createTitledBorder(null, "\u914d\u7f6e", 0, 0, new Font("MingLiU", 0, 12), null));
        this.positionPanel.setFont(new Font("Monospaced", 0, 15));
        this.pos0.setFont(new Font("Monospaced", 0, 12));
        this.pos0.setText("-");
        this.pos0.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamPanel.this.pushPosition(evt);
            }
        });
        this.pos1.setFont(new Font("Monospaced", 0, 12));
        this.pos1.setText("-");
        this.pos1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamPanel.this.pushPosition(evt);
            }
        });
        this.pos2.setFont(new Font("Monospaced", 0, 12));
        this.pos2.setText("-");
        this.pos2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamPanel.this.pushPosition(evt);
            }
        });
        this.pos3.setFont(new Font("Monospaced", 0, 12));
        this.pos3.setText("-");
        this.pos3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamPanel.this.pushPosition(evt);
            }
        });
        this.pos4.setFont(new Font("Monospaced", 0, 12));
        this.pos4.setText("-");
        this.pos4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamPanel.this.pushPosition(evt);
            }
        });
        this.pos5.setFont(new Font("Monospaced", 0, 12));
        this.pos5.setText("-");
        this.pos5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamPanel.this.pushPosition(evt);
            }
        });
        this.pos6.setFont(new Font("Monospaced", 0, 12));
        this.pos6.setText("-");
        this.pos6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamPanel.this.pushPosition(evt);
            }
        });
        this.pos7.setFont(new Font("Monospaced", 0, 12));
        this.pos7.setText("-");
        this.pos7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamPanel.this.pushPosition(evt);
            }
        });
        this.pos8.setFont(new Font("Monospaced", 0, 12));
        this.pos8.setText("-");
        this.pos8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamPanel.this.pushPosition(evt);
            }
        });
        GroupLayout positionPanelLayout = new GroupLayout(this.positionPanel);
        this.positionPanel.setLayout(positionPanelLayout);
        positionPanelLayout.setHorizontalGroup(positionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(positionPanelLayout.createSequentialGroup().addContainerGap().addGroup(positionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(positionPanelLayout.createSequentialGroup().addComponent(this.pos0).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pos1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pos2)).addGroup(positionPanelLayout.createSequentialGroup().addComponent(this.pos3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pos4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pos5)).addGroup(positionPanelLayout.createSequentialGroup().addComponent(this.pos6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pos7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pos8))).addContainerGap(-1, Short.MAX_VALUE)));
        positionPanelLayout.setVerticalGroup(positionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(positionPanelLayout.createSequentialGroup().addContainerGap().addGroup(positionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pos0).addComponent(this.pos1).addComponent(this.pos2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(positionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pos3).addComponent(this.pos4).addComponent(this.pos5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(positionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pos6).addComponent(this.pos7).addComponent(this.pos8)).addContainerGap(-1, Short.MAX_VALUE)));
        this.addOKE.setFont(new Font("Monospaced", 0, 12));
        this.addOKE.setText(bundle.getString("addOKE"));
        this.addOKE.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamPanel.this.addOKEActionPerformed(evt);
            }
        });
        this.delOKE.setFont(new Font("Monospaced", 0, 12));
        this.delOKE.setText(bundle.getString("delOKE"));
        this.delOKE.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamPanel.this.delOKEActionPerformed(evt);
            }
        });
        this.loadTEAM.setFont(new Font("Monospaced", 0, 12));
        this.loadTEAM.setText(bundle.getString("readTeam"));
        this.loadTEAM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamPanel.this.loadTEAMActionPerformed(evt);
            }
        });
        this.closeTEAM.setFont(new Font("Monospaced", 0, 12));
        this.closeTEAM.setText(bundle.getString("closeWindow"));
        this.closeTEAM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamPanel.this.closeTEAMActionPerformed(evt);
            }
        });
        this.saveTEAM.setFont(new Font("Monospaced", 0, 12));
        this.saveTEAM.setText(bundle.getString("saveTeam"));
        this.saveTEAM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamPanel.this.saveTEAMActionPerformed(evt);
            }
        });
        this.teamIcon.setBackground(Color.white);
        this.teamIcon.setFont(new Font("Monospaced", 0, 12));
        this.teamIcon.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.teamIcon.setMaximumSize(new Dimension(34, 34));
        this.teamIcon.setMinimumSize(new Dimension(34, 34));
        this.teamIcon.setPreferredSize(new Dimension(34, 34));
        this.titleEmblem.setFont(new Font("Monospaced", 0, 12));
        this.titleEmblem.setText(bundle.getString("labelTeamEmblem"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 404, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.titleTeam).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.teamName, -1, 332, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.titleOwner).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ownerName, -1, 332, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.saveTEAM).addGap(54, 54, 54).addComponent(this.closeTEAM)).addGroup(layout.createSequentialGroup().addComponent(this.positionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.titleEmblem).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 76, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.loadTEAM).addComponent(this.delOKE).addComponent(this.addOKE).addGroup(layout.createSequentialGroup().addComponent(this.teamIcon, -2, -1, -2).addGap(84, 84, 84))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleTeam).addComponent(this.teamName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleOwner).addComponent(this.ownerName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 103, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.teamIcon, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.addOKE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.delOKE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.loadTEAM)).addComponent(this.titleEmblem)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.closeTEAM).addComponent(this.saveTEAM))).addComponent(this.positionPanel, -2, -1, -2)).addContainerGap()));
    }

    private void closeTEAMActionPerformed(ActionEvent evt) {
        String mesg;
        String title;
        JDialog dlg = (JDialog)this.getRootPane().getParent();
        if (Main.confirm_box(dlg, title = ResourceBundle.getBundle("chexaformation/resource").getString("titleClose"), mesg = ResourceBundle.getBundle("chexaformation/resource").getString("confirmClose"), "")) {
            dlg.dispose();
        }
    }

    private void addOKEActionPerformed(ActionEvent evt) {
        TeamListPanel teamlist;
        cheOkeData wkoke;
        int nsel = this.memberList.getSelectedIndex();
        if (nsel != -1 && (wkoke = (teamlist = this.get_teamlist()).get_current_oke()) != null) {
            this.team.add_member(nsel, wkoke, teamlist.get_current_oke_pos());
            if (nsel == 0) {
                this.team.set_emblem(wkoke);
                this.teamIcon.setIcon(this.team.get_emblem().getImgicon());
            }
            this.update_memberlist();
        }
    }

    private void delOKEActionPerformed(ActionEvent evt) {
        int nsel = this.memberList.getSelectedIndex();
        if (nsel != -1) {
            this.team.del_member(nsel);
            this.update_memberlist();
        }
    }

    private void saveTEAMActionPerformed(ActionEvent evt) {
        JFileChooser fdlg = new JFileChooser(Main.cheDataDir);
        String filterTitle = ResourceBundle.getBundle("chexaformation/resource").getString("filterTitleCHE");
        FileNameExtensionFilter ffilter = new FileNameExtensionFilter(filterTitle, "CHE");
        fdlg.setFileFilter(ffilter);
        fdlg.setSelectedFile(new File(this.che.get_fname()));
        int nret = fdlg.showSaveDialog(this.getRootPane().getParent());
        if (nret == 0) {
            File ifile = fdlg.getSelectedFile();
            if (ifile.exists()) {
                String wktitle = ResourceBundle.getBundle("chexaformation/resource").getString("titleSaveTeam");
                String wkmesg = ResourceBundle.getBundle("chexaformation/resource").getString("confirmExistCHE");
                if (!Main.confirm_box((Dialog)this.getRootPane().getParent(), wktitle, wkmesg, "")) {
                    return;
                }
            }
            Main.cheDataDir = ifile.getParent();
            this.team.set_team_name(this.teamName.getText());
            this.team.set_owner_name(this.ownerName.getText());
            this.che.set_team(0, this.team);
            this.che.set_fname(ifile.getAbsolutePath());
            if (this.che.save()) {
                Main.mesg_box((Dialog)this.getRootPane().getParent(), ResourceBundle.getBundle("chexaformation/resource").getString("titleSaveTeam"), ResourceBundle.getBundle("chexaformation/resource").getString("mesgSaveTeam"), "");
            } else {
                Main.mesg_box((Dialog)this.getRootPane().getParent(), ResourceBundle.getBundle("chexaformation/resource").getString("titleSaveTeam"), ResourceBundle.getBundle("chexaformation/resource").getString("failSaveTeam"), ifile.getAbsolutePath());
            }
            this.update_title();
        }
    }

    private void pushPosition(ActionEvent evt) {
        int nsel = this.memberList.getSelectedIndex();
        if (nsel != -1) {
            Component[] btnlist = this.positionPanel.getComponents();
            for (int i = 0; i < btnlist.length; ++i) {
                if (btnlist[i] != evt.getSource() || !this.team.check_position(nsel, i)) continue;
                int old_pos = this.team.get_position(nsel);
                if (old_pos != -1) {
                    ((JButton)btnlist[old_pos]).setText("-");
                }
                this.team.set_position(nsel, i);
                ((JButton)btnlist[i]).setText(Integer.toString(nsel + 1));
                this.okedata.setElementAt(this.team, nsel);
                break;
            }
        }
    }

    private void loadTEAMActionPerformed(ActionEvent evt) {
        TeamListPanel teamlist = this.get_teamlist();
        this.load_team(teamlist.get_current_team());
    }
}

