/*
 * Decompiled with CFR 0.152.
 */
package chexaformation;

import chexaformation.Main;
import chexaformation.MatchDataPanel;
import chexaformation.cheFile;
import chexaformation.cheOkeData;
import chexaformation.cheTeamData;
import chexaformation.okeView;
import chexaformation.transOkeHandler;
import chexaformation.transTeamHandler;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class TeamListPanel
extends JPanel {
    DefaultListModel teamdata = new DefaultListModel();
    DefaultListModel okedata = new DefaultListModel();
    private JButton clearCHE;
    private JButton exitGUI;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton loadCHE;
    private JList memberList;
    private JLabel pos0;
    private JLabel pos1;
    private JLabel pos2;
    private JLabel pos3;
    private JLabel pos4;
    private JLabel pos5;
    private JLabel pos6;
    private JLabel pos7;
    private JLabel pos8;
    private JPanel positionPanel;
    private JButton removeCHE;
    private JLabel teamIcon;
    private JList teamList;
    private JButton textOutTeam;

    public TeamListPanel() {
        this.initComponents();
    }

    public cheTeamData get_current_team() {
        int nsel = this.teamList.getSelectedIndex();
        if (nsel != -1) {
            return (cheTeamData)this.teamdata.get(nsel);
        }
        return null;
    }

    public cheOkeData get_current_oke() {
        int nsel = this.teamList.getSelectedIndex();
        if (nsel != -1) {
            cheTeamData team = (cheTeamData)this.teamdata.get(nsel);
            nsel = this.memberList.getSelectedIndex();
            if (nsel != -1) {
                return team.get_member(nsel);
            }
        }
        return null;
    }

    public int get_current_oke_pos() {
        int nsel = this.teamList.getSelectedIndex();
        if (nsel != -1) {
            cheTeamData team = (cheTeamData)this.teamdata.get(nsel);
            nsel = this.memberList.getSelectedIndex();
            if (nsel != -1) {
                return team.get_position(nsel);
            }
        }
        return -1;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.teamList = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.memberList = new JList();
        this.positionPanel = new JPanel();
        this.pos0 = new JLabel();
        this.pos1 = new JLabel();
        this.pos2 = new JLabel();
        this.pos3 = new JLabel();
        this.pos4 = new JLabel();
        this.pos5 = new JLabel();
        this.pos6 = new JLabel();
        this.pos7 = new JLabel();
        this.pos8 = new JLabel();
        this.loadCHE = new JButton();
        this.clearCHE = new JButton();
        this.teamIcon = new JLabel();
        this.textOutTeam = new JButton();
        this.removeCHE = new JButton();
        this.exitGUI = new JButton();
        this.teamList.setFont(new Font("Monospaced", 0, 12));
        this.teamList.setModel(this.teamdata);
        this.teamList.setSelectionMode(0);
        this.teamList.setDragEnabled(true);
        this.teamList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                TeamListPanel.this.teamListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.teamList);
        this.teamList.setTransferHandler(new transTeamHandler());
        this.memberList.setFont(new Font("Monospaced", 0, 12));
        this.memberList.setModel(this.okedata);
        this.memberList.setSelectionMode(0);
        this.memberList.setCellRenderer(new okeView());
        this.memberList.setCursor(new Cursor(0));
        this.memberList.setDragEnabled(true);
        this.jScrollPane2.setViewportView(this.memberList);
        this.memberList.setTransferHandler(new transOkeHandler());
        this.positionPanel.setBorder(BorderFactory.createTitledBorder(null, "\u914d\u7f6e", 0, 0, new Font("MingLiU", 0, 12), SystemColor.windowText));
        this.positionPanel.setFont(new Font("Monospaced", 0, 12));
        this.pos0.setFont(new Font("Courier New", 0, 12));
        this.pos0.setText("-");
        this.pos1.setFont(new Font("Courier New", 0, 12));
        this.pos1.setText("-");
        this.pos2.setFont(new Font("Courier New", 0, 12));
        this.pos2.setText("-");
        this.pos3.setFont(new Font("Courier New", 0, 12));
        this.pos3.setText("-");
        this.pos4.setFont(new Font("Courier New", 0, 12));
        this.pos4.setText("-");
        this.pos5.setFont(new Font("Courier New", 0, 12));
        this.pos5.setText("-");
        this.pos6.setFont(new Font("Courier New", 0, 12));
        this.pos6.setText("-");
        this.pos7.setFont(new Font("Courier New", 0, 12));
        this.pos7.setText("-");
        this.pos8.setFont(new Font("Courier New", 0, 12));
        this.pos8.setText("-");
        GroupLayout positionPanelLayout = new GroupLayout(this.positionPanel);
        this.positionPanel.setLayout(positionPanelLayout);
        positionPanelLayout.setHorizontalGroup(positionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(positionPanelLayout.createSequentialGroup().addGroup(positionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(positionPanelLayout.createSequentialGroup().addComponent(this.pos0).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pos1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pos2)).addGroup(positionPanelLayout.createSequentialGroup().addComponent(this.pos3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pos4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pos5)).addGroup(positionPanelLayout.createSequentialGroup().addComponent(this.pos6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pos7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pos8))).addContainerGap(13, Short.MAX_VALUE)));
        positionPanelLayout.setVerticalGroup(positionPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(positionPanelLayout.createSequentialGroup().addGroup(positionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pos0).addComponent(this.pos1).addComponent(this.pos2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(positionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pos3).addComponent(this.pos4).addComponent(this.pos5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(positionPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pos6).addComponent(this.pos7).addComponent(this.pos8)).addContainerGap(-1, Short.MAX_VALUE)));
        this.loadCHE.setFont(new Font("Monospaced", 0, 12));
        ResourceBundle bundle = ResourceBundle.getBundle("chexaformation/resource");
        this.loadCHE.setText(bundle.getString("loadCHE"));
        this.loadCHE.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamListPanel.this.loadCHEActionPerformed(evt);
            }
        });
        this.clearCHE.setFont(new Font("Monospaced", 0, 12));
        this.clearCHE.setText(bundle.getString("allClearTeam"));
        this.clearCHE.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamListPanel.this.clearCHEActionPerformed(evt);
            }
        });
        this.teamIcon.setBackground(Color.white);
        this.teamIcon.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.teamIcon.setMaximumSize(new Dimension(34, 34));
        this.teamIcon.setMinimumSize(new Dimension(34, 34));
        this.teamIcon.setPreferredSize(new Dimension(34, 34));
        this.textOutTeam.setFont(new Font("Monospaced", 0, 12));
        this.textOutTeam.setText(bundle.getString("textOut"));
        this.textOutTeam.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamListPanel.this.textOutTeamActionPerformed(evt);
            }
        });
        this.removeCHE.setFont(new Font("Monospaced", 0, 12));
        this.removeCHE.setText(bundle.getString("removeCHE"));
        this.removeCHE.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamListPanel.this.removeCHEActionPerformed(evt);
            }
        });
        this.exitGUI.setFont(new Font("Monospaced", 0, 12));
        this.exitGUI.setText(bundle.getString("exitAPP"));
        this.exitGUI.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TeamListPanel.this.exitGUIActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 416, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.loadCHE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeCHE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.textOutTeam).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.clearCHE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.exitGUI)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane2, -1, 357, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.teamIcon, -2, -1, -2).addComponent(this.positionPanel, -2, -1, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 186, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.positionPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.teamIcon, -2, -1, -2)).addComponent(this.jScrollPane2, -2, 147, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearCHE).addComponent(this.exitGUI).addComponent(this.textOutTeam)).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.loadCHE).addComponent(this.removeCHE))).addContainerGap()));
    }

    private void loadCHEActionPerformed(ActionEvent evt) {
        JFileChooser fdlg = new JFileChooser(Main.cheDataDir);
        String filterTitle = ResourceBundle.getBundle("chexaformation/resource").getString("filterTitleCHE");
        FileNameExtensionFilter ffilter = new FileNameExtensionFilter(filterTitle, "CHE");
        fdlg.setFileFilter(ffilter);
        fdlg.setMultiSelectionEnabled(true);
        int nret = fdlg.showOpenDialog(this.getRootPane().getParent());
        if (nret == 0) {
            File[] ifiles = fdlg.getSelectedFiles();
            for (int nidx = 0; nidx < ifiles.length; ++nidx) {
                cheFile che = new cheFile(ifiles[nidx].getAbsolutePath());
                Main.cheDataDir = ifiles[nidx].getParent();
                if (che.load()) {
                    for (int i = 0; i < che.get_team_max(); ++i) {
                        cheTeamData team = che.get_team(i);
                        if (team == null || !team.is_enable()) continue;
                        this.teamdata.addElement(team);
                    }
                    continue;
                }
                Main.mesg_box((Frame)this.getRootPane().getParent(), ResourceBundle.getBundle("chexaformation/resource").getString("loadCHE"), ResourceBundle.getBundle("chexaformation/resource").getString("faileReadCHE"), ifiles[nidx].getAbsolutePath());
            }
        }
    }

    private void resetTeamDetail() {
        this.okedata.clear();
        this.pos0.setText("-");
        this.pos1.setText("-");
        this.pos2.setText("-");
        this.pos3.setText("-");
        this.pos4.setText("-");
        this.pos5.setText("-");
        this.pos6.setText("-");
        this.pos7.setText("-");
        this.pos8.setText("-");
    }

    private void clearCHEActionPerformed(ActionEvent evt) {
        this.teamdata.clear();
        this.resetTeamDetail();
        this.teamIcon.setIcon(null);
    }

    private void teamListValueChanged(ListSelectionEvent evt) {
        int nidx = this.teamList.getSelectedIndex();
        if (nidx != -1) {
            cheTeamData team = (cheTeamData)this.teamdata.get(nidx);
            this.resetTeamDetail();
            for (int i = 0; i < 3; ++i) {
                int n;
                this.okedata.addElement(team);
                if (team.get_member(i) == null || (n = team.get_position(i)) == -1) continue;
                JLabel wk = (JLabel)this.positionPanel.getComponent(n);
                wk.setText(Integer.toString(i + 1));
            }
            this.teamIcon.setIcon(team.get_emblem().getImgicon());
        } else {
            this.resetTeamDetail();
            this.teamIcon.setIcon(null);
        }
    }

    private void exitGUIActionPerformed(ActionEvent evt) {
        String mesg;
        String title;
        JFrame frame = (JFrame)this.getRootPane().getParent();
        if (Main.confirm_box(frame, title = ResourceBundle.getBundle("chexaformation/resource").getString("titleExit"), mesg = ResourceBundle.getBundle("chexaformation/resource").getString("confitmExit"), "")) {
            frame.dispose();
        }
    }

    private void removeCHEActionPerformed(ActionEvent evt) {
        int nidx = this.teamList.getSelectedIndex();
        if (nidx != -1) {
            this.teamdata.remove(nidx);
            this.resetTeamDetail();
            this.teamIcon.setIcon(null);
        }
    }

    private void textOutTeamActionPerformed(ActionEvent evt) {
        JFileChooser fdlg = new JFileChooser(Main.cheTextDataDir);
        String filterTitle = ResourceBundle.getBundle("chexaformation/resource").getString("filterTitleText");
        FileNameExtensionFilter ffilter = new FileNameExtensionFilter(filterTitle, "txt");
        fdlg.setFileFilter(ffilter);
        if (fdlg.showSaveDialog(this.getRootPane().getParent()) == 0) {
            File ifile = fdlg.getSelectedFile();
            if (ifile.exists()) {
                String wktitle = ResourceBundle.getBundle("chexaformation/resource").getString("titleSaveText");
                String wkmesg = ResourceBundle.getBundle("chexaformation/resource").getString("confirmExistText");
                if (!Main.confirm_box((Frame)this.getRootPane().getParent(), wktitle, wkmesg, "")) {
                    return;
                }
            }
            try {
                PrintWriter w = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(ifile.getAbsolutePath()), "UTF-8"));
                Main.cheTextDataDir = ifile.getParent();
                for (int i = 0; i < this.teamdata.size(); ++i) {
                    cheTeamData team = (cheTeamData)this.teamdata.get(i);
                    if (team == null) continue;
                    w.println(team.make_text(null));
                }
                w.close();
            }
            catch (IOException ex) {
                Logger.getLogger(MatchDataPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

