﻿#include <windows.h>
#include <process.h>
#include <dbghelp.h>
#include <iostream>

//#include <cstdint>
#include <stdint.h>

using namespace std;

__declspec(thread) int tls_int = 0;

/* winnt.h
#define DLL_PROCESS_ATTACH 1
#define DLL_THREAD_ATTACH 2
#define DLL_THREAD_DETACH 3
#define DLL_PROCESS_DETACH 0
#define DLL_PROCESS_VERIFIER 4
*/

static CRITICAL_SECTION g_printf_crit_sec;

#if 0x0
int sync_printf(const char *format, ...)
{
    va_list args;
    va_start(args, format);
	EnterCriticalSection(&g_printf_crit_sec);
    int ret = vprintf(format, args);
	LeaveCriticalSection(&g_printf_crit_sec);
    va_end(args);
	return ret;
}

#define printf sync_printf
#endif

namespace {
	static void NTAPI on_tls_callback(PVOID hModule, DWORD dwReason, PVOID lpReserved)
	{
		printf("on_tls_callback(): hModule=0x%08x dwReason=0x%08x lpReserved=0x%08x\n", hModule, dwReason, lpReserved);
		tls_int = 1234;
		char szPath[_MAX_PATH];
		memset(szPath, 0x00, sizeof(szPath));
		DWORD dwRet = GetModuleFileNameA((HMODULE)hModule, szPath, sizeof(szPath));
		if(dwRet == 0) {
		}
		puts(szPath);
		if(dwReason==DLL_THREAD_ATTACH)
		{
			HANDLE v_handle = GetCurrentThread();
			printf("DLL_THREAD_ATTACH: v_handle=0x%08x\n", v_handle);
		}
		switch(dwReason){
		case DLL_PROCESS_ATTACH:
			puts("-> DLL_PROCESS_ATTACH");
			break;
		case DLL_PROCESS_DETACH:
			puts("-> DLL_PROCESS_DETACH");
			break;
		case DLL_THREAD_ATTACH:
			puts("-> DLL_THREAD_ATTACH");
			break;
		case DLL_THREAD_DETACH:
			puts("-> DLL_THREAD_DETACH");
			break;
		default:
			puts("-> UNKNOWN");
			break;
		}
	}
}

#ifdef __GNUC__
extern "C"
{
	PIMAGE_TLS_CALLBACK __my_tls_callback__ __attribute__ ((section(".CRT$XLB"))) = on_tls_callback;
}
#else
#pragma data_seg(".CRT$XLB")
extern "C"
{
   PIMAGE_TLS_CALLBACK __my_tls_callback__ = on_tls_callback;
}
#pragma data_seg()
#endif

// http://www.nirsoft.net/kernel_struct/vista/CLIENT_ID.html
typedef struct _CLIENT_ID
{
     PVOID UniqueProcess;
     PVOID UniqueThread;
} CLIENT_ID, *PCLIENT_ID;

// http://www.nirsoft.net/kernel_struct/vista/RTL_ACTIVATION_CONTEXT_STACK_FRAME.html
// http://doxygen.reactos.org/d2/dc3/winternl_8h_source.html#l00194
typedef struct _RTL_ACTIVATION_CONTEXT_STACK_FRAME
{
     //PRTL_ACTIVATION_CONTEXT_STACK_FRAME Previous;
     struct _RTL_ACTIVATION_CONTEXT_STACK_FRAME *Previous;
     _ACTIVATION_CONTEXT * ActivationContext;
     ULONG Flags;
} RTL_ACTIVATION_CONTEXT_STACK_FRAME, *PRTL_ACTIVATION_CONTEXT_STACK_FRAME;

// http://www.nirsoft.net/kernel_struct/vista/ACTIVATION_CONTEXT_STACK.html
typedef struct _ACTIVATION_CONTEXT_STACK
{
     PRTL_ACTIVATION_CONTEXT_STACK_FRAME ActiveFrame;
     LIST_ENTRY FrameListCache;
     ULONG Flags;
     ULONG NextCookieSequenceNumber;
     ULONG StackId;
} ACTIVATION_CONTEXT_STACK, *PACTIVATION_CONTEXT_STACK;

// http://shitwefoundout.com/wiki/Win32_Thread_Environment_Block
typedef struct _MY_NT_TIB {              //  x86  /  x64
  void *ExceptionList;        // 0x000 / 0x000
  void *StackBase;            // 0x004 / 0x008
  void *StackLimit;           // 0x008 / 0x010
  void *SubSystemTib;         // 0x00c / 0x018
  union {
    void *FiberData;          // 0x010 / 0x020
    uint32_t Version;         // 0x010 / 0x020
  };
  void *ArbitraryUserPointer; // 0x014 / 0x028
  struct _NT_TIB *Self;       // 0x018 / 0x030
} MY_NT_TIB, *PMY_NT_TIB;
typedef struct _MY_TEB {                                          //  x86  /  x64
  struct _MY_NT_TIB                 NtTib;                        // 0x000 / 0x000
  void                             *EnvironmentPointer;           // 0x01c / 0x038
  struct _CLIENT_ID                 ClientId;                     // 0x020 / 0x040
  void                             *ActiveRpcHandle;              // 0x028 / 0x050
  void                             *ThreadLocalStoragePointer;    // 0x02c / 0x058
  struct _PEB                      *ProcessEnvironmentBlock;      // 0x030 / 0x060
  uint32_t                          LastErrorValue;               // 0x034 / 0x068
  uint32_t                          CountOfOwnedCriticalSections; // 0x038 / 0x06c
  void                             *CsrClientThread;              // 0x03c / 0x070
  void                             *Win32ThreadInfo;              // 0x040 / 0x078
  uint32_t                          User32Reserved[26];           // 0x044 / 0x080
  uint32_t                          UserReserved[5];              // 0x0ac / 0x0e8
  void                             *WOW32Reserved;                // 0x0c0 / 0x100?
  uint32_t                          CurrentLocale;                // 0x0c4
  uint32_t                          FpSoftwareStatusRegister;     // 0x0c8
  void                             *SystemReserved1[54];          // 0x0cc
  uint32_t                          ExceptionCode;                // 0x1a4
  struct _ACTIVATION_CONTEXT_STACK  ActivationContextStack;       // 0x1a8
  uint8_t                           SpareBytes1[24];              // 0x1bc
  //struct _GDI_TEB_BATCH           GdiTebBatch;                  // 0x1d4
} MY_TEB, *PMY_TEB;

#if 0x0
typedef struct _NT_TIB32 {
    DWORD ExceptionList;
    DWORD StackBase;
    DWORD StackLimit;
    DWORD SubSystemTib;
#if defined(_MSC_EXTENSIONS)
    union {
        DWORD FiberData;
        DWORD Version;
    };
#else
    DWORD FiberData;
#endif
    DWORD ArbitraryUserPointer;
    DWORD Self;
} NT_TIB32, *PNT_TIB32;
typedef struct _TEB {
    PVOID Reserved1[12];
    PPEB ProcessEnvironmentBlock;
    PVOID Reserved2[399];
    BYTE Reserved3[1952];
    PVOID TlsSlots[64];
    BYTE Reserved4[8];
    PVOID Reserved5[26];
    PVOID ReservedForOle;  // Windows 2000 only
    PVOID Reserved6[4];
    PVOID TlsExpansionSlots;
} TEB, *PTEB;
#endif

static PMY_TEB getTEB()
{
  return (PMY_TEB)__readfsdword(0x18);
}

void Bounce(PVOID p)
{
	UNREFERENCED_PARAMETER(p);
	printf("Bounce() called: p=0x%08x\n", p);
	PMY_TEB v_teb = getTEB();
	printf("[Bounce] v_teb=0x%08x\n", v_teb);
	printf("[Bounce] v_teb->ThreadLocalStoragePointer=0x%08x\n", v_teb->ThreadLocalStoragePointer);
}

int wmain(int argc, wchar_t *argv[])
{
	UNREFERENCED_PARAMETER(argc);
	UNREFERENCED_PARAMETER(argv);

	InitializeCriticalSection(&g_printf_crit_sec);

	cout<<"main thread tls value = "<<tls_int<<endl;
	_beginthread(Bounce, 0, (void *)NULL);
	cout<<"main thread tls value = "<<tls_int<<endl;
/*
    typedef struct _IMAGE_TLS_DIRECTORY32 {
      DWORD StartAddressOfRawData;
      DWORD EndAddressOfRawData;
      DWORD AddressOfIndex;
      DWORD AddressOfCallBacks;
      DWORD SizeOfZeroFill;
      DWORD Characteristics;
    } IMAGE_TLS_DIRECTORY32;
    typedef IMAGE_TLS_DIRECTORY32 *PIMAGE_TLS_DIRECTORY32;
*/
	HMODULE v_base_addr = GetModuleHandleA(NULL);
	ULONG v_size;
	PIMAGE_SECTION_HEADER v_section_header;
	PIMAGE_TLS_DIRECTORY v_ret_addr = (PIMAGE_TLS_DIRECTORY)ImageDirectoryEntryToDataEx(
		v_base_addr,
		TRUE, //FALSE,
		IMAGE_DIRECTORY_ENTRY_TLS,
		&v_size,
		&v_section_header
	);
	
	printf("v_base_addr=0x%08x\n", v_base_addr);
	printf("v_ret_addr=0x%08x\n", v_ret_addr);
	printf("v_size=%u\n", v_size);
	printf("v_section_header=0x%08x\n", v_section_header);
	printf("StartAddressOfRawData=0x%08x\n", v_ret_addr->StartAddressOfRawData);
	printf("EndAddressOfRawData=0x%08x\n", v_ret_addr->EndAddressOfRawData);
	printf("diff=%u\n", v_ret_addr->EndAddressOfRawData - v_ret_addr->StartAddressOfRawData);
	printf("AddressOfIndex=0x%08x\n", v_ret_addr->AddressOfIndex);
	printf("AddressOfCallBacks=0x%08x\n", v_ret_addr->AddressOfCallBacks);
	printf("SizeOfZeroFill=0x%08x\n", v_ret_addr->SizeOfZeroFill);
	printf("Characteristics=0x%08x\n", v_ret_addr->Characteristics);
	if(v_ret_addr->AddressOfIndex)
	{
		DWORD v_peek_0 = ((DWORD *)v_ret_addr->AddressOfIndex)[0];
		printf("v_peek_0=0x%08x\n", v_peek_0);
	}
	if(v_ret_addr->AddressOfCallBacks)
	{
		printf("__my_tls_callback__=0x%08x\n", __my_tls_callback__);
		printf("on_tls_callback=0x%08x\n", on_tls_callback);
		DWORD v_peek_0 = ((DWORD *)v_ret_addr->AddressOfCallBacks)[0];
		printf("v_peek_0=0x%08x\n", v_peek_0);
		DWORD v_peek_1 = ((DWORD *)v_ret_addr->AddressOfCallBacks)[1];
		printf("v_peek_1=0x%08x\n", v_peek_1);
		DWORD v_peek_2 = ((DWORD *)v_ret_addr->AddressOfCallBacks)[2];
		printf("v_peek_2=0x%08x\n", v_peek_2);
		DWORD v_peek_3 = ((DWORD *)v_ret_addr->AddressOfCallBacks)[3];
		printf("v_peek_3=0x%08x\n", v_peek_3);
		DWORD v_peek_4 = ((DWORD *)v_ret_addr->AddressOfCallBacks)[4];
		printf("v_peek_4=0x%08x\n", v_peek_4);
	}
	PMY_TEB v_teb = getTEB();
	printf("v_teb=0x%08x\n", v_teb);
	printf("v_teb->ThreadLocalStoragePointer=0x%08x\n", v_teb->ThreadLocalStoragePointer);
	DWORD v_tls_idx = TlsAlloc();
	printf("v_tls_idx=%u\n", v_tls_idx);
	for(ULONG i=0; i<=v_tls_idx; i++)
	{
		printf("v_teb->ThreadLocalStoragePointer[%d]=0x%08x\n", i, ((DWORD *)v_teb->ThreadLocalStoragePointer)[i]);
	}

	Sleep(3000);
#if 0x0	
    PIMAGE_TLS_DIRECTORY TlsDirectory;
    /* Get the TLS directory */
    TlsDirectory = RtlImageDirectoryEntryToData(LdrEntry->DllBase,
                                                TRUE,
                                                IMAGE_DIRECTORY_ENTRY_TLS,
                                                &Size);
#endif
	return 0;
}

extern "C" int _tls_used;
int dummy()
{
	return _tls_used;
}
