#include "PeLdr.h"
#include "Debug.h"

#include "strconv.h"
#include <psapi.h>

static
INT ShowUsage()
{
	printf("-- PE Loader Sample --\n\n");
	printf("PeLdr [PE-File]\n");
	printf("\n");

	return 0;
}

int wmain(int argc, wchar_t *argv[])
{
	PE_LDR_PARAM peLdr;
#if 0x0
	if(argc < 2)
		return ShowUsage();
#endif

#if 0x1
	HMODULE v_hmod = GetModuleHandleW(NULL);
	printf("v_hmod=0x%08x\n", v_hmod);
#endif

    HMODULE hMods[1024];
    DWORD cbNeeded;
	HANDLE hProcess = GetCurrentProcess();
    if( EnumProcessModules(hProcess, hMods, sizeof(hMods), &cbNeeded))
    {
        for ( unsigned int i = 0; i < (cbNeeded / sizeof(HMODULE)); i++ )
        {
            WCHAR szModName[MAX_PATH];
        	MODULEINFO mi;

            // Get the full path to the module's file.
			GetModuleInformation(hProcess, hMods[i], &mi, sizeof(MODULEINFO));
        	if ( GetModuleFileNameExW( hProcess, hMods[i], szModName,
                                       sizeof(szModName) / sizeof(WCHAR)))
            {
                // Print the module name and handle value.
                printf("\t%s (0x%08X)\n", wide_to_sjis(szModName).c_str(), hMods[i] );
            }
        	printf("\t\tBase=0x%08x Size=0x%08x EntryPoint=0x%08x\n", mi.lpBaseOfDll, mi.SizeOfImage, mi.EntryPoint);
        }
    }

	PeLdrInit(&peLdr);
	PeLdrSetExecutablePath(&peLdr, (wchar_t *)L"V:\\QtBuild\\#svn\\qt5.4.0\\#labo\\browser5.4.0\\release\\browser.exe");
	PeLdrStart(&peLdr);

	return 0;
}
