//#include <winnt.h>
#include <windows.h>
#include <stdio.h>
#include <lua.hpp>
#include <iostream>

int wmain(int argc, wchar_t *argv[])
{
	UNREFERENCED_PARAMETER(argc);
	UNREFERENCED_PARAMETER(argv);
	printf("this is wmain()\n");
	int iErr = 0;
	lua_State *lua = luaL_newstate (); // Open Lua
	//luaopen_io (lua); // Load io library
	luaL_openlibs(lua);

	if ((iErr = luaL_loadfile (lua, "hw.lua")) == 0)
	{
		std::cout<<"step1"<<std::endl;

		if ((iErr = lua_pcall (lua, 0, LUA_MULTRET, 0)) == 0)
		{ 
			std::cout<<"step2"<<std::endl;

			lua_getglobal (lua, "helloWorld");	// Push the function name onto the stack

			if (lua_type(lua, lua_gettop(lua)) == LUA_TNIL) {
				// if the global variable does not exist then we will bail out with an error.
				std::cout<<"global variable not found : helloworld"<<std::endl;

				/* error so we will just clear the Lua virtual stack and then return
if we do not clear the Lua stack, we leave garbage that will cause problems with later 
function calls from the application. we do this rather than use lua_error() because this function
is called from the application and not through Lua. */

				lua_settop (lua, 0);
				return -1;
			}		 

			// Function is located in the Global Table
			/* lua_gettable (lua, LUA_GLOBALSINDEX); */ //lua5.1
			lua_pcall (lua, 0, 0, 0);
		}
	}

	std::cout<<"iErr="<<iErr<<std::endl;

	lua_close (lua);

	return 0;
}
