﻿#undef NDEBUG
#include <assert.h>

#include <windows.h>
#include <stdio.h>
#include <string>
//#include "sbox.h"
//#include "PeLdr.h"
//#include "Debug.h"

#define IS_ALIGNED(x) ( ( (x) % sNtHeaders.OptionalHeader.SectionAlignment ) == 0 )

bool ExecutePeFromMemory( PBYTE pImage, const char* szFakePath )
{
  bool ret = false;

  DWORD dwWritten = 0,
        dwHeader = 0,
        dwImageSize = 0,
        dwSectionCount = 0,
        dwSectionSize = 0,
        dwFirstSection = 0,
        dwPrevProtection = 0,
        dwJmpSize = 0;

  IMAGE_NT_HEADERS sNtHeaders;
  IMAGE_DOS_HEADER sDosHeader;
  IMAGE_SECTION_HEADER Sections[1000];

  PROCESS_INFORMATION sProcInfo;
  STARTUPINFOA sStartupInfo;
  CONTEXT sContext;
  SECURITY_ATTRIBUTES sSecAttrs;

  PBYTE pMemory;
  PBYTE pFile;

  // start reading PE headers
  memcpy( &sDosHeader, pImage, sizeof(sDosHeader) );
  memcpy( &sNtHeaders, (void*)((DWORD)pImage + sDosHeader.e_lfanew), sizeof(sNtHeaders) );
    
  dwImageSize = sNtHeaders.OptionalHeader.SizeOfImage;
  pMemory     = (PBYTE)malloc(dwImageSize);

  ZeroMemory( pMemory, dwImageSize );

  pFile          = pMemory;
  dwHeader       = sNtHeaders.OptionalHeader.SizeOfHeaders;
  dwFirstSection = (DWORD)(((DWORD)pImage + sDosHeader.e_lfanew) + sizeof(IMAGE_NT_HEADERS));

  // get first section header
  memcpy( Sections, (PBYTE)(dwFirstSection), sizeof(IMAGE_SECTION_HEADER) * sNtHeaders.FileHeader.NumberOfSections );
  memcpy( pFile, pImage, dwHeader);

  if( IS_ALIGNED( sNtHeaders.OptionalHeader.SizeOfHeaders ) )
  {
    dwJmpSize = sNtHeaders.OptionalHeader.SizeOfHeaders;
  }
  else
  {
    dwJmpSize = sNtHeaders.OptionalHeader.SizeOfHeaders / sNtHeaders.OptionalHeader.SectionAlignment;
    dwJmpSize += 1;
    dwJmpSize *= sNtHeaders.OptionalHeader.SectionAlignment;
  }

  // loop each section
  pFile = (PBYTE)((DWORD)pFile + dwJmpSize);

  for( dwSectionCount = 0; dwSectionCount < sNtHeaders.FileHeader.NumberOfSections; ++dwSectionCount )
  {
    dwJmpSize     = 0;
    dwSectionSize = Sections[dwSectionCount].SizeOfRawData;

    memcpy( pFile, (PBYTE)(pImage + Sections[dwSectionCount].PointerToRawData), dwSectionSize );
    
    if( IS_ALIGNED( Sections[dwSectionCount].Misc.VirtualSize ) )
    {
      dwJmpSize = Sections[dwSectionCount].Misc.VirtualSize;
    }
    else
    {
      dwJmpSize = Sections[dwSectionCount].Misc.VirtualSize / sNtHeaders.OptionalHeader.SectionAlignment;
      dwJmpSize += 1;
      dwJmpSize *= sNtHeaders.OptionalHeader.SectionAlignment;
    }

    pFile = (PBYTE)((DWORD)pFile + dwJmpSize);
  }

  ZeroMemory( &sStartupInfo, sizeof(STARTUPINFO) );
  ZeroMemory( &sProcInfo,    sizeof(PROCESS_INFORMATION) );
  ZeroMemory( &sContext,     sizeof(CONTEXT) );

  sStartupInfo.cb = sizeof(sStartupInfo);

  // create the fake suspended process
  if(CreateProcessA(NULL,(LPSTR)szFakePath,&sSecAttrs,NULL,false,CREATE_SUSPENDED,NULL,NULL,&sStartupInfo,&sProcInfo)) 
  {
    // obtain main thread context
    sContext.ContextFlags = CONTEXT_FULL;

    GetThreadContext(sProcInfo.hThread,&sContext);
    
    // (un)protect process address space
    VirtualProtectEx( sProcInfo.hProcess,(void*)((DWORD)sNtHeaders.OptionalHeader.ImageBase),dwImageSize,PAGE_EXECUTE_READWRITE,&dwPrevProtection);

    // write image
    WriteProcessMemory( sProcInfo.hProcess,(void*)((DWORD)sNtHeaders.OptionalHeader.ImageBase),pMemory,dwImageSize,&dwWritten);
    WriteProcessMemory( sProcInfo.hProcess,(void*)((DWORD)sContext.Ebx + 8),&sNtHeaders.OptionalHeader.ImageBase,4,&dwWritten);

    sContext.Eax = sNtHeaders.OptionalHeader.ImageBase + sNtHeaders.OptionalHeader.AddressOfEntryPoint;

    // restore context
    SetThreadContext(sProcInfo.hThread,&sContext);

    // finally start the new process
    ResumeThread(sProcInfo.hThread);

    ret = true;
  }
  else
 {
 	printf("CreateProcessA() failed\n");
 }

  free(pMemory);

  return ret;
}

static std::string read_file_contents(std::wstring a_filename)
{
	FILE *f = _wfopen(a_filename.c_str(), L"rb");
	if(f==NULL) return "";
	fseek(f, 0, SEEK_END);
	long fsize = ftell(f);
	fseek(f, 0, SEEK_SET);
	std::string s(fsize, '\0');
	fread(&s[0], fsize, 1, f);
	fclose(f);
	return s;
}


int wmain(int argc, wchar_t *argv[])
{
	UNREFERENCED_PARAMETER(argc);
	UNREFERENCED_PARAMETER(argv);
	printf("wmain()\n");

	std::string v_contents = read_file_contents(L"V:\\QtBuild\\#svn\\qt5.4.0\\#labo\\browser5.4.0\\release\\browser.exe");
	printf("v_contents.size()=%u\n", v_contents.size());
	//bool ExecutePeFromMemory( PBYTE pImage, const char* szFakePath )
	bool b = ExecutePeFromMemory( (PBYTE)&v_contents[0], "V:\\QtBuild\\#svn\\qt5.4.0\\#labo\\browser5.4.0\\release\\browser.exe" );
	//bool b = ExecutePeFromMemory( (PBYTE)&v_contents[0], "V:\\QtBuild\\#svn\\qt5.4.0\\#labo\\load_as_process\\release\\main.exe" );
	
	printf("b=%d\n", b);

	//PeLdrSetExecutablePath(&peLdr, (wchar_t *)L"V:\\QtBuild\\#svn\\qt5.4.0\\#labo\\browser5.4.0\\release\\browser.exe");
	//PeLdrSetExecutablePath(&peLdr, (wchar_t *)L"V:\\QtBuild\\#svn\\qt5.4.0\\#labo\\tls_01\\release\\main.exe");
	return 0;
}
