﻿#include <windows.h>
#include <stdio.h>
#include <iostream>

#include <string>

namespace string {
    // multibyte to widechar
    void         encode(const std::string& codepage, const std::string& src, std::wstring& dst);
    std::wstring encode(const std::string& codepage, const std::string& src);

    // widechar to multibyte
    void         encode(const std::wstring& src, const std::string& codepage, std::string& dst);
    std::string  encode(const std::wstring& src, const std::string& codepage);

    // multibyte to multibyte
    void         encode(const std::string& codepageSrc, const std::string& src, const std::string& codepageDst, std::string& dst);
    std::string  encode(const std::string& codepageSrc, const std::string& src, const std::string& codepageDst);
}

//#include "encode.hpp"
#define U_STATIC_IMPLEMENTATION
#include <unicode/ucnv.h>
#include <vector>

// multibyte to widechar
void string::encode(const std::string& codepage, const std::string& src, std::wstring& dst)
{
    const icu::UnicodeString ustr(src.c_str(), src.size(), codepage.c_str());

    dst.assign(ustr.getBuffer(), ustr.getBuffer() + ustr.length());
}


std::wstring string::encode(const std::string& codepage, const std::string& src)
{
    std::wstring dst;

    encode(codepage, src, dst);

    return dst;
}


// widechar to multibyte
void string::encode(const std::wstring& src, const std::string& codepage, std::string& dst)
{
	printf("debug(1): src.size()=%d, %s\n", src.size(), codepage.c_str());
    const icu::UnicodeString ustr(src.c_str(), src.size());
	printf("debug(1.1): ustr.length()=%d\n", ustr.length());
    const int32_t            len = ustr.extract(0, ustr.length(), 0, codepage.c_str());
	printf("debug(1.2): len=%d\n", len);

    if (len > 0) {
		printf("debug(2)\n");
        std::vector<char> buf(len);

        ustr.extract(0, ustr.length(), &buf[0], buf.size(), codepage.c_str());
        dst.assign(buf.begin(), buf.end());
    }
    else {
		printf("debug(3)\n");
        dst.clear();
    }
}


std::string string::encode(const std::wstring& src, const std::string& codepage)
{
    std::string dst;

    encode(src, codepage, dst);

    return dst;
}


// multibyte to multibyte
void string::encode(const std::string& codepageSrc, const std::string& src, const std::string& codepageDst, std::string& dst)
{
    std::wstring intermediate;

    encode(codepageSrc, src, intermediate);
    encode(intermediate, codepageDst, dst);
}


std::string string::encode(const std::string& codepageSrc, const std::string& src, const std::string& codepageDst)
{
    std::string dst;

    encode(codepageSrc, src, codepageDst, dst);

    return dst;
}

int wmain(int argc, wchar_t *argv[])
{
	UNREFERENCED_PARAMETER(argc);
	UNREFERENCED_PARAMETER(argv);
	printf("this is wmain()\n");
	
	std::string s1 = string::encode(L"テスト", "shift_jis");
	printf("s1.length()=%d\n", s1.length());
	std::string s2 = string::encode(L"テスト", "cp932");
	printf("s2.length()=%d\n", s2.length());
    // widechar to multibyte
	std::cout << "(1)" << string::encode(L"テスト", "shift_jis") << std::endl; // utf16 to shift_jis
    // multibyte to multibyte
    std::cout << "(2)" << string::encode("utf8", "\xE3\x83\x86\xE3\x82\xB9\xE3\x83\x88", "shift_jis") << std::endl; // utf8 to shift_jis

	return 0;
}
