﻿#ifndef _WIN32_VECTOR_H_
#define _WIN32_VECTOR_H_

#include <windows.h>

#ifdef __cplusplus
extern "C" {
#endif
	/* char vector */
	void   win32_thread_char_clear(char **vector);
	DWORD  win32_thread_char_size(char **vector);
	void   win32_thread_char_resize(char **vector, DWORD size);
	void   win32_thread_char_reserve(char **vector, DWORD size);
	char   win32_thread_char_get(char **vector, DWORD pos);
	void   win32_thread_char_set(char **vector, DWORD pos, char val);
	void   win32_thread_char_push_back(char **vector, char val);
	char   win32_thread_char_erase(char **vector, DWORD pos);
	void   win32_thread_char_insert(char **vector, DWORD pos, char val);
	/* wchar_t vector */
	void    win32_thread_wchar_clear(wchar_t **vector);
	DWORD   win32_thread_wchar_size(wchar_t **vector);
	void    win32_thread_wchar_resize(wchar_t **vector, DWORD size);
	void    win32_thread_wchar_reserve(wchar_t **vector, DWORD size);
	wchar_t win32_thread_wchar_get(wchar_t **vector, DWORD pos);
	void    win32_thread_wchar_set(wchar_t **vector, DWORD pos, wchar_t val);
	void    win32_thread_wchar_push_back(wchar_t **vector, wchar_t val);
	wchar_t win32_thread_wchar_erase(wchar_t **vector, DWORD pos);
	void    win32_thread_wchar_insert(wchar_t **vector, DWORD pos, wchar_t val);
#ifdef __cplusplus
}
#endif

#ifdef __cplusplus // ***** C++ only *****
#endif /* __cplusplus */

#endif /* _WIN32_VECTOR_H_ */
