﻿#undef NDEBUG
#include <assert.h>

#include "win32_vector.h"
#include "win32.h"
#include "win32_print.h"
#include <stdint.h>

#define DBG(format, ...) win32_errorfA("[WIN32_VECTOR] " format "\n", ## __VA_ARGS__)

/* extern */
void   win32_thread_char_clear(char **vector)
{
	win32_thread_vector_resize(sizeof(**vector), (char **)vector, 0);
}

/* extern */
DWORD   win32_thread_char_size(char **vector)
{
	return win32_thread_vector_size(sizeof(**vector), (char **)vector);
}

/* extern */
void   win32_thread_char_resize(char **vector, DWORD size)
{
	win32_thread_vector_resize(sizeof(**vector), (char **)vector, size);
}

/* extern */
void   win32_thread_char_reserve(char **vector, DWORD size)
{
	win32_thread_vector_reserve(sizeof(**vector), (char **)vector, size);
}

/* extern */
char   win32_thread_char_get(char **vector, DWORD pos)
{
	char val;
	win32_thread_vector_get(sizeof(**vector), (char **)vector, pos, (char *)&val);
	return val;
}

/* extern */
void   win32_thread_char_set(char **vector, DWORD pos, char val)
{
	win32_thread_vector_set(sizeof(**vector), (char **)vector, pos, (char *)&val);
}

/* extern */
void   win32_thread_char_push_back(char **vector, char val)
{
	win32_thread_vector_push_back(sizeof(**vector), (char **)vector, (char *)&val);
}

/* extern */
char   win32_thread_char_erase(char **vector, DWORD pos)
{
	char val;
	win32_thread_vector_erase(sizeof(**vector), (char **)vector, pos, (char *)&val);
	return val;
}

/* extern */
void   win32_thread_char_insert(char **vector, DWORD pos, char val)
{
	win32_thread_vector_insert(sizeof(**vector), (char **)vector, pos, (char *)&val);
}

/* extern */
void    win32_thread_wchar_clear(wchar_t **vector)
{
	win32_thread_vector_clear(sizeof(**vector), (char **)vector);
}

/* extern */
DWORD   win32_thread_wchar_size(wchar_t **vector)
{
	return win32_thread_vector_size(sizeof(**vector), (char **)vector);
}

/* extern */
void    win32_thread_wchar_resize(wchar_t **vector, DWORD size)
{
	win32_thread_vector_resize(sizeof(**vector), (char **)vector, size);
}

/* extern */
void    win32_thread_wchar_reserve(wchar_t **vector, DWORD size)
{
	win32_thread_vector_reserve(sizeof(**vector), (char **)vector, size);
}

/* extern */
wchar_t win32_thread_wchar_get(wchar_t **vector, DWORD pos)
{
	wchar_t val;
	win32_thread_vector_get(sizeof(**vector), (char **)vector, pos, (char *)&val);
	return val;
}

/* extern */
void    win32_thread_wchar_set(wchar_t **vector, DWORD pos, wchar_t val)
{
	win32_thread_vector_set(sizeof(**vector), (char **)vector, pos, (char *)&val);
}

/* extern */
void    win32_thread_wchar_push_back(wchar_t **vector, wchar_t val)
{
	win32_thread_vector_push_back(sizeof(**vector), (char **)vector, (char *)&val);
}

/* extern */
wchar_t win32_thread_wchar_erase(wchar_t **vector, DWORD pos)
{
	wchar_t val;
	win32_thread_vector_erase(sizeof(**vector), (char **)vector, pos, (char *)&val);
	return val;
}

/* extern */
void    win32_thread_wchar_insert(wchar_t **vector, DWORD pos, wchar_t val)
{
	win32_thread_vector_insert(sizeof(**vector), (char **)vector, pos, (char *)&val);
}
