﻿#undef NDEBUG

#include "sbox_print.h"
#include <windows.h>
#include <stdio.h>
#include <assert.h>
#include "tlsdecl.h"

#include <string>
#include <vector>

#define SBOX_PRINT_SYNC_ENTER_CSECT 1
#define SBOX_PRINT_SYNC_LEAVE_CSECT 0

class SBOX_PRINT_BUFFER
{
public:
	std::wstring f_buffer;
	//std::vector<unsigned char> f_byte_vector;
	explicit SBOX_PRINT_BUFFER()
	{
		//sync_printf("SBOX_PRINT_BUFFER created\n");
		f_buffer.reserve(256);
		//f_byte_vector.reserve(1025);
	}
	virtual ~SBOX_PRINT_BUFFER()
	{
		//sync_printf("SBOX_PRINT_BUFFER deleted\n");
	}
};
static TLS_VARIABLE_DECL SBOX_PRINT_BUFFER *l_sbox_print_buffer = NULL;

/* for debug */
static void sync_puts(const char* s)
{
	HANDLE hStdOutput;
	hStdOutput = GetStdHandle(STD_OUTPUT_HANDLE);
	DWORD dwWriteByte;
	WriteConsoleA(hStdOutput, s, lstrlenA(s), &dwWriteByte, NULL);
	WriteConsoleA(hStdOutput, "\n", 1, &dwWriteByte, NULL);
	return;
}

static void sync_enter_or_leave(DWORD dwEnterOrLeave)
{
	//sync_puts("sync_enter_or_leave(1)");
	//static SBOX_PRINT_CSECT l_print_crit_sec; //N.G.
	static bool s_initialized = false;
	static CRITICAL_SECTION s_crit_sec;
	if(!s_initialized)
	{
		InitializeCriticalSection(&s_crit_sec);
		s_initialized = true;
	}
	switch(dwEnterOrLeave)
	{
	case SBOX_PRINT_SYNC_ENTER_CSECT:
		//l_print_crit_sec.enter();
		EnterCriticalSection(&s_crit_sec);
		break;
	case SBOX_PRINT_SYNC_LEAVE_CSECT:
		//l_print_crit_sec.leave();
		LeaveCriticalSection(&s_crit_sec);
		break;
	default:
		assert(0);
		break;
	}
	//sync_puts("sync_enter_or_leave(end)");
	return;
}

/* extern */
int sync_printf(const char *format, ...)
{
	//sync_puts("sync_printf(1)");
	sync_enter_or_leave(SBOX_PRINT_SYNC_ENTER_CSECT);
	va_list args;
	va_start(args, format);
	char v_buffer[1024+1];
	//sync_puts("sync_printf(2)");
	wvsprintfA((LPSTR)v_buffer, format, args); // Win32 API
	HANDLE hStdOutput;
	hStdOutput = GetStdHandle(STD_OUTPUT_HANDLE);
	DWORD dwWriteByte;
	WriteConsoleA(hStdOutput, v_buffer, lstrlenA(v_buffer), &dwWriteByte, NULL);
	//sync_puts("sync_printf(3)");
    va_end(args);
	sync_enter_or_leave(SBOX_PRINT_SYNC_LEAVE_CSECT);
	//sync_puts("sync_printf(end)");
	return dwWriteByte;
}

static std::wstring wstring_printf_body(size_t max_length, const wchar_t *format, va_list argptr)
{
	if(l_sbox_print_buffer==NULL) l_sbox_print_buffer = new SBOX_PRINT_BUFFER();
	if(l_sbox_print_buffer->f_buffer.size() < (max_length+1)) l_sbox_print_buffer->f_buffer.resize(max_length+1);
	assert(sizeof(l_sbox_print_buffer->f_buffer[0])==sizeof(wchar_t));
	memset(&l_sbox_print_buffer->f_buffer[0], 0, sizeof(l_sbox_print_buffer->f_buffer[0]) * (max_length+1));
	/*int print_len =*/ _vsnwprintf(&l_sbox_print_buffer->f_buffer[0], max_length, format, argptr);
	return l_sbox_print_buffer->f_buffer.c_str();
}

/* extern */
std::wstring wstring_printf(size_t max_length, const wchar_t *format, ...)
{
	va_list args;
	va_start(args, format);
	std::wstring ret = wstring_printf_body(max_length, format, args);
	va_end(args);
	return ret;
}

/* extern */
std::wstring wstring_printf(const wchar_t *format, ...)
{
	va_list args;
	va_start(args, format);
	std::wstring ret = wstring_printf_body(1024, format, args);
	va_end(args);
	return ret;
}

static void NTAPI sbox_print_callback(PVOID hModule, DWORD dwReason, PVOID lpReserved)
{
	UNREFERENCED_PARAMETER(hModule);
	UNREFERENCED_PARAMETER(lpReserved);
	//sync_fprintf(stderr, "sbox_print_callback(): dwReason=0x%08x\n", dwReason);
	switch(dwReason){
	case DLL_PROCESS_ATTACH:
	case DLL_THREAD_ATTACH:
		break;
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		if(l_sbox_print_buffer)
		{
			delete l_sbox_print_buffer;
			l_sbox_print_buffer = NULL;
		}
		break;
	default:
		break;
	}
}
TLS_CALLBACK_DECL(".CRT$XLB", __sbox_print_callback__, sbox_print_callback);
