﻿#undef NDEBUG

#include "sbox_print.h"
#include <windows.h>
#include <stdio.h>
#include <assert.h>
#include "tlsdecl.h"

#define SBOX_PRINT_SYNC_ENTER_CSECT 1
#define SBOX_PRINT_SYNC_LEAVE_CSECT 0

class SBOX_PRINT_CSECT
{
private:
	CRITICAL_SECTION f_crit_sec;
public:
	explicit SBOX_PRINT_CSECT()
	{
		InitializeCriticalSection(&f_crit_sec);
		//printf("SBOX_PRINT_CSECT created\n"); // DO NOT USE sync_printf(), sync_frintf() HERE
	}
	virtual ~SBOX_PRINT_CSECT()
	{
		DeleteCriticalSection(&f_crit_sec);
		//printf("SBOX_PRINT_CSECT deleted\n"); // DO NOT USE sync_printf(), sync_frintf() HERE
	}
	void enter()
	{
		EnterCriticalSection(&f_crit_sec);
	}
	void leave()
	{
		LeaveCriticalSection(&f_crit_sec);
	}
};

static void sync_enter_or_leave(DWORD dwEnterOrLeave)
{
	static SBOX_PRINT_CSECT l_print_crit_sec;
	switch(dwEnterOrLeave)
	{
	case SBOX_PRINT_SYNC_ENTER_CSECT:
		l_print_crit_sec.enter();
		break;
	case SBOX_PRINT_SYNC_LEAVE_CSECT:
		l_print_crit_sec.leave();
		break;
	default:
		assert(0);
		break;
	}
}

/* extern */
int sync_printf(const char *format, ...)
{
    va_list args;
    va_start(args, format);
	sync_enter_or_leave(SBOX_PRINT_SYNC_ENTER_CSECT);
    int ret = vprintf(format, args);
	fflush(stdout);
	sync_enter_or_leave(SBOX_PRINT_SYNC_LEAVE_CSECT);
    va_end(args);
	return ret;
}

/* extern */
int sync_fprintf(FILE *stream, const char *format, ...)
{
    va_list args;
    va_start(args, format);
	sync_enter_or_leave(SBOX_PRINT_SYNC_ENTER_CSECT);
    int ret = vfprintf(stream, format, args);
	fflush(stream);
	sync_enter_or_leave(SBOX_PRINT_SYNC_LEAVE_CSECT);
    va_end(args);
	return ret;
}

class SBOX_PRINT_BUFFER
{
public:
	std::wstring f_buffer;
	explicit SBOX_PRINT_BUFFER()
	{
		//sync_fprintf(stderr, "SBOX_PRINT_BUFFER created\n");
		f_buffer.reserve(256);
	}
	virtual ~SBOX_PRINT_BUFFER()
	{
		//sync_fprintf(stderr, "SBOX_PRINT_BUFFER deleted\n");
	}
};

static TLS_VARIABLE_DECL SBOX_PRINT_BUFFER *l_sbox_print_buffer = NULL;

static std::wstring wstring_printf_body(size_t max_length, const wchar_t *format, va_list argptr)
{
	if(l_sbox_print_buffer==NULL) l_sbox_print_buffer = new SBOX_PRINT_BUFFER();
	if(l_sbox_print_buffer->f_buffer.size() < (max_length+1)) l_sbox_print_buffer->f_buffer.resize(max_length+1);
	assert(sizeof(l_sbox_print_buffer->f_buffer[0])==sizeof(wchar_t));
	memset(&l_sbox_print_buffer->f_buffer[0], 0, sizeof(l_sbox_print_buffer->f_buffer[0]) * (max_length+1));
	/*int print_len =*/ _vsnwprintf(&l_sbox_print_buffer->f_buffer[0], max_length, format, argptr);
	return l_sbox_print_buffer->f_buffer.c_str();
}

/* extern */
std::wstring wstring_printf(size_t max_length, const wchar_t *format, ...)
{
	va_list args;
	va_start(args, format);
	std::wstring ret = wstring_printf_body(max_length, format, args);
	va_end(args);
	return ret;
}

/* extern */
std::wstring wstring_printf(const wchar_t *format, ...)
{
	va_list args;
	va_start(args, format);
	std::wstring ret = wstring_printf_body(1024, format, args);
	va_end(args);
	return ret;
}

static void NTAPI sbox_print_callback(PVOID hModule, DWORD dwReason, PVOID lpReserved)
{
	UNREFERENCED_PARAMETER(hModule);
	UNREFERENCED_PARAMETER(lpReserved);
	//sync_fprintf(stderr, "sbox_print_callback(): dwReason=0x%08x\n", dwReason);
	switch(dwReason){
	case DLL_PROCESS_ATTACH:
	case DLL_THREAD_ATTACH:
		break;
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		if(l_sbox_print_buffer)
		{
			delete l_sbox_print_buffer;
			l_sbox_print_buffer = NULL;
		}
		break;
	default:
		break;
	}
}
TLS_CALLBACK_DECL(".CRT$XLB", __sbox_print_callback__, sbox_print_callback);
