TARGET = browser
TEMPLATE = app
CONFIG += console
QT += webkitwidgets network widgets printsupport

qtHaveModule(uitools):!embedded: QT += uitools
else: DEFINES += QT_NO_UITOOLS

msvc {
  #QMAKE_LFLAGS -= /DYNAMICBASE /NXCOMPAT
  #QMAKE_LFLAGS -= /NXCOMPAT
  QMAKE_LFLAGS -= /DYNAMICBASE /NXCOMPAT
  QMAKE_LFLAGS += /FIXED /BASE:0x66000000
}
gcc {
  QMAKE_LFLAGS += -Wl,--image-base=0x66000000
}


FORMS += \
    addbookmarkdialog.ui \
    bookmarks.ui \
    cookies.ui \
    cookiesexceptions.ui \
    downloaditem.ui \
    downloads.ui \
    history.ui \
    passworddialog.ui \
    proxy.ui \
    settings.ui

HEADERS += \
    autosaver.h \
    bookmarks.h \
    browserapplication.h \
    browsermainwindow.h \
    chasewidget.h \
    cookiejar.h \
    downloadmanager.h \
    edittableview.h \
    edittreeview.h \
    history.h \
    modelmenu.h \
    networkaccessmanager.h \
    searchlineedit.h \
    settings.h \
    squeezelabel.h \
    tabwidget.h \
    toolbarsearch.h \
    urllineedit.h \
    webview.h \
    xbel.h

SOURCES += \
    autosaver.cpp \
    bookmarks.cpp \
    browserapplication.cpp \
    browsermainwindow.cpp \
    chasewidget.cpp \
    cookiejar.cpp \
    downloadmanager.cpp \
    edittableview.cpp \
    edittreeview.cpp \
    history.cpp \
    modelmenu.cpp \
    networkaccessmanager.cpp \
    searchlineedit.cpp \
    settings.cpp \
    squeezelabel.cpp \
    tabwidget.cpp \
    toolbarsearch.cpp \
    urllineedit.cpp \
    webview.cpp \
    xbel.cpp \
    main.cpp

RESOURCES += data/data.qrc htmls/htmls.qrc

build_all:!build_pass {
    CONFIG -= build_all
    CONFIG += release
}

win32 {
   RC_FILE = browser.rc
}

mac {
    ICON = browser.icns
    QMAKE_INFO_PLIST = Info_mac.plist
    TARGET = Browser

    # No 64-bit Flash on Mac, so build the browser 32-bit
    contains(QT_CONFIG, x86) {
        CONFIG -= x86_64
        CONFIG += x86
    }
    contains(QT_CONFIG, ppc) {
        CONFIG -= ppc64
        CONFIG += ppc
    }
}

wince*: {
    DEPLOYMENT_PLUGIN += qjpeg qgif
}

EXAMPLE_FILES = Info_mac.plist browser.icns browser.ico browser.rc

# install
target.path = $$[QT_INSTALL_EXAMPLES]/webkitwidgets/browser
INSTALLS += target
