﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Text.RegularExpressions;

namespace JCLEmulator
{
    class regx
    {
        public static string[] getMathers(string targetString,string regxString)
        {
            Regex r = new Regex(regxString, RegexOptions.IgnoreCase);
            return r.Matches(targetString).Cast<Match>().Select(m => m.Value).ToArray();
        }
    }

    static class regxConst
    {
        public const string execPGMKey = @"//[\w\*%\&\.]+\s+EXEC\s+(PGM.*)";
        public const string execPROCKey = @"//[\w\*%\&\.]+\s+EXEC\s+(PROC.*)";
        public const string procKey = @"//[\w\*%\&\.]+\s+PROC\s+(.*)";
        public const string ddKey = @"//[\w\*%\&\.]+\s+DD\s+(.*)";
        public const string setValueKey = @"//[\w\*%\&\.]+\s+SETVAR\s+(.*)";
        public const string setKey = @"//[\w\*%\&\.]+\s+SET\s+(.*)";
        public const string jobKey = @"//[\w\*%\&\.]+\s+JOB\s+(.*)";
        public const string nextstep = @"//\s+(.*)";

        public const string splitvalue = @"\w+=";

    }
}
