/*
 * Decompiled with CFR 0.152.
 */
package webScraping.utility;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import webScraping.core.HtmlParser;
import webScraping.core.SearchData;
import webScraping.utility.SearchDataRW;
import webScraping.utility.SearchDataTableModel;

public class HtmlSearch
extends JFrame {
    private final SearchDataRW sio = new SearchDataRW();
    SearchDataTableModel sdatatblmodel = new SearchDataTableModel();
    private JButton jBtnRowCpy;
    private JButton jBtnRowDel;
    private JButton jBtnRowIns;
    private JButton jBtnSearch;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuLoad;
    private JMenuItem jMenuSave;
    private JPanel jPanelRtn;
    private JPanel jPanelTab1;
    private JPanel jPanelTab2;
    private JRadioButton jRadioButton1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane404msg;
    private JScrollPane jScrollPaneLabel;
    private JScrollPane jScrollPaneRtn;
    private JTabbedPane jTabbedPane1;
    private JTable jTable1;
    private JTextArea jTxt404msg;
    private JTextArea jTxtLabel;
    private JTextArea jTxtRtn;
    private JTextField jTxtUrl;

    public HtmlSearch() {
        this.initComponents();
        String dir = System.getProperty("user.dir");
        File file = new File(dir + "\\data");
        this.jFileChooser1.setCurrentDirectory(file);
        FileNameExtensionFilter filter1 = new FileNameExtensionFilter("XML\u30d5\u30a1\u30a4\u30eb", "xml");
        FileNameExtensionFilter filter2 = new FileNameExtensionFilter("TEXT\u30d5\u30a1\u30a4\u30eb", "txt");
        this.jFileChooser1.addChoosableFileFilter(filter1);
        this.jFileChooser1.addChoosableFileFilter(filter2);
        this.jFileChooser1.setFileFilter(filter1);
    }

    private void initComponents() {
        this.jFileChooser1 = new JFileChooser();
        this.jRadioButton1 = new JRadioButton();
        this.jLabel1 = new JLabel();
        this.jTxtUrl = new JTextField();
        this.jBtnSearch = new JButton();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanelTab1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jBtnRowIns = new JButton();
        this.jBtnRowDel = new JButton();
        this.jBtnRowCpy = new JButton();
        this.jPanelTab2 = new JPanel();
        this.jScrollPaneLabel = new JScrollPane();
        this.jTxtLabel = new JTextArea();
        this.jScrollPane404msg = new JScrollPane();
        this.jTxt404msg = new JTextArea();
        this.jPanelRtn = new JPanel();
        this.jScrollPaneRtn = new JScrollPane();
        this.jTxtRtn = new JTextArea();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuLoad = new JMenuItem();
        this.jMenuSave = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jFileChooser1.setCurrentDirectory(null);
        this.jFileChooser1.setDialogTitle("");
        this.jRadioButton1.setText("jRadioButton1");
        this.setDefaultCloseOperation(3);
        this.setTitle("\u30bf\u30b0\u691c\u7d22");
        this.jLabel1.setText(" URL:");
        this.jBtnSearch.setText("\u691c\u7d22");
        this.jBtnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlSearch.this.jBtnSearchActionPerformed(evt);
            }
        });
        this.jPanelTab1.setBorder(BorderFactory.createTitledBorder("\u691c\u7d22\u60c5\u5831"));
        this.jTable1.setModel(this.sdatatblmodel);
        this.jTable1.setSelectionMode(0);
        this.jTable1.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jBtnRowIns.setText("\u884c\u633f\u5165");
        this.jBtnRowIns.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlSearch.this.jBtnRowInsActionPerformed(evt);
            }
        });
        this.jBtnRowDel.setText("\u884c\u524a\u9664");
        this.jBtnRowDel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlSearch.this.jBtnRowDelActionPerformed(evt);
            }
        });
        this.jBtnRowCpy.setText("\u884c\u30b3\u30d4\u30fc");
        this.jBtnRowCpy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlSearch.this.jBtnRowCpyActionPerformed(evt);
            }
        });
        GroupLayout jPanelTab1Layout = new GroupLayout(this.jPanelTab1);
        this.jPanelTab1.setLayout(jPanelTab1Layout);
        jPanelTab1Layout.setHorizontalGroup(jPanelTab1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTab1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jBtnRowCpy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBtnRowDel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBtnRowIns)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE));
        jPanelTab1Layout.setVerticalGroup(jPanelTab1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTab1Layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 173, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelTab1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBtnRowDel).addComponent(this.jBtnRowIns).addComponent(this.jBtnRowCpy))));
        this.jTabbedPane1.addTab("\u30ad\u30fc\u8a2d\u5b9a", this.jPanelTab1);
        this.jPanelTab2.setBorder(BorderFactory.createTitledBorder("\u30e1\u30c3\u30bb\u30fc\u30b8"));
        this.jScrollPaneLabel.setHorizontalScrollBarPolicy(31);
        this.jScrollPaneLabel.setVerticalScrollBarPolicy(21);
        this.jTxtLabel.setEditable(false);
        this.jTxtLabel.setBackground(Color.lightGray);
        this.jTxtLabel.setColumns(20);
        this.jTxtLabel.setFont(new Font("MS UI Gothic", 0, 12));
        this.jTxtLabel.setLineWrap(true);
        this.jTxtLabel.setRows(2);
        this.jTxtLabel.setText("\u53d6\u5f97\u30da\u30fc\u30b8\u306b\u4ee5\u4e0b\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u304c\u542b\u307e\u308c\u3066\u3044\u305f\u5834\u5408\u3001\u5bfe\u8c61\u30c7\u30fc\u30bf\u304c\u53d6\u5f97\u51fa\u6765\u306a\u304b\u3063\u305f\u3068\u901a\u77e5\u3057\u307e\u3059\u3002");
        this.jTxtLabel.setAutoscrolls(false);
        this.jTxtLabel.setBorder(null);
        this.jTxtLabel.setCursor(new Cursor(0));
        this.jTxtLabel.setFocusable(false);
        this.jTxtLabel.setHighlighter(null);
        this.jTxtLabel.setKeymap(null);
        this.jTxtLabel.setOpaque(false);
        this.jTxtLabel.setRequestFocusEnabled(false);
        this.jTxtLabel.setVerifyInputWhenFocusTarget(false);
        this.jScrollPaneLabel.setViewportView(this.jTxtLabel);
        this.jTxt404msg.setColumns(20);
        this.jTxt404msg.setRows(3);
        this.jTxt404msg.setText("\u4e00\u81f4\u3059\u308b\u9298\u67c4\u306f\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3067\u3057\u305f\n");
        this.jScrollPane404msg.setViewportView(this.jTxt404msg);
        GroupLayout jPanelTab2Layout = new GroupLayout(this.jPanelTab2);
        this.jPanelTab2.setLayout(jPanelTab2Layout);
        jPanelTab2Layout.setHorizontalGroup(jPanelTab2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane404msg).addGroup(GroupLayout.Alignment.TRAILING, jPanelTab2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneLabel, -1, 359, Short.MAX_VALUE).addContainerGap()));
        jPanelTab2Layout.setVerticalGroup(jPanelTab2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelTab2Layout.createSequentialGroup().addComponent(this.jScrollPaneLabel, -2, 38, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane404msg)));
        this.jTabbedPane1.addTab("\u7d50\u679c\u7121\u3057\u5224\u5b9a", this.jPanelTab2);
        this.jPanelRtn.setBorder(BorderFactory.createTitledBorder("\u691c\u7d22\u7d50\u679c"));
        this.jTxtRtn.setColumns(20);
        this.jTxtRtn.setRows(5);
        this.jScrollPaneRtn.setViewportView(this.jTxtRtn);
        GroupLayout jPanelRtnLayout = new GroupLayout(this.jPanelRtn);
        this.jPanelRtn.setLayout(jPanelRtnLayout);
        jPanelRtnLayout.setHorizontalGroup(jPanelRtnLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneRtn));
        jPanelRtnLayout.setVerticalGroup(jPanelRtnLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneRtn, -1, 163, Short.MAX_VALUE));
        this.jMenu1.setText("\u30d5\u30a1\u30a4\u30eb");
        this.jMenuLoad.setText("LOAD");
        this.jMenuLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlSearch.this.jMenuLoadActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuLoad);
        this.jMenuSave.setText("SAVE");
        this.jMenuSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlSearch.this.jMenuSaveActionPerformed(evt);
            }
        });
        this.jMenu1.add(this.jMenuSave);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu3.setText("\u30c4\u30fc\u30eb");
        this.jMenuItem1.setText("\u30d6\u30e9\u30a6\u30b6\u3067\u8868\u793a");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HtmlSearch.this.jMenuItem1ActionPerformed(evt);
            }
        });
        this.jMenu3.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu3);
        this.jMenu2.setText("\u691c\u7d22");
        this.jMenu2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                HtmlSearch.this.jMenu2MouseClicked(evt);
            }
        });
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelRtn, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTxtUrl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jBtnSearch)).addComponent(this.jTabbedPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jTxtUrl, -2, -1, -2).addComponent(this.jBtnSearch)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1, -2, 250, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelRtn, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void jBtnRowInsActionPerformed(ActionEvent evt) {
        int SelectedRow = this.jTable1.getSelectedRow();
        SearchData sdata = new SearchData();
        if (SelectedRow >= 0) {
            this.sdatatblmodel.insertRow(SelectedRow, sdata);
        } else {
            this.sdatatblmodel.addRow(sdata);
        }
    }

    private void jBtnRowDelActionPerformed(ActionEvent evt) {
        int SelectedRow = this.jTable1.getSelectedRow();
        if (SelectedRow >= 0) {
            this.sdatatblmodel.removeRow(SelectedRow);
        }
    }

    private void jMenuLoadActionPerformed(ActionEvent evt) {
        this.jFileChooser1.setDialogTitle("\u8aad\u8fbc");
        int selected = this.jFileChooser1.showOpenDialog(this);
        if (selected == 0) {
            File file = this.jFileChooser1.getSelectedFile();
            this.sio.load(file);
            this.jTxtUrl.setText(this.sio.geturl());
            this.sdatatblmodel.setRowCount(0);
            for (int i = 0; i < SearchData.size(); ++i) {
                SearchData sdata = SearchData.get(i);
                this.sdatatblmodel.addRow(sdata);
            }
        }
    }

    private void jMenuSaveActionPerformed(ActionEvent evt) {
        this.jFileChooser1.setDialogTitle("\u4fdd\u5b58");
        int selected = this.jFileChooser1.showSaveDialog(this);
        if (selected == 0) {
            File file = this.jFileChooser1.getSelectedFile();
            this.sio.seturl(this.jTxtUrl.getText());
            SearchData.clear();
            for (int row = 0; row < this.sdatatblmodel.getRowCount(); ++row) {
                SearchData sdata = this.sdatatblmodel.getSearchData(row);
                SearchData.add(sdata);
            }
            this.sio.save(file);
        }
    }

    private void jBtnRowCpyActionPerformed(ActionEvent evt) {
        int SelectedRow = this.jTable1.getSelectedRow();
        if (SelectedRow >= 0) {
            SearchData sdata = this.sdatatblmodel.getSearchData(SelectedRow);
            this.sdatatblmodel.insertRow(SelectedRow, sdata);
        }
    }

    private void jMenuItem1ActionPerformed(ActionEvent evt) {
        Desktop desktop = Desktop.getDesktop();
        String uriString = this.jTxtUrl.getText();
        try {
            URI uri = new URI(uriString);
            desktop.browse(uri);
        }
        catch (IOException | URISyntaxException ex) {
            Logger.getLogger(HtmlSearch.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void jMenu2MouseClicked(MouseEvent evt) {
        this.Search_execution();
    }

    private void jBtnSearchActionPerformed(ActionEvent evt) {
        this.Search_execution();
    }

    void Search_execution() {
        String[] strsearch;
        this.jTxtRtn.setText(null);
        HtmlParser par = new HtmlParser(this.jTxtUrl.getText());
        String strdata = par.getStringPageData();
        if (strdata == null) {
            this.jTxtRtn.append("\u8aad\u8fbc\u307f\u30da\u30fc\u30b8\u304c\u3042\u308a\u307e\u305b\u3093");
            return;
        }
        String text = this.jTxt404msg.getText();
        for (String strsearch1 : strsearch = text.split("\n")) {
            if (!strdata.contains(strsearch1)) continue;
            this.jTxtRtn.append(strsearch1);
            return;
        }
        for (int row = 0; row < this.sdatatblmodel.getRowCount(); ++row) {
            SearchData sdata = this.sdatatblmodel.getSearchData(row);
            String ans = sdata.getitem();
            String rtn = par.search(sdata);
            this.jTxtRtn.append(ans + "\t" + rtn + "\n");
        }
        this.jTxtRtn.setCaretPosition(0);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            Logger.getLogger(HtmlSearch.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new HtmlSearch().setVisible(true);
            }
        });
    }
}

