/*
 * Decompiled with CFR 0.152.
 */
package webScraping.core;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.html.parser.ParserDelegator;
import webScraping.core.DebugProcess;
import webScraping.core.HtmlParserCallback;
import webScraping.core.SearchData;

public class HtmlParser {
    URL url;
    String pageData;
    ArrayList sData;
    String htmltag;
    String htmlid;
    String htmlclass;

    public HtmlParser(URL UrlAdress) {
        DebugProcess.debuglog_set();
        this.url = UrlAdress;
        this.getPageData();
    }

    public HtmlParser(String UrlAdress) {
        DebugProcess.debuglog_set();
        try {
            this.url = new URL(UrlAdress);
            this.getPageData();
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(HtmlParser.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public HtmlParser() {
        DebugProcess.debuglog_set();
        this.url = null;
    }

    public String getStringPageData() {
        return this.pageData;
    }

    public void seturl(URL UrlAdress) {
        this.url = UrlAdress;
        this.getPageData();
    }

    public void seturl(String UrlAdress) {
        try {
            this.url = new URL(UrlAdress);
            this.getPageData();
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(HtmlParser.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public String search(SearchData skey) {
        if (!this.isHtmlkeyEq(skey)) {
            this.searchPageData(skey);
        }
        String regexp = skey.getregexp();
        if (skey.getaround().length() > 0) {
            int wkAround = Integer.parseInt(skey.getaround());
            if (wkAround < this.sData.size()) {
                String str = (String)this.sData.get(wkAround);
                String rtn = this.RegularExpression(str, regexp);
                return rtn;
            }
        } else {
            StringBuilder strbuf = new StringBuilder();
            for (Object sData1 : this.sData) {
                String str = (String)sData1;
                String rtn = this.RegularExpression(str, regexp);
                if (strbuf.length() > 0) {
                    strbuf.append("\t");
                }
                strbuf.append(rtn);
            }
            return strbuf.toString();
        }
        return null;
    }

    boolean isHtmlkeyEq(SearchData skey) {
        String stag = skey.getHtmltag();
        String sid = skey.getHtmlid();
        String sclass = skey.getHtmlclass();
        boolean rtn = true;
        if (this.htmltag == null) {
            rtn = false;
        } else if (!this.htmltag.equals(stag)) {
            rtn = false;
        }
        if (this.htmlid == null) {
            rtn = false;
        } else if (!this.htmlid.equals(sid)) {
            rtn = false;
        }
        if (this.htmlclass == null) {
            rtn = false;
        } else if (!this.htmlclass.equals(sclass)) {
            rtn = false;
        }
        if (!rtn) {
            this.htmltag = stag;
            this.htmlid = sid;
            this.htmlclass = sclass;
        }
        return rtn;
    }

    String RegularExpression(String strdata, String regexp) {
        String expdata = null;
        if (regexp.isEmpty()) {
            expdata = strdata;
            return expdata;
        }
        Pattern ptn = Pattern.compile(regexp);
        Matcher matchdata = ptn.matcher(strdata);
        if (matchdata.find() && matchdata.groupCount() >= 1) {
            expdata = matchdata.group(1);
        }
        return expdata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPageData() {
        HttpURLConnection con = null;
        try {
            String wkline;
            con = (HttpURLConnection)this.url.openConnection();
            con.setRequestMethod("GET");
            BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream(), "utf-8"));
            StringBuilder sb = new StringBuilder();
            while ((wkline = reader.readLine()) != null) {
                sb.append(wkline).append("\n");
            }
            this.pageData = sb.toString();
        }
        catch (FileNotFoundException ex) {
            this.pageData = null;
        }
        catch (IOException ex) {
            Logger.getLogger(HtmlParser.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    private void searchPageData(SearchData skey) {
        DebugProcess.searchDatainfo(skey);
        try {
            BufferedReader reader = new BufferedReader(new StringReader(this.pageData));
            HtmlParserCallback cb = new HtmlParserCallback(skey);
            ParserDelegator pd = new ParserDelegator();
            pd.parse(reader, cb, true);
            ((Reader)reader).close();
            this.sData = cb.getrtnData();
        }
        catch (IOException ex) {
            Logger.getLogger(HtmlParser.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

