/*
 * Decompiled with CFR 0.152.
 */
package webScraping.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import webScraping.core.AttributeData;
import webScraping.core.HtmlFormatter;
import webScraping.core.SearchData;

public class DebugProcess {
    protected static final String configurationFilename = "Debug.prop";
    protected static final Logger logger = Logger.getLogger("WebScraping");
    protected static final Level loggerlevel = Level.FINEST;

    public static void debuglog_set() {
        try {
            DebugProcess.initLogConfiguration();
            if (Level.ALL.equals(logger.getLevel())) {
                logger.addHandler(new FileHandler("WebScraping%g.log", true));
            }
            DebugProcess.setFomatter();
        }
        catch (IOException | SecurityException ex) {
            Logger.getLogger(DebugProcess.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void debuglog_unset() {
    }

    public static void htmlinfo(HTML.Tag tag, MutableAttributeSet attr, String methodname, int count) {
        if (logger.getLevel() == null) {
            return;
        }
        if (logger.getLevel().intValue() > loggerlevel.intValue()) {
            return;
        }
        char kbn = ' ';
        if ("handleStartTag".equals(methodname)) {
            kbn = 'F';
        }
        if ("handleEndTag".equals(methodname)) {
            kbn = 'E';
        }
        if ("handleSimpleTag".equals(methodname)) {
            kbn = 'S';
        }
        StringBuilder strBuf = new StringBuilder(80);
        strBuf.append(count).append(" : ");
        strBuf.append(kbn).append(" : ");
        strBuf.append(tag.toString());
        if (attr != null && attr.getAttributeCount() != 0) {
            AttributeData handleAttrData = new AttributeData();
            handleAttrData.add(tag, attr);
            for (int i = 0; i < handleAttrData.size; ++i) {
                strBuf.append(" [");
                strBuf.append(handleAttrData.getattrname(i));
                strBuf.append("]");
                strBuf.append(handleAttrData.getcount(i));
                strBuf.append(" = ");
                strBuf.append(handleAttrData.getattrvalue(i));
            }
        }
        logger.log(loggerlevel, strBuf.toString());
    }

    public static void htmlinfo(String str, String methodname) {
        logger.log(loggerlevel, str);
    }

    public static void htmlinfo(String str) {
        logger.log(loggerlevel, str);
    }

    public static void htmlinfo(char[] data, String methodname) {
        String dat = new String(data);
        logger.log(loggerlevel, dat);
    }

    public static void htmlinfo(char[] data) {
        String dat = new String(data);
        logger.log(loggerlevel, dat);
    }

    public static void searchDatainfo(SearchData skey) {
        StringBuilder strBuf = new StringBuilder(30);
        strBuf.append("SearchData KEY tag[");
        strBuf.append(skey.getHtmltag());
        strBuf.append("] ID[");
        strBuf.append(skey.getHtmlid());
        strBuf.append("] CLASS[");
        strBuf.append(skey.getHtmlclass());
        strBuf.append("]\n");
        logger.log(loggerlevel, strBuf.toString());
    }

    private static void initLogConfiguration() {
        File file = new File(configurationFilename);
        try {
            if (file.exists()) {
                FileInputStream inputStream = new FileInputStream(file);
                LogManager.getLogManager().readConfiguration(inputStream);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(DebugProcess.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(DebugProcess.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private static void setFomatter() {
        Handler[] handlers = logger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            if (!(handlers[i] instanceof FileHandler)) continue;
            handlers[i].setFormatter(new HtmlFormatter());
        }
    }
}

