#include "v8stdint.h"
#include "curl/curl.h"
#include <vector>

size_t write_data(void *buf, size_t sz, size_t nmemb, void *ud){
	size_t segsize = sz * nmemb;
	std::vector<uint8_t> *data = static_cast<std::vector<uint8_t> *>(ud);
	uint8_t *begin = static_cast<uint8_t *>(buf);
	data->insert(data->end(), begin, begin + segsize);
	return segsize;
}

void download(const char *url, std::vector<uint8_t> &data){
	data.clear();
	CURL *curl = ::curl_easy_init();
	::curl_easy_setopt(curl, CURLOPT_URL, url);
	::curl_easy_setopt(curl, CURLOPT_WRITEDATA, &data);
	::curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_data);
	CURLcode rc = ::curl_easy_perform(curl);
	::curl_easy_cleanup(curl);
}
