/*
	vfdwin.h

	Virtual Floppy Disk drive control panel
    Copyright (C) 2003 Kenji Kato
*/

#ifndef _VFDWIN_H_
#define _VFDWIN_H_

#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus

#define VFD_WAKEUP_MSG_STR			"VfdWinWakeupMessage"

#define VFD_APP_NAME				"Virtual FD"
#define VFD_APP_FILENAME			"vfdwin.exe"

#define	VFD_MOUNT_SWITCH			"/mount"
#define VFD_CFG_LINK_NAME			"Virtual FD Control Panel"

#define INVALID_FILE_ATTRIBUTES		(DWORD)-1L

//	icon index enumeration

enum {
	VFD_ICON_IDX_CONFIG = 0,
	VFD_ICON_IDX_MOUNT,
	VFD_ICON_IDX_IMAGE,
};

//	Application instance handle

extern HINSTANCE	hAppInstance;

//	dialog procedures

BOOL CALLBACK MainProc (HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK DriverProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK AssocProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK LinkProc (HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);
BOOL CALLBACK AboutProc(HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam);

//	Device operating functions

void OnDriveRefresh		(HWND hDlg, WPARAM reason, DWORD driver_state);

//	Unmount callback functions

BOOL Retry_Callback(HWND hWnd);

//	Message Functions

void ShowErrorMessage(DWORD err, DWORD msg, ...);

//	Debug routines

#ifdef __cplusplus
}
#endif	// _cplusplus

#endif	// _VFDWIN_H_

// End of File
