/* $Id$ */
package nicobrowser.util
import org.cyberneko.html.parsers.SAXParser

class UserInfo {
    /**
     * 動画閲覧ページからユーザIDを取得する.
     * @params is 動画閲覧ページ.
     * @return ユーザID. 取得できなければnull.
     */
    String getUserId(InputStream is){
        def html = new XmlSlurper(new SAXParser()).parse(is)
        def res = html.'**'.find{it.attributes()['href']?.startsWith '/user/'}

        // 公式動画(IDがsoで始まる動画)のように投稿者が無い場合がある
        if(res==null) return null

        return res.attributes()['href'].replaceAll('/user/','').toString()
    }

    String getNotifierUrl(InputStream is){
        def html = new XmlSlurper(new SAXParser()).parse(is)
        def res = html.'**'.find{it.text() == 'この動画を違反通報'}

        // 公式動画(IDがsoで始まる動画)のように投稿者が無い場合がある
        if(res==null) return null

        return res.attributes()['href'].toString()
    }

    String getUserName(InputStream is){
        def html = new XmlSlurper(new SAXParser()).parse(is)
        def statement = html.'BODY'.'DIV'.'P'.find{it.text().contains('が投稿した動画を、違反動画として通報します。')}//'STRONG'.text().toString()
        statement.'STRONG'.toString()
    }
}

